/*
 * Decompiled with CFR 0.152.
 */
package ai.dragonfly.math.matrix;

import ai.dragonfly.math.UnsupportedVectorDimension$;
import ai.dragonfly.math.matrix.Matrix$;
import ai.dragonfly.math.matrix.util.CannotExpressMatrixAsVector$;
import java.io.Serializable;
import narr.native.NArr;
import scala.Double$;
import scala.Function1;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyInt;
import scala.scalajs.js.Array;
import scala.scalajs.js.typedarray.Float64Array;
import scala.scalajs.js.typedarray.Int32Array;
import scala.scalajs.js.typedarray.TypedArray;
import scala.util.Random;

public class Matrix<M, N> {
    private final Array values;
    private final Integer x$2;
    private final Integer x$3;
    private final int rows;
    private final int columns;
    private final int mn;

    public static <M, N> Matrix<M, N> apply(Array<Float64Array> array, Integer n, Integer n2) {
        return Matrix$.MODULE$.apply(array, n, n2);
    }

    public static <M, N> Matrix<M, N> apply(double d, Integer n, Integer n2) {
        return Matrix$.MODULE$.apply(d, n, n2);
    }

    public static <M, N> Matrix<M, N> apply(Float64Array float64Array, Integer n, Integer n2) {
        return Matrix$.MODULE$.apply(float64Array, n, n2);
    }

    public static <M, N> Matrix<M, N> constructWithCopy(Array<Float64Array> array, Integer n, Integer n2) {
        return Matrix$.MODULE$.constructWithCopy(array, n, n2);
    }

    public static <M, N> Matrix<M, N> diagonal(double d, Integer n, Integer n2) {
        return Matrix$.MODULE$.diagonal(d, n, n2);
    }

    public static <D> Matrix<D, D> diagonal(Float64Array float64Array, Integer n) {
        return Matrix$.MODULE$.diagonal(float64Array, n);
    }

    public static <M, N, D> Matrix<M, N> diagonal(Float64Array float64Array, Integer n, Integer n2, Integer n3) {
        return Matrix$.MODULE$.diagonal(float64Array, n, n2, n3);
    }

    public static <M, N> Matrix<M, N> identity(Integer n, Integer n2) {
        return Matrix$.MODULE$.identity(n, n2);
    }

    public static <M, N> Matrix<M, N> random(double d, Random random, Integer n, Integer n2) {
        return Matrix$.MODULE$.random(d, random, n, n2);
    }

    public static <M, N> Matrix<M, N> zeros(Integer n, Integer n2) {
        return Matrix$.MODULE$.zeros(n, n2);
    }

    public static <M, N> double random$default$1() {
        return Matrix$.MODULE$.random$default$1();
    }

    public static <M, N> Random random$default$2() {
        return Matrix$.MODULE$.random$default$2();
    }

    public Matrix(Array<Float64Array> values, Integer x$2, Integer x$3) {
        this.values = values;
        this.x$2 = x$2;
        this.x$3 = x$3;
        Integer ev = x$2;
        this.rows = BoxesRunTime.unboxToInt((Object)ev);
        Integer ev2 = x$3;
        this.columns = BoxesRunTime.unboxToInt((Object)ev2);
        this.mn = this.rows() * this.columns();
    }

    public Array<Float64Array> values() {
        return this.values;
    }

    public int rows() {
        return this.rows;
    }

    public int columns() {
        return this.columns;
    }

    public Matrix<M, N> copy() {
        return new Matrix<M, N>(this.copyValues(), this.x$2, this.x$3);
    }

    public Array<Float64Array> copyValues() {
        Function1 & Serializable f$proxy9 = (Function1 & Serializable)row -> this.$anonfun$1(BoxesRunTime.unboxToInt((Object)row));
        ClassTag x$3$proxy10 = ClassTag$.MODULE$.apply(Float64Array.class);
        int n$proxy5 = this.rows();
        Array out = new Array(n$proxy5);
        for (int i = 0; i < this.rows(); ++i) {
            int index$proxy12 = i;
            Float64Array value$proxy11 = (Float64Array)f$proxy9.apply((Object)BoxesRunTime.boxToInteger((int)i));
            ((NArr)out).update(index$proxy12, (Object)value$proxy11);
        }
        return out;
    }

    public Float64Array columnPackedArray() {
        Float64Array vals = new Float64Array(this.rows() * this.columns());
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.columns(); ++j) {
                vals.update(i + j * this.rows(), ((TypedArray)this.values().apply(i)).apply(j));
            }
        }
        return vals;
    }

    public Float64Array rowPackedArray() {
        Float64Array vals = new Float64Array(this.rows() * this.columns());
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.columns(); ++j) {
                vals.update(i * this.columns() + j, ((TypedArray)this.values().apply(i)).apply(j));
            }
        }
        return vals;
    }

    public int rowDimension() {
        return this.rows();
    }

    public int columnDimension() {
        return this.columns();
    }

    public <M1, N1> Matrix<M1, N1> subMatrix(int r0, int c0, Integer x$3, Integer x$4) {
        Integer ev = x$3;
        int r1 = r0 + BoxesRunTime.unboxToInt((Object)ev);
        Integer ev2 = x$4;
        int c1 = c0 + BoxesRunTime.unboxToInt((Object)ev2);
        int length$proxy8 = r1 - r0;
        Function1 & Serializable f$proxy11 = (Function1 & Serializable)r -> this.$anonfun$3(c0, c1, BoxesRunTime.unboxToInt((Object)r));
        ClassTag x$3$proxy12 = ClassTag$.MODULE$.apply(Float64Array.class);
        int n$proxy6 = length$proxy8;
        Array out = new Array(n$proxy6);
        for (int i = 0; i < length$proxy8; ++i) {
            int index$proxy14 = i;
            Float64Array value$proxy13 = (Float64Array)f$proxy11.apply((Object)BoxesRunTime.boxToInteger((int)i));
            ((NArr)out).update(index$proxy14, (Object)value$proxy13);
        }
        return new Matrix<M, N>((Array<Float64Array>)out, x$3, x$4);
    }

    public <M1, N1> Matrix<M1, N1> subMatrix(Int32Array rowIndices, Int32Array columnIndices, Integer x$3, Integer x$4) {
        Integer ev = x$3;
        int supplied$proxy5 = BoxesRunTime.unboxToInt((Object)ev);
        if (supplied$proxy5 != rowIndices.length()) {
            throw UnsupportedVectorDimension$.MODULE$.apply(supplied$proxy5, rowIndices.length());
        }
        Integer ev2 = x$4;
        int supplied$proxy6 = BoxesRunTime.unboxToInt((Object)ev2);
        if (supplied$proxy6 != columnIndices.length()) {
            throw UnsupportedVectorDimension$.MODULE$.apply(supplied$proxy6, columnIndices.length());
        }
        Function1 & Serializable f$proxy13 = (Function1 & Serializable)r -> this.$anonfun$5(rowIndices, columnIndices, BoxesRunTime.unboxToInt((Object)r));
        ClassTag x$3$proxy14 = ClassTag$.MODULE$.apply(Float64Array.class);
        int n$proxy7 = rowIndices.length();
        Array out = new Array(n$proxy7);
        for (int i = 0; i < rowIndices.length(); ++i) {
            int index$proxy16 = i;
            Float64Array value$proxy15 = (Float64Array)f$proxy13.apply((Object)BoxesRunTime.boxToInteger((int)i));
            ((NArr)out).update(index$proxy16, (Object)value$proxy15);
        }
        return new Matrix<M, N>((Array<Float64Array>)out, x$3, x$4);
    }

    public <M1, N1> Matrix<M1, N1> getMatrix(int r0, Int32Array columnIndices, Integer x$3, Integer x$4) {
        Integer ev = x$3;
        int r1 = r0 + BoxesRunTime.unboxToInt((Object)ev);
        Integer ev2 = x$4;
        int supplied$proxy7 = BoxesRunTime.unboxToInt((Object)ev2);
        if (supplied$proxy7 != columnIndices.length()) {
            throw UnsupportedVectorDimension$.MODULE$.apply(supplied$proxy7, columnIndices.length());
        }
        int length$proxy9 = r1 - r0 + 1;
        Function1 & Serializable f$proxy15 = (Function1 & Serializable)r -> this.$anonfun$7(r0, columnIndices, BoxesRunTime.unboxToInt((Object)r));
        ClassTag x$3$proxy16 = ClassTag$.MODULE$.apply(Float64Array.class);
        int n$proxy8 = length$proxy9;
        Array out = new Array(n$proxy8);
        for (int i = 0; i < length$proxy9; ++i) {
            int index$proxy18 = i;
            Float64Array value$proxy17 = (Float64Array)f$proxy15.apply((Object)BoxesRunTime.boxToInteger((int)i));
            ((NArr)out).update(index$proxy18, (Object)value$proxy17);
        }
        return new Matrix<M, N>((Array<Float64Array>)out, x$3, x$4);
    }

    public <M1, N1> Matrix<M1, N1> getMatrix(Int32Array rowIndices, int c0, Integer x$3, Integer x$4) {
        Integer ev = x$4;
        int c1 = c0 + BoxesRunTime.unboxToInt((Object)ev);
        Function1 & Serializable f$proxy17 = (Function1 & Serializable)r -> this.$anonfun$9(rowIndices, c0, c1, BoxesRunTime.unboxToInt((Object)r));
        ClassTag x$3$proxy18 = ClassTag$.MODULE$.apply(Float64Array.class);
        int n$proxy9 = rowIndices.length();
        Array out = new Array(n$proxy9);
        for (int i = 0; i < rowIndices.length(); ++i) {
            int index$proxy20 = i;
            Float64Array value$proxy19 = (Float64Array)f$proxy17.apply((Object)BoxesRunTime.boxToInteger((int)i));
            ((NArr)out).update(index$proxy20, (Object)value$proxy19);
        }
        return new Matrix<M, N>((Array<Float64Array>)out, x$3, x$4);
    }

    public <M1, N1> void setMatrix(int r0, int c0, Matrix<M1, N1> mtrx, Integer x$4, Integer x$5) {
        Integer ev = x$4;
        int r1 = BoxesRunTime.unboxToInt((Object)ev);
        Integer ev2 = x$5;
        int c1 = BoxesRunTime.unboxToInt((Object)ev2);
        for (int r = r0; r <= r1; ++r) {
            for (int c = c0; c <= c1; ++c) {
                Matrix<M1, N1> Matrix_this = mtrx;
                int r$proxy4 = r - r0;
                int c$proxy4 = c - c0;
                ((TypedArray)this.values().apply(r)).update(c, (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)((TypedArray)Matrix_this.values().apply(r$proxy4)).apply(c$proxy4))));
            }
        }
    }

    public <M1, N1> void setMatrix(Int32Array rowIndices, Int32Array columnIndices, Matrix<M1, N1> X) {
        for (int i = 0; i < rowIndices.length(); ++i) {
            for (int j = 0; j < columnIndices.length(); ++j) {
                Matrix<M1, N1> Matrix_this = X;
                int r$proxy5 = i;
                int c$proxy5 = j;
                ((TypedArray)this.values().apply(BoxesRunTime.unboxToInt((Object)rowIndices.apply(i)))).update(BoxesRunTime.unboxToInt((Object)columnIndices.apply(j)), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)((TypedArray)Matrix_this.values().apply(r$proxy5)).apply(c$proxy5))));
            }
        }
    }

    public <M1, N1> void setMatrix(Int32Array rowIndices, int c0, Matrix<M1, N1> X, Integer x$4, Integer x$5) {
        Integer ev = x$5;
        int c1 = c0 + BoxesRunTime.unboxToInt((Object)ev);
        for (int r = 0; r < rowIndices.length(); ++r) {
            for (int c = c0; c <= c1; ++c) {
                Matrix<M1, N1> Matrix_this = X;
                int r$proxy6 = r;
                int c$proxy6 = c - c0;
                ((TypedArray)this.values().apply(BoxesRunTime.unboxToInt((Object)rowIndices.apply(r)))).update(c, (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)((TypedArray)Matrix_this.values().apply(r$proxy6)).apply(c$proxy6))));
            }
        }
    }

    public <M1, N1> void setMatrix(int r0, Int32Array columnIndices, Matrix<M1, N1> X, Integer x$4, Integer x$5) {
        Integer ev = x$4;
        int r1 = r0 + BoxesRunTime.unboxToInt((Object)ev);
        for (int r = r0; r <= r1; ++r) {
            for (int c = 0; c < columnIndices.length(); ++c) {
                Matrix<M1, N1> Matrix_this = X;
                int r$proxy7 = r - r0;
                int c$proxy7 = c;
                ((TypedArray)this.values().apply(r)).update(BoxesRunTime.unboxToInt((Object)columnIndices.apply(c)), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)((TypedArray)Matrix_this.values().apply(r$proxy7)).apply(c$proxy7))));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public Matrix<N, M> transpose() {
        void var3_4;
        Function1 & Serializable f$proxy19 = (Function1 & Serializable)col -> this.$anonfun$11(BoxesRunTime.unboxToInt((Object)col));
        ClassTag x$3$proxy20 = ClassTag$.MODULE$.apply(Float64Array.class);
        int n$proxy10 = this.columns();
        Array out = new Array(n$proxy10);
        for (int i = 0; i < this.columns(); ++i) {
            int index$proxy22 = i;
            Float64Array value$proxy21 = (Float64Array)f$proxy19.apply((Object)BoxesRunTime.boxToInteger((int)i));
            ((NArr)out).update(index$proxy22, (Object)value$proxy21);
        }
        return new Matrix<M, N>((Array<Float64Array>)var3_4, this.x$3, this.x$2);
    }

    public double norm1() {
        double maxColumnSum = Double$.MODULE$.MinValue();
        for (int c = 0; c < this.columns(); ++c) {
            double columnSum = 0.0;
            for (int r = 0; r < this.rows(); ++r) {
                columnSum += Math.abs(BoxesRunTime.unboxToDouble((Object)((TypedArray)this.values().apply(r)).apply(c)));
            }
            maxColumnSum = Math.max(maxColumnSum, columnSum);
        }
        return maxColumnSum;
    }

    public double normInfinity() {
        double maxRowSum = Double$.MODULE$.MinValue();
        for (int r = 0; r < this.rows(); ++r) {
            double rowSum = 0.0;
            for (int c = 0; c < this.columns(); ++c) {
                rowSum += Math.abs(BoxesRunTime.unboxToDouble((Object)((TypedArray)this.values().apply(r)).apply(c)));
            }
            maxRowSum = Math.max(maxRowSum, rowSum);
        }
        return maxRowSum;
    }

    public double normFrobenius() {
        double f = Double$.MODULE$.MinValue();
        for (int r = 0; r < this.rows(); ++r) {
            for (int c = 0; c < this.columns(); ++c) {
                f = package$.MODULE$.hypot(f, BoxesRunTime.unboxToDouble((Object)((TypedArray)this.values().apply(r)).apply(c)));
            }
        }
        return f;
    }

    public Matrix<M, N> add(Matrix<M, N> B) {
        for (int r = 0; r < this.rows(); ++r) {
            for (int c = 0; c < this.columns(); ++c) {
                Matrix<M, N> Matrix_this = B;
                int r$proxy8 = r;
                int c$proxy8 = c;
                ((TypedArray)this.values().apply(r)).update(c, (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)((TypedArray)this.values().apply(r)).apply(c)) + BoxesRunTime.unboxToDouble((Object)((TypedArray)Matrix_this.values().apply(r$proxy8)).apply(c$proxy8)))));
            }
        }
        return this;
    }

    public Matrix<M, N> subtract(Matrix<M, N> B) {
        for (int r = 0; r < this.rows(); ++r) {
            for (int c = 0; c < this.columns(); ++c) {
                Matrix<M, N> Matrix_this = B;
                int r$proxy9 = r;
                int c$proxy9 = c;
                ((TypedArray)this.values().apply(r)).update(c, (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)((TypedArray)this.values().apply(r)).apply(c)) - BoxesRunTime.unboxToDouble((Object)((TypedArray)Matrix_this.values().apply(r$proxy9)).apply(c$proxy9)))));
            }
        }
        return this;
    }

    public Matrix<M, N> times(double s) {
        for (int r = 0; r < this.rows(); ++r) {
            for (int c = 0; c < this.columns(); ++c) {
                ((TypedArray)this.values().apply(r)).update(c, (Object)BoxesRunTime.boxToDouble((double)(s * BoxesRunTime.unboxToDouble((Object)((TypedArray)this.values().apply(r)).apply(c)))));
            }
        }
        return this;
    }

    public <V> Matrix<M, V> $times(Matrix<N, V> thatMatrix, Integer x$2) {
        LazyInt lazyInt = new LazyInt();
        return this.times(thatMatrix, x$2);
    }

    public <V> Matrix<M, V> times(Matrix<N, V> b, Integer x$2) {
        Matrix X = Matrix$.MODULE$.zeros(this.x$2, x$2);
        double[] Bcolj = new double[this.columns()];
        for (int j = 0; j < b.columns(); ++j) {
            int k;
            for (k = 0; k < this.columns(); ++k) {
                Matrix<N, V> Matrix_this = b;
                int r$proxy10 = k;
                int c$proxy10 = j;
                Bcolj[k] = BoxesRunTime.unboxToDouble((Object)((TypedArray)Matrix_this.values().apply(r$proxy10)).apply(c$proxy10));
            }
            int i = 0;
            while (i < this.rows()) {
                Float64Array Arowi = (Float64Array)this.values().apply(i);
                double s = 0.0;
                for (k = 0; k < this.columns(); ++k) {
                    s += BoxesRunTime.unboxToDouble((Object)Arowi.apply(k)) * Bcolj[k];
                }
                Matrix Matrix_this = X;
                int r$proxy11 = i++;
                int c$proxy11 = j;
                double value$proxy22 = s;
                ((TypedArray)Matrix_this.values().apply(r$proxy11)).update(c$proxy11, (Object)BoxesRunTime.boxToDouble((double)value$proxy22));
            }
        }
        return X;
    }

    public double trace() {
        double t = 0.0;
        for (int i = 0; i < Math.min(this.rows(), this.columns()); ++i) {
            t += BoxesRunTime.unboxToDouble((Object)((TypedArray)this.values().apply(i)).apply(i));
        }
        return t;
    }

    public int mn() {
        return this.mn;
    }

    public Float64Array asVector() {
        if (this.columns() == 1 || this.rows() == 1) {
            return this.rowPackedArray();
        }
        throw CannotExpressMatrixAsVector$.MODULE$.apply(this);
    }

    public String dim() {
        return new StringBuilder(6).append("dim(").append(this.rows()).append("x").append(this.columns()).append(")").toString();
    }

    public String toString() {
        scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
        for (int r = 0; r < this.values().length(); ++r) {
            sb.append("\n");
            for (int c = 0; c < ((TypedArray)this.values().apply(0)).length(); ++c) {
                sb.append(new StringBuilder(2).append(((TypedArray)this.values().apply(r)).apply(c)).append(", ").toString());
            }
        }
        return sb.toString();
    }

    private final /* synthetic */ double $anonfun$2(int row$1, int col) {
        return BoxesRunTime.unboxToDouble((Object)((TypedArray)this.values().apply(row$1)).apply(col));
    }

    private final /* synthetic */ Float64Array $anonfun$1(int row) {
        Function1 & Serializable f$proxy8 = (Function1 & Serializable)col -> this.$anonfun$2(row, BoxesRunTime.unboxToInt((Object)col));
        ClassTag x$3$proxy9 = ClassTag$.MODULE$.apply(Double.TYPE);
        Float64Array out = new Float64Array(this.columns());
        for (int i = 0; i < this.columns(); ++i) {
            int index$proxy11 = i;
            double value$proxy10 = BoxesRunTime.unboxToDouble((Object)f$proxy8.apply((Object)BoxesRunTime.boxToInteger((int)i)));
            ((NArr)out).update(index$proxy11, (Object)BoxesRunTime.boxToDouble((double)value$proxy10));
        }
        return out;
    }

    private final /* synthetic */ double $anonfun$4(int c0$2, int r$1, int c) {
        return BoxesRunTime.unboxToDouble((Object)((TypedArray)this.values().apply(r$1 + r$1)).apply(c0$2 + c));
    }

    private final /* synthetic */ Float64Array $anonfun$3(int c0$1, int c1$1, int r) {
        int length$proxy7 = c1$1 - c0$1;
        Function1 & Serializable f$proxy10 = (Function1 & Serializable)c -> this.$anonfun$4(c0$1, r, BoxesRunTime.unboxToInt((Object)c));
        ClassTag x$3$proxy11 = ClassTag$.MODULE$.apply(Double.TYPE);
        Float64Array out = new Float64Array(length$proxy7);
        for (int i = 0; i < length$proxy7; ++i) {
            int index$proxy13 = i;
            double value$proxy12 = BoxesRunTime.unboxToDouble((Object)f$proxy10.apply((Object)BoxesRunTime.boxToInteger((int)i)));
            ((NArr)out).update(index$proxy13, (Object)BoxesRunTime.boxToDouble((double)value$proxy12));
        }
        return out;
    }

    private final /* synthetic */ double $anonfun$6(Int32Array rowIndices$2, Int32Array columnIndices$2, int r$2, int c) {
        return BoxesRunTime.unboxToDouble((Object)((TypedArray)this.values().apply(BoxesRunTime.unboxToInt((Object)rowIndices$2.apply(r$2)))).apply(BoxesRunTime.unboxToInt((Object)columnIndices$2.apply(c))));
    }

    private final /* synthetic */ Float64Array $anonfun$5(Int32Array rowIndices$1, Int32Array columnIndices$1, int r) {
        Function1 & Serializable f$proxy12 = (Function1 & Serializable)c -> this.$anonfun$6(rowIndices$1, columnIndices$1, r, BoxesRunTime.unboxToInt((Object)c));
        ClassTag x$3$proxy13 = ClassTag$.MODULE$.apply(Double.TYPE);
        Float64Array out = new Float64Array(columnIndices$1.length());
        for (int i = 0; i < columnIndices$1.length(); ++i) {
            int index$proxy15 = i;
            double value$proxy14 = BoxesRunTime.unboxToDouble((Object)f$proxy12.apply((Object)BoxesRunTime.boxToInteger((int)i)));
            ((NArr)out).update(index$proxy15, (Object)BoxesRunTime.boxToDouble((double)value$proxy14));
        }
        return out;
    }

    private final /* synthetic */ double $anonfun$8(int r0$1, Int32Array columnIndices$3, int r$3, int c) {
        return BoxesRunTime.unboxToDouble((Object)((TypedArray)this.values().apply(r$3 + r0$1)).apply(BoxesRunTime.unboxToInt((Object)columnIndices$3.apply(c))));
    }

    private final /* synthetic */ Float64Array $anonfun$7(int r0$2, Int32Array columnIndices$4, int r) {
        Function1 & Serializable f$proxy14 = (Function1 & Serializable)c -> this.$anonfun$8(r0$2, columnIndices$4, r, BoxesRunTime.unboxToInt((Object)c));
        ClassTag x$3$proxy15 = ClassTag$.MODULE$.apply(Double.TYPE);
        Float64Array out = new Float64Array(columnIndices$4.length());
        for (int i = 0; i < columnIndices$4.length(); ++i) {
            int index$proxy17 = i;
            double value$proxy16 = BoxesRunTime.unboxToDouble((Object)f$proxy14.apply((Object)BoxesRunTime.boxToInteger((int)i)));
            ((NArr)out).update(index$proxy17, (Object)BoxesRunTime.boxToDouble((double)value$proxy16));
        }
        return out;
    }

    private final /* synthetic */ double $anonfun$10(Int32Array rowIndices$4, int c0$4, int r$4, int c) {
        return BoxesRunTime.unboxToDouble((Object)((TypedArray)this.values().apply(BoxesRunTime.unboxToInt((Object)rowIndices$4.apply(r$4)))).apply(c + c0$4));
    }

    private final /* synthetic */ Float64Array $anonfun$9(Int32Array rowIndices$3, int c0$3, int c1$2, int r) {
        int length$proxy10 = c1$2 - c0$3 + 1;
        Function1 & Serializable f$proxy16 = (Function1 & Serializable)c -> this.$anonfun$10(rowIndices$3, c0$3, r, BoxesRunTime.unboxToInt((Object)c));
        ClassTag x$3$proxy17 = ClassTag$.MODULE$.apply(Double.TYPE);
        Float64Array out = new Float64Array(length$proxy10);
        for (int i = 0; i < length$proxy10; ++i) {
            int index$proxy19 = i;
            double value$proxy18 = BoxesRunTime.unboxToDouble((Object)f$proxy16.apply((Object)BoxesRunTime.boxToInteger((int)i)));
            ((NArr)out).update(index$proxy19, (Object)BoxesRunTime.boxToDouble((double)value$proxy18));
        }
        return out;
    }

    private final /* synthetic */ double $anonfun$12(int col$1, int row) {
        return BoxesRunTime.unboxToDouble((Object)((TypedArray)this.values().apply(row)).apply(col$1));
    }

    private final /* synthetic */ Float64Array $anonfun$11(int col) {
        Function1 & Serializable f$proxy18 = (Function1 & Serializable)row -> this.$anonfun$12(col, BoxesRunTime.unboxToInt((Object)row));
        ClassTag x$3$proxy19 = ClassTag$.MODULE$.apply(Double.TYPE);
        Float64Array out = new Float64Array(this.rows());
        for (int i = 0; i < this.rows(); ++i) {
            int index$proxy21 = i;
            double value$proxy20 = BoxesRunTime.unboxToDouble((Object)f$proxy18.apply((Object)BoxesRunTime.boxToInteger((int)i)));
            ((NArr)out).update(index$proxy21, (Object)BoxesRunTime.boxToDouble((double)value$proxy20));
        }
        return out;
    }

    private final int v$lzyINIT1$1(Integer x$2$1, LazyInt v$lzy1$1) {
        int n;
        LazyInt lazyInt = v$lzy1$1;
        synchronized (lazyInt) {
            int n2;
            if (v$lzy1$1.initialized()) {
                n2 = v$lzy1$1.value();
            } else {
                Integer ev = this.x$2;
                Integer ev2 = x$2$1;
                n2 = v$lzy1$1.initialize(Math.min(BoxesRunTime.unboxToInt((Object)ev), BoxesRunTime.unboxToInt((Object)ev2)));
            }
            n = n2;
        }
        return n;
    }

    private final int v$1(Integer x$2$2, LazyInt v$lzy1$2) {
        if (v$lzy1$2.initialized()) {
            return v$lzy1$2.value();
        }
        return this.v$lzyINIT1$1(x$2$2, v$lzy1$2);
    }
}

