/*
 * Decompiled with CFR 0.152.
 */
package ai.dragonfly.math.matrix.decomposition;

import ai.dragonfly.math.matrix.Matrix;
import ai.dragonfly.math.matrix.Matrix$;
import ai.dragonfly.math.matrix.decomposition.Cholesky;
import ai.dragonfly.math.matrix.util.MatrixNotSymmetricPositiveDefinite$;
import java.io.Serializable;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.scalajs.js.Array;
import scala.scalajs.js.typedarray.Float64Array;
import scala.scalajs.js.typedarray.TypedArray;

public final class Cholesky$
implements Serializable {
    public static final Cholesky$ MODULE$ = new Cholesky$();

    private Cholesky$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Cholesky$.class);
    }

    public <N> Cholesky<N> apply(Matrix<N, N> m, Integer x$2) {
        Array<Float64Array> A = m.copyValues();
        int n = A.length();
        Array<Float64Array> L = Matrix$.MODULE$.zeros(x$2, x$2).values();
        boolean isspd = true;
        for (int j = 0; j < n; ++j) {
            int k;
            Float64Array Lrowj = (Float64Array)L.apply(j);
            double d = 0.0;
            for (k = 0; k < j; ++k) {
                Float64Array Lrowk = (Float64Array)L.apply(k);
                double s = 0.0;
                for (int i = 0; i < k; ++i) {
                    s += BoxesRunTime.unboxToDouble((Object)Lrowk.apply(i)) * BoxesRunTime.unboxToDouble((Object)Lrowj.apply(i));
                }
                s = (BoxesRunTime.unboxToDouble((Object)((TypedArray)A.apply(j)).apply(k)) - s) / BoxesRunTime.unboxToDouble((Object)((TypedArray)L.apply(k)).apply(k));
                Lrowj.update(k, (Object)BoxesRunTime.boxToDouble((double)s));
                d += s * s;
                isspd &= BoxesRunTime.unboxToDouble((Object)((TypedArray)A.apply(k)).apply(j)) == BoxesRunTime.unboxToDouble((Object)((TypedArray)A.apply(j)).apply(k));
            }
            d = BoxesRunTime.unboxToDouble((Object)((TypedArray)A.apply(j)).apply(j)) - d;
            isspd &= d > 0.0;
            ((TypedArray)L.apply(j)).update(j, (Object)BoxesRunTime.boxToDouble((double)Math.sqrt(Math.max(d, 0.0))));
            for (k = j + 1; k < n; ++k) {
                ((TypedArray)L.apply(j)).update(k, (Object)BoxesRunTime.boxToDouble((double)0.0));
            }
        }
        if (isspd) {
            return new Cholesky(Matrix$.MODULE$.apply(L, x$2, x$2), x$2);
        }
        throw MatrixNotSymmetricPositiveDefinite$.MODULE$.apply(m);
    }
}

