/*
 * Decompiled with CFR 0.152.
 */
package ai.dragonfly.math.matrix.decomposition;

import ai.dragonfly.math.matrix.Matrix;
import ai.dragonfly.math.matrix.Matrix$;
import ai.dragonfly.math.matrix.decomposition.LU$;
import java.io.Serializable;
import narr.native.NArr;
import scala.Function1;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.scalajs.js.Array;
import scala.scalajs.js.typedarray.Float64Array;
import scala.scalajs.js.typedarray.Int32Array;
import scala.scalajs.js.typedarray.TypedArray;

public class LU<M, N> {
    private final Matrix LU;
    private final Int32Array piv;
    private final double pivsign;
    private final Integer x$4;
    private final Integer x$5;
    private final int m;
    private final int n;

    public static <M, N> LU<M, N> apply(Matrix<M, N> matrix, Integer n, Integer n2) {
        return LU$.MODULE$.apply(matrix, n, n2);
    }

    public LU(Matrix<M, N> LU2, Int32Array piv, double pivsign, Integer x$4, Integer x$5) {
        this.LU = LU2;
        this.piv = piv;
        this.pivsign = pivsign;
        this.x$4 = x$4;
        this.x$5 = x$5;
        Integer ev = x$4;
        this.m = BoxesRunTime.unboxToInt((Object)ev);
        Integer ev2 = x$5;
        this.n = BoxesRunTime.unboxToInt((Object)ev2);
    }

    public Matrix<M, N> LU() {
        return this.LU;
    }

    public int m() {
        return this.m;
    }

    public int n() {
        return this.n;
    }

    public boolean isSingular() {
        int j = 0;
        while (j < this.n()) {
            Matrix<M, N> Matrix_this = this.LU();
            int r$proxy10 = j;
            int c$proxy10 = j++;
            if (BoxesRunTime.unboxToDouble((Object)((TypedArray)Matrix_this.values().apply(r$proxy10)).apply(c$proxy10)) != 0.0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public Matrix<M, N> L() {
        void var3_4;
        Function1 & Serializable f$proxy3 = (Function1 & Serializable)r -> this.$anonfun$1(BoxesRunTime.unboxToInt((Object)r));
        ClassTag x$3$proxy4 = ClassTag$.MODULE$.apply(Float64Array.class);
        int n$proxy1 = this.m();
        Array out = new Array(n$proxy1);
        for (int i = 0; i < this.m(); ++i) {
            int index$proxy4 = i;
            Float64Array value$proxy5 = (Float64Array)f$proxy3.apply((Object)BoxesRunTime.boxToInteger((int)i));
            ((NArr)out).update(index$proxy4, (Object)value$proxy5);
        }
        return Matrix$.MODULE$.apply((Array<Float64Array>)var3_4, this.x$4, this.x$5);
    }

    /*
     * WARNING - void declaration
     */
    public Matrix<N, N> U() {
        void var3_4;
        Function1 & Serializable f$proxy5 = (Function1 & Serializable)r -> this.$anonfun$3(BoxesRunTime.unboxToInt((Object)r));
        ClassTag x$3$proxy6 = ClassTag$.MODULE$.apply(Float64Array.class);
        int n$proxy2 = this.n();
        Array out = new Array(n$proxy2);
        for (int i = 0; i < this.n(); ++i) {
            int index$proxy6 = i;
            Float64Array value$proxy7 = (Float64Array)f$proxy5.apply((Object)BoxesRunTime.boxToInteger((int)i));
            ((NArr)out).update(index$proxy6, (Object)value$proxy7);
        }
        return Matrix$.MODULE$.apply((Array<Float64Array>)var3_4, this.x$5, this.x$5);
    }

    public Int32Array pivot() {
        Function1 & Serializable f$proxy6 = (Function1 & Serializable)i -> this.$anonfun$5(BoxesRunTime.unboxToInt((Object)i));
        ClassTag x$3$proxy7 = ClassTag$.MODULE$.apply(Integer.TYPE);
        Int32Array out = new Int32Array(this.m());
        for (int i2 = 0; i2 < this.m(); ++i2) {
            int index$proxy7 = i2;
            int value$proxy8 = BoxesRunTime.unboxToInt((Object)f$proxy6.apply((Object)BoxesRunTime.boxToInteger((int)i2)));
            ((NArr)out).update(index$proxy7, (Object)BoxesRunTime.boxToInteger((int)value$proxy8));
        }
        return out;
    }

    public Float64Array doubleValuedPivot() {
        Function1 & Serializable f$proxy7 = (Function1 & Serializable)i -> this.$anonfun$6(BoxesRunTime.unboxToInt((Object)i));
        ClassTag x$3$proxy8 = ClassTag$.MODULE$.apply(Double.TYPE);
        Float64Array out = new Float64Array(this.m());
        for (int i2 = 0; i2 < this.m(); ++i2) {
            int index$proxy8 = i2;
            double value$proxy9 = BoxesRunTime.unboxToDouble((Object)f$proxy7.apply((Object)BoxesRunTime.boxToInteger((int)i2)));
            ((NArr)out).update(index$proxy8, (Object)BoxesRunTime.boxToDouble((double)value$proxy9));
        }
        return out;
    }

    public double determinant() {
        if (this.m() != this.n()) {
            throw new IllegalArgumentException("Matrix must be square.");
        }
        double d = this.pivsign;
        int j = 0;
        while (j < this.n()) {
            Matrix<M, N> Matrix_this = this.LU();
            int r$proxy11 = j;
            int c$proxy11 = j++;
            d *= BoxesRunTime.unboxToDouble((Object)((TypedArray)Matrix_this.values().apply(r$proxy11)).apply(c$proxy11));
        }
        return d;
    }

    public <V> Matrix<N, V> solve(Matrix<M, V> B, Integer x$2) {
        int k;
        if (this.isSingular()) {
            throw new RuntimeException("Matrix is singular.");
        }
        int nx = B.columns();
        Matrix Xmat = B.getMatrix(this.piv, 0, this.x$5, x$2);
        Array<Float64Array> X = Xmat.values();
        for (k = 0; k < this.n(); ++k) {
            for (int i = k + 1; i < this.n(); ++i) {
                for (int j = 0; j < nx; ++j) {
                    Matrix<M, N> Matrix_this = this.LU();
                    int r$proxy12 = i;
                    int c$proxy12 = k;
                    ((TypedArray)X.apply(i)).update(j, (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)((TypedArray)X.apply(i)).apply(j)) - BoxesRunTime.unboxToDouble((Object)((TypedArray)X.apply(k)).apply(j)) * BoxesRunTime.unboxToDouble((Object)((TypedArray)Matrix_this.values().apply(r$proxy12)).apply(c$proxy12)))));
                }
            }
        }
        for (k = this.n() - 1; k > -1; --k) {
            for (int j = 0; j < nx; ++j) {
                Matrix<M, N> Matrix_this = this.LU();
                int r$proxy13 = k;
                int c$proxy13 = k;
                ((TypedArray)X.apply(k)).update(j, (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)((TypedArray)X.apply(k)).apply(j)) / BoxesRunTime.unboxToDouble((Object)((TypedArray)Matrix_this.values().apply(r$proxy13)).apply(c$proxy13)))));
            }
            for (int i = 0; i < k; ++i) {
                for (int j1 = 0; j1 < nx; ++j1) {
                    Matrix<M, N> Matrix_this = this.LU();
                    int r$proxy14 = i;
                    int c$proxy14 = k;
                    ((TypedArray)X.apply(i)).update(j1, (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)((TypedArray)X.apply(i)).apply(j1)) - BoxesRunTime.unboxToDouble((Object)((TypedArray)X.apply(k)).apply(j1)) * BoxesRunTime.unboxToDouble((Object)((TypedArray)Matrix_this.values().apply(r$proxy14)).apply(c$proxy14)))));
                }
            }
        }
        return Xmat;
    }

    private final /* synthetic */ double $anonfun$2(int r$1, int c) {
        if (r$1 > c) {
            Matrix<M, N> Matrix_this = this.LU();
            return BoxesRunTime.unboxToDouble((Object)((TypedArray)Matrix_this.values().apply(r$1)).apply(c));
        }
        if (r$1 == c) {
            return 1.0;
        }
        return 0.0;
    }

    private final /* synthetic */ Float64Array $anonfun$1(int r) {
        Function1 & Serializable f$proxy2 = (Function1 & Serializable)c -> this.$anonfun$2(r, BoxesRunTime.unboxToInt((Object)c));
        ClassTag x$3$proxy3 = ClassTag$.MODULE$.apply(Double.TYPE);
        Float64Array out = new Float64Array(this.n());
        for (int i = 0; i < this.n(); ++i) {
            int index$proxy3 = i;
            double value$proxy4 = BoxesRunTime.unboxToDouble((Object)f$proxy2.apply((Object)BoxesRunTime.boxToInteger((int)i)));
            ((NArr)out).update(index$proxy3, (Object)BoxesRunTime.boxToDouble((double)value$proxy4));
        }
        return out;
    }

    private final /* synthetic */ double $anonfun$4(int r$2, int c) {
        if (r$2 > c) {
            return 0.0;
        }
        Matrix<M, N> Matrix_this = this.LU();
        return BoxesRunTime.unboxToDouble((Object)((TypedArray)Matrix_this.values().apply(r$2)).apply(c));
    }

    private final /* synthetic */ Float64Array $anonfun$3(int r) {
        Function1 & Serializable f$proxy4 = (Function1 & Serializable)c -> this.$anonfun$4(r, BoxesRunTime.unboxToInt((Object)c));
        ClassTag x$3$proxy5 = ClassTag$.MODULE$.apply(Double.TYPE);
        Float64Array out = new Float64Array(this.n());
        for (int i = 0; i < this.n(); ++i) {
            int index$proxy5 = i;
            double value$proxy6 = BoxesRunTime.unboxToDouble((Object)f$proxy4.apply((Object)BoxesRunTime.boxToInteger((int)i)));
            ((NArr)out).update(index$proxy5, (Object)BoxesRunTime.boxToDouble((double)value$proxy6));
        }
        return out;
    }

    private final /* synthetic */ int $anonfun$5(int i) {
        return BoxesRunTime.unboxToInt((Object)this.piv.apply(i));
    }

    private final /* synthetic */ double $anonfun$6(int i) {
        return BoxesRunTime.unboxToInt((Object)this.piv.apply(i));
    }
}

