/*
 * Decompiled with CFR 0.152.
 */
package ai.dragonfly.math.matrix.decomposition;

import ai.dragonfly.math.matrix.Matrix;
import ai.dragonfly.math.matrix.Matrix$;
import ai.dragonfly.math.matrix.decomposition.QR$;
import ai.dragonfly.math.vector.package$;
import java.io.Serializable;
import narr.native.NArr;
import scala.Function1;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.scalajs.js.Array;
import scala.scalajs.js.typedarray.Float64Array;
import scala.scalajs.js.typedarray.TypedArray;

public class QR<M, N> {
    private final Matrix QR;
    private final Float64Array Rdiag;
    private final Integer x$3;
    private final Integer x$4;
    private final int rows;
    private final int columns;

    public static <M, N> QR<M, N> apply(Matrix<M, N> matrix, Integer n, Integer n2) {
        return QR$.MODULE$.apply(matrix, n, n2);
    }

    public QR(Matrix<M, N> QR2, Float64Array Rdiag, Integer x$3, Integer x$4) {
        this.QR = QR2;
        this.Rdiag = Rdiag;
        this.x$3 = x$3;
        this.x$4 = x$4;
        Integer ev = x$3;
        this.rows = BoxesRunTime.unboxToInt((Object)ev);
        Integer ev2 = x$4;
        this.columns = BoxesRunTime.unboxToInt((Object)ev2);
    }

    public Matrix<M, N> QR() {
        return this.QR;
    }

    public Float64Array Rdiag() {
        return this.Rdiag;
    }

    public int rows() {
        return this.rows;
    }

    public int columns() {
        return this.columns;
    }

    public boolean isFullRank() {
        int i = 0;
        while (i < this.columns()) {
            int index$proxy3;
            package$ package$2 = package$.MODULE$;
            Float64Array thisVector$proxy2 = this.Rdiag();
            if (BoxesRunTime.unboxToDouble((Object)thisVector$proxy2.apply(index$proxy3 = i++)) != 0.0) continue;
        }
        return i == this.columns();
    }

    /*
     * WARNING - void declaration
     */
    public Matrix<M, N> H() {
        void var3_4;
        Function1 & Serializable f$proxy2 = (Function1 & Serializable)r -> this.$anonfun$1(BoxesRunTime.unboxToInt((Object)r));
        ClassTag x$3$proxy3 = ClassTag$.MODULE$.apply(Float64Array.class);
        int n$proxy1 = this.rows();
        Array out = new Array(n$proxy1);
        for (int i = 0; i < this.rows(); ++i) {
            int index$proxy5 = i;
            Float64Array value$proxy3 = (Float64Array)f$proxy2.apply((Object)BoxesRunTime.boxToInteger((int)i));
            ((NArr)out).update(index$proxy5, (Object)value$proxy3);
        }
        return Matrix$.MODULE$.apply((Array<Float64Array>)var3_4, this.x$3, this.x$4);
    }

    /*
     * WARNING - void declaration
     */
    public Matrix<N, N> R() {
        void var3_4;
        Function1 & Serializable f$proxy4 = (Function1 & Serializable)r -> this.$anonfun$3(BoxesRunTime.unboxToInt((Object)r));
        ClassTag x$3$proxy5 = ClassTag$.MODULE$.apply(Float64Array.class);
        int n$proxy2 = this.columns();
        Array out = new Array(n$proxy2);
        for (int i = 0; i < this.columns(); ++i) {
            int index$proxy7 = i;
            Float64Array value$proxy5 = (Float64Array)f$proxy4.apply((Object)BoxesRunTime.boxToInteger((int)i));
            ((NArr)out).update(index$proxy7, (Object)value$proxy5);
        }
        return Matrix$.MODULE$.apply((Array<Float64Array>)var3_4, this.x$4, this.x$4);
    }

    public Matrix<M, N> Q() {
        Matrix X = Matrix$.MODULE$.zeros(this.x$3, this.x$4);
        Array<Float64Array> Q = X.values();
        for (int k = this.columns() - 1; k > -1; --k) {
            int i;
            for (i = 0; i < this.rows(); ++i) {
                ((TypedArray)Q.apply(i)).update(k, (Object)BoxesRunTime.boxToDouble((double)0.0));
            }
            ((TypedArray)Q.apply(k)).update(k, (Object)BoxesRunTime.boxToDouble((double)1.0));
            for (int j = k; j < this.columns(); ++j) {
                Matrix<M, N> Matrix_this = this.QR();
                int r$proxy1 = k;
                int c$proxy1 = k;
                if (BoxesRunTime.unboxToDouble((Object)((TypedArray)Matrix_this.values().apply(r$proxy1)).apply(c$proxy1)) == 0.0) continue;
                double s = 0.0;
                for (i = k; i < this.rows(); ++i) {
                    Matrix<M, N> Matrix_this2 = this.QR();
                    int r$proxy2 = i;
                    int c$proxy2 = k;
                    s += BoxesRunTime.unboxToDouble((Object)((TypedArray)Matrix_this2.values().apply(r$proxy2)).apply(c$proxy2)) * BoxesRunTime.unboxToDouble((Object)((TypedArray)Q.apply(i)).apply(j));
                }
                Matrix<M, N> Matrix_this3 = this.QR();
                int r$proxy3 = k;
                int c$proxy3 = k;
                s = -s / BoxesRunTime.unboxToDouble((Object)((TypedArray)Matrix_this3.values().apply(r$proxy3)).apply(c$proxy3));
                i = k;
                while (i < this.rows()) {
                    Float64Array float64Array = (Float64Array)Q.apply(i);
                    int n = j;
                    Matrix<M, N> Matrix_this4 = this.QR();
                    int r$proxy4 = i++;
                    int c$proxy4 = k;
                    float64Array.update(n, (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)float64Array.apply(n)) + s * BoxesRunTime.unboxToDouble((Object)((TypedArray)Matrix_this4.values().apply(r$proxy4)).apply(c$proxy4)))));
                }
            }
        }
        return X;
    }

    public <V> Matrix<N, V> solve(Matrix<M, V> b, Integer x$2) {
        int k;
        if (!this.isFullRank()) {
            throw new RuntimeException("Matrix is rank deficient.");
        }
        int nx = b.columns();
        Array<Float64Array> X = b.copyValues();
        for (k = 0; k < this.columns(); ++k) {
            for (int j = 0; j < nx; ++j) {
                int i;
                double s = 0.0;
                for (i = k; i < this.rows(); ++i) {
                    Matrix<M, N> Matrix_this = this.QR();
                    int r$proxy5 = i;
                    int c$proxy5 = k;
                    s += BoxesRunTime.unboxToDouble((Object)((TypedArray)Matrix_this.values().apply(r$proxy5)).apply(c$proxy5)) * BoxesRunTime.unboxToDouble((Object)((TypedArray)X.apply(i)).apply(j));
                }
                Matrix<M, N> Matrix_this = this.QR();
                int r$proxy6 = k;
                int c$proxy6 = k;
                s = -s / BoxesRunTime.unboxToDouble((Object)((TypedArray)Matrix_this.values().apply(r$proxy6)).apply(c$proxy6));
                i = k;
                while (i < this.rows()) {
                    Float64Array float64Array = (Float64Array)X.apply(i);
                    int n = j;
                    Matrix<M, N> Matrix_this2 = this.QR();
                    int r$proxy7 = i++;
                    int c$proxy7 = k;
                    float64Array.update(n, (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)float64Array.apply(n)) + s * BoxesRunTime.unboxToDouble((Object)((TypedArray)Matrix_this2.values().apply(r$proxy7)).apply(c$proxy7)))));
                }
            }
        }
        for (k = this.columns() - 1; k > -1; --k) {
            int j = 0;
            while (j < nx) {
                Float64Array float64Array = (Float64Array)X.apply(k);
                int n = j++;
                package$ package$2 = package$.MODULE$;
                Float64Array thisVector$proxy4 = this.Rdiag();
                int index$proxy8 = k;
                float64Array.update(n, (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)float64Array.apply(n)) / BoxesRunTime.unboxToDouble((Object)thisVector$proxy4.apply(index$proxy8)))));
            }
            for (int i = 0; i < k; ++i) {
                for (j = 0; j < nx; ++j) {
                    Float64Array float64Array = (Float64Array)X.apply(i);
                    int n = j;
                    Matrix<M, N> Matrix_this = this.QR();
                    int r$proxy8 = i;
                    int c$proxy8 = k;
                    float64Array.update(n, (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)float64Array.apply(n)) - BoxesRunTime.unboxToDouble((Object)((TypedArray)X.apply(k)).apply(j)) * BoxesRunTime.unboxToDouble((Object)((TypedArray)Matrix_this.values().apply(r$proxy8)).apply(c$proxy8)))));
                }
            }
        }
        return Matrix$.MODULE$.apply(X, this.x$3, x$2).subMatrix(0, 0, this.x$4, x$2);
    }

    private final /* synthetic */ double $anonfun$2(int r$1, int c) {
        if (r$1 >= c) {
            Matrix<M, N> Matrix_this = this.QR();
            return BoxesRunTime.unboxToDouble((Object)((TypedArray)Matrix_this.values().apply(r$1)).apply(c));
        }
        return 0.0;
    }

    private final /* synthetic */ Float64Array $anonfun$1(int r) {
        Function1 & Serializable f$proxy1 = (Function1 & Serializable)c -> this.$anonfun$2(r, BoxesRunTime.unboxToInt((Object)c));
        ClassTag x$3$proxy2 = ClassTag$.MODULE$.apply(Double.TYPE);
        Float64Array out = new Float64Array(this.columns());
        for (int i = 0; i < this.columns(); ++i) {
            int index$proxy4 = i;
            double value$proxy2 = BoxesRunTime.unboxToDouble((Object)f$proxy1.apply((Object)BoxesRunTime.boxToInteger((int)i)));
            ((NArr)out).update(index$proxy4, (Object)BoxesRunTime.boxToDouble((double)value$proxy2));
        }
        return out;
    }

    private final /* synthetic */ double $anonfun$4(int r$2, int c) {
        if (r$2 < c) {
            Matrix<M, N> Matrix_this = this.QR();
            return BoxesRunTime.unboxToDouble((Object)((TypedArray)Matrix_this.values().apply(r$2)).apply(c));
        }
        if (r$2 == c) {
            package$ package$2 = package$.MODULE$;
            Float64Array thisVector$proxy3 = this.Rdiag();
            return BoxesRunTime.unboxToDouble((Object)thisVector$proxy3.apply(r$2));
        }
        return 0.0;
    }

    private final /* synthetic */ Float64Array $anonfun$3(int r) {
        Function1 & Serializable f$proxy3 = (Function1 & Serializable)c -> this.$anonfun$4(r, BoxesRunTime.unboxToInt((Object)c));
        ClassTag x$3$proxy4 = ClassTag$.MODULE$.apply(Double.TYPE);
        Float64Array out = new Float64Array(this.columns());
        for (int i = 0; i < this.columns(); ++i) {
            int index$proxy6 = i;
            double value$proxy4 = BoxesRunTime.unboxToDouble((Object)f$proxy3.apply((Object)BoxesRunTime.boxToInteger((int)i)));
            ((NArr)out).update(index$proxy6, (Object)BoxesRunTime.boxToDouble((double)value$proxy4));
        }
        return out;
    }
}

