/*
 * Decompiled with CFR 0.152.
 */
package ai.dragonfly.mesh.shape;

import ai.dragonfly.mesh.Mesh;
import ai.dragonfly.mesh.Triangle;
import ai.dragonfly.mesh.Triangle$;
import ai.dragonfly.mesh.shape.package$;
import java.io.Serializable;
import narr.native.NArr;
import narr.package;
import scala.Predef$;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.scalajs.js.Array;
import scala.scalajs.js.typedarray.Float64Array;
import scala.scalajs.js.typedarray.Int8Array;
import slash.Constant$;
import slash.UnsupportedVectorDimension$;
import slash.vector.package;

public final class Drum$
implements Serializable {
    public static final Drum$ MODULE$ = new Drum$();

    private Drum$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Drum$.class);
    }

    public Mesh apply(int angularSegments, int sideSegments, int baseSegments, int capSegments, double baseRadius, double capRadius, double height, String name) {
        Float64Array float64Array;
        Float64Array float64Array2;
        if (angularSegments < 3) {
            throw new IllegalArgumentException("Drum doesn't support radial segment values less than 3.");
        }
        if (sideSegments < 1 || baseSegments < 1 || capSegments < 1) {
            throw new IllegalArgumentException("Drum doesn't support 0 segment values.");
        }
        if (height < 0.0 || baseRadius < 0.0 || capRadius < 0.0) {
            throw new IllegalArgumentException("Drum doesn't support negative dimension values.");
        }
        double \u0394\u03b8 = (double)2 * Constant$.MODULE$.\u03c0() / (double)angularSegments;
        int cuts = 2 + baseSegments + sideSegments + capSegments - 3;
        int length$proxy1 = 2 + cuts * angularSegments;
        ClassTag x$2$proxy1 = ClassTag$.MODULE$.apply(Float64Array.class);
        int n$proxy1 = length$proxy1;
        Array points = new Array(n$proxy1);
        int pEnd = ((NArr)narr.package$.MODULE$.nArray2NArr((Int8Array)points)).length() - 1;
        NArr nArr = (NArr)narr.package$.MODULE$.nArray2NArr((Int8Array)points);
        slash.vector.package$ package$2 = slash.vector.package$.MODULE$;
        package.Vec$ Vec$_this = package.Vec$.MODULE$;
        slash.vector.package$ package$_this = package$2;
        ArraySeq d$proxy1 = ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 0.0});
        Integer ev = BoxesRunTime.boxToInteger((int)3);
        int dimension = 3;
        int supplied$proxy1 = d$proxy1.size();
        if (supplied$proxy1 != dimension) {
            throw UnsupportedVectorDimension$.MODULE$.apply(supplied$proxy1, dimension);
        }
        int n = d$proxy1.size();
        int dim = n;
        if (dim < 2) {
            throw UnsupportedVectorDimension$.MODULE$.apply(dim, UnsupportedVectorDimension$.MODULE$.$lessinit$greater$default$2());
        }
        switch (n) {
            case 2: {
                slash.vector.package$ package$3;
                slash.vector.package$ package$_this2 = package$3 = package$2;
                double x$proxy1 = BoxesRunTime.unboxToDouble((Object)d$proxy1.apply(0));
                double y$proxy1 = BoxesRunTime.unboxToDouble((Object)d$proxy1.apply(1));
                float64Array2 = (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy1, y$proxy1}), ClassTag$.MODULE$.apply(Double.TYPE));
                break;
            }
            case 3: {
                slash.vector.package$ package$4;
                slash.vector.package$ package$_this3 = package$4 = package$2;
                double x$proxy2 = BoxesRunTime.unboxToDouble((Object)d$proxy1.apply(0));
                double y$proxy2 = BoxesRunTime.unboxToDouble((Object)d$proxy1.apply(1));
                double z$proxy1 = BoxesRunTime.unboxToDouble((Object)d$proxy1.apply(2));
                float64Array2 = (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy2, y$proxy2, z$proxy1}), ClassTag$.MODULE$.apply(Double.TYPE));
                break;
            }
            case 4: {
                slash.vector.package$ package$5;
                slash.vector.package$ package$_this4 = package$5 = package$2;
                double x$proxy3 = BoxesRunTime.unboxToDouble((Object)d$proxy1.apply(0));
                double y$proxy3 = BoxesRunTime.unboxToDouble((Object)d$proxy1.apply(1));
                double z$proxy2 = BoxesRunTime.unboxToDouble((Object)d$proxy1.apply(2));
                double w$proxy1 = BoxesRunTime.unboxToDouble((Object)d$proxy1.apply(3));
                float64Array2 = (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy3, y$proxy3, z$proxy2, w$proxy1}), ClassTag$.MODULE$.apply(Double.TYPE));
                break;
            }
            default: {
                slash.vector.package$ package$6;
                slash.vector.package$ package$_this5 = package$6 = package$2;
                Float64Array a$proxy1 = (Float64Array)package.NArray$.MODULE$.apply((Seq)d$proxy1, ClassTag$.MODULE$.apply(Double.TYPE));
                Integer ev2 = BoxesRunTime.boxToInteger((int)dimension);
                int requiredDimension$proxy1 = BoxesRunTime.unboxToInt((Object)ev2);
                if (a$proxy1.length() != requiredDimension$proxy1) {
                    throw UnsupportedVectorDimension$.MODULE$.apply(a$proxy1.length(), requiredDimension$proxy1);
                }
                float64Array2 = a$proxy1;
                break;
            }
        }
        nArr.update(0, (Object)float64Array2);
        NArr nArr2 = (NArr)narr.package$.MODULE$.nArray2NArr((Int8Array)points);
        slash.vector.package$ package$7 = slash.vector.package$.MODULE$;
        package.Vec$ Vec$_this2 = package.Vec$.MODULE$;
        slash.vector.package$ package$_this6 = package$7;
        ArraySeq d$proxy2 = ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, height});
        Integer ev3 = BoxesRunTime.boxToInteger((int)3);
        int dimension2 = 3;
        int supplied$proxy2 = d$proxy2.size();
        if (supplied$proxy2 != dimension2) {
            throw UnsupportedVectorDimension$.MODULE$.apply(supplied$proxy2, dimension2);
        }
        int n2 = d$proxy2.size();
        int dim2 = n2;
        if (dim2 < 2) {
            throw UnsupportedVectorDimension$.MODULE$.apply(dim2, UnsupportedVectorDimension$.MODULE$.$lessinit$greater$default$2());
        }
        switch (n2) {
            case 2: {
                slash.vector.package$ package$8;
                slash.vector.package$ package$_this7 = package$8 = package$7;
                double x$proxy4 = BoxesRunTime.unboxToDouble((Object)d$proxy2.apply(0));
                double y$proxy4 = BoxesRunTime.unboxToDouble((Object)d$proxy2.apply(1));
                float64Array = (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy4, y$proxy4}), ClassTag$.MODULE$.apply(Double.TYPE));
                break;
            }
            case 3: {
                slash.vector.package$ package$9;
                slash.vector.package$ package$_this8 = package$9 = package$7;
                double x$proxy5 = BoxesRunTime.unboxToDouble((Object)d$proxy2.apply(0));
                double y$proxy5 = BoxesRunTime.unboxToDouble((Object)d$proxy2.apply(1));
                double z$proxy3 = BoxesRunTime.unboxToDouble((Object)d$proxy2.apply(2));
                float64Array = (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy5, y$proxy5, z$proxy3}), ClassTag$.MODULE$.apply(Double.TYPE));
                break;
            }
            case 4: {
                slash.vector.package$ package$10;
                slash.vector.package$ package$_this9 = package$10 = package$7;
                double x$proxy6 = BoxesRunTime.unboxToDouble((Object)d$proxy2.apply(0));
                double y$proxy6 = BoxesRunTime.unboxToDouble((Object)d$proxy2.apply(1));
                double z$proxy4 = BoxesRunTime.unboxToDouble((Object)d$proxy2.apply(2));
                double w$proxy2 = BoxesRunTime.unboxToDouble((Object)d$proxy2.apply(3));
                float64Array = (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy6, y$proxy6, z$proxy4, w$proxy2}), ClassTag$.MODULE$.apply(Double.TYPE));
                break;
            }
            default: {
                slash.vector.package$ package$11;
                slash.vector.package$ package$_this10 = package$11 = package$7;
                Float64Array a$proxy2 = (Float64Array)package.NArray$.MODULE$.apply((Seq)d$proxy2, ClassTag$.MODULE$.apply(Double.TYPE));
                Integer ev4 = BoxesRunTime.boxToInteger((int)dimension2);
                int requiredDimension$proxy2 = BoxesRunTime.unboxToInt((Object)ev4);
                if (a$proxy2.length() != requiredDimension$proxy2) {
                    throw UnsupportedVectorDimension$.MODULE$.apply(a$proxy2.length(), requiredDimension$proxy2);
                }
                float64Array = a$proxy2;
                break;
            }
        }
        nArr2.update(pEnd, (Object)float64Array);
        double dT = 0.0;
        int p = 1;
        int pcount = 2;
        int cut = 0;
        while (cut < cuts) {
            ++cut;
            for (p = 1; p <= angularSegments; ++p) {
                Float64Array float64Array3;
                double r = baseRadius;
                double h = 0.0;
                if (cut < baseSegments) {
                    double w = (double)cut / (double)baseSegments;
                    r = baseRadius * w;
                } else if (cut == baseSegments) {
                    r = baseRadius;
                } else if (cut < baseSegments + sideSegments) {
                    double w = (double)(cut - baseSegments) / (double)sideSegments;
                    r = w * baseRadius + (1.0 - w) * capRadius;
                    h = w * height;
                } else if (cut == baseSegments + sideSegments) {
                    r = capRadius;
                    h = height;
                } else {
                    double w = 1.0 - (double)(cut - (baseSegments + sideSegments)) / (double)capSegments;
                    r = capRadius * w;
                    h = height;
                }
                double x = r * Math.cos(dT);
                double y = r * Math.sin(dT);
                int cutOffset = (cut - 1) * angularSegments;
                NArr nArr3 = (NArr)narr.package$.MODULE$.nArray2NArr((Int8Array)points);
                slash.vector.package$ package$12 = slash.vector.package$.MODULE$;
                package.Vec$ Vec$_this3 = package.Vec$.MODULE$;
                slash.vector.package$ package$_this11 = package$12;
                ArraySeq d$proxy3 = ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x, y, h});
                Integer ev5 = BoxesRunTime.boxToInteger((int)3);
                int dimension3 = 3;
                int supplied$proxy3 = d$proxy3.size();
                if (supplied$proxy3 != dimension3) {
                    throw UnsupportedVectorDimension$.MODULE$.apply(supplied$proxy3, dimension3);
                }
                int n3 = d$proxy3.size();
                int dim3 = n3;
                if (dim3 < 2) {
                    throw UnsupportedVectorDimension$.MODULE$.apply(dim3, UnsupportedVectorDimension$.MODULE$.$lessinit$greater$default$2());
                }
                switch (n3) {
                    case 2: {
                        slash.vector.package$ package$13;
                        slash.vector.package$ package$_this12 = package$13 = package$12;
                        double x$proxy7 = BoxesRunTime.unboxToDouble((Object)d$proxy3.apply(0));
                        double y$proxy7 = BoxesRunTime.unboxToDouble((Object)d$proxy3.apply(1));
                        float64Array3 = (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy7, y$proxy7}), ClassTag$.MODULE$.apply(Double.TYPE));
                        break;
                    }
                    case 3: {
                        slash.vector.package$ package$14;
                        slash.vector.package$ package$_this13 = package$14 = package$12;
                        double x$proxy8 = BoxesRunTime.unboxToDouble((Object)d$proxy3.apply(0));
                        double y$proxy8 = BoxesRunTime.unboxToDouble((Object)d$proxy3.apply(1));
                        double z$proxy5 = BoxesRunTime.unboxToDouble((Object)d$proxy3.apply(2));
                        float64Array3 = (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy8, y$proxy8, z$proxy5}), ClassTag$.MODULE$.apply(Double.TYPE));
                        break;
                    }
                    case 4: {
                        slash.vector.package$ package$15;
                        slash.vector.package$ package$_this14 = package$15 = package$12;
                        double x$proxy9 = BoxesRunTime.unboxToDouble((Object)d$proxy3.apply(0));
                        double y$proxy9 = BoxesRunTime.unboxToDouble((Object)d$proxy3.apply(1));
                        double z$proxy6 = BoxesRunTime.unboxToDouble((Object)d$proxy3.apply(2));
                        double w$proxy3 = BoxesRunTime.unboxToDouble((Object)d$proxy3.apply(3));
                        float64Array3 = (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy9, y$proxy9, z$proxy6, w$proxy3}), ClassTag$.MODULE$.apply(Double.TYPE));
                        break;
                    }
                    default: {
                        slash.vector.package$ package$16;
                        slash.vector.package$ package$_this15 = package$16 = package$12;
                        Float64Array a$proxy3 = (Float64Array)package.NArray$.MODULE$.apply((Seq)d$proxy3, ClassTag$.MODULE$.apply(Double.TYPE));
                        Integer ev6 = BoxesRunTime.boxToInteger((int)dimension3);
                        int requiredDimension$proxy3 = BoxesRunTime.unboxToInt((Object)ev6);
                        if (a$proxy3.length() != requiredDimension$proxy3) {
                            throw UnsupportedVectorDimension$.MODULE$.apply(a$proxy3.length(), requiredDimension$proxy3);
                        }
                        float64Array3 = a$proxy3;
                        break;
                    }
                }
                nArr3.update(cutOffset + p, (Object)float64Array3);
                dT = (double)p * \u0394\u03b8;
            }
            pcount += p - 1;
        }
        Array triangles = new Array(2 * angularSegments * (baseSegments + capSegments + sideSegments - 1));
        int t = 0;
        int coEnd = pEnd - angularSegments - 1;
        for (p = 1; p <= angularSegments; ++p) {
            int ps = p % angularSegments;
            triangles.update(t, (Object)Triangle$.MODULE$.apply(0, ps + 1, p));
            triangles.update(t + 1, (Object)Triangle$.MODULE$.apply(pEnd, coEnd + p, coEnd + ps + 1));
            t += 2;
        }
        for (cut = 0; cut < cuts; ++cut) {
            int cutOffset = cut * angularSegments;
            for (p = 1; p <= angularSegments && t < triangles.length(); ++p) {
                int ps = p % angularSegments;
                int off2 = cutOffset + angularSegments;
                t = package$.MODULE$.addQuad(off2 + p, cutOffset + ps + 1, off2 + ps + 1, cutOffset + p, (Array<Triangle>)triangles, t);
            }
        }
        Predef$.MODULE$.println((Object)new StringBuilder(29).append("triangles.length = ").append(triangles.length()).append(", and t = ").append(t).toString());
        return new Mesh(points, (Array<Triangle>)triangles, name);
    }

    public int apply$default$1() {
        return 12;
    }

    public int apply$default$2() {
        return 1;
    }

    public int apply$default$3() {
        return 1;
    }

    public int apply$default$4() {
        return 1;
    }

    public double apply$default$5() {
        return 2.0;
    }

    public double apply$default$6() {
        return 1.0;
    }

    public double apply$default$7() {
        return 1.0;
    }

    public String apply$default$8() {
        return "Drum";
    }
}

