/*
 * Decompiled with CFR 0.152.
 */
package slash.matrix;

import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.util.Random;
import slash.UnsupportedVectorDimension$;
import slash.interval.Interval;
import slash.matrix.Matrix$;

public class Matrix<M, N> {
    private final double[] values;
    private final Integer x$2;
    private final Integer x$3;
    private final int rows;
    private final int columns;
    private final int MxN;

    public static <M, N> Matrix<Object, Object> apply(double[] dArray, Integer n, Integer n2) {
        return Matrix$.MODULE$.apply(dArray, n, n2);
    }

    public static <M, N> Matrix<Object, Object> apply(double[][] dArray, Integer n, Integer n2) {
        return Matrix$.MODULE$.apply(dArray, n, n2);
    }

    public static <M, N> Matrix<Object, Object> apply(Seq<Object> seq, Integer n, Integer n2) {
        return Matrix$.MODULE$.apply(seq, n, n2);
    }

    public static <M, N> Matrix<Object, Object> diagonal(double d, Integer n, Integer n2) {
        return Matrix$.MODULE$.diagonal(d, n, n2);
    }

    public static <D> Matrix<Object, Object> diagonal(double[] dArray, Integer n) {
        return Matrix$.MODULE$.diagonal(dArray, n);
    }

    public static <M, N, D> Matrix<Object, Object> diagonal(double[] dArray, Integer n, Integer n2, Integer n3) {
        return Matrix$.MODULE$.diagonal(dArray, n, n2, n3);
    }

    public static <M, N> Matrix<Object, Object> fill(double d, Integer n, Integer n2) {
        return Matrix$.MODULE$.fill(d, n, n2);
    }

    public static <M, N> Matrix<Object, Object> identity(Integer n, Integer n2) {
        return Matrix$.MODULE$.identity(n, n2);
    }

    public static <M, N> Matrix<Object, Object> ones(Integer n, Integer n2) {
        return Matrix$.MODULE$.ones(n, n2);
    }

    public static <M, N> Matrix<Object, Object> random(Interval<Object> interval, Random random, Integer n, Integer n2) {
        return Matrix$.MODULE$.random(interval, random, n, n2);
    }

    public static <M, N> Matrix<Object, Object> zeros(Integer n, Integer n2) {
        return Matrix$.MODULE$.zeros(n, n2);
    }

    public Matrix(double[] values, Integer x$2, Integer x$3) {
        this.values = values;
        this.x$2 = x$2;
        this.x$3 = x$3;
        Integer ev = x$2;
        this.rows = BoxesRunTime.unboxToInt((Object)ev);
        Integer ev2 = x$3;
        this.columns = BoxesRunTime.unboxToInt((Object)ev2);
        this.MxN = this.rows() * this.columns();
        Predef$.MODULE$.require(this.rows() * this.columns() == values.length, () -> this.$init$$$anonfun$1(values));
    }

    public double[] values() {
        return this.values;
    }

    public int rows() {
        return this.rows;
    }

    public int columns() {
        return this.columns;
    }

    public int MxN() {
        return this.MxN;
    }

    public Matrix<M, N> copy() {
        return new Matrix<M, N>((double[])narr.package$.MODULE$.copy((Object)this.values()), this.x$2, this.x$3);
    }

    public double[] columnPackedArray() {
        double[] vs = new double[this.rows() * this.columns()];
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.columns(); ++j) {
                int r$proxy4 = i;
                int c$proxy4 = j;
                vs[i + j * this.rows()] = this.values()[r$proxy4 * this.columns() + c$proxy4];
            }
        }
        return vs;
    }

    public double[][] rowVectors() {
        Object object;
        ClassTag x$3$proxy3;
        Function1 & Serializable f$proxy2 = (Function1 & Serializable)row -> this.$anonfun$1(BoxesRunTime.unboxToInt((Object)row));
        ClassTag classTag = x$3$proxy3 = ClassTag$.MODULE$.apply(double[].class);
        ManifestFactory.ByteManifest byteManifest = ClassTag$.MODULE$.Byte();
        ClassTag classTag2 = classTag;
        if (!(byteManifest != null ? !byteManifest.equals(classTag2) : classTag2 != null)) {
            object = new byte[this.rows()];
        } else {
            ManifestFactory.ShortManifest shortManifest = ClassTag$.MODULE$.Short();
            ClassTag classTag3 = classTag;
            if (!(shortManifest != null ? !shortManifest.equals(classTag3) : classTag3 != null)) {
                object = new short[this.rows()];
            } else {
                ManifestFactory.IntManifest intManifest = ClassTag$.MODULE$.Int();
                ClassTag classTag4 = classTag;
                if (!(intManifest != null ? !intManifest.equals(classTag4) : classTag4 != null)) {
                    object = new int[this.rows()];
                } else {
                    ManifestFactory.FloatManifest floatManifest = ClassTag$.MODULE$.Float();
                    ClassTag classTag5 = classTag;
                    if (!(floatManifest != null ? !floatManifest.equals(classTag5) : classTag5 != null)) {
                        object = new float[this.rows()];
                    } else {
                        ManifestFactory.DoubleManifest doubleManifest = ClassTag$.MODULE$.Double();
                        ClassTag classTag6 = classTag;
                        if (!(doubleManifest != null ? !doubleManifest.equals(classTag6) : classTag6 != null)) {
                            object = new double[this.rows()];
                        } else {
                            int n$proxy3 = this.rows();
                            object = (double[][])Arrays$.MODULE$.newGenericArray(n$proxy3, x$3$proxy3);
                        }
                    }
                }
            }
        }
        double[][] out = (double[][])object;
        for (int i = 0; i < this.rows(); ++i) {
            out[i] = (double[])f$proxy2.apply((Object)BoxesRunTime.boxToInteger((int)i));
        }
        return out;
    }

    public double[][] columnVectors() {
        return this.transpose().rowVectors();
    }

    public int rowDimension() {
        return this.rows();
    }

    public int columnDimension() {
        return this.columns();
    }

    public <M1, N1> Matrix<Object, Object> subMatrix(int r0, int c0, Integer x$3, Integer x$4) {
        Integer ev = x$3;
        int subRows = BoxesRunTime.unboxToInt((Object)ev);
        Integer ev2 = x$4;
        int subColumns = BoxesRunTime.unboxToInt((Object)ev2);
        int rEnd = r0 + subRows;
        int cEnd = c0 + subColumns;
        double[] vs = new double[subRows * subColumns];
        int i = 0;
        for (int r = r0; r < rEnd; ++r) {
            int c = c0;
            while (c < cEnd) {
                int r$proxy5 = r;
                int c$proxy5 = c++;
                vs[i] = this.values()[r$proxy5 * this.columns() + c$proxy5];
                ++i;
            }
        }
        return new Matrix<Object, Object>(vs, x$3, x$4);
    }

    public <M1, N1> Matrix<Object, Object> subMatrix(int[] rowIndices, int[] columnIndices, Integer x$3, Integer x$4) {
        double[] vs = new double[rowIndices.length * columnIndices.length];
        int i = 0;
        for (int ri = 0; ri < rowIndices.length; ++ri) {
            for (int ci = 0; ci < columnIndices.length; ++ci) {
                int r$proxy6 = rowIndices[ri];
                int c$proxy6 = columnIndices[ci];
                vs[i] = this.values()[r$proxy6 * this.columns() + c$proxy6];
                ++i;
            }
        }
        return new Matrix<Object, Object>(vs, x$3, x$4);
    }

    public <M1, N1> Matrix<Object, Object> subMatrix(int r0, int[] columnIndices, Integer x$3, Integer x$4) {
        Integer ev = x$3;
        int subRows = BoxesRunTime.unboxToInt((Object)ev);
        Integer ev2 = x$4;
        int subColumns = BoxesRunTime.unboxToInt((Object)ev2);
        int rEnd = r0 + subRows;
        double[] vs = new double[subRows * subColumns];
        int i = 0;
        for (int ri = r0; ri < rEnd; ++ri) {
            for (int ci = 0; ci < columnIndices.length; ++ci) {
                int r$proxy7 = ri;
                int c$proxy7 = columnIndices[ci];
                vs[i] = this.values()[r$proxy7 * this.columns() + c$proxy7];
                ++i;
            }
        }
        return new Matrix<Object, Object>(vs, x$3, x$4);
    }

    public <M1, N1> Matrix<Object, Object> subMatrix(int[] rowIndices, int c0, Integer x$3, Integer x$4) {
        Integer ev = x$3;
        int subRows = BoxesRunTime.unboxToInt((Object)ev);
        Integer ev2 = x$4;
        int subColumns = BoxesRunTime.unboxToInt((Object)ev2);
        int cEnd = c0 + subColumns;
        double[] vs = new double[subRows * subColumns];
        int i = 0;
        for (int ri = 0; ri < rowIndices.length; ++ri) {
            int ci = c0;
            while (ci < cEnd) {
                int r$proxy8 = rowIndices[ri];
                int c$proxy8 = ci++;
                vs[i] = this.values()[r$proxy8 * this.columns() + c$proxy8];
                ++i;
            }
        }
        return new Matrix<Object, Object>(vs, x$3, x$4);
    }

    public <M1, N1> void setMatrix(int r0, int c0, Matrix<Object, Object> thatMatrix, Integer x$4, Integer x$5) {
        Integer ev = x$4;
        int rEnd = BoxesRunTime.unboxToInt((Object)ev) + r0;
        Integer ev2 = x$5;
        int cEnd = BoxesRunTime.unboxToInt((Object)ev2) + c0;
        for (int r = r0; r < rEnd; ++r) {
            for (int c = c0; c < cEnd; ++c) {
                double value$proxy3;
                Matrix<Object, Object> matrix;
                Matrix<Object, Object> matrix2;
                int r$proxy10 = r;
                int c$proxy10 = c;
                Matrix<Object, Object> Matrix_this = matrix2 = thatMatrix;
                int r$proxy9 = r - r0;
                int c$proxy9 = c - c0;
                Matrix<Object, Object> Matrix_this2 = matrix = Matrix_this;
                this.values()[r$proxy10 * this.columns() + c$proxy10] = value$proxy3 = Matrix_this.values()[r$proxy9 * Matrix_this2.columns() + c$proxy9];
            }
        }
    }

    public <M1, N1> void setMatrix(int[] rowIndices, int[] columnIndices, Matrix<Object, Object> thatMatrix) {
        for (int i = 0; i < rowIndices.length; ++i) {
            int j = 0;
            while (j < columnIndices.length) {
                double value$proxy4;
                Matrix<Object, Object> matrix;
                Matrix<Object, Object> matrix2;
                int r$proxy12 = rowIndices[i];
                int c$proxy12 = columnIndices[j];
                Matrix<Object, Object> Matrix_this = matrix2 = thatMatrix;
                int r$proxy11 = i;
                int c$proxy11 = j++;
                Matrix<Object, Object> Matrix_this2 = matrix = Matrix_this;
                this.values()[r$proxy12 * this.columns() + c$proxy12] = value$proxy4 = Matrix_this.values()[r$proxy11 * Matrix_this2.columns() + c$proxy11];
            }
        }
    }

    public <M1, N1> void setMatrix(int[] rowIndices, int c0, Matrix<Object, Object> thatMatrix, Integer x$4, Integer x$5) {
        Integer ev = x$5;
        int c1 = c0 + BoxesRunTime.unboxToInt((Object)ev);
        for (int r = 0; r < rowIndices.length; ++r) {
            for (int c = c0; c < c1; ++c) {
                double value$proxy5;
                Matrix<Object, Object> matrix;
                Matrix<Object, Object> matrix2;
                int r$proxy14 = rowIndices[r];
                int c$proxy14 = c;
                Matrix<Object, Object> Matrix_this = matrix2 = thatMatrix;
                int r$proxy13 = r;
                int c$proxy13 = c - c0;
                Matrix<Object, Object> Matrix_this2 = matrix = Matrix_this;
                this.values()[r$proxy14 * this.columns() + c$proxy14] = value$proxy5 = Matrix_this.values()[r$proxy13 * Matrix_this2.columns() + c$proxy13];
            }
        }
    }

    public <M1, N1> void setMatrix(int r0, int[] columnIndices, Matrix<Object, Object> thatMatrix, Integer x$4, Integer x$5) {
        Integer ev = x$4;
        int r1 = r0 + BoxesRunTime.unboxToInt((Object)ev);
        for (int r = r0; r < r1; ++r) {
            int c = 0;
            while (c < columnIndices.length) {
                double value$proxy6;
                Matrix<Object, Object> matrix;
                Matrix<Object, Object> matrix2;
                int r$proxy16 = r;
                int c$proxy16 = columnIndices[c];
                Matrix<Object, Object> Matrix_this = matrix2 = thatMatrix;
                int r$proxy15 = r - r0;
                int c$proxy15 = c++;
                Matrix<Object, Object> Matrix_this2 = matrix = Matrix_this;
                this.values()[r$proxy16 * this.columns() + c$proxy16] = value$proxy6 = Matrix_this.values()[r$proxy15 * Matrix_this2.columns() + c$proxy15];
            }
        }
    }

    public Matrix<N, M> transpose() {
        return new Matrix<M, N>(this.columnPackedArray(), this.x$3, this.x$2);
    }

    public double norm1() {
        double maxColumnSum = -1.7976931348623157E308;
        for (int c = 0; c < this.columns(); ++c) {
            double columnSum = 0.0;
            int r = 0;
            while (r < this.rows()) {
                int r$proxy17 = r++;
                int c$proxy17 = c;
                columnSum += Math.abs(this.values()[r$proxy17 * this.columns() + c$proxy17]);
            }
            maxColumnSum = Math.max(maxColumnSum, columnSum);
        }
        return maxColumnSum;
    }

    public double normInfinity() {
        double maxRowSum = -1.7976931348623157E308;
        for (int r = 0; r < this.rows(); ++r) {
            double rowSum = 0.0;
            int c = 0;
            while (c < this.columns()) {
                int r$proxy18 = r;
                int c$proxy18 = c++;
                rowSum += Math.abs(this.values()[r$proxy18 * this.columns() + c$proxy18]);
            }
            maxRowSum = Math.max(maxRowSum, rowSum);
        }
        return maxRowSum;
    }

    public double normFrobenius() {
        double f = 0.0;
        for (int i = 0; i < this.values().length; ++i) {
            f = package$.MODULE$.hypot(f, this.values()[i]);
        }
        return f;
    }

    public Matrix<M, N> add(Matrix<M, N> B) {
        for (int r = 0; r < this.rows(); ++r) {
            int c = 0;
            while (c < this.columns()) {
                double value$proxy7;
                Matrix<M, N> matrix;
                Matrix<M, N> matrix2;
                int r$proxy21 = r;
                int c$proxy21 = c;
                int r$proxy19 = r;
                int c$proxy19 = c;
                Matrix<M, N> Matrix_this = matrix2 = B;
                int r$proxy20 = r;
                int c$proxy20 = c++;
                Matrix<M, N> Matrix_this2 = matrix = Matrix_this;
                this.values()[r$proxy21 * this.columns() + c$proxy21] = value$proxy7 = this.values()[r$proxy19 * this.columns() + c$proxy19] + Matrix_this.values()[r$proxy20 * Matrix_this2.columns() + c$proxy20];
            }
        }
        return this;
    }

    public Matrix<M, N> subtract(Matrix<M, N> B) {
        for (int r = 0; r < this.rows(); ++r) {
            int c = 0;
            while (c < this.columns()) {
                double value$proxy8;
                Matrix<M, N> matrix;
                Matrix<M, N> matrix2;
                int r$proxy24 = r;
                int c$proxy24 = c;
                int r$proxy22 = r;
                int c$proxy22 = c;
                Matrix<M, N> Matrix_this = matrix2 = B;
                int r$proxy23 = r;
                int c$proxy23 = c++;
                Matrix<M, N> Matrix_this2 = matrix = Matrix_this;
                this.values()[r$proxy24 * this.columns() + c$proxy24] = value$proxy8 = this.values()[r$proxy22 * this.columns() + c$proxy22] - Matrix_this.values()[r$proxy23 * Matrix_this2.columns() + c$proxy23];
            }
        }
        return this;
    }

    public Matrix<M, N> times(double s) {
        for (int i = 0; i < this.values().length; ++i) {
            this.values()[i] = this.values()[i] * s;
        }
        return this;
    }

    public <V> Matrix<M, Object> $times(Matrix<N, Object> thatMatrix, Integer x$2) {
        return this.times(thatMatrix, x$2);
    }

    public <V> Matrix<M, Object> times(Matrix<N, Object> b, Integer x$2) {
        Matrix<Object, Object> X = Matrix$.MODULE$.zeros(this.x$2, x$2);
        double[] Bcolj = new double[this.columns()];
        for (int j = 0; j < b.columns(); ++j) {
            int k;
            for (k = 0; k < this.columns(); ++k) {
                Matrix<Object, Object> matrix;
                Matrix<Object, Object> matrix2;
                Matrix<Object, Object> Matrix_this = matrix2 = b;
                int r$proxy25 = k;
                int c$proxy25 = j;
                Matrix<Object, Object> Matrix_this2 = matrix = Matrix_this;
                Bcolj[k] = Matrix_this.values()[r$proxy25 * Matrix_this2.columns() + c$proxy25];
            }
            int i = 0;
            while (i < this.rows()) {
                Matrix<Object, Object> matrix;
                Matrix<Object, Object> matrix3;
                double s = 0.0;
                for (k = 0; k < this.columns(); ++k) {
                    int r$proxy26 = i;
                    int c$proxy26 = k;
                    s += this.values()[r$proxy26 * this.columns() + c$proxy26] * Bcolj[k];
                }
                Matrix<Object, Object> Matrix_this = matrix3 = X;
                int r$proxy27 = i++;
                int c$proxy27 = j;
                double value$proxy9 = s;
                Matrix<Object, Object> Matrix_this3 = matrix = Matrix_this;
                Matrix_this.values()[r$proxy27 * Matrix_this3.columns() + c$proxy27] = value$proxy9;
            }
        }
        return X;
    }

    public double trace() {
        double t = 0.0;
        int i = 0;
        while (i < Math.min(this.rows(), this.columns())) {
            int r$proxy28 = i;
            int c$proxy28 = i++;
            t += this.values()[r$proxy28 * this.columns() + c$proxy28];
        }
        return t;
    }

    public String dim() {
        return new StringBuilder(6).append("dim(").append(this.rows()).append("x").append(this.columns()).append(")").toString();
    }

    public double[][] asNativeArray2D() {
        return this.rowVectors();
    }

    public String toString() {
        scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
        for (int r = 0; r < this.rows(); ++r) {
            sb.append("\n");
            int c = 0;
            while (c < this.columns()) {
                int r$proxy29 = r;
                int c$proxy29 = c++;
                sb.append(new StringBuilder(2).append(BoxesRunTime.boxToDouble((double)this.values()[r$proxy29 * this.columns() + c$proxy29])).append(", ").toString());
            }
        }
        return sb.toString();
    }

    private final Object $init$$$anonfun$1(double[] values$1) {
        return new StringBuilder(18).append("Product of ").append(this.rows()).append(" x ").append(this.columns()).append(" != ").append(values$1.length).toString();
    }

    private final /* synthetic */ double[] $anonfun$1(int row) {
        Integer ev;
        int requiredDimension$proxy1;
        slash.vector.package$ package$2;
        slash.vector.package$ package$_this = package$2 = slash.vector.package$.MODULE$;
        Object object = Predef$.MODULE$.doubleArrayOps(this.values());
        double[] a$proxy1 = (double[])ArrayOps$.MODULE$.slice$extension(object, row * this.columns(), row * this.columns() + this.columns());
        int supplied$proxy2 = a$proxy1.length;
        if (supplied$proxy2 != (requiredDimension$proxy1 = BoxesRunTime.unboxToInt((Object)(ev = this.x$3)))) {
            throw UnsupportedVectorDimension$.MODULE$.apply(supplied$proxy2, requiredDimension$proxy1);
        }
        return a$proxy1;
    }
}

