/*
 * Decompiled with CFR 0.152.
 */
package slash.matrix.decomposition;

import java.io.Serializable;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.java8.JFunction1;
import slash.matrix.Matrix;
import slash.matrix.Matrix$;
import slash.matrix.decomposition.LU$;

public class LU<M, N> {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(LU.class.getDeclaredField("L$lzy1"));
    private final Matrix LU;
    private final int[] piv;
    private final double pivsign;
    private final Integer x$4;
    private final Integer x$5;
    private final int m;
    private final int n;
    private volatile Object L$lzy1;

    public static <M, N> LU<Object, Object> apply(Matrix<Object, Object> matrix, Integer n, Integer n2) {
        return LU$.MODULE$.apply(matrix, n, n2);
    }

    public LU(Matrix<Object, Object> LU2, int[] piv, double pivsign, Integer x$4, Integer x$5) {
        this.LU = LU2;
        this.piv = piv;
        this.pivsign = pivsign;
        this.x$4 = x$4;
        this.x$5 = x$5;
        Integer ev = x$4;
        this.m = BoxesRunTime.unboxToInt((Object)ev);
        Integer ev2 = x$5;
        this.n = BoxesRunTime.unboxToInt((Object)ev2);
    }

    public Matrix<M, N> LU() {
        return this.LU;
    }

    public int m() {
        return this.m;
    }

    public int n() {
        return this.n;
    }

    public boolean isSingular() {
        int j = 0;
        while (j < this.n()) {
            Matrix<M, N> matrix;
            Matrix<M, N> matrix2;
            Matrix<M, N> Matrix_this = matrix2 = this.LU();
            int r$proxy12 = j;
            int c$proxy12 = j++;
            Matrix<M, N> Matrix_this2 = matrix = Matrix_this;
            if (Matrix_this.values()[r$proxy12 * Matrix_this2.columns() + c$proxy12] != 0.0) continue;
            return true;
        }
        return false;
    }

    public Matrix<M, N> L() {
        Object object = this.L$lzy1;
        if (object instanceof Matrix) {
            return (Matrix)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Matrix)this.L$lzyINIT1();
    }

    private Object L$lzyINIT1() {
        Object object;
        block11: {
            while (true) {
                if ((object = this.L$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Matrix<Object, Object> matrix = null;
                    try {
                        double[] values = new double[this.m() * this.n()];
                        int i = 0;
                        for (int r = 0; r < this.m(); ++r) {
                            for (int c = 0; c < this.n(); ++c) {
                                double d;
                                if (r > c) {
                                    Matrix<M, N> matrix2;
                                    Matrix<M, N> matrix3;
                                    Matrix<M, N> Matrix_this = matrix3 = this.LU();
                                    int r$proxy13 = r;
                                    int c$proxy13 = c;
                                    Matrix<M, N> Matrix_this2 = matrix2 = Matrix_this;
                                    d = Matrix_this.values()[r$proxy13 * Matrix_this2.columns() + c$proxy13];
                                } else {
                                    d = r == c ? 1.0 : 0.0;
                                }
                                values[i] = d;
                                ++i;
                            }
                        }
                        matrix = Matrix$.MODULE$.apply(values, this.x$4, this.x$5);
                        object2 = matrix == null ? LazyVals.NullValue$.MODULE$ : matrix;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.L$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.L$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return matrix;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block11;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Matrix<N, N> U() {
        double[] values = new double[this.n() * this.n()];
        int i = 0;
        for (int r = 0; r < this.n(); ++r) {
            for (int c = 0; c < this.n(); ++c) {
                double d;
                if (r > c) {
                    d = 0.0;
                } else {
                    Matrix<M, N> matrix;
                    Matrix<M, N> matrix2;
                    Matrix<M, N> Matrix_this = matrix2 = this.LU();
                    int r$proxy14 = r;
                    int c$proxy14 = c;
                    Matrix<M, N> Matrix_this2 = matrix = Matrix_this;
                    d = Matrix_this.values()[r$proxy14 * Matrix_this2.columns() + c$proxy14];
                }
                values[i] = d;
                ++i;
            }
        }
        return Matrix$.MODULE$.apply(values, this.x$5, this.x$5);
    }

    public int[] pivot() {
        Object[] objectArray;
        ClassTag x$3$proxy3;
        JFunction1.mcII.sp & Serializable f$proxy2 = (JFunction1.mcII.sp & Serializable)i -> this.piv[i];
        ClassTag classTag = x$3$proxy3 = ClassTag$.MODULE$.apply(Integer.TYPE);
        ManifestFactory.ByteManifest byteManifest = ClassTag$.MODULE$.Byte();
        ClassTag classTag2 = classTag;
        if (!(byteManifest != null ? !byteManifest.equals(classTag2) : classTag2 != null)) {
            objectArray = new byte[this.m()];
        } else {
            ManifestFactory.ShortManifest shortManifest = ClassTag$.MODULE$.Short();
            ClassTag classTag3 = classTag;
            if (!(shortManifest != null ? !shortManifest.equals(classTag3) : classTag3 != null)) {
                objectArray = new short[this.m()];
            } else {
                ManifestFactory.IntManifest intManifest = ClassTag$.MODULE$.Int();
                ClassTag classTag4 = classTag;
                if (!(intManifest != null ? !intManifest.equals(classTag4) : classTag4 != null)) {
                    objectArray = new int[this.m()];
                } else {
                    ManifestFactory.FloatManifest floatManifest = ClassTag$.MODULE$.Float();
                    ClassTag classTag5 = classTag;
                    if (!(floatManifest != null ? !floatManifest.equals(classTag5) : classTag5 != null)) {
                        objectArray = new float[this.m()];
                    } else {
                        ManifestFactory.DoubleManifest doubleManifest = ClassTag$.MODULE$.Double();
                        ClassTag classTag6 = classTag;
                        if (!(doubleManifest != null ? !doubleManifest.equals(classTag6) : classTag6 != null)) {
                            objectArray = new double[this.m()];
                        } else {
                            int n$proxy3 = this.m();
                            objectArray = (int[])Arrays$.MODULE$.newGenericArray(n$proxy3, x$3$proxy3);
                        }
                    }
                }
            }
        }
        int[] out = objectArray;
        for (int i2 = 0; i2 < this.m(); ++i2) {
            out[i2] = f$proxy2.apply$mcII$sp(i2);
        }
        return out;
    }

    public double[] doubleValuedPivot() {
        Object[] objectArray;
        ClassTag x$3$proxy4;
        JFunction1.mcDI.sp & Serializable f$proxy3 = (JFunction1.mcDI.sp & Serializable)i -> this.piv[i];
        ClassTag classTag = x$3$proxy4 = ClassTag$.MODULE$.apply(Double.TYPE);
        ManifestFactory.ByteManifest byteManifest = ClassTag$.MODULE$.Byte();
        ClassTag classTag2 = classTag;
        if (!(byteManifest != null ? !byteManifest.equals(classTag2) : classTag2 != null)) {
            objectArray = new byte[this.m()];
        } else {
            ManifestFactory.ShortManifest shortManifest = ClassTag$.MODULE$.Short();
            ClassTag classTag3 = classTag;
            if (!(shortManifest != null ? !shortManifest.equals(classTag3) : classTag3 != null)) {
                objectArray = new short[this.m()];
            } else {
                ManifestFactory.IntManifest intManifest = ClassTag$.MODULE$.Int();
                ClassTag classTag4 = classTag;
                if (!(intManifest != null ? !intManifest.equals(classTag4) : classTag4 != null)) {
                    objectArray = new int[this.m()];
                } else {
                    ManifestFactory.FloatManifest floatManifest = ClassTag$.MODULE$.Float();
                    ClassTag classTag5 = classTag;
                    if (!(floatManifest != null ? !floatManifest.equals(classTag5) : classTag5 != null)) {
                        objectArray = new float[this.m()];
                    } else {
                        ManifestFactory.DoubleManifest doubleManifest = ClassTag$.MODULE$.Double();
                        ClassTag classTag6 = classTag;
                        if (!(doubleManifest != null ? !doubleManifest.equals(classTag6) : classTag6 != null)) {
                            objectArray = new double[this.m()];
                        } else {
                            int n$proxy4 = this.m();
                            objectArray = (double[])Arrays$.MODULE$.newGenericArray(n$proxy4, x$3$proxy4);
                        }
                    }
                }
            }
        }
        double[] out = objectArray;
        for (int i2 = 0; i2 < this.m(); ++i2) {
            out[i2] = f$proxy3.apply$mcDI$sp(i2);
        }
        return out;
    }

    public double determinant() {
        if (this.m() != this.n()) {
            throw new IllegalArgumentException("Matrix must be square.");
        }
        double d = this.pivsign;
        int j = 0;
        while (j < this.n()) {
            Matrix<M, N> matrix;
            Matrix<M, N> matrix2;
            Matrix<M, N> Matrix_this = matrix2 = this.LU();
            int r$proxy15 = j;
            int c$proxy15 = j++;
            Matrix<M, N> Matrix_this2 = matrix = Matrix_this;
            d *= Matrix_this.values()[r$proxy15 * Matrix_this2.columns() + c$proxy15];
        }
        return d;
    }

    public <V> Matrix<N, Object> solve(Matrix<M, Object> B, Integer x$2) {
        int k;
        if (this.isSingular()) {
            throw new RuntimeException("Matrix is singular.");
        }
        int nx = B.columns();
        Matrix<Object, Object> X = B.subMatrix(this.piv, 0, this.x$5, x$2);
        for (k = 0; k < this.n(); ++k) {
            for (int i = k + 1; i < this.n(); ++i) {
                int j = 0;
                while (j < nx) {
                    Matrix<Object, Object> matrix;
                    Matrix<M, N> matrix2;
                    Matrix<M, N> matrix3;
                    Matrix<Object, Object> matrix4;
                    Matrix<Object, Object> matrix5;
                    Matrix<Object, Object> matrix6;
                    Matrix<Object, Object> matrix7;
                    Matrix<Object, Object> matrix8;
                    Matrix<Object, Object> Matrix_this = matrix8 = X;
                    int r$proxy19 = i;
                    int c$proxy19 = j;
                    Matrix<Object, Object> Matrix_this2 = matrix7 = X;
                    int r$proxy16 = i;
                    int c$proxy16 = j;
                    Matrix<Object, Object> Matrix_this3 = matrix6 = Matrix_this2;
                    Matrix<Object, Object> Matrix_this4 = matrix5 = X;
                    int r$proxy17 = k;
                    int c$proxy17 = j++;
                    Matrix<Object, Object> Matrix_this5 = matrix4 = Matrix_this4;
                    Matrix<M, N> Matrix_this6 = matrix3 = this.LU();
                    int r$proxy18 = i;
                    int c$proxy18 = k;
                    Matrix<M, N> Matrix_this7 = matrix2 = Matrix_this6;
                    double value$proxy4 = Matrix_this2.values()[r$proxy16 * Matrix_this3.columns() + c$proxy16] - Matrix_this4.values()[r$proxy17 * Matrix_this5.columns() + c$proxy17] * Matrix_this6.values()[r$proxy18 * Matrix_this7.columns() + c$proxy18];
                    Matrix<Object, Object> Matrix_this8 = matrix = Matrix_this;
                    Matrix_this.values()[r$proxy19 * Matrix_this8.columns() + c$proxy19] = value$proxy4;
                }
            }
        }
        for (k = this.n() - 1; k > -1; --k) {
            int j = 0;
            while (j < nx) {
                Matrix<Object, Object> matrix;
                Matrix<M, N> matrix9;
                Matrix<M, N> matrix10;
                Matrix<Object, Object> matrix11;
                Matrix<Object, Object> matrix12;
                Matrix<Object, Object> matrix13;
                Matrix<Object, Object> Matrix_this = matrix13 = X;
                int r$proxy22 = k;
                int c$proxy22 = j;
                Matrix<Object, Object> Matrix_this9 = matrix12 = X;
                int r$proxy20 = k;
                int c$proxy20 = j++;
                Matrix<Object, Object> Matrix_this10 = matrix11 = Matrix_this9;
                Matrix<M, N> Matrix_this11 = matrix10 = this.LU();
                int r$proxy21 = k;
                int c$proxy21 = k;
                Matrix<M, N> Matrix_this12 = matrix9 = Matrix_this11;
                double value$proxy5 = Matrix_this9.values()[r$proxy20 * Matrix_this10.columns() + c$proxy20] / Matrix_this11.values()[r$proxy21 * Matrix_this12.columns() + c$proxy21];
                Matrix<Object, Object> Matrix_this13 = matrix = Matrix_this;
                Matrix_this.values()[r$proxy22 * Matrix_this13.columns() + c$proxy22] = value$proxy5;
            }
            for (int i = 0; i < k; ++i) {
                int j1 = 0;
                while (j1 < nx) {
                    Matrix<Object, Object> matrix;
                    Matrix<M, N> matrix14;
                    Matrix<M, N> matrix15;
                    Matrix<Object, Object> matrix16;
                    Matrix<Object, Object> matrix17;
                    Matrix<Object, Object> matrix18;
                    Matrix<Object, Object> matrix19;
                    Matrix<Object, Object> matrix20;
                    Matrix<Object, Object> Matrix_this = matrix20 = X;
                    int r$proxy26 = i;
                    int c$proxy26 = j1;
                    Matrix<Object, Object> Matrix_this14 = matrix19 = X;
                    int r$proxy23 = i;
                    int c$proxy23 = j1;
                    Matrix<Object, Object> Matrix_this15 = matrix18 = Matrix_this14;
                    Matrix<Object, Object> Matrix_this16 = matrix17 = X;
                    int r$proxy24 = k;
                    int c$proxy24 = j1++;
                    Matrix<Object, Object> Matrix_this17 = matrix16 = Matrix_this16;
                    Matrix<M, N> Matrix_this18 = matrix15 = this.LU();
                    int r$proxy25 = i;
                    int c$proxy25 = k;
                    Matrix<M, N> Matrix_this19 = matrix14 = Matrix_this18;
                    double value$proxy6 = Matrix_this14.values()[r$proxy23 * Matrix_this15.columns() + c$proxy23] - Matrix_this16.values()[r$proxy24 * Matrix_this17.columns() + c$proxy24] * Matrix_this18.values()[r$proxy25 * Matrix_this19.columns() + c$proxy25];
                    Matrix<Object, Object> Matrix_this20 = matrix = Matrix_this;
                    Matrix_this.values()[r$proxy26 * Matrix_this20.columns() + c$proxy26] = value$proxy6;
                }
            }
        }
        return X;
    }
}

