/*
 * Decompiled with CFR 0.152.
 */
package slash.matrix.decomposition;

import scala.runtime.BoxesRunTime;
import slash.matrix.Matrix;
import slash.matrix.Matrix$;
import slash.matrix.decomposition.QR$;
import slash.vector.package$;

public class QR<M, N> {
    private final Matrix QR;
    private final double[] Rdiag;
    private final Integer x$3;
    private final Integer x$4;
    private final int rows;
    private final int columns;

    public static <M, N> QR<Object, Object> apply(Matrix<Object, Object> matrix, Integer n, Integer n2) {
        return QR$.MODULE$.apply(matrix, n, n2);
    }

    public QR(Matrix<Object, Object> QR2, double[] Rdiag, Integer x$3, Integer x$4) {
        this.QR = QR2;
        this.Rdiag = Rdiag;
        this.x$3 = x$3;
        this.x$4 = x$4;
        Integer ev = x$3;
        this.rows = BoxesRunTime.unboxToInt((Object)ev);
        Integer ev2 = x$4;
        this.columns = BoxesRunTime.unboxToInt((Object)ev2);
    }

    public Matrix<M, N> QR() {
        return this.QR;
    }

    public double[] Rdiag() {
        return this.Rdiag;
    }

    public int rows() {
        return this.rows;
    }

    public int columns() {
        return this.columns;
    }

    public boolean isFullRank() {
        int i = 0;
        while (i < this.columns()) {
            int index$proxy2;
            package$ package$2 = package$.MODULE$;
            double[] thisVector$proxy2 = this.Rdiag();
            if (thisVector$proxy2[index$proxy2 = i++] != 0.0) continue;
        }
        return i == this.columns();
    }

    public Matrix<M, N> H() {
        double[] values = new double[this.rows() * this.columns()];
        int i = 0;
        for (int r = 0; r < this.rows(); ++r) {
            for (int c = 0; c < this.columns(); ++c) {
                double d;
                if (r >= c) {
                    Matrix<M, N> matrix;
                    Matrix<M, N> matrix2;
                    Matrix<M, N> Matrix_this = matrix2 = this.QR();
                    int r$proxy7 = r;
                    int c$proxy7 = c;
                    Matrix<M, N> Matrix_this2 = matrix = Matrix_this;
                    d = Matrix_this.values()[r$proxy7 * Matrix_this2.columns() + c$proxy7];
                } else {
                    d = 0.0;
                }
                values[i] = d;
                ++i;
            }
        }
        return Matrix$.MODULE$.apply(values, this.x$3, this.x$4);
    }

    public Matrix<N, N> R() {
        double[] values = new double[this.columns() * this.columns()];
        int i = 0;
        for (int r = 0; r < this.columns(); ++r) {
            for (int c = 0; c < this.columns(); ++c) {
                double d;
                if (r < c) {
                    Matrix<M, N> matrix;
                    Matrix<M, N> matrix2;
                    Matrix<M, N> Matrix_this = matrix2 = this.QR();
                    int r$proxy8 = r;
                    int c$proxy8 = c;
                    Matrix<M, N> Matrix_this2 = matrix = Matrix_this;
                    d = Matrix_this.values()[r$proxy8 * Matrix_this2.columns() + c$proxy8];
                } else if (r == c) {
                    package$ package$2 = package$.MODULE$;
                    double[] thisVector$proxy3 = this.Rdiag();
                    int index$proxy3 = r;
                    d = thisVector$proxy3[index$proxy3];
                } else {
                    d = 0.0;
                }
                values[i] = d;
                ++i;
            }
        }
        return Matrix$.MODULE$.apply(values, this.x$4, this.x$4);
    }

    public Matrix<M, N> Q() {
        Matrix<Object, Object> X = Matrix$.MODULE$.zeros(this.x$3, this.x$4);
        for (int k = this.columns() - 1; k > -1; --k) {
            Matrix<Object, Object> matrix;
            Matrix<Object, Object> matrix2;
            int i = 0;
            while (i < this.rows()) {
                Matrix<Object, Object> matrix3;
                Matrix<Object, Object> matrix4;
                Matrix<Object, Object> Matrix_this = matrix4 = X;
                int r$proxy9 = i++;
                int c$proxy9 = k;
                Matrix<Object, Object> Matrix_this2 = matrix3 = Matrix_this;
                Matrix_this.values()[r$proxy9 * Matrix_this2.columns() + c$proxy9] = 0.0;
            }
            Matrix<Object, Object> Matrix_this = matrix2 = X;
            int r$proxy10 = k;
            int c$proxy10 = k;
            Matrix<Object, Object> Matrix_this3 = matrix = Matrix_this;
            Matrix_this.values()[r$proxy10 * Matrix_this3.columns() + c$proxy10] = 1.0;
            for (int j = k; j < this.columns(); ++j) {
                Matrix<M, N> matrix5;
                Matrix<M, N> matrix6;
                Matrix<M, N> matrix7;
                Matrix<M, N> matrix8;
                Matrix<M, N> Matrix_this4 = matrix8 = this.QR();
                int r$proxy11 = k;
                int c$proxy11 = k;
                Matrix<M, N> Matrix_this5 = matrix7 = Matrix_this4;
                if (Matrix_this4.values()[r$proxy11 * Matrix_this5.columns() + c$proxy11] == 0.0) continue;
                double s = 0.0;
                i = k;
                while (i < this.rows()) {
                    Matrix<Object, Object> matrix9;
                    Matrix<Object, Object> matrix10;
                    Matrix<M, N> matrix11;
                    Matrix<M, N> matrix12;
                    Matrix<M, N> Matrix_this6 = matrix12 = this.QR();
                    int r$proxy12 = i;
                    int c$proxy12 = k;
                    Matrix<M, N> Matrix_this7 = matrix11 = Matrix_this6;
                    Matrix<Object, Object> Matrix_this8 = matrix10 = X;
                    int r$proxy13 = i++;
                    int c$proxy13 = j;
                    Matrix<Object, Object> Matrix_this9 = matrix9 = Matrix_this8;
                    s += Matrix_this6.values()[r$proxy12 * Matrix_this7.columns() + c$proxy12] * Matrix_this8.values()[r$proxy13 * Matrix_this9.columns() + c$proxy13];
                }
                Matrix<M, N> Matrix_this10 = matrix6 = this.QR();
                int r$proxy14 = k;
                int c$proxy14 = k;
                Matrix<M, N> Matrix_this11 = matrix5 = Matrix_this10;
                s = -s / Matrix_this10.values()[r$proxy14 * Matrix_this11.columns() + c$proxy14];
                i = k;
                while (i < this.rows()) {
                    Matrix<Object, Object> matrix13;
                    Matrix<M, N> matrix14;
                    Matrix<M, N> matrix15;
                    Matrix<Object, Object> matrix16;
                    Matrix<Object, Object> Matrix_this12;
                    Matrix<Object, Object> matrix17;
                    Matrix<Object, Object> matrix18;
                    int n = i;
                    int n2 = j;
                    Matrix<Object, Object> Matrix_this13 = matrix18 = X;
                    Matrix<Object, Object> Matrix_this14 = matrix17 = (Matrix_this12 = (matrix16 = X));
                    Matrix<M, N> Matrix_this15 = matrix15 = this.QR();
                    int r$proxy15 = i++;
                    int c$proxy15 = k;
                    Matrix<M, N> Matrix_this16 = matrix14 = Matrix_this15;
                    double value$proxy5 = Matrix_this12.values()[n * Matrix_this14.columns() + n2] + s * Matrix_this15.values()[r$proxy15 * Matrix_this16.columns() + c$proxy15];
                    Matrix<Object, Object> Matrix_this17 = matrix13 = Matrix_this13;
                    Matrix_this13.values()[n * Matrix_this17.columns() + n2] = value$proxy5;
                }
            }
        }
        return X;
    }

    public <V> Matrix<N, Object> solve(Matrix<M, Object> B, Integer x$2) {
        int k;
        if (!this.isFullRank()) {
            throw new RuntimeException("Matrix is rank deficient.");
        }
        int nx = B.columns();
        for (k = 0; k < this.columns(); ++k) {
            for (int j = 0; j < nx; ++j) {
                Matrix<M, N> matrix;
                Matrix<M, N> matrix2;
                double s = 0.0;
                int i = k;
                while (i < this.rows()) {
                    Matrix<M, Object> matrix3;
                    Matrix<M, Object> matrix4;
                    Matrix<M, N> matrix5;
                    Matrix<M, N> matrix6;
                    Matrix<M, N> Matrix_this = matrix6 = this.QR();
                    int r$proxy16 = i;
                    int c$proxy16 = k;
                    Matrix<M, N> Matrix_this2 = matrix5 = Matrix_this;
                    Matrix<M, Object> Matrix_this3 = matrix4 = B;
                    int r$proxy17 = i++;
                    int c$proxy17 = j;
                    Matrix<M, Object> Matrix_this4 = matrix3 = Matrix_this3;
                    s += Matrix_this.values()[r$proxy16 * Matrix_this2.columns() + c$proxy16] * Matrix_this3.values()[r$proxy17 * Matrix_this4.columns() + c$proxy17];
                }
                Matrix<M, N> Matrix_this = matrix2 = this.QR();
                int r$proxy18 = k;
                int c$proxy18 = k;
                Matrix<M, N> Matrix_this5 = matrix = Matrix_this;
                s = -s / Matrix_this.values()[r$proxy18 * Matrix_this5.columns() + c$proxy18];
                i = k;
                while (i < this.rows()) {
                    Matrix<M, Object> matrix7;
                    Matrix<M, N> matrix8;
                    Matrix<M, N> matrix9;
                    Matrix<M, Object> matrix10;
                    Matrix<M, Object> Matrix_this6;
                    Matrix<M, Object> matrix11;
                    Matrix<M, Object> matrix12;
                    int n = i;
                    int n2 = j;
                    Matrix<M, Object> Matrix_this7 = matrix12 = B;
                    Matrix<M, Object> Matrix_this8 = matrix11 = (Matrix_this6 = (matrix10 = B));
                    Matrix<M, N> Matrix_this9 = matrix9 = this.QR();
                    int r$proxy19 = i++;
                    int c$proxy19 = k;
                    Matrix<M, N> Matrix_this10 = matrix8 = Matrix_this9;
                    double value$proxy6 = Matrix_this6.values()[n * Matrix_this8.columns() + n2] + s * Matrix_this9.values()[r$proxy19 * Matrix_this10.columns() + c$proxy19];
                    Matrix<M, Object> Matrix_this11 = matrix7 = Matrix_this7;
                    Matrix_this7.values()[n * Matrix_this11.columns() + n2] = value$proxy6;
                }
            }
        }
        for (k = this.columns() - 1; k > -1; --k) {
            int j = 0;
            while (j < nx) {
                Matrix<M, Object> matrix;
                Matrix<M, Object> matrix13;
                Matrix<M, Object> Matrix_this;
                Matrix<M, Object> matrix14;
                Matrix<M, Object> matrix15;
                int n = k;
                int n3 = j++;
                Matrix<M, Object> Matrix_this12 = matrix15 = B;
                Matrix<M, Object> Matrix_this13 = matrix14 = (Matrix_this = (matrix13 = B));
                package$ package$2 = package$.MODULE$;
                double[] thisVector$proxy4 = this.Rdiag();
                int index$proxy4 = k;
                double value$proxy7 = Matrix_this.values()[n * Matrix_this13.columns() + n3] / thisVector$proxy4[index$proxy4];
                Matrix<M, Object> Matrix_this14 = matrix = Matrix_this12;
                Matrix_this12.values()[n * Matrix_this14.columns() + n3] = value$proxy7;
            }
            for (int i = 0; i < k; ++i) {
                j = 0;
                while (j < nx) {
                    Matrix<M, Object> matrix;
                    Matrix<M, N> matrix16;
                    Matrix<M, N> matrix17;
                    Matrix<M, Object> matrix18;
                    Matrix<M, Object> matrix19;
                    Matrix<M, Object> matrix20;
                    Matrix<M, Object> Matrix_this;
                    Matrix<M, Object> matrix21;
                    Matrix<M, Object> matrix22;
                    int n = i;
                    int n4 = j;
                    Matrix<M, Object> Matrix_this15 = matrix22 = B;
                    Matrix<M, Object> Matrix_this16 = matrix21 = (Matrix_this = (matrix20 = B));
                    Matrix<M, Object> Matrix_this17 = matrix19 = B;
                    int r$proxy20 = k;
                    int c$proxy20 = j++;
                    Matrix<M, Object> Matrix_this18 = matrix18 = Matrix_this17;
                    Matrix<M, N> Matrix_this19 = matrix17 = this.QR();
                    int r$proxy21 = i;
                    int c$proxy21 = k;
                    Matrix<M, N> Matrix_this20 = matrix16 = Matrix_this19;
                    double value$proxy8 = Matrix_this.values()[n * Matrix_this16.columns() + n4] - Matrix_this17.values()[r$proxy20 * Matrix_this18.columns() + c$proxy20] * Matrix_this19.values()[r$proxy21 * Matrix_this20.columns() + c$proxy21];
                    Matrix<M, Object> Matrix_this21 = matrix = Matrix_this15;
                    Matrix_this15.values()[n * Matrix_this21.columns() + n4] = value$proxy8;
                }
            }
        }
        return B.subMatrix(0, 0, this.x$4, x$2);
    }
}

