/*
 * Decompiled with CFR 0.152.
 */
package slash.matrix;

import java.io.Serializable;
import scala.Double$;
import scala.Function1;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.Random;
import slash.UnsupportedVectorDimension$;
import slash.matrix.Matrix$;
import slash.matrix.util.CannotExpressMatrixAsVector$;

public class Matrix<M, N> {
    private final double[][] values;
    private final Integer x$2;
    private final Integer x$3;
    private final int rows;
    private final int columns;
    private final int mn;

    public static <M, N> Matrix<Object, Object> apply(double d, Integer n, Integer n2) {
        return Matrix$.MODULE$.apply(d, n, n2);
    }

    public static <M, N> Matrix<Object, Object> apply(double[] dArray, Integer n, Integer n2) {
        return Matrix$.MODULE$.apply(dArray, n, n2);
    }

    public static <M, N> Matrix<Object, Object> apply(double[][] dArray, Integer n, Integer n2) {
        return Matrix$.MODULE$.apply(dArray, n, n2);
    }

    public static <M, N> Matrix<Object, Object> constructWithCopy(double[][] dArray, Integer n, Integer n2) {
        return Matrix$.MODULE$.constructWithCopy(dArray, n, n2);
    }

    public static <M, N> Matrix<Object, Object> diagonal(double d, Integer n, Integer n2) {
        return Matrix$.MODULE$.diagonal(d, n, n2);
    }

    public static <D> Matrix<Object, Object> diagonal(double[] dArray, Integer n) {
        return Matrix$.MODULE$.diagonal(dArray, n);
    }

    public static <M, N, D> Matrix<Object, Object> diagonal(double[] dArray, Integer n, Integer n2, Integer n3) {
        return Matrix$.MODULE$.diagonal(dArray, n, n2, n3);
    }

    public static <M, N> Matrix<Object, Object> identity(Integer n, Integer n2) {
        return Matrix$.MODULE$.identity(n, n2);
    }

    public static <M, N> Matrix<Object, Object> random(double d, Random random, Integer n, Integer n2) {
        return Matrix$.MODULE$.random(d, random, n, n2);
    }

    public static <M, N> Matrix<Object, Object> zeros(Integer n, Integer n2) {
        return Matrix$.MODULE$.zeros(n, n2);
    }

    public static <M, N> double random$default$1() {
        return Matrix$.MODULE$.random$default$1();
    }

    public static <M, N> Random random$default$2() {
        return Matrix$.MODULE$.random$default$2();
    }

    public Matrix(double[][] values, Integer x$2, Integer x$3) {
        this.values = values;
        this.x$2 = x$2;
        this.x$3 = x$3;
        Integer ev = x$2;
        this.rows = BoxesRunTime.unboxToInt((Object)ev);
        Integer ev2 = x$3;
        this.columns = BoxesRunTime.unboxToInt((Object)ev2);
        this.mn = this.rows() * this.columns();
    }

    public double[][] values() {
        return this.values;
    }

    public int rows() {
        return this.rows;
    }

    public int columns() {
        return this.columns;
    }

    public Matrix<M, N> copy() {
        return new Matrix<M, N>(this.copyValues(), this.x$2, this.x$3);
    }

    public double[][] copyValues() {
        Function1 & Serializable f$proxy9 = (Function1 & Serializable)row -> this.$anonfun$1(BoxesRunTime.unboxToInt((Object)row));
        ClassTag x$3$proxy10 = ClassTag$.MODULE$.apply(Double.TYPE).wrap();
        int n$proxy5 = this.rows();
        double[][] out = (double[][])Arrays$.MODULE$.newGenericArray(n$proxy5, x$3$proxy10);
        for (int i = 0; i < this.rows(); ++i) {
            out[i] = (double[])f$proxy9.apply((Object)BoxesRunTime.boxToInteger((int)i));
        }
        return out;
    }

    public double[] columnPackedArray() {
        double[] vals = new double[this.rows() * this.columns()];
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.columns(); ++j) {
                vals[i + j * this.rows()] = this.values()[i][j];
            }
        }
        return vals;
    }

    public double[] rowPackedArray() {
        double[] vals = new double[this.rows() * this.columns()];
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.columns(); ++j) {
                vals[i * this.columns() + j] = this.values()[i][j];
            }
        }
        return vals;
    }

    public int rowDimension() {
        return this.rows();
    }

    public int columnDimension() {
        return this.columns();
    }

    public <M1, N1> Matrix<Object, Object> subMatrix(int r0, int c0, Integer x$3, Integer x$4) {
        Integer ev = x$3;
        int r1 = r0 + BoxesRunTime.unboxToInt((Object)ev);
        Integer ev2 = x$4;
        int c1 = c0 + BoxesRunTime.unboxToInt((Object)ev2);
        int length$proxy8 = r1 - r0;
        Function1 & Serializable f$proxy11 = (Function1 & Serializable)r -> this.$anonfun$3(c0, c1, BoxesRunTime.unboxToInt((Object)r));
        ClassTag x$3$proxy12 = ClassTag$.MODULE$.apply(Double.TYPE).wrap();
        int n$proxy6 = length$proxy8;
        double[][] out = (double[][])Arrays$.MODULE$.newGenericArray(n$proxy6, x$3$proxy12);
        for (int i = 0; i < length$proxy8; ++i) {
            out[i] = (double[])f$proxy11.apply((Object)BoxesRunTime.boxToInteger((int)i));
        }
        return new Matrix<Object, Object>(out, x$3, x$4);
    }

    public <M1, N1> Matrix<Object, Object> subMatrix(int[] rowIndices, int[] columnIndices, Integer x$3, Integer x$4) {
        int required$proxy7;
        int required$proxy6;
        Integer ev = x$3;
        int supplied$proxy5 = BoxesRunTime.unboxToInt((Object)ev);
        if (supplied$proxy5 != (required$proxy6 = rowIndices.length)) {
            throw UnsupportedVectorDimension$.MODULE$.apply(supplied$proxy5, required$proxy6);
        }
        Integer ev2 = x$4;
        int supplied$proxy6 = BoxesRunTime.unboxToInt((Object)ev2);
        if (supplied$proxy6 != (required$proxy7 = columnIndices.length)) {
            throw UnsupportedVectorDimension$.MODULE$.apply(supplied$proxy6, required$proxy7);
        }
        int length$proxy10 = rowIndices.length;
        Function1 & Serializable f$proxy13 = (Function1 & Serializable)r -> this.$anonfun$5(rowIndices, columnIndices, BoxesRunTime.unboxToInt((Object)r));
        ClassTag x$3$proxy14 = ClassTag$.MODULE$.apply(Double.TYPE).wrap();
        int n$proxy7 = length$proxy10;
        double[][] out = (double[][])Arrays$.MODULE$.newGenericArray(n$proxy7, x$3$proxy14);
        for (int i = 0; i < length$proxy10; ++i) {
            out[i] = (double[])f$proxy13.apply((Object)BoxesRunTime.boxToInteger((int)i));
        }
        return new Matrix<Object, Object>(out, x$3, x$4);
    }

    public <M1, N1> Matrix<Object, Object> getMatrix(int r0, int[] columnIndices, Integer x$3, Integer x$4) {
        int required$proxy8;
        Integer ev = x$3;
        int r1 = r0 + BoxesRunTime.unboxToInt((Object)ev);
        Integer ev2 = x$4;
        int supplied$proxy7 = BoxesRunTime.unboxToInt((Object)ev2);
        if (supplied$proxy7 != (required$proxy8 = columnIndices.length)) {
            throw UnsupportedVectorDimension$.MODULE$.apply(supplied$proxy7, required$proxy8);
        }
        int length$proxy12 = r1 - r0 + 1;
        Function1 & Serializable f$proxy15 = (Function1 & Serializable)r -> this.$anonfun$7(r0, columnIndices, BoxesRunTime.unboxToInt((Object)r));
        ClassTag x$3$proxy16 = ClassTag$.MODULE$.apply(Double.TYPE).wrap();
        int n$proxy8 = length$proxy12;
        double[][] out = (double[][])Arrays$.MODULE$.newGenericArray(n$proxy8, x$3$proxy16);
        for (int i = 0; i < length$proxy12; ++i) {
            out[i] = (double[])f$proxy15.apply((Object)BoxesRunTime.boxToInteger((int)i));
        }
        return new Matrix<Object, Object>(out, x$3, x$4);
    }

    public <M1, N1> Matrix<Object, Object> getMatrix(int[] rowIndices, int c0, Integer x$3, Integer x$4) {
        Integer ev = x$4;
        int c1 = c0 + BoxesRunTime.unboxToInt((Object)ev);
        int length$proxy14 = rowIndices.length;
        Function1 & Serializable f$proxy17 = (Function1 & Serializable)r -> this.$anonfun$9(rowIndices, c0, c1, BoxesRunTime.unboxToInt((Object)r));
        ClassTag x$3$proxy18 = ClassTag$.MODULE$.apply(Double.TYPE).wrap();
        int n$proxy9 = length$proxy14;
        double[][] out = (double[][])Arrays$.MODULE$.newGenericArray(n$proxy9, x$3$proxy18);
        for (int i = 0; i < length$proxy14; ++i) {
            out[i] = (double[])f$proxy17.apply((Object)BoxesRunTime.boxToInteger((int)i));
        }
        return new Matrix<Object, Object>(out, x$3, x$4);
    }

    public <M1, N1> void setMatrix(int r0, int c0, Matrix<Object, Object> mtrx, Integer x$4, Integer x$5) {
        Integer ev = x$4;
        int r1 = BoxesRunTime.unboxToInt((Object)ev);
        Integer ev2 = x$5;
        int c1 = BoxesRunTime.unboxToInt((Object)ev2);
        for (int r = r0; r <= r1; ++r) {
            for (int c = c0; c <= c1; ++c) {
                Matrix<Object, Object> Matrix_this = mtrx;
                int r$proxy4 = r - r0;
                int c$proxy4 = c - c0;
                this.values()[r][c] = Matrix_this.values()[r$proxy4][c$proxy4];
            }
        }
    }

    public <M1, N1> void setMatrix(int[] rowIndices, int[] columnIndices, Matrix<Object, Object> X) {
        for (int i = 0; i < rowIndices.length; ++i) {
            for (int j = 0; j < columnIndices.length; ++j) {
                Matrix<Object, Object> Matrix_this = X;
                int r$proxy5 = i;
                int c$proxy5 = j;
                this.values()[rowIndices[i]][columnIndices[j]] = Matrix_this.values()[r$proxy5][c$proxy5];
            }
        }
    }

    public <M1, N1> void setMatrix(int[] rowIndices, int c0, Matrix<Object, Object> X, Integer x$4, Integer x$5) {
        Integer ev = x$5;
        int c1 = c0 + BoxesRunTime.unboxToInt((Object)ev);
        for (int r = 0; r < rowIndices.length; ++r) {
            for (int c = c0; c <= c1; ++c) {
                Matrix<Object, Object> Matrix_this = X;
                int r$proxy6 = r;
                int c$proxy6 = c - c0;
                this.values()[rowIndices[r]][c] = Matrix_this.values()[r$proxy6][c$proxy6];
            }
        }
    }

    public <M1, N1> void setMatrix(int r0, int[] columnIndices, Matrix<Object, Object> X, Integer x$4, Integer x$5) {
        Integer ev = x$4;
        int r1 = r0 + BoxesRunTime.unboxToInt((Object)ev);
        for (int r = r0; r <= r1; ++r) {
            for (int c = 0; c < columnIndices.length; ++c) {
                Matrix<Object, Object> Matrix_this = X;
                int r$proxy7 = r - r0;
                int c$proxy7 = c;
                this.values()[r][columnIndices[c]] = Matrix_this.values()[r$proxy7][c$proxy7];
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public Matrix<N, M> transpose() {
        void var3_4;
        Function1 & Serializable f$proxy19 = (Function1 & Serializable)col -> this.$anonfun$11(BoxesRunTime.unboxToInt((Object)col));
        ClassTag x$3$proxy20 = ClassTag$.MODULE$.apply(Double.TYPE).wrap();
        int n$proxy10 = this.columns();
        double[][] out = (double[][])Arrays$.MODULE$.newGenericArray(n$proxy10, x$3$proxy20);
        for (int i = 0; i < this.columns(); ++i) {
            out[i] = (double[])f$proxy19.apply((Object)BoxesRunTime.boxToInteger((int)i));
        }
        return new Matrix<M, N>((double[][])var3_4, this.x$3, this.x$2);
    }

    public double norm1() {
        double maxColumnSum = Double$.MODULE$.MinValue();
        for (int c = 0; c < this.columns(); ++c) {
            double columnSum = 0.0;
            for (int r = 0; r < this.rows(); ++r) {
                columnSum += Math.abs(this.values()[r][c]);
            }
            maxColumnSum = Math.max(maxColumnSum, columnSum);
        }
        return maxColumnSum;
    }

    public double normInfinity() {
        double maxRowSum = Double$.MODULE$.MinValue();
        for (int r = 0; r < this.rows(); ++r) {
            double rowSum = 0.0;
            for (int c = 0; c < this.columns(); ++c) {
                rowSum += Math.abs(this.values()[r][c]);
            }
            maxRowSum = Math.max(maxRowSum, rowSum);
        }
        return maxRowSum;
    }

    public double normFrobenius() {
        double f = Double$.MODULE$.MinValue();
        for (int r = 0; r < this.rows(); ++r) {
            for (int c = 0; c < this.columns(); ++c) {
                f = package$.MODULE$.hypot(f, this.values()[r][c]);
            }
        }
        return f;
    }

    public Matrix<M, N> add(Matrix<M, N> B) {
        for (int r = 0; r < this.rows(); ++r) {
            for (int c = 0; c < this.columns(); ++c) {
                Matrix<M, N> Matrix_this = B;
                int r$proxy8 = r;
                int c$proxy8 = c;
                this.values()[r][c] = this.values()[r][c] + Matrix_this.values()[r$proxy8][c$proxy8];
            }
        }
        return this;
    }

    public Matrix<M, N> subtract(Matrix<M, N> B) {
        for (int r = 0; r < this.rows(); ++r) {
            for (int c = 0; c < this.columns(); ++c) {
                Matrix<M, N> Matrix_this = B;
                int r$proxy9 = r;
                int c$proxy9 = c;
                this.values()[r][c] = this.values()[r][c] - Matrix_this.values()[r$proxy9][c$proxy9];
            }
        }
        return this;
    }

    public Matrix<M, N> times(double s) {
        for (int r = 0; r < this.rows(); ++r) {
            for (int c = 0; c < this.columns(); ++c) {
                this.values()[r][c] = s * this.values()[r][c];
            }
        }
        return this;
    }

    public <V> Matrix<M, Object> $times(Matrix<N, Object> thatMatrix, Integer x$2) {
        return this.times(thatMatrix, x$2);
    }

    public <V> Matrix<M, Object> times(Matrix<N, Object> b, Integer x$2) {
        Matrix<Object, Object> X = Matrix$.MODULE$.zeros(this.x$2, x$2);
        double[] Bcolj = new double[this.columns()];
        for (int j = 0; j < b.columns(); ++j) {
            int k;
            for (k = 0; k < this.columns(); ++k) {
                Matrix<N, Object> Matrix_this = b;
                int r$proxy10 = k;
                int c$proxy10 = j;
                Bcolj[k] = Matrix_this.values()[r$proxy10][c$proxy10];
            }
            int i = 0;
            while (i < this.rows()) {
                double value$proxy3;
                double[] Arowi = this.values()[i];
                double s = 0.0;
                for (k = 0; k < this.columns(); ++k) {
                    s += Arowi[k] * Bcolj[k];
                }
                Matrix<Object, Object> Matrix_this = X;
                int r$proxy11 = i++;
                int c$proxy11 = j;
                Matrix_this.values()[r$proxy11][c$proxy11] = value$proxy3 = s;
            }
        }
        return X;
    }

    public double trace() {
        double t = 0.0;
        for (int i = 0; i < Math.min(this.rows(), this.columns()); ++i) {
            t += this.values()[i][i];
        }
        return t;
    }

    public int mn() {
        return this.mn;
    }

    public double[] asVector() {
        if (this.columns() == 1 || this.rows() == 1) {
            return this.rowPackedArray();
        }
        throw CannotExpressMatrixAsVector$.MODULE$.apply(this);
    }

    public String dim() {
        return new java.lang.StringBuilder(6).append("dim(").append(this.rows()).append("x").append(this.columns()).append(")").toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int r = 0; r < this.values().length; ++r) {
            sb.append("\n");
            for (int c = 0; c < this.values()[0].length; ++c) {
                sb.append(new java.lang.StringBuilder(2).append(this.values()[r][c]).append(", ").toString());
            }
        }
        return sb.toString();
    }

    private final /* synthetic */ double[] $anonfun$1(int row) {
        JFunction1.mcDI.sp & Serializable f$proxy8 = (JFunction1.mcDI.sp & Serializable)col -> this.values()[row][col];
        ClassTag x$3$proxy9 = ClassTag$.MODULE$.apply(Double.TYPE);
        double[] out = new double[this.columns()];
        for (int i = 0; i < this.columns(); ++i) {
            out[i] = f$proxy8.apply$mcDI$sp(i);
        }
        return out;
    }

    private final /* synthetic */ double[] $anonfun$3(int c0$1, int c1$1, int r) {
        int length$proxy7 = c1$1 - c0$1;
        JFunction1.mcDI.sp & Serializable f$proxy10 = (JFunction1.mcDI.sp & Serializable)c -> this.values()[r + r][c0$1 + c];
        ClassTag x$3$proxy11 = ClassTag$.MODULE$.apply(Double.TYPE);
        double[] out = new double[length$proxy7];
        for (int i = 0; i < length$proxy7; ++i) {
            out[i] = f$proxy10.apply$mcDI$sp(i);
        }
        return out;
    }

    private final /* synthetic */ double[] $anonfun$5(int[] rowIndices$1, int[] columnIndices$1, int r) {
        int length$proxy9 = columnIndices$1.length;
        JFunction1.mcDI.sp & Serializable f$proxy12 = (JFunction1.mcDI.sp & Serializable)c -> this.values()[rowIndices$1[r]][columnIndices$1[c]];
        ClassTag x$3$proxy13 = ClassTag$.MODULE$.apply(Double.TYPE);
        double[] out = new double[length$proxy9];
        for (int i = 0; i < length$proxy9; ++i) {
            out[i] = f$proxy12.apply$mcDI$sp(i);
        }
        return out;
    }

    private final /* synthetic */ double[] $anonfun$7(int r0$1, int[] columnIndices$3, int r) {
        int length$proxy11 = columnIndices$3.length;
        JFunction1.mcDI.sp & Serializable f$proxy14 = (JFunction1.mcDI.sp & Serializable)c -> this.values()[r + r0$1][columnIndices$3[c]];
        ClassTag x$3$proxy15 = ClassTag$.MODULE$.apply(Double.TYPE);
        double[] out = new double[length$proxy11];
        for (int i = 0; i < length$proxy11; ++i) {
            out[i] = f$proxy14.apply$mcDI$sp(i);
        }
        return out;
    }

    private final /* synthetic */ double[] $anonfun$9(int[] rowIndices$3, int c0$3, int c1$2, int r) {
        int length$proxy13 = c1$2 - c0$3 + 1;
        JFunction1.mcDI.sp & Serializable f$proxy16 = (JFunction1.mcDI.sp & Serializable)c -> this.values()[rowIndices$3[r]][c + c0$3];
        ClassTag x$3$proxy17 = ClassTag$.MODULE$.apply(Double.TYPE);
        double[] out = new double[length$proxy13];
        for (int i = 0; i < length$proxy13; ++i) {
            out[i] = f$proxy16.apply$mcDI$sp(i);
        }
        return out;
    }

    private final /* synthetic */ double[] $anonfun$11(int col) {
        JFunction1.mcDI.sp & Serializable f$proxy18 = (JFunction1.mcDI.sp & Serializable)row -> this.values()[row][col];
        ClassTag x$3$proxy19 = ClassTag$.MODULE$.apply(Double.TYPE);
        double[] out = new double[this.rows()];
        for (int i = 0; i < this.rows(); ++i) {
            out[i] = f$proxy18.apply$mcDI$sp(i);
        }
        return out;
    }
}

