/*
 * Decompiled with CFR 0.152.
 */
package slash.matrix.decomposition;

import java.io.Serializable;
import scala.runtime.ModuleSerializationProxy;
import slash.matrix.Matrix;
import slash.matrix.Matrix$;
import slash.matrix.decomposition.Cholesky;
import slash.matrix.util.MatrixNotSymmetricPositiveDefinite$;

public final class Cholesky$
implements Serializable {
    public static final Cholesky$ MODULE$ = new Cholesky$();

    private Cholesky$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Cholesky$.class);
    }

    public <N> Cholesky<Object> apply(Matrix<Object, Object> m, Integer x$2) {
        double[][] A = m.copyValues();
        int n = A.length;
        double[][] L = Matrix$.MODULE$.zeros(x$2, x$2).values();
        boolean isspd = true;
        for (int j = 0; j < n; ++j) {
            int k;
            double[] Lrowj = L[j];
            double d = 0.0;
            for (k = 0; k < j; ++k) {
                double[] Lrowk = L[k];
                double s = 0.0;
                for (int i = 0; i < k; ++i) {
                    s += Lrowk[i] * Lrowj[i];
                }
                Lrowj[k] = s = (A[j][k] - s) / L[k][k];
                d += s * s;
                isspd &= A[k][j] == A[j][k];
            }
            isspd &= (d = A[j][j] - d) > 0.0;
            L[j][j] = Math.sqrt(Math.max(d, 0.0));
            for (k = j + 1; k < n; ++k) {
                L[j][k] = 0.0;
            }
        }
        if (isspd) {
            return new Cholesky<Object>(Matrix$.MODULE$.apply(L, x$2, x$2), x$2);
        }
        throw MatrixNotSymmetricPositiveDefinite$.MODULE$.apply(m);
    }
}

