/*
 * Decompiled with CFR 0.152.
 */
package slash.matrix.decomposition;

import java.io.Serializable;
import scala.Function1;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import slash.matrix.Matrix;
import slash.matrix.Matrix$;
import slash.matrix.decomposition.LU$;

public class LU<M, N> {
    private final Matrix LU;
    private final int[] piv;
    private final double pivsign;
    private final Integer x$4;
    private final Integer x$5;
    private final int m;
    private final int n;

    public static <M, N> LU<Object, Object> apply(Matrix<Object, Object> matrix, Integer n, Integer n2) {
        return LU$.MODULE$.apply(matrix, n, n2);
    }

    public LU(Matrix<Object, Object> LU2, int[] piv, double pivsign, Integer x$4, Integer x$5) {
        this.LU = LU2;
        this.piv = piv;
        this.pivsign = pivsign;
        this.x$4 = x$4;
        this.x$5 = x$5;
        Integer ev = x$4;
        this.m = BoxesRunTime.unboxToInt((Object)ev);
        Integer ev2 = x$5;
        this.n = BoxesRunTime.unboxToInt((Object)ev2);
    }

    public Matrix<M, N> LU() {
        return this.LU;
    }

    public int m() {
        return this.m;
    }

    public int n() {
        return this.n;
    }

    public boolean isSingular() {
        int j = 0;
        while (j < this.n()) {
            Matrix<M, N> Matrix_this = this.LU();
            int r$proxy10 = j;
            int c$proxy10 = j++;
            if (Matrix_this.values()[r$proxy10][c$proxy10] != 0.0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public Matrix<M, N> L() {
        void var3_4;
        Function1 & Serializable f$proxy3 = (Function1 & Serializable)r -> this.$anonfun$1(BoxesRunTime.unboxToInt((Object)r));
        ClassTag x$3$proxy4 = ClassTag$.MODULE$.apply(Double.TYPE).wrap();
        int n$proxy1 = this.m();
        double[][] out = (double[][])Arrays$.MODULE$.newGenericArray(n$proxy1, x$3$proxy4);
        for (int i = 0; i < this.m(); ++i) {
            out[i] = (double[])f$proxy3.apply((Object)BoxesRunTime.boxToInteger((int)i));
        }
        return Matrix$.MODULE$.apply((double[][])var3_4, this.x$4, this.x$5);
    }

    /*
     * WARNING - void declaration
     */
    public Matrix<N, N> U() {
        void var3_4;
        Function1 & Serializable f$proxy5 = (Function1 & Serializable)r -> this.$anonfun$3(BoxesRunTime.unboxToInt((Object)r));
        ClassTag x$3$proxy6 = ClassTag$.MODULE$.apply(Double.TYPE).wrap();
        int n$proxy2 = this.n();
        double[][] out = (double[][])Arrays$.MODULE$.newGenericArray(n$proxy2, x$3$proxy6);
        for (int i = 0; i < this.n(); ++i) {
            out[i] = (double[])f$proxy5.apply((Object)BoxesRunTime.boxToInteger((int)i));
        }
        return Matrix$.MODULE$.apply((double[][])var3_4, this.x$5, this.x$5);
    }

    public int[] pivot() {
        JFunction1.mcII.sp & Serializable f$proxy6 = (JFunction1.mcII.sp & Serializable)i -> this.piv[i];
        ClassTag x$3$proxy7 = ClassTag$.MODULE$.apply(Integer.TYPE);
        int[] out = new int[this.m()];
        for (int i2 = 0; i2 < this.m(); ++i2) {
            out[i2] = f$proxy6.apply$mcII$sp(i2);
        }
        return out;
    }

    public double[] doubleValuedPivot() {
        JFunction1.mcDI.sp & Serializable f$proxy7 = (JFunction1.mcDI.sp & Serializable)i -> this.piv[i];
        ClassTag x$3$proxy8 = ClassTag$.MODULE$.apply(Double.TYPE);
        double[] out = new double[this.m()];
        for (int i2 = 0; i2 < this.m(); ++i2) {
            out[i2] = f$proxy7.apply$mcDI$sp(i2);
        }
        return out;
    }

    public double determinant() {
        if (this.m() != this.n()) {
            throw new IllegalArgumentException("Matrix must be square.");
        }
        double d = this.pivsign;
        int j = 0;
        while (j < this.n()) {
            Matrix<M, N> Matrix_this = this.LU();
            int r$proxy11 = j;
            int c$proxy11 = j++;
            d *= Matrix_this.values()[r$proxy11][c$proxy11];
        }
        return d;
    }

    public <V> Matrix<N, Object> solve(Matrix<M, Object> B, Integer x$2) {
        int k;
        if (this.isSingular()) {
            throw new RuntimeException("Matrix is singular.");
        }
        int nx = B.columns();
        Matrix<Object, Object> Xmat = B.getMatrix(this.piv, 0, this.x$5, x$2);
        double[][] X = Xmat.values();
        for (k = 0; k < this.n(); ++k) {
            for (int i = k + 1; i < this.n(); ++i) {
                for (int j = 0; j < nx; ++j) {
                    Matrix<M, N> Matrix_this = this.LU();
                    int r$proxy12 = i;
                    int c$proxy12 = k;
                    X[i][j] = X[i][j] - X[k][j] * Matrix_this.values()[r$proxy12][c$proxy12];
                }
            }
        }
        for (k = this.n() - 1; k > -1; --k) {
            for (int j = 0; j < nx; ++j) {
                Matrix<M, N> Matrix_this = this.LU();
                int r$proxy13 = k;
                int c$proxy13 = k;
                X[k][j] = X[k][j] / Matrix_this.values()[r$proxy13][c$proxy13];
            }
            for (int i = 0; i < k; ++i) {
                for (int j1 = 0; j1 < nx; ++j1) {
                    Matrix<M, N> Matrix_this = this.LU();
                    int r$proxy14 = i;
                    int c$proxy14 = k;
                    X[i][j1] = X[i][j1] - X[k][j1] * Matrix_this.values()[r$proxy14][c$proxy14];
                }
            }
        }
        return Xmat;
    }

    private final /* synthetic */ double[] $anonfun$1(int r) {
        JFunction1.mcDI.sp & Serializable f$proxy2 = (JFunction1.mcDI.sp & Serializable)c -> {
            if (r > c) {
                Matrix<M, N> Matrix_this = this.LU();
                return Matrix_this.values()[r][c];
            }
            if (r == c) {
                return 1.0;
            }
            return 0.0;
        };
        ClassTag x$3$proxy3 = ClassTag$.MODULE$.apply(Double.TYPE);
        double[] out = new double[this.n()];
        for (int i = 0; i < this.n(); ++i) {
            out[i] = f$proxy2.apply$mcDI$sp(i);
        }
        return out;
    }

    private final /* synthetic */ double[] $anonfun$3(int r) {
        JFunction1.mcDI.sp & Serializable f$proxy4 = (JFunction1.mcDI.sp & Serializable)c -> {
            if (r > c) {
                return 0.0;
            }
            Matrix<M, N> Matrix_this = this.LU();
            return Matrix_this.values()[r][c];
        };
        ClassTag x$3$proxy5 = ClassTag$.MODULE$.apply(Double.TYPE);
        double[] out = new double[this.n()];
        for (int i = 0; i < this.n(); ++i) {
            out[i] = f$proxy4.apply$mcDI$sp(i);
        }
        return out;
    }
}

