/*
 * Decompiled with CFR 0.152.
 */
package slash.matrix.decomposition;

import java.io.Serializable;
import scala.Function1;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import slash.matrix.Matrix;
import slash.matrix.Matrix$;
import slash.matrix.decomposition.QR$;
import slash.vector.package$;

public class QR<M, N> {
    private final Matrix QR;
    private final double[] Rdiag;
    private final Integer x$3;
    private final Integer x$4;
    private final int rows;
    private final int columns;

    public static <M, N> QR<Object, Object> apply(Matrix<Object, Object> matrix, Integer n, Integer n2) {
        return QR$.MODULE$.apply(matrix, n, n2);
    }

    public QR(Matrix<Object, Object> QR2, double[] Rdiag, Integer x$3, Integer x$4) {
        this.QR = QR2;
        this.Rdiag = Rdiag;
        this.x$3 = x$3;
        this.x$4 = x$4;
        Integer ev = x$3;
        this.rows = BoxesRunTime.unboxToInt((Object)ev);
        Integer ev2 = x$4;
        this.columns = BoxesRunTime.unboxToInt((Object)ev2);
    }

    public Matrix<M, N> QR() {
        return this.QR;
    }

    public double[] Rdiag() {
        return this.Rdiag;
    }

    public int rows() {
        return this.rows;
    }

    public int columns() {
        return this.columns;
    }

    public boolean isFullRank() {
        int i = 0;
        while (i < this.columns()) {
            int index$proxy2;
            package$ package$2 = package$.MODULE$;
            double[] thisVector$proxy2 = this.Rdiag();
            if (thisVector$proxy2[index$proxy2 = i++] != 0.0) continue;
        }
        return i == this.columns();
    }

    /*
     * WARNING - void declaration
     */
    public Matrix<M, N> H() {
        void var3_4;
        Function1 & Serializable f$proxy2 = (Function1 & Serializable)r -> this.$anonfun$1(BoxesRunTime.unboxToInt((Object)r));
        ClassTag x$3$proxy3 = ClassTag$.MODULE$.apply(Double.TYPE).wrap();
        int n$proxy1 = this.rows();
        double[][] out = (double[][])Arrays$.MODULE$.newGenericArray(n$proxy1, x$3$proxy3);
        for (int i = 0; i < this.rows(); ++i) {
            out[i] = (double[])f$proxy2.apply((Object)BoxesRunTime.boxToInteger((int)i));
        }
        return Matrix$.MODULE$.apply((double[][])var3_4, this.x$3, this.x$4);
    }

    /*
     * WARNING - void declaration
     */
    public Matrix<N, N> R() {
        void var3_4;
        Function1 & Serializable f$proxy4 = (Function1 & Serializable)r -> this.$anonfun$3(BoxesRunTime.unboxToInt((Object)r));
        ClassTag x$3$proxy5 = ClassTag$.MODULE$.apply(Double.TYPE).wrap();
        int n$proxy2 = this.columns();
        double[][] out = (double[][])Arrays$.MODULE$.newGenericArray(n$proxy2, x$3$proxy5);
        for (int i = 0; i < this.columns(); ++i) {
            out[i] = (double[])f$proxy4.apply((Object)BoxesRunTime.boxToInteger((int)i));
        }
        return Matrix$.MODULE$.apply((double[][])var3_4, this.x$4, this.x$4);
    }

    public Matrix<M, N> Q() {
        Matrix<Object, Object> X = Matrix$.MODULE$.zeros(this.x$3, this.x$4);
        double[][] Q = X.values();
        for (int k = this.columns() - 1; k > -1; --k) {
            int i;
            for (i = 0; i < this.rows(); ++i) {
                Q[i][k] = 0.0;
            }
            Q[k][k] = 1.0;
            for (int j = k; j < this.columns(); ++j) {
                Matrix<M, N> Matrix_this = this.QR();
                int r$proxy1 = k;
                int c$proxy1 = k;
                if (Matrix_this.values()[r$proxy1][c$proxy1] == 0.0) continue;
                double s = 0.0;
                for (i = k; i < this.rows(); ++i) {
                    Matrix<M, N> Matrix_this2 = this.QR();
                    int r$proxy2 = i;
                    int c$proxy2 = k;
                    s += Matrix_this2.values()[r$proxy2][c$proxy2] * Q[i][j];
                }
                Matrix<M, N> Matrix_this3 = this.QR();
                int r$proxy3 = k;
                int c$proxy3 = k;
                s = -s / Matrix_this3.values()[r$proxy3][c$proxy3];
                i = k;
                while (i < this.rows()) {
                    double[] dArray = Q[i];
                    int n = j;
                    Matrix<M, N> Matrix_this4 = this.QR();
                    int r$proxy4 = i++;
                    int c$proxy4 = k;
                    dArray[n] = dArray[n] + s * Matrix_this4.values()[r$proxy4][c$proxy4];
                }
            }
        }
        return X;
    }

    public <V> Matrix<N, Object> solve(Matrix<M, Object> b, Integer x$2) {
        int k;
        if (!this.isFullRank()) {
            throw new RuntimeException("Matrix is rank deficient.");
        }
        int nx = b.columns();
        double[][] X = b.copyValues();
        for (k = 0; k < this.columns(); ++k) {
            for (int j = 0; j < nx; ++j) {
                int i;
                double s = 0.0;
                for (i = k; i < this.rows(); ++i) {
                    Matrix<M, N> Matrix_this = this.QR();
                    int r$proxy5 = i;
                    int c$proxy5 = k;
                    s += Matrix_this.values()[r$proxy5][c$proxy5] * X[i][j];
                }
                Matrix<M, N> Matrix_this = this.QR();
                int r$proxy6 = k;
                int c$proxy6 = k;
                s = -s / Matrix_this.values()[r$proxy6][c$proxy6];
                i = k;
                while (i < this.rows()) {
                    double[] dArray = X[i];
                    int n = j;
                    Matrix<M, N> Matrix_this2 = this.QR();
                    int r$proxy7 = i++;
                    int c$proxy7 = k;
                    dArray[n] = dArray[n] + s * Matrix_this2.values()[r$proxy7][c$proxy7];
                }
            }
        }
        for (k = this.columns() - 1; k > -1; --k) {
            int j = 0;
            while (j < nx) {
                double[] dArray = X[k];
                int n = j++;
                package$ package$2 = package$.MODULE$;
                double[] thisVector$proxy4 = this.Rdiag();
                int index$proxy3 = k;
                dArray[n] = dArray[n] / thisVector$proxy4[index$proxy3];
            }
            for (int i = 0; i < k; ++i) {
                for (j = 0; j < nx; ++j) {
                    double[] dArray = X[i];
                    int n = j;
                    Matrix<M, N> Matrix_this = this.QR();
                    int r$proxy8 = i;
                    int c$proxy8 = k;
                    dArray[n] = dArray[n] - X[k][j] * Matrix_this.values()[r$proxy8][c$proxy8];
                }
            }
        }
        return Matrix$.MODULE$.apply(X, this.x$3, x$2).subMatrix(0, 0, this.x$4, x$2);
    }

    private final /* synthetic */ double[] $anonfun$1(int r) {
        JFunction1.mcDI.sp & Serializable f$proxy1 = (JFunction1.mcDI.sp & Serializable)c -> {
            if (r >= c) {
                Matrix<M, N> Matrix_this = this.QR();
                return Matrix_this.values()[r][c];
            }
            return 0.0;
        };
        ClassTag x$3$proxy2 = ClassTag$.MODULE$.apply(Double.TYPE);
        double[] out = new double[this.columns()];
        for (int i = 0; i < this.columns(); ++i) {
            out[i] = f$proxy1.apply$mcDI$sp(i);
        }
        return out;
    }

    private final /* synthetic */ double[] $anonfun$3(int r) {
        JFunction1.mcDI.sp & Serializable f$proxy3 = (JFunction1.mcDI.sp & Serializable)c -> {
            if (r < c) {
                Matrix<M, N> Matrix_this = this.QR();
                return Matrix_this.values()[r][c];
            }
            if (r == c) {
                package$ package$2 = package$.MODULE$;
                double[] thisVector$proxy3 = this.Rdiag();
                return thisVector$proxy3[r];
            }
            return 0.0;
        };
        ClassTag x$3$proxy4 = ClassTag$.MODULE$.apply(Double.TYPE);
        double[] out = new double[this.columns()];
        for (int i = 0; i < this.columns(); ++i) {
            out[i] = f$proxy3.apply$mcDI$sp(i);
        }
        return out;
    }
}

