/*
 * Decompiled with CFR 0.152.
 */
package slash;

import java.io.Serializable;
import narr.package;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import slash.InvalidArgumentToGammaFunction$;

public final class Gamma$
implements Serializable {
    private static final double[] lanczos_coefficients;
    private static final double A0;
    private static final double A1;
    private static final double B1;
    private static final double B2;
    private static final double B3;
    private static final double B4;
    private static final double B5;
    private static final double B6;
    private static final double B7;
    private static final double B8;
    private static final double P0;
    private static final double P1;
    private static final double P2;
    private static final double P3;
    private static final double P4;
    private static final double P5;
    private static final double P6;
    private static final double Q1;
    private static final double Q2;
    private static final double Q3;
    private static final double Q4;
    private static final double C;
    private static final double C0;
    private static final double C1;
    private static final double C2;
    private static final double C3;
    private static final double C4;
    private static final double C5;
    private static final double C6;
    private static final double C7;
    private static final double C8;
    private static final double C9;
    private static final double C10;
    private static final double C11;
    private static final double C12;
    private static final double C13;
    public static final Gamma$ MODULE$;

    private Gamma$() {
    }

    static {
        MODULE$ = new Gamma$();
        lanczos_coefficients = (double[])package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.9999999999999971, 57.15623566586292, -59.59796035547549, 14.136097974741746, -0.4919138160976202, 3.399464998481189E-5, 4.652362892704858E-5, -9.837447530487956E-5, 1.580887032249125E-4, -2.1026444172410488E-4, 2.1743961811521265E-4, -1.643181065367639E-4, 8.441822398385275E-5, -2.6190838401581408E-5, 3.6899182659531625E-6}), ClassTag$.MODULE$.apply(Double.TYPE));
        A0 = 6.116095104481416E-9;
        A1 = 6.247308301164655E-9;
        B1 = 0.203610414066807;
        B2 = 0.026620534842894922;
        B3 = 4.939449793824468E-4;
        B4 = -8.514194324403149E-6;
        B5 = -6.4304548177935305E-6;
        B6 = 9.926418406727737E-7;
        B7 = -6.077618957228252E-8;
        B8 = 1.9575583661463974E-10;
        P0 = 6.116095104481416E-9;
        P1 = 6.8716741130671986E-9;
        P2 = 6.820161668496171E-10;
        P3 = 4.686843322948848E-11;
        P4 = 1.5728330277104463E-12;
        P5 = -1.2494415722763663E-13;
        P6 = 4.343529937408594E-15;
        Q1 = 0.3056961078365221;
        Q2 = 0.054642130860422966;
        Q3 = 0.004956830093825887;
        Q4 = 2.6923694661863613E-4;
        C = -0.42278433509846713;
        C0 = 0.5772156649015329;
        C1 = -0.6558780715202539;
        C2 = -0.04200263503409524;
        C3 = 0.16653861138229148;
        C4 = -0.04219773455554433;
        C5 = -0.009621971527876973;
        C6 = 0.0072189432466631;
        C7 = -0.0011651675918590652;
        C8 = -2.1524167411495098E-4;
        C9 = 1.280502823881162E-4;
        C10 = -2.013485478078824E-5;
        C11 = -1.2504934821426706E-6;
        C12 = 1.133027231981696E-6;
        C13 = -2.056338416977607E-7;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Gamma$.class);
    }

    public double lnGamma(double x) {
        if (x == Double.NaN || x <= 0.0) {
            throw InvalidArgumentToGammaFunction$.MODULE$.apply(x, new StringBuilder(43).append("logGamma( x = ").append(x).append(" ) is only defined on x > 0. ").toString());
        }
        if (x < 0.5) {
            return this.lnGamma1p(x) - Math.log(x);
        }
        if (x <= 2.5) {
            return this.lnGamma1p(x - 0.5 - 0.5);
        }
        if (x <= 8.0) {
            int n = (int)Math.floor(x - 1.5);
            double prod = 1.0;
            for (int i = 1; i <= n; ++i) {
                prod *= x - (double)i;
            }
            return this.lnGamma1p(x - (double)(n + 1)) + Math.log(prod);
        }
        double sum = this.inline$lanczos_coefficients()[0];
        for (int i = 1; i < this.inline$lanczos_coefficients().length; ++i) {
            sum += this.inline$lanczos_coefficients()[i] / (x + (double)i);
        }
        double sum2 = sum;
        double tmp = x + 5.2421875;
        return (x + 0.5) * Math.log(tmp) - tmp + 0.9189385332046727 + Math.log(sum2 / x);
    }

    private double lnGamma1p(double x) {
        if (x < -0.5 || x > 1.5) {
            throw InvalidArgumentToGammaFunction$.MODULE$.apply(x, new StringBuilder(44).append("logGamma1p( x = ").append(x).append(" ) defined on -0.5 > x > 1.5").toString());
        }
        return -Math.log1p(this.invGamma1pm1(x));
    }

    public double A0() {
        return A0;
    }

    public double A1() {
        return A1;
    }

    public double B1() {
        return B1;
    }

    public double B2() {
        return B2;
    }

    public double B3() {
        return B3;
    }

    public double B4() {
        return B4;
    }

    public double B5() {
        return B5;
    }

    public double B6() {
        return B6;
    }

    public double B7() {
        return B7;
    }

    public double B8() {
        return B8;
    }

    public double P0() {
        return P0;
    }

    public double P1() {
        return P1;
    }

    public double P2() {
        return P2;
    }

    public double P3() {
        return P3;
    }

    public double P4() {
        return P4;
    }

    public double P5() {
        return P5;
    }

    public double P6() {
        return P6;
    }

    public double Q1() {
        return Q1;
    }

    public double Q2() {
        return Q2;
    }

    public double Q3() {
        return Q3;
    }

    public double Q4() {
        return Q4;
    }

    public double C() {
        return C;
    }

    public double C0() {
        return C0;
    }

    public double C1() {
        return C1;
    }

    public double C2() {
        return C2;
    }

    public double C3() {
        return C3;
    }

    public double C4() {
        return C4;
    }

    public double C5() {
        return C5;
    }

    public double C6() {
        return C6;
    }

    public double C7() {
        return C7;
    }

    public double C8() {
        return C8;
    }

    public double C9() {
        return C9;
    }

    public double C10() {
        return C10;
    }

    public double C11() {
        return C11;
    }

    public double C12() {
        return C12;
    }

    public double C13() {
        return C13;
    }

    private double invGamma1pm1(double x) {
        double t;
        if (x < -0.5 || x > 1.5) {
            throw InvalidArgumentToGammaFunction$.MODULE$.apply(x, new StringBuilder(46).append("invGamma1pm1( x = ").append(x).append(" ) defined on -0.5 > x > 1.5").toString());
        }
        double d = t = x <= 0.5 ? x : x - 0.5 - 0.5;
        if (t < 0.0) {
            double a = this.A0() + t * this.A1();
            double b = this.B8();
            b = this.B7() + t * b;
            b = this.B6() + t * b;
            b = this.B5() + t * b;
            b = this.B4() + t * b;
            b = this.B3() + t * b;
            b = this.B2() + t * b;
            b = this.B1() + t * b;
            b = 1.0 + t * b;
            double c = this.C13() + t * (a / b);
            c = this.C12() + t * c;
            c = this.C11() + t * c;
            c = this.C10() + t * c;
            c = this.C9() + t * c;
            c = this.C8() + t * c;
            c = this.C7() + t * c;
            c = this.C6() + t * c;
            c = this.C5() + t * c;
            c = this.C4() + t * c;
            c = this.C3() + t * c;
            c = this.C2() + t * c;
            c = this.C1() + t * c;
            c = this.C() + t * c;
            if (x > 0.5) {
                return t * c / x;
            }
            return x * (c + 0.5 + 0.5);
        }
        double p = this.P6();
        p = this.P5() + t * p;
        p = this.P4() + t * p;
        p = this.P3() + t * p;
        p = this.P2() + t * p;
        p = this.P1() + t * p;
        p = this.P0() + t * p;
        double q = this.Q4();
        q = this.Q3() + t * q;
        q = this.Q2() + t * q;
        q = this.Q1() + t * q;
        q = 1.0 + t * q;
        double c = this.C13() + p / q * t;
        c = this.C12() + t * c;
        c = this.C11() + t * c;
        c = this.C10() + t * c;
        c = this.C9() + t * c;
        c = this.C8() + t * c;
        c = this.C7() + t * c;
        c = this.C6() + t * c;
        c = this.C5() + t * c;
        c = this.C4() + t * c;
        c = this.C3() + t * c;
        c = this.C2() + t * c;
        c = this.C1() + t * c;
        c = this.C0() + t * c;
        if (x > 0.5) {
            return t / x * (c - 0.5 - 0.5);
        }
        return x * c;
    }

    public final double[] inline$lanczos_coefficients() {
        return lanczos_coefficients;
    }
}

