/*
 * Decompiled with CFR 0.152.
 */
package slash.stats.kernel;

import java.io.Serializable;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import slash.stats.kernel.DiscreteKernel;
import slash.stats.kernel.EpanechnikovKernel$;
import slash.stats.kernel.Kernel;
import slash.vector.package$;

public class EpanechnikovKernel<N>
implements Kernel<N>,
Product,
Serializable {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(EpanechnikovKernel.class.getDeclaredField("discretize$lzy2"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(EpanechnikovKernel.class.getDeclaredField("exclusionRadiusSquared$lzy2"));
    private volatile Object exclusionRadiusSquared$lzy2;
    private volatile Object discretize$lzy2;
    private final double exclusionRadius;

    public static <N> EpanechnikovKernel<Object> apply(double d) {
        return EpanechnikovKernel$.MODULE$.apply(d);
    }

    public static EpanechnikovKernel<?> fromProduct(Product product) {
        return EpanechnikovKernel$.MODULE$.fromProduct(product);
    }

    public static <N> EpanechnikovKernel<Object> unapply(EpanechnikovKernel<Object> epanechnikovKernel) {
        return EpanechnikovKernel$.MODULE$.unapply(epanechnikovKernel);
    }

    public EpanechnikovKernel(double exclusionRadius) {
        this.exclusionRadius = exclusionRadius;
        Kernel.$init$(this);
    }

    @Override
    public double exclusionRadiusSquared() {
        Object object = this.exclusionRadiusSquared$lzy2;
        if (object instanceof Double) {
            return BoxesRunTime.unboxToDouble((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToDouble(null);
        }
        return BoxesRunTime.unboxToDouble((Object)this.exclusionRadiusSquared$lzyINIT2());
    }

    private Object exclusionRadiusSquared$lzyINIT2() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.exclusionRadiusSquared$lzy2) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Double d = null;
                    try {
                        d = BoxesRunTime.boxToDouble((double)Kernel.exclusionRadiusSquared$(this));
                        object2 = d == null ? LazyVals.NullValue$.MODULE$ : d;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.exclusionRadiusSquared$lzy2;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return d;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public DiscreteKernel discretize() {
        Object object = this.discretize$lzy2;
        if (object instanceof DiscreteKernel) {
            return (DiscreteKernel)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (DiscreteKernel)this.discretize$lzyINIT2();
    }

    private Object discretize$lzyINIT2() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.discretize$lzy2) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    DiscreteKernel discreteKernel = null;
                    try {
                        discreteKernel = Kernel.discretize$(this);
                        object2 = discreteKernel == null ? LazyVals.NullValue$.MODULE$ : discreteKernel;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.discretize$lzy2;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return discreteKernel;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.exclusionRadius()));
        return Statics.finalizeHash((int)n, (int)1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof EpanechnikovKernel)) return false;
        EpanechnikovKernel epanechnikovKernel = (EpanechnikovKernel)object;
        if (this.exclusionRadius() != epanechnikovKernel.exclusionRadius()) return false;
        if (!epanechnikovKernel.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof EpanechnikovKernel;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "EpanechnikovKernel";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 != n2) {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return BoxesRunTime.boxToDouble((double)this._1());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "exclusionRadius";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    @Override
    public double exclusionRadius() {
        return this.exclusionRadius;
    }

    @Override
    public double weight(double[] v) {
        return this.weight(package$.MODULE$.normSquared(v));
    }

    @Override
    public double weight(double magnitudeSquared) {
        if (magnitudeSquared > this.exclusionRadiusSquared()) {
            return 0.0;
        }
        return 0.75 - 0.75 * (magnitudeSquared / this.exclusionRadiusSquared());
    }

    public <N> EpanechnikovKernel<Object> copy(double exclusionRadius) {
        return new EpanechnikovKernel<Object>(exclusionRadius);
    }

    public double copy$default$1() {
        return this.exclusionRadius();
    }

    public double _1() {
        return this.exclusionRadius();
    }
}

