/*
 * Decompiled with CFR 0.152.
 */
package slash.stats.kernel;

import java.io.Serializable;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import slash.stats.kernel.DiscreteKernel;
import slash.stats.kernel.GaussianKernel$;
import slash.stats.kernel.Kernel;
import slash.stats.probability.distributions.Gaussian;
import slash.vector.package$;

public class GaussianKernel<N>
implements Kernel<N>,
Product,
Serializable {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(GaussianKernel.class.getDeclaredField("discretize$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(GaussianKernel.class.getDeclaredField("exclusionRadiusSquared$lzy1"));
    private volatile Object exclusionRadiusSquared$lzy1;
    private volatile Object discretize$lzy1;
    private final double exclusionRadius;
    private final Gaussian gaussian;

    public static <N> GaussianKernel<Object> apply(double d, Gaussian gaussian) {
        return GaussianKernel$.MODULE$.apply(d, gaussian);
    }

    public static GaussianKernel<?> fromProduct(Product product) {
        return GaussianKernel$.MODULE$.fromProduct(product);
    }

    public static <N> GaussianKernel<Object> unapply(GaussianKernel<Object> gaussianKernel) {
        return GaussianKernel$.MODULE$.unapply(gaussianKernel);
    }

    public GaussianKernel(double exclusionRadius, Gaussian gaussian) {
        this.exclusionRadius = exclusionRadius;
        this.gaussian = gaussian;
        Kernel.$init$(this);
    }

    @Override
    public double exclusionRadiusSquared() {
        Object object = this.exclusionRadiusSquared$lzy1;
        if (object instanceof Double) {
            return BoxesRunTime.unboxToDouble((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToDouble(null);
        }
        return BoxesRunTime.unboxToDouble((Object)this.exclusionRadiusSquared$lzyINIT1());
    }

    private Object exclusionRadiusSquared$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.exclusionRadiusSquared$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Double d = null;
                    try {
                        d = BoxesRunTime.boxToDouble((double)Kernel.exclusionRadiusSquared$(this));
                        object2 = d == null ? LazyVals.NullValue$.MODULE$ : d;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.exclusionRadiusSquared$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return d;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public DiscreteKernel discretize() {
        Object object = this.discretize$lzy1;
        if (object instanceof DiscreteKernel) {
            return (DiscreteKernel)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (DiscreteKernel)this.discretize$lzyINIT1();
    }

    private Object discretize$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.discretize$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    DiscreteKernel discreteKernel = null;
                    try {
                        discreteKernel = Kernel.discretize$(this);
                        object2 = discreteKernel == null ? LazyVals.NullValue$.MODULE$ : discreteKernel;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.discretize$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return discreteKernel;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.exclusionRadius()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.gaussian()));
        return Statics.finalizeHash((int)n, (int)2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof GaussianKernel)) return false;
        GaussianKernel gaussianKernel = (GaussianKernel)object;
        if (this.exclusionRadius() != gaussianKernel.exclusionRadius()) return false;
        Gaussian gaussian = this.gaussian();
        Gaussian gaussian2 = gaussianKernel.gaussian();
        if (gaussian == null) {
            if (gaussian2 != null) {
                return false;
            }
        } else if (!((Object)gaussian).equals(gaussian2)) return false;
        if (!gaussianKernel.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof GaussianKernel;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "GaussianKernel";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return BoxesRunTime.boxToDouble((double)this._1());
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "exclusionRadius";
        }
        if (1 == n2) {
            return "gaussian";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    @Override
    public double exclusionRadius() {
        return this.exclusionRadius;
    }

    public Gaussian gaussian() {
        return this.gaussian;
    }

    @Override
    public double weight(double[] v) {
        return this.weight(package$.MODULE$.normSquared(v));
    }

    @Override
    public double weight(double magnitudeSquared) {
        if (magnitudeSquared > this.exclusionRadiusSquared()) {
            return 0.0;
        }
        return this.gaussian().p2(magnitudeSquared);
    }

    public <N> GaussianKernel<Object> copy(double exclusionRadius, Gaussian gaussian) {
        return new GaussianKernel<Object>(exclusionRadius, gaussian);
    }

    public double copy$default$1() {
        return this.exclusionRadius();
    }

    public <N> Gaussian copy$default$2() {
        return this.gaussian();
    }

    public double _1() {
        return this.exclusionRadius();
    }

    public Gaussian _2() {
        return this.gaussian();
    }
}

