/*
 * Copyright 2023 dragonfly.ai
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package ai.dragonfly.math.stats.probability.distributions.stream

import ai.dragonfly.math.stats.probability.distributions
import ai.dragonfly.math.stats.probability.distributions.ProbabilityDistribution
import ai.dragonfly.math.stats.BoundedMean

object PERT {
  val doNotUse:String = "" +
    "As a special case of the Beta distribution, PERT only has utility in applications with unknowable σ².\n" +
    "In such situations, PERT approximates σ² with the huristic value: σ² = ((μ - min) * (MAX - μ)) / 7.0.\n" +
    "Because stream.Beta can approximate σ² directly, its accuracy always meets or exceeds that of stream.PERT.\n\n" +
    "One should always prefer stream.Beta, but if you insist on using stream.PERT, the UseBetaDistributionInstead\n" +
    "exception generated by its constructor contains a reference to a functioning instance of stream.PERT:\n\n" +
    "val onlinePERT = try {\n" +
      "\tnew ai.dragonfly.math.stats.probability.distributions.stream.PERT\n" +
    "} catch {\n" +
      "\t/* I understand the superiority of stream.Beta over stream.PERT, but I have reasons! */\n" +
      "\tcase ai.dragonfly.math.stats.probability.distributions.stream.UseBetaDistributionInstead(pert) => pert\n" +
    "}"

}

/**
 * As a special case of the Beta distribution, PERT only has utility in applications with unknowable σ².
 * In such situations, PERT approximates σ² with the huristic value: σ² = ((μ - min) * (MAX - μ)) / 7.0.
 * Because stream.Beta can approximate σ² directly, its accuracy always meets or exceeds that of streem.PERT.

 * One should always prefer stream.Beta, but if you insist on using stream.PERT, the UseBetaDistributionInstead
 * exception generated by its constructor contains a reference to a functioning instance of stream.PERT:
 * val onlinePERT = try {
 * 	new ai.dragonfly.math.stats.probability.distributions.stream.PERT
 * } catch {
 * 	/* I understand the superiority of stream.Beta over stream.PERT, but I have reasons! */
 * 	case ai.dragonfly.math.stats.probability.distributions.stream.UseBetaDistributionInstead(pert) => pert
 * }
 */


class PERT extends OnlineUnivariateProbabilityDistributionEstimator[Double, distributions.PERT] {

  val estimator = new BoundedMeanEstimator[Double](distributions.PERT.domain)

  override def observe(frequency: Double, observation: Double):PERT = {
    estimator.observe(Array[Double](frequency, observation))
    this
  }

  override def estimate: distributions.EstimatedPERT = {
    val bμ̂ = estimator.sampleBoundedMean
    distributions.EstimatedPERT(
      distributions.PERT(bμ̂),
      bμ̂.ℕ
    )
  }

  throw UseBetaDistributionInstead(this)
}

case class UseBetaDistributionInstead(pert:PERT) extends Exception(PERT.doNotUse)