/*
 * Decompiled with CFR 0.152.
 */
package slash.stats;

import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.TreeMap;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.util.Random;
import slash.Random$;
import slash.stats.UnivariateGenerativeModel$;
import slash.stats.UnivariateHistogram;
import slash.stats.probability.distributions.Sampleable;

public class UnivariateGenerativeModel<T>
implements Sampleable<T> {
    private final ClassTag slash$stats$probability$distributions$Sampleable$$evidence$1;
    private final UnivariateHistogram hist;
    private final TreeMap cumulative;

    public static <T> UnivariateGenerativeModel<T> apply(UnivariateHistogram<T> univariateHistogram, ClassTag<T> classTag) {
        return UnivariateGenerativeModel$.MODULE$.apply(univariateHistogram, classTag);
    }

    public UnivariateGenerativeModel(UnivariateHistogram<T> hist, TreeMap<Object, Object> cumulative, ClassTag<T> evidence$1) {
        this.hist = hist;
        this.cumulative = cumulative;
        this.slash$stats$probability$distributions$Sampleable$$evidence$1 = evidence$1;
    }

    @Override
    public ClassTag slash$stats$probability$distributions$Sampleable$$evidence$1() {
        return this.slash$stats$probability$distributions$Sampleable$$evidence$1;
    }

    private UnivariateHistogram<T> hist() {
        return this.hist;
    }

    private TreeMap<Object, Object> cumulative() {
        return this.cumulative;
    }

    @Override
    public T random(Random r) {
        double pX = r.nextDouble() * this.hist().mass();
        Tuple2 tuple2 = ((TreeMap)this.cumulative().rangeTo((Object)BoxesRunTime.boxToDouble((double)pX))).last();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double top = BoxesRunTime.unboxToDouble((Object)tuple2._1());
        int bINdex = BoxesRunTime.unboxToInt((Object)tuple2._2());
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)top), (Object)BoxesRunTime.boxToInteger((int)bINdex));
        double top2 = BoxesRunTime.unboxToDouble((Object)tuple22._1());
        int bINdex2 = BoxesRunTime.unboxToInt((Object)tuple22._2());
        return this.hist().bINTerpolator(bINdex2, 1.0 - (top2 - pX) / this.hist().binMass(bINdex2));
    }

    @Override
    public Random random$default$1() {
        return Random$.MODULE$.defaultRandom();
    }

    public T min() {
        return this.hist().min();
    }

    public T MAX() {
        return this.hist().MAX();
    }

    public double p(T x) {
        return this.hist().binMass(this.hist().index(x)) / this.hist().mass();
    }

    public T \u03bc() {
        double halfMass = this.hist().mass() / 2.0;
        Tuple2 tuple2 = ((TreeMap)this.cumulative().rangeTo((Object)BoxesRunTime.boxToDouble((double)halfMass))).last();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double top = BoxesRunTime.unboxToDouble((Object)tuple2._1());
        int bINdex = BoxesRunTime.unboxToInt((Object)tuple2._2());
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)top), (Object)BoxesRunTime.boxToInteger((int)bINdex));
        double top2 = BoxesRunTime.unboxToDouble((Object)tuple22._1());
        int bINdex2 = BoxesRunTime.unboxToInt((Object)tuple22._2());
        return this.hist().bINTerpolator(bINdex2, 1.0 - (top2 - halfMass) / this.hist().binMass(bINdex2));
    }

    public String toString() {
        return this.cumulative().toString();
    }
}

