/*
 * Decompiled with CFR 0.152.
 */
package slash.matrix;

import java.io.Serializable;
import narr.native.NArr;
import scala.Function1;
import scala.Predef$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory;
import scala.runtime.BoxesRunTime;
import scala.scalajs.js.Array;
import scala.scalajs.js.typedarray.Float32Array;
import scala.scalajs.js.typedarray.Float64Array;
import scala.scalajs.js.typedarray.Int16Array;
import scala.scalajs.js.typedarray.Int32Array;
import scala.scalajs.js.typedarray.Int8Array;
import scala.util.Random;
import slash.UnsupportedVectorDimension$;
import slash.interval.Interval;
import slash.matrix.Matrix$;

public class Matrix<M, N> {
    private final Float64Array values;
    private final Integer x$2;
    private final Integer x$3;
    private final int rows;
    private final int columns;
    private final int MxN;

    public static <M, N> Matrix<Object, Object> apply(Float64Array float64Array, Integer n, Integer n2) {
        return Matrix$.MODULE$.apply(float64Array, n, n2);
    }

    public static <M, N> Matrix<Object, Object> apply(Object object, Integer n, Integer n2) {
        return Matrix$.MODULE$.apply(object, n, n2);
    }

    public static <M, N> Matrix<Object, Object> diagonal(double d, Integer n, Integer n2) {
        return Matrix$.MODULE$.diagonal(d, n, n2);
    }

    public static <D> Matrix<Object, Object> diagonal(Float64Array float64Array, Integer n) {
        return Matrix$.MODULE$.diagonal(float64Array, n);
    }

    public static <M, N, D> Matrix<Object, Object> diagonal(Float64Array float64Array, Integer n, Integer n2, Integer n3) {
        return Matrix$.MODULE$.diagonal(float64Array, n, n2, n3);
    }

    public static <M, N> Matrix<Object, Object> fill(double d, Integer n, Integer n2) {
        return Matrix$.MODULE$.fill(d, n, n2);
    }

    public static <M, N> Matrix<Object, Object> identity(Integer n, Integer n2) {
        return Matrix$.MODULE$.identity(n, n2);
    }

    public static <M, N> Matrix<Object, Object> ones(Integer n, Integer n2) {
        return Matrix$.MODULE$.ones(n, n2);
    }

    public static <M, N> Matrix<Object, Object> random(Interval<Object> interval, Random random, Integer n, Integer n2) {
        return Matrix$.MODULE$.random(interval, random, n, n2);
    }

    public static <M, N> Matrix<Object, Object> zeros(Integer n, Integer n2) {
        return Matrix$.MODULE$.zeros(n, n2);
    }

    public Matrix(Float64Array values, Integer x$2, Integer x$3) {
        this.values = values;
        this.x$2 = x$2;
        this.x$3 = x$3;
        Integer ev = x$2;
        this.rows = BoxesRunTime.unboxToInt((Object)ev);
        Integer ev2 = x$3;
        this.columns = BoxesRunTime.unboxToInt((Object)ev2);
        this.MxN = this.rows() * this.columns();
        Predef$.MODULE$.require(this.rows() * this.columns() == values.length(), () -> this.$init$$$anonfun$1(values));
    }

    public Float64Array values() {
        return this.values;
    }

    public int rows() {
        return this.rows;
    }

    public int columns() {
        return this.columns;
    }

    public int MxN() {
        return this.MxN;
    }

    public Matrix<M, N> copy() {
        NArr temp = (NArr)this.values();
        return new Matrix<M, N>((Float64Array)temp.slice(0, temp.length()), this.x$2, this.x$3);
    }

    public Float64Array columnPackedArray() {
        Float64Array vs = new Float64Array(this.rows() * this.columns());
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.columns(); ++j) {
                int r$proxy4 = i;
                int c$proxy4 = j;
                vs.update(i + j * this.rows(), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)this.values().apply(r$proxy4 * this.columns() + c$proxy4))));
            }
        }
        return vs;
    }

    public Object rowVectors() {
        Int8Array int8Array;
        ClassTag x$3$proxy3;
        Function1 & Serializable f$proxy2 = (Function1 & Serializable)row -> this.$anonfun$1(BoxesRunTime.unboxToInt((Object)row));
        ClassTag classTag = x$3$proxy3 = ClassTag$.MODULE$.apply(Float64Array.class);
        ManifestFactory.ByteManifest byteManifest = ClassTag$.MODULE$.Byte();
        ClassTag classTag2 = classTag;
        if (!(byteManifest != null ? !byteManifest.equals(classTag2) : classTag2 != null)) {
            int8Array = new Int8Array(this.rows());
        } else {
            ManifestFactory.ShortManifest shortManifest = ClassTag$.MODULE$.Short();
            ClassTag classTag3 = classTag;
            if (!(shortManifest != null ? !shortManifest.equals(classTag3) : classTag3 != null)) {
                int8Array = new Int16Array(this.rows());
            } else {
                ManifestFactory.IntManifest intManifest = ClassTag$.MODULE$.Int();
                ClassTag classTag4 = classTag;
                if (!(intManifest != null ? !intManifest.equals(classTag4) : classTag4 != null)) {
                    int8Array = new Int32Array(this.rows());
                } else {
                    ManifestFactory.FloatManifest floatManifest = ClassTag$.MODULE$.Float();
                    ClassTag classTag5 = classTag;
                    if (!(floatManifest != null ? !floatManifest.equals(classTag5) : classTag5 != null)) {
                        int8Array = new Float32Array(this.rows());
                    } else {
                        ManifestFactory.DoubleManifest doubleManifest = ClassTag$.MODULE$.Double();
                        ClassTag classTag6 = classTag;
                        if (!(doubleManifest != null ? !doubleManifest.equals(classTag6) : classTag6 != null)) {
                            int8Array = new Float64Array(this.rows());
                        } else {
                            int n$proxy3 = this.rows();
                            int8Array = new Array(n$proxy3);
                        }
                    }
                }
            }
        }
        Int8Array out = int8Array;
        for (int i = 0; i < this.rows(); ++i) {
            ((NArr)narr.package$.MODULE$.nArray2NArr(out)).update(i, f$proxy2.apply((Object)BoxesRunTime.boxToInteger((int)i)));
        }
        return out;
    }

    public Object columnVectors() {
        return this.transpose().rowVectors();
    }

    public int rowDimension() {
        return this.rows();
    }

    public int columnDimension() {
        return this.columns();
    }

    public <M1, N1> Matrix<Object, Object> subMatrix(int r0, int c0, Integer x$3, Integer x$4) {
        Integer ev = x$3;
        int subRows = BoxesRunTime.unboxToInt((Object)ev);
        Integer ev2 = x$4;
        int subColumns = BoxesRunTime.unboxToInt((Object)ev2);
        int rEnd = r0 + subRows;
        int cEnd = c0 + subColumns;
        Float64Array vs = new Float64Array(subRows * subColumns);
        int i = 0;
        for (int r = r0; r < rEnd; ++r) {
            int c = c0;
            while (c < cEnd) {
                int r$proxy5 = r;
                int c$proxy5 = c++;
                vs.update(i, (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)this.values().apply(r$proxy5 * this.columns() + c$proxy5))));
                ++i;
            }
        }
        return new Matrix<Object, Object>(vs, x$3, x$4);
    }

    public <M1, N1> Matrix<Object, Object> subMatrix(Int32Array rowIndices, Int32Array columnIndices, Integer x$3, Integer x$4) {
        Float64Array vs = new Float64Array(rowIndices.length() * columnIndices.length());
        int i = 0;
        for (int ri = 0; ri < rowIndices.length(); ++ri) {
            for (int ci = 0; ci < columnIndices.length(); ++ci) {
                int r$proxy6 = BoxesRunTime.unboxToInt((Object)rowIndices.apply(ri));
                int c$proxy6 = BoxesRunTime.unboxToInt((Object)columnIndices.apply(ci));
                vs.update(i, (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)this.values().apply(r$proxy6 * this.columns() + c$proxy6))));
                ++i;
            }
        }
        return new Matrix<Object, Object>(vs, x$3, x$4);
    }

    public <M1, N1> Matrix<Object, Object> subMatrix(int r0, Int32Array columnIndices, Integer x$3, Integer x$4) {
        Integer ev = x$3;
        int subRows = BoxesRunTime.unboxToInt((Object)ev);
        Integer ev2 = x$4;
        int subColumns = BoxesRunTime.unboxToInt((Object)ev2);
        int rEnd = r0 + subRows;
        Float64Array vs = new Float64Array(subRows * subColumns);
        int i = 0;
        for (int ri = r0; ri < rEnd; ++ri) {
            for (int ci = 0; ci < columnIndices.length(); ++ci) {
                int r$proxy7 = ri;
                int c$proxy7 = BoxesRunTime.unboxToInt((Object)columnIndices.apply(ci));
                vs.update(i, (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)this.values().apply(r$proxy7 * this.columns() + c$proxy7))));
                ++i;
            }
        }
        return new Matrix<Object, Object>(vs, x$3, x$4);
    }

    public <M1, N1> Matrix<Object, Object> subMatrix(Int32Array rowIndices, int c0, Integer x$3, Integer x$4) {
        Integer ev = x$3;
        int subRows = BoxesRunTime.unboxToInt((Object)ev);
        Integer ev2 = x$4;
        int subColumns = BoxesRunTime.unboxToInt((Object)ev2);
        int cEnd = c0 + subColumns;
        Float64Array vs = new Float64Array(subRows * subColumns);
        int i = 0;
        for (int ri = 0; ri < rowIndices.length(); ++ri) {
            int ci = c0;
            while (ci < cEnd) {
                int r$proxy8 = BoxesRunTime.unboxToInt((Object)rowIndices.apply(ri));
                int c$proxy8 = ci++;
                vs.update(i, (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)this.values().apply(r$proxy8 * this.columns() + c$proxy8))));
                ++i;
            }
        }
        return new Matrix<Object, Object>(vs, x$3, x$4);
    }

    public <M1, N1> void setMatrix(int r0, int c0, Matrix<Object, Object> thatMatrix, Integer x$4, Integer x$5) {
        Integer ev = x$4;
        int rEnd = BoxesRunTime.unboxToInt((Object)ev) + r0;
        Integer ev2 = x$5;
        int cEnd = BoxesRunTime.unboxToInt((Object)ev2) + c0;
        for (int r = r0; r < rEnd; ++r) {
            for (int c = c0; c < cEnd; ++c) {
                Matrix<Object, Object> matrix;
                Matrix<Object, Object> matrix2;
                int r$proxy10 = r;
                int c$proxy10 = c;
                Matrix<Object, Object> Matrix_this = matrix2 = thatMatrix;
                int r$proxy9 = r - r0;
                int c$proxy9 = c - c0;
                Matrix<Object, Object> Matrix_this2 = matrix = Matrix_this;
                double value$proxy3 = BoxesRunTime.unboxToDouble((Object)Matrix_this.values().apply(r$proxy9 * Matrix_this2.columns() + c$proxy9));
                this.values().update(r$proxy10 * this.columns() + c$proxy10, (Object)BoxesRunTime.boxToDouble((double)value$proxy3));
            }
        }
    }

    public <M1, N1> void setMatrix(Int32Array rowIndices, Int32Array columnIndices, Matrix<Object, Object> thatMatrix) {
        for (int i = 0; i < rowIndices.length(); ++i) {
            int j = 0;
            while (j < columnIndices.length()) {
                Matrix<Object, Object> matrix;
                Matrix<Object, Object> matrix2;
                int r$proxy12 = BoxesRunTime.unboxToInt((Object)rowIndices.apply(i));
                int c$proxy12 = BoxesRunTime.unboxToInt((Object)columnIndices.apply(j));
                Matrix<Object, Object> Matrix_this = matrix2 = thatMatrix;
                int r$proxy11 = i;
                int c$proxy11 = j++;
                Matrix<Object, Object> Matrix_this2 = matrix = Matrix_this;
                double value$proxy4 = BoxesRunTime.unboxToDouble((Object)Matrix_this.values().apply(r$proxy11 * Matrix_this2.columns() + c$proxy11));
                this.values().update(r$proxy12 * this.columns() + c$proxy12, (Object)BoxesRunTime.boxToDouble((double)value$proxy4));
            }
        }
    }

    public <M1, N1> void setMatrix(Int32Array rowIndices, int c0, Matrix<Object, Object> thatMatrix, Integer x$4, Integer x$5) {
        Integer ev = x$5;
        int c1 = c0 + BoxesRunTime.unboxToInt((Object)ev);
        for (int r = 0; r < rowIndices.length(); ++r) {
            for (int c = c0; c < c1; ++c) {
                Matrix<Object, Object> matrix;
                Matrix<Object, Object> matrix2;
                int r$proxy14 = BoxesRunTime.unboxToInt((Object)rowIndices.apply(r));
                int c$proxy14 = c;
                Matrix<Object, Object> Matrix_this = matrix2 = thatMatrix;
                int r$proxy13 = r;
                int c$proxy13 = c - c0;
                Matrix<Object, Object> Matrix_this2 = matrix = Matrix_this;
                double value$proxy5 = BoxesRunTime.unboxToDouble((Object)Matrix_this.values().apply(r$proxy13 * Matrix_this2.columns() + c$proxy13));
                this.values().update(r$proxy14 * this.columns() + c$proxy14, (Object)BoxesRunTime.boxToDouble((double)value$proxy5));
            }
        }
    }

    public <M1, N1> void setMatrix(int r0, Int32Array columnIndices, Matrix<Object, Object> thatMatrix, Integer x$4, Integer x$5) {
        Integer ev = x$4;
        int r1 = r0 + BoxesRunTime.unboxToInt((Object)ev);
        for (int r = r0; r < r1; ++r) {
            int c = 0;
            while (c < columnIndices.length()) {
                Matrix<Object, Object> matrix;
                Matrix<Object, Object> matrix2;
                int r$proxy16 = r;
                int c$proxy16 = BoxesRunTime.unboxToInt((Object)columnIndices.apply(c));
                Matrix<Object, Object> Matrix_this = matrix2 = thatMatrix;
                int r$proxy15 = r - r0;
                int c$proxy15 = c++;
                Matrix<Object, Object> Matrix_this2 = matrix = Matrix_this;
                double value$proxy6 = BoxesRunTime.unboxToDouble((Object)Matrix_this.values().apply(r$proxy15 * Matrix_this2.columns() + c$proxy15));
                this.values().update(r$proxy16 * this.columns() + c$proxy16, (Object)BoxesRunTime.boxToDouble((double)value$proxy6));
            }
        }
    }

    public Matrix<N, M> transpose() {
        return new Matrix<M, N>(this.columnPackedArray(), this.x$3, this.x$2);
    }

    public double norm1() {
        double maxColumnSum = -1.7976931348623157E308;
        for (int c = 0; c < this.columns(); ++c) {
            double columnSum = 0.0;
            int r = 0;
            while (r < this.rows()) {
                int r$proxy17 = r++;
                int c$proxy17 = c;
                columnSum += Math.abs(BoxesRunTime.unboxToDouble((Object)this.values().apply(r$proxy17 * this.columns() + c$proxy17)));
            }
            maxColumnSum = Math.max(maxColumnSum, columnSum);
        }
        return maxColumnSum;
    }

    public double normInfinity() {
        double maxRowSum = -1.7976931348623157E308;
        for (int r = 0; r < this.rows(); ++r) {
            double rowSum = 0.0;
            int c = 0;
            while (c < this.columns()) {
                int r$proxy18 = r;
                int c$proxy18 = c++;
                rowSum += Math.abs(BoxesRunTime.unboxToDouble((Object)this.values().apply(r$proxy18 * this.columns() + c$proxy18)));
            }
            maxRowSum = Math.max(maxRowSum, rowSum);
        }
        return maxRowSum;
    }

    public double normFrobenius() {
        double f = 0.0;
        for (int i = 0; i < this.values().length(); ++i) {
            f = package$.MODULE$.hypot(f, BoxesRunTime.unboxToDouble((Object)this.values().apply(i)));
        }
        return f;
    }

    public Matrix<M, N> add(Matrix<M, N> B) {
        for (int r = 0; r < this.rows(); ++r) {
            int c = 0;
            while (c < this.columns()) {
                Matrix<M, N> matrix;
                Matrix<M, N> matrix2;
                int r$proxy21 = r;
                int c$proxy21 = c;
                int r$proxy19 = r;
                int c$proxy19 = c;
                Matrix<M, N> Matrix_this = matrix2 = B;
                int r$proxy20 = r;
                int c$proxy20 = c++;
                Matrix<M, N> Matrix_this2 = matrix = Matrix_this;
                double value$proxy7 = BoxesRunTime.unboxToDouble((Object)this.values().apply(r$proxy19 * this.columns() + c$proxy19)) + BoxesRunTime.unboxToDouble((Object)Matrix_this.values().apply(r$proxy20 * Matrix_this2.columns() + c$proxy20));
                this.values().update(r$proxy21 * this.columns() + c$proxy21, (Object)BoxesRunTime.boxToDouble((double)value$proxy7));
            }
        }
        return this;
    }

    public Matrix<M, N> subtract(Matrix<M, N> B) {
        for (int r = 0; r < this.rows(); ++r) {
            int c = 0;
            while (c < this.columns()) {
                Matrix<M, N> matrix;
                Matrix<M, N> matrix2;
                int r$proxy24 = r;
                int c$proxy24 = c;
                int r$proxy22 = r;
                int c$proxy22 = c;
                Matrix<M, N> Matrix_this = matrix2 = B;
                int r$proxy23 = r;
                int c$proxy23 = c++;
                Matrix<M, N> Matrix_this2 = matrix = Matrix_this;
                double value$proxy8 = BoxesRunTime.unboxToDouble((Object)this.values().apply(r$proxy22 * this.columns() + c$proxy22)) - BoxesRunTime.unboxToDouble((Object)Matrix_this.values().apply(r$proxy23 * Matrix_this2.columns() + c$proxy23));
                this.values().update(r$proxy24 * this.columns() + c$proxy24, (Object)BoxesRunTime.boxToDouble((double)value$proxy8));
            }
        }
        return this;
    }

    public Matrix<M, N> times(double s) {
        for (int i = 0; i < this.values().length(); ++i) {
            this.values().update(i, (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)this.values().apply(i)) * s)));
        }
        return this;
    }

    public <V> Matrix<M, Object> $times(Matrix<N, Object> thatMatrix, Integer x$2) {
        return this.times(thatMatrix, x$2);
    }

    public <V> Matrix<M, Object> times(Matrix<N, Object> b, Integer x$2) {
        Matrix<Object, Object> X = Matrix$.MODULE$.zeros(this.x$2, x$2);
        Float64Array Bcolj = new Float64Array(this.columns());
        for (int j = 0; j < b.columns(); ++j) {
            int k;
            for (k = 0; k < this.columns(); ++k) {
                Matrix<Object, Object> matrix;
                Matrix<Object, Object> matrix2;
                Matrix<Object, Object> Matrix_this = matrix2 = b;
                int r$proxy25 = k;
                int c$proxy25 = j;
                Matrix<Object, Object> Matrix_this2 = matrix = Matrix_this;
                Bcolj.update(k, (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)Matrix_this.values().apply(r$proxy25 * Matrix_this2.columns() + c$proxy25))));
            }
            int i = 0;
            while (i < this.rows()) {
                Matrix<Object, Object> matrix;
                Matrix<Object, Object> matrix3;
                double s = 0.0;
                for (k = 0; k < this.columns(); ++k) {
                    int r$proxy26 = i;
                    int c$proxy26 = k;
                    s += BoxesRunTime.unboxToDouble((Object)this.values().apply(r$proxy26 * this.columns() + c$proxy26)) * BoxesRunTime.unboxToDouble((Object)Bcolj.apply(k));
                }
                Matrix<Object, Object> Matrix_this = matrix3 = X;
                int r$proxy27 = i++;
                int c$proxy27 = j;
                double value$proxy9 = s;
                Matrix<Object, Object> Matrix_this3 = matrix = Matrix_this;
                Matrix_this.values().update(r$proxy27 * Matrix_this3.columns() + c$proxy27, (Object)BoxesRunTime.boxToDouble((double)value$proxy9));
            }
        }
        return X;
    }

    public double trace() {
        double t = 0.0;
        int i = 0;
        while (i < Math.min(this.rows(), this.columns())) {
            int r$proxy28 = i;
            int c$proxy28 = i++;
            t += BoxesRunTime.unboxToDouble((Object)this.values().apply(r$proxy28 * this.columns() + c$proxy28));
        }
        return t;
    }

    public String dim() {
        return new StringBuilder(6).append("dim(").append(this.rows()).append("x").append(this.columns()).append(")").toString();
    }

    public Array<Float64Array> asNativeArray2D() {
        return (Array)this.rowVectors();
    }

    public String toString() {
        scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
        for (int r = 0; r < this.rows(); ++r) {
            sb.append("\n");
            int c = 0;
            while (c < this.columns()) {
                int r$proxy29 = r;
                int c$proxy29 = c++;
                sb.append(new StringBuilder(2).append(BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)this.values().apply(r$proxy29 * this.columns() + c$proxy29)))).append(", ").toString());
            }
        }
        return sb.toString();
    }

    private final Object $init$$$anonfun$1(Float64Array values$1) {
        return new StringBuilder(18).append("Product of ").append(this.rows()).append(" x ").append(this.columns()).append(" != ").append(values$1.length()).toString();
    }

    private final /* synthetic */ Float64Array $anonfun$1(int row) {
        slash.vector.package$ package$2;
        slash.vector.package$ package$_this = package$2 = slash.vector.package$.MODULE$;
        Float64Array a$proxy1 = (Float64Array)((NArr)this.values()).slice(row * this.columns(), row * this.columns() + this.columns());
        Integer ev = this.x$3;
        int requiredDimension$proxy1 = BoxesRunTime.unboxToInt((Object)ev);
        if (a$proxy1.length() != requiredDimension$proxy1) {
            throw UnsupportedVectorDimension$.MODULE$.apply(a$proxy1.length(), requiredDimension$proxy1);
        }
        return a$proxy1;
    }
}

