/*
 * Decompiled with CFR 0.152.
 */
package slash.matrix.decomposition;

import java.io.Serializable;
import narr.native.NArr;
import narr.package$;
import scala.Function1;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory;
import scala.runtime.BoxesRunTime;
import scala.scalajs.js.Array;
import scala.scalajs.js.typedarray.Float32Array;
import scala.scalajs.js.typedarray.Float64Array;
import scala.scalajs.js.typedarray.Int16Array;
import scala.scalajs.js.typedarray.Int32Array;
import scala.scalajs.js.typedarray.Int8Array;
import slash.matrix.Matrix;
import slash.matrix.Matrix$;
import slash.matrix.decomposition.LU$;

public class LU<M, N> {
    private final Matrix LU;
    private final Int32Array piv;
    private final double pivsign;
    private final Integer x$4;
    private final Integer x$5;
    private final int m;
    private final int n;
    private Matrix L$lzy1;
    private boolean Lbitmap$1;

    public static <M, N> LU<Object, Object> apply(Matrix<Object, Object> matrix, Integer n, Integer n2) {
        return LU$.MODULE$.apply(matrix, n, n2);
    }

    public LU(Matrix<Object, Object> LU2, Int32Array piv, double pivsign, Integer x$4, Integer x$5) {
        this.LU = LU2;
        this.piv = piv;
        this.pivsign = pivsign;
        this.x$4 = x$4;
        this.x$5 = x$5;
        Integer ev = x$4;
        this.m = BoxesRunTime.unboxToInt((Object)ev);
        Integer ev2 = x$5;
        this.n = BoxesRunTime.unboxToInt((Object)ev2);
    }

    public Matrix<M, N> LU() {
        return this.LU;
    }

    public int m() {
        return this.m;
    }

    public int n() {
        return this.n;
    }

    public boolean isSingular() {
        int j = 0;
        while (j < this.n()) {
            Matrix<M, N> matrix;
            Matrix<M, N> matrix2;
            Matrix<M, N> Matrix_this = matrix2 = this.LU();
            int r$proxy12 = j;
            int c$proxy12 = j++;
            Matrix<M, N> Matrix_this2 = matrix = Matrix_this;
            if (BoxesRunTime.unboxToDouble((Object)Matrix_this.values().apply(r$proxy12 * Matrix_this2.columns() + c$proxy12)) != 0.0) continue;
            return true;
        }
        return false;
    }

    public Matrix<M, N> L() {
        if (!this.Lbitmap$1) {
            Float64Array values = new Float64Array(this.m() * this.n());
            int i = 0;
            for (int r = 0; r < this.m(); ++r) {
                for (int c = 0; c < this.n(); ++c) {
                    Double d;
                    if (r > c) {
                        Matrix<M, N> matrix;
                        Matrix<M, N> matrix2;
                        Matrix<M, N> Matrix_this = matrix2 = this.LU();
                        int r$proxy13 = r;
                        int c$proxy13 = c;
                        Matrix<M, N> Matrix_this2 = matrix = Matrix_this;
                        d = BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)Matrix_this.values().apply(r$proxy13 * Matrix_this2.columns() + c$proxy13)));
                    } else {
                        d = r == c ? BoxesRunTime.boxToDouble((double)1.0) : BoxesRunTime.boxToDouble((double)0.0);
                    }
                    values.update(i, (Object)d);
                    ++i;
                }
            }
            this.L$lzy1 = Matrix$.MODULE$.apply(values, this.x$4, this.x$5);
            this.Lbitmap$1 = true;
        }
        return this.L$lzy1;
    }

    public Matrix<N, N> U() {
        Float64Array values = new Float64Array(this.n() * this.n());
        int i = 0;
        for (int r = 0; r < this.n(); ++r) {
            for (int c = 0; c < this.n(); ++c) {
                Double d;
                if (r > c) {
                    d = BoxesRunTime.boxToDouble((double)0.0);
                } else {
                    Matrix<M, N> matrix;
                    Matrix<M, N> matrix2;
                    Matrix<M, N> Matrix_this = matrix2 = this.LU();
                    int r$proxy14 = r;
                    int c$proxy14 = c;
                    Matrix<M, N> Matrix_this2 = matrix = Matrix_this;
                    d = BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)Matrix_this.values().apply(r$proxy14 * Matrix_this2.columns() + c$proxy14)));
                }
                values.update(i, (Object)d);
                ++i;
            }
        }
        return Matrix$.MODULE$.apply(values, this.x$5, this.x$5);
    }

    public Int32Array pivot() {
        Int8Array int8Array;
        ClassTag x$3$proxy3;
        Function1 & Serializable f$proxy2 = (Function1 & Serializable)i -> this.$anonfun$1(BoxesRunTime.unboxToInt((Object)i));
        ClassTag classTag = x$3$proxy3 = ClassTag$.MODULE$.apply(Integer.TYPE);
        ManifestFactory.ByteManifest byteManifest = ClassTag$.MODULE$.Byte();
        ClassTag classTag2 = classTag;
        if (!(byteManifest != null ? !byteManifest.equals(classTag2) : classTag2 != null)) {
            int8Array = new Int8Array(this.m());
        } else {
            ManifestFactory.ShortManifest shortManifest = ClassTag$.MODULE$.Short();
            ClassTag classTag3 = classTag;
            if (!(shortManifest != null ? !shortManifest.equals(classTag3) : classTag3 != null)) {
                int8Array = new Int16Array(this.m());
            } else {
                ManifestFactory.IntManifest intManifest = ClassTag$.MODULE$.Int();
                ClassTag classTag4 = classTag;
                if (!(intManifest != null ? !intManifest.equals(classTag4) : classTag4 != null)) {
                    int8Array = new Int32Array(this.m());
                } else {
                    ManifestFactory.FloatManifest floatManifest = ClassTag$.MODULE$.Float();
                    ClassTag classTag5 = classTag;
                    if (!(floatManifest != null ? !floatManifest.equals(classTag5) : classTag5 != null)) {
                        int8Array = new Float32Array(this.m());
                    } else {
                        ManifestFactory.DoubleManifest doubleManifest = ClassTag$.MODULE$.Double();
                        ClassTag classTag6 = classTag;
                        if (!(doubleManifest != null ? !doubleManifest.equals(classTag6) : classTag6 != null)) {
                            int8Array = new Float64Array(this.m());
                        } else {
                            int n$proxy3 = this.m();
                            int8Array = new Array(n$proxy3);
                        }
                    }
                }
            }
        }
        Int32Array out = (Int32Array)int8Array;
        for (int i2 = 0; i2 < this.m(); ++i2) {
            ((NArr)package$.MODULE$.nArray2NArr((Int8Array)out)).update(i2, f$proxy2.apply((Object)BoxesRunTime.boxToInteger((int)i2)));
        }
        return out;
    }

    public Float64Array doubleValuedPivot() {
        Int8Array int8Array;
        ClassTag x$3$proxy4;
        Function1 & Serializable f$proxy3 = (Function1 & Serializable)i -> this.$anonfun$2(BoxesRunTime.unboxToInt((Object)i));
        ClassTag classTag = x$3$proxy4 = ClassTag$.MODULE$.apply(Double.TYPE);
        ManifestFactory.ByteManifest byteManifest = ClassTag$.MODULE$.Byte();
        ClassTag classTag2 = classTag;
        if (!(byteManifest != null ? !byteManifest.equals(classTag2) : classTag2 != null)) {
            int8Array = new Int8Array(this.m());
        } else {
            ManifestFactory.ShortManifest shortManifest = ClassTag$.MODULE$.Short();
            ClassTag classTag3 = classTag;
            if (!(shortManifest != null ? !shortManifest.equals(classTag3) : classTag3 != null)) {
                int8Array = new Int16Array(this.m());
            } else {
                ManifestFactory.IntManifest intManifest = ClassTag$.MODULE$.Int();
                ClassTag classTag4 = classTag;
                if (!(intManifest != null ? !intManifest.equals(classTag4) : classTag4 != null)) {
                    int8Array = new Int32Array(this.m());
                } else {
                    ManifestFactory.FloatManifest floatManifest = ClassTag$.MODULE$.Float();
                    ClassTag classTag5 = classTag;
                    if (!(floatManifest != null ? !floatManifest.equals(classTag5) : classTag5 != null)) {
                        int8Array = new Float32Array(this.m());
                    } else {
                        ManifestFactory.DoubleManifest doubleManifest = ClassTag$.MODULE$.Double();
                        ClassTag classTag6 = classTag;
                        if (!(doubleManifest != null ? !doubleManifest.equals(classTag6) : classTag6 != null)) {
                            int8Array = new Float64Array(this.m());
                        } else {
                            int n$proxy4 = this.m();
                            int8Array = new Array(n$proxy4);
                        }
                    }
                }
            }
        }
        Float64Array out = (Float64Array)int8Array;
        for (int i2 = 0; i2 < this.m(); ++i2) {
            ((NArr)package$.MODULE$.nArray2NArr((Int8Array)out)).update(i2, f$proxy3.apply((Object)BoxesRunTime.boxToInteger((int)i2)));
        }
        return out;
    }

    public double determinant() {
        if (this.m() != this.n()) {
            throw new IllegalArgumentException("Matrix must be square.");
        }
        double d = this.pivsign;
        int j = 0;
        while (j < this.n()) {
            Matrix<M, N> matrix;
            Matrix<M, N> matrix2;
            Matrix<M, N> Matrix_this = matrix2 = this.LU();
            int r$proxy15 = j;
            int c$proxy15 = j++;
            Matrix<M, N> Matrix_this2 = matrix = Matrix_this;
            d *= BoxesRunTime.unboxToDouble((Object)Matrix_this.values().apply(r$proxy15 * Matrix_this2.columns() + c$proxy15));
        }
        return d;
    }

    public <V> Matrix<N, Object> solve(Matrix<M, Object> B, Integer x$2) {
        int k;
        if (this.isSingular()) {
            throw new RuntimeException("Matrix is singular.");
        }
        int nx = B.columns();
        Matrix<Object, Object> X = B.subMatrix(this.piv, 0, this.x$5, x$2);
        for (k = 0; k < this.n(); ++k) {
            for (int i = k + 1; i < this.n(); ++i) {
                int j = 0;
                while (j < nx) {
                    Matrix<Object, Object> matrix;
                    Matrix<M, N> matrix2;
                    Matrix<M, N> matrix3;
                    Matrix<Object, Object> matrix4;
                    Matrix<Object, Object> matrix5;
                    Matrix<Object, Object> matrix6;
                    Matrix<Object, Object> matrix7;
                    Matrix<Object, Object> matrix8;
                    Matrix<Object, Object> Matrix_this = matrix8 = X;
                    int r$proxy19 = i;
                    int c$proxy19 = j;
                    Matrix<Object, Object> Matrix_this2 = matrix7 = X;
                    int r$proxy16 = i;
                    int c$proxy16 = j;
                    Matrix<Object, Object> Matrix_this3 = matrix6 = Matrix_this2;
                    Matrix<Object, Object> Matrix_this4 = matrix5 = X;
                    int r$proxy17 = k;
                    int c$proxy17 = j++;
                    Matrix<Object, Object> Matrix_this5 = matrix4 = Matrix_this4;
                    Matrix<M, N> Matrix_this6 = matrix3 = this.LU();
                    int r$proxy18 = i;
                    int c$proxy18 = k;
                    Matrix<M, N> Matrix_this7 = matrix2 = Matrix_this6;
                    double value$proxy4 = BoxesRunTime.unboxToDouble((Object)Matrix_this2.values().apply(r$proxy16 * Matrix_this3.columns() + c$proxy16)) - BoxesRunTime.unboxToDouble((Object)Matrix_this4.values().apply(r$proxy17 * Matrix_this5.columns() + c$proxy17)) * BoxesRunTime.unboxToDouble((Object)Matrix_this6.values().apply(r$proxy18 * Matrix_this7.columns() + c$proxy18));
                    Matrix<Object, Object> Matrix_this8 = matrix = Matrix_this;
                    Matrix_this.values().update(r$proxy19 * Matrix_this8.columns() + c$proxy19, (Object)BoxesRunTime.boxToDouble((double)value$proxy4));
                }
            }
        }
        for (k = this.n() - 1; k > -1; --k) {
            int j = 0;
            while (j < nx) {
                Matrix<Object, Object> matrix;
                Matrix<M, N> matrix9;
                Matrix<M, N> matrix10;
                Matrix<Object, Object> matrix11;
                Matrix<Object, Object> matrix12;
                Matrix<Object, Object> matrix13;
                Matrix<Object, Object> Matrix_this = matrix13 = X;
                int r$proxy22 = k;
                int c$proxy22 = j;
                Matrix<Object, Object> Matrix_this9 = matrix12 = X;
                int r$proxy20 = k;
                int c$proxy20 = j++;
                Matrix<Object, Object> Matrix_this10 = matrix11 = Matrix_this9;
                Matrix<M, N> Matrix_this11 = matrix10 = this.LU();
                int r$proxy21 = k;
                int c$proxy21 = k;
                Matrix<M, N> Matrix_this12 = matrix9 = Matrix_this11;
                double value$proxy5 = BoxesRunTime.unboxToDouble((Object)Matrix_this9.values().apply(r$proxy20 * Matrix_this10.columns() + c$proxy20)) / BoxesRunTime.unboxToDouble((Object)Matrix_this11.values().apply(r$proxy21 * Matrix_this12.columns() + c$proxy21));
                Matrix<Object, Object> Matrix_this13 = matrix = Matrix_this;
                Matrix_this.values().update(r$proxy22 * Matrix_this13.columns() + c$proxy22, (Object)BoxesRunTime.boxToDouble((double)value$proxy5));
            }
            for (int i = 0; i < k; ++i) {
                int j1 = 0;
                while (j1 < nx) {
                    Matrix<Object, Object> matrix;
                    Matrix<M, N> matrix14;
                    Matrix<M, N> matrix15;
                    Matrix<Object, Object> matrix16;
                    Matrix<Object, Object> matrix17;
                    Matrix<Object, Object> matrix18;
                    Matrix<Object, Object> matrix19;
                    Matrix<Object, Object> matrix20;
                    Matrix<Object, Object> Matrix_this = matrix20 = X;
                    int r$proxy26 = i;
                    int c$proxy26 = j1;
                    Matrix<Object, Object> Matrix_this14 = matrix19 = X;
                    int r$proxy23 = i;
                    int c$proxy23 = j1;
                    Matrix<Object, Object> Matrix_this15 = matrix18 = Matrix_this14;
                    Matrix<Object, Object> Matrix_this16 = matrix17 = X;
                    int r$proxy24 = k;
                    int c$proxy24 = j1++;
                    Matrix<Object, Object> Matrix_this17 = matrix16 = Matrix_this16;
                    Matrix<M, N> Matrix_this18 = matrix15 = this.LU();
                    int r$proxy25 = i;
                    int c$proxy25 = k;
                    Matrix<M, N> Matrix_this19 = matrix14 = Matrix_this18;
                    double value$proxy6 = BoxesRunTime.unboxToDouble((Object)Matrix_this14.values().apply(r$proxy23 * Matrix_this15.columns() + c$proxy23)) - BoxesRunTime.unboxToDouble((Object)Matrix_this16.values().apply(r$proxy24 * Matrix_this17.columns() + c$proxy24)) * BoxesRunTime.unboxToDouble((Object)Matrix_this18.values().apply(r$proxy25 * Matrix_this19.columns() + c$proxy25));
                    Matrix<Object, Object> Matrix_this20 = matrix = Matrix_this;
                    Matrix_this.values().update(r$proxy26 * Matrix_this20.columns() + c$proxy26, (Object)BoxesRunTime.boxToDouble((double)value$proxy6));
                }
            }
        }
        return X;
    }

    private final /* synthetic */ int $anonfun$1(int i) {
        return BoxesRunTime.unboxToInt((Object)this.piv.apply(i));
    }

    private final /* synthetic */ double $anonfun$2(int i) {
        return BoxesRunTime.unboxToInt((Object)this.piv.apply(i));
    }
}

