/*
 * Decompiled with CFR 0.152.
 */
package slash.stats.kernel;

import java.io.Serializable;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.scalajs.js.typedarray.Float64Array;
import slash.stats.kernel.DiscreteKernel;
import slash.stats.kernel.EpanechnikovKernel$;
import slash.stats.kernel.Kernel;
import slash.vector.package$;

public class EpanechnikovKernel<N>
implements Kernel<N>,
Product,
Serializable {
    private double exclusionRadiusSquared$lzy2;
    private boolean exclusionRadiusSquaredbitmap$2;
    private DiscreteKernel discretize$lzy2;
    private boolean discretizebitmap$2;
    private final double exclusionRadius;

    public static <N> EpanechnikovKernel<Object> apply(double d) {
        return EpanechnikovKernel$.MODULE$.apply(d);
    }

    public static EpanechnikovKernel<?> fromProduct(Product product) {
        return EpanechnikovKernel$.MODULE$.fromProduct(product);
    }

    public static <N> EpanechnikovKernel<Object> unapply(EpanechnikovKernel<Object> epanechnikovKernel) {
        return EpanechnikovKernel$.MODULE$.unapply(epanechnikovKernel);
    }

    public EpanechnikovKernel(double exclusionRadius) {
        this.exclusionRadius = exclusionRadius;
        Kernel.$init$(this);
    }

    @Override
    public double exclusionRadiusSquared() {
        if (!this.exclusionRadiusSquaredbitmap$2) {
            this.exclusionRadiusSquared$lzy2 = Kernel.exclusionRadiusSquared$(this);
            this.exclusionRadiusSquaredbitmap$2 = true;
        }
        return this.exclusionRadiusSquared$lzy2;
    }

    @Override
    public DiscreteKernel discretize() {
        if (!this.discretizebitmap$2) {
            this.discretize$lzy2 = Kernel.discretize$(this);
            this.discretizebitmap$2 = true;
        }
        return this.discretize$lzy2;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.exclusionRadius()));
        return Statics.finalizeHash((int)n, (int)1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof EpanechnikovKernel)) return false;
        EpanechnikovKernel epanechnikovKernel = (EpanechnikovKernel)object;
        if (this.exclusionRadius() != epanechnikovKernel.exclusionRadius()) return false;
        if (!epanechnikovKernel.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof EpanechnikovKernel;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "EpanechnikovKernel";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 != n2) {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return BoxesRunTime.boxToDouble((double)this._1());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "exclusionRadius";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    @Override
    public double exclusionRadius() {
        return this.exclusionRadius;
    }

    @Override
    public double weight(Float64Array v) {
        return this.weight(package$.MODULE$.normSquared(v));
    }

    @Override
    public double weight(double magnitudeSquared) {
        if (magnitudeSquared > this.exclusionRadiusSquared()) {
            return 0.0;
        }
        return 0.75 - 0.75 * (magnitudeSquared / this.exclusionRadiusSquared());
    }

    public <N> EpanechnikovKernel<Object> copy(double exclusionRadius) {
        return new EpanechnikovKernel<Object>(exclusionRadius);
    }

    public double copy$default$1() {
        return this.exclusionRadius();
    }

    public double _1() {
        return this.exclusionRadius();
    }
}

