/*
 * Decompiled with CFR 0.152.
 */
package ai.dragonfly.math.stats;

import ai.dragonfly.math.Random$;
import ai.dragonfly.math.stats.UnivariateGenerativeModel$;
import ai.dragonfly.math.stats.UnivariateHistogram;
import ai.dragonfly.math.stats.probability.distributions.Sampleable;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.TreeMap;
import scala.runtime.BoxesRunTime;
import scala.util.Random;

public class UnivariateGenerativeModel<T>
implements Sampleable<T> {
    private final UnivariateHistogram hist;
    private final TreeMap cumulative;

    public static <T> UnivariateGenerativeModel<T> apply(UnivariateHistogram<T> univariateHistogram) {
        return UnivariateGenerativeModel$.MODULE$.apply(univariateHistogram);
    }

    public UnivariateGenerativeModel(UnivariateHistogram<T> hist, TreeMap<Object, Object> cumulative) {
        this.hist = hist;
        this.cumulative = cumulative;
    }

    private UnivariateHistogram<T> hist() {
        return this.hist;
    }

    private TreeMap<Object, Object> cumulative() {
        return this.cumulative;
    }

    @Override
    public T random(Random r) {
        double pX = r.nextDouble() * this.hist().mass();
        Tuple2 tuple2 = ((TreeMap)this.cumulative().rangeTo((Object)BoxesRunTime.boxToDouble((double)pX))).last();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double top = BoxesRunTime.unboxToDouble((Object)tuple2._1());
        int bINdex = BoxesRunTime.unboxToInt((Object)tuple2._2());
        Tuple2.mcDI.sp sp2 = new Tuple2.mcDI.sp(top, bINdex);
        double top2 = sp2._1$mcD$sp();
        int bINdex2 = sp2._2$mcI$sp();
        return this.hist().bINTerpolator(bINdex2, 1.0 - (top2 - pX) / this.hist().binMass(bINdex2));
    }

    @Override
    public Random random$default$1() {
        return Random$.MODULE$.defaultRandom();
    }

    public T min() {
        return this.hist().min();
    }

    public T MAX() {
        return this.hist().MAX();
    }

    public double p(T x) {
        return this.hist().binMass(this.hist().index(x)) / this.hist().mass();
    }

    public T \u03bc() {
        double halfMass = this.hist().mass() / 2.0;
        Tuple2 tuple2 = ((TreeMap)this.cumulative().rangeTo((Object)BoxesRunTime.boxToDouble((double)halfMass))).last();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double top = BoxesRunTime.unboxToDouble((Object)tuple2._1());
        int bINdex = BoxesRunTime.unboxToInt((Object)tuple2._2());
        Tuple2.mcDI.sp sp2 = new Tuple2.mcDI.sp(top, bINdex);
        double top2 = sp2._1$mcD$sp();
        int bINdex2 = sp2._2$mcI$sp();
        return this.hist().bINTerpolator(bINdex2, 1.0 - (top2 - halfMass) / this.hist().binMass(bINdex2));
    }

    public String toString() {
        return this.cumulative().toString();
    }
}

