/*
 * Decompiled with CFR 0.152.
 */
package ai.dragonfly.math.interval;

import ai.dragonfly.math.Random$;
import ai.dragonfly.math.interval.Domain$;
import ai.dragonfly.math.interval.Interval;
import java.io.Serializable;
import scala.MatchError;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.math.Numeric;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Random;

public final class Interval$
implements Serializable {
    private static final int OPEN;
    private static final int RIGHT_CLOSED;
    private static final int LEFT_CLOSED;
    private static final int CLOSED;
    public static final Interval$ MODULE$;

    private Interval$() {
    }

    static {
        MODULE$ = new Interval$();
        OPEN = 0;
        RIGHT_CLOSED = 1;
        LEFT_CLOSED = 2;
        CLOSED = MODULE$.RIGHT_CLOSED() | MODULE$.LEFT_CLOSED();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Interval$.class);
    }

    public <DOMAIN> Interval<DOMAIN> apply(int code, DOMAIN min, DOMAIN MAX, Numeric<DOMAIN> $hash) {
        return new Interval<DOMAIN>(code, min, MAX, $hash);
    }

    public <DOMAIN> Interval<DOMAIN> unapply(Interval<DOMAIN> x$1) {
        return x$1;
    }

    public String toString() {
        return "Interval";
    }

    public <N> N randomFrom(Interval<N> ntrvl, Random r) {
        N n = ntrvl.min();
        if (n instanceof Double) {
            double i = BoxesRunTime.unboxToDouble(n);
            Interval<N> i$proxy1 = ntrvl;
            return (N)BoxesRunTime.boxToDouble((double)r.between(BoxesRunTime.unboxToDouble(i$proxy1.min()), BoxesRunTime.unboxToDouble(i$proxy1.MAX())));
        }
        if (n instanceof Long) {
            long i = BoxesRunTime.unboxToLong(n);
            Interval<N> i$proxy2 = ntrvl;
            return (N)BoxesRunTime.boxToLong((long)r.between(BoxesRunTime.unboxToLong(i$proxy2.min()), BoxesRunTime.unboxToLong(i$proxy2.MAX())));
        }
        if (n instanceof Float) {
            float i = BoxesRunTime.unboxToFloat(n);
            Interval<N> i$proxy3 = ntrvl;
            return (N)BoxesRunTime.boxToFloat((float)r.between(BoxesRunTime.unboxToFloat(i$proxy3.min()), BoxesRunTime.unboxToFloat(i$proxy3.MAX())));
        }
        if (n instanceof Integer) {
            int i = BoxesRunTime.unboxToInt(n);
            Interval<N> i$proxy4 = ntrvl;
            return (N)BoxesRunTime.boxToInteger((int)r.between(BoxesRunTime.unboxToInt(i$proxy4.min()), BoxesRunTime.unboxToInt(i$proxy4.MAX())));
        }
        if (n instanceof BigDecimal) {
            BigDecimal i = (BigDecimal)n;
            Interval<N> i$proxy5 = ntrvl;
            return (N)Random$.MODULE$.between(r, (BigDecimal)i$proxy5.min(), (BigDecimal)i$proxy5.MAX());
        }
        if (n instanceof BigInt) {
            BigInt i = (BigInt)n;
            Interval<N> i$proxy6 = ntrvl;
            return (N)Random$.MODULE$.between(r, (BigInt)i$proxy6.min(), (BigInt)i$proxy6.MAX());
        }
        throw new MatchError(n);
    }

    public <N> Random randomFrom$default$2(Interval<N> ntrvl) {
        return Random$.MODULE$.defaultRandom();
    }

    public <N> boolean rangeContains(Interval<N> ntrvl, double x) {
        N n = ntrvl.min();
        if (n instanceof Double) {
            double d = BoxesRunTime.unboxToDouble(n);
            return ntrvl.contains(BoxesRunTime.boxToDouble((double)x));
        }
        if (n instanceof Long) {
            long l = BoxesRunTime.unboxToLong(n);
            Interval<N> i = ntrvl;
            return this.apply(i.code(), (Object)package$.MODULE$.BigDecimal().apply(BoxesRunTime.unboxToLong(i.min())), (Object)package$.MODULE$.BigDecimal().apply(BoxesRunTime.unboxToLong(i.MAX())), (Numeric)Numeric.BigDecimalIsFractional$.MODULE$).contains(package$.MODULE$.BigDecimal().apply(x));
        }
        if (n instanceof Float) {
            float f = BoxesRunTime.unboxToFloat(n);
            Interval<N> i = ntrvl;
            return this.apply(ntrvl.code(), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToFloat(i.min())), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToFloat(i.MAX())), (Numeric)Numeric.DoubleIsFractional$.MODULE$).contains(BoxesRunTime.boxToDouble((double)x));
        }
        if (n instanceof Integer) {
            int i = BoxesRunTime.unboxToInt(n);
            Interval<N> i2 = ntrvl;
            return this.apply(ntrvl.code(), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToInt(i2.min())), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToInt(i2.MAX())), (Numeric)Numeric.DoubleIsFractional$.MODULE$).contains(BoxesRunTime.boxToDouble((double)x));
        }
        if (n instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)n;
            return ntrvl.contains(package$.MODULE$.BigDecimal().apply(x));
        }
        if (n instanceof BigInt) {
            BigInt bi = (BigInt)n;
            Interval<N> i = ntrvl;
            return this.apply(ntrvl.code(), (Object)package$.MODULE$.BigDecimal().apply((BigInt)i.min()), (Object)package$.MODULE$.BigDecimal().apply((BigInt)i.MAX()), (Numeric)Numeric.BigDecimalIsFractional$.MODULE$).contains(package$.MODULE$.BigDecimal().apply(x));
        }
        throw new MatchError(n);
    }

    public <N> boolean setContains(Interval<N> ntrvl, double x) {
        N n = ntrvl.min();
        if (n instanceof Double) {
            double d = BoxesRunTime.unboxToDouble(n);
            return ntrvl.contains(BoxesRunTime.boxToDouble((double)x));
        }
        if (n instanceof Integer) {
            int i = BoxesRunTime.unboxToInt(n);
            return Domain$.MODULE$.precisionLossSquared(x, BoxesRunTime.boxToInteger((int)0)) == 0.0 && ntrvl.contains(BoxesRunTime.boxToInteger((int)((int)x)));
        }
        if (n instanceof Long) {
            long l = BoxesRunTime.unboxToLong(n);
            return Domain$.MODULE$.precisionLossSquared(x, BoxesRunTime.boxToLong((long)0L)) == 0.0 && ntrvl.contains(BoxesRunTime.boxToLong((long)((long)x)));
        }
        if (n instanceof Float) {
            float f = BoxesRunTime.unboxToFloat(n);
            return Domain$.MODULE$.precisionLossSquared(x, BoxesRunTime.boxToFloat((float)0.0f)) == 0.0 && ntrvl.contains(BoxesRunTime.boxToFloat((float)((float)x)));
        }
        if (n instanceof BigInt) {
            BigInt bi = (BigInt)n;
            return Domain$.MODULE$.precisionLossSquared(x, package$.MODULE$.BigInt().apply(0L)) == 0.0 && ntrvl.contains(package$.MODULE$.BigDecimal().apply(x).toBigInt());
        }
        if (n instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)n;
            return ntrvl.contains(package$.MODULE$.BigDecimal().apply(x));
        }
        throw new MatchError(n);
    }

    public <N> String typeName(N n) {
        N n2 = n;
        if (n2 instanceof Integer) {
            int i = BoxesRunTime.unboxToInt(n2);
            return "Int";
        }
        if (n2 instanceof Long) {
            long l = BoxesRunTime.unboxToLong(n2);
            return "Long";
        }
        if (n2 instanceof BigInt) {
            BigInt bi = (BigInt)n2;
            return "BigInt";
        }
        if (n2 instanceof Float) {
            float f = BoxesRunTime.unboxToFloat(n2);
            return "Float";
        }
        if (n2 instanceof Double) {
            double d = BoxesRunTime.unboxToDouble(n2);
            return "Double";
        }
        if (n2 instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)n2;
            return "BigDecimal";
        }
        throw new MatchError(n2);
    }

    public int OPEN() {
        return OPEN;
    }

    public int RIGHT_CLOSED() {
        return RIGHT_CLOSED;
    }

    public int LEFT_CLOSED() {
        return LEFT_CLOSED;
    }

    public int CLOSED() {
        return CLOSED;
    }

    public <DOMAIN> Interval<DOMAIN> $u005B$u005D(DOMAIN min, DOMAIN MAX, Numeric<DOMAIN> $hash) {
        return new Interval<DOMAIN>(this.CLOSED(), min, MAX, $hash);
    }

    public <DOMAIN> Interval<DOMAIN> $u0028$u005D(DOMAIN min, DOMAIN MAX, Numeric<DOMAIN> $hash) {
        return new Interval<DOMAIN>(this.RIGHT_CLOSED(), min, MAX, $hash);
    }

    public <DOMAIN> Interval<DOMAIN> $u005B$u0029(DOMAIN min, DOMAIN MAX, Numeric<DOMAIN> $hash) {
        return new Interval<DOMAIN>(this.LEFT_CLOSED(), min, MAX, $hash);
    }

    public <DOMAIN> Interval<DOMAIN> $u0028$u0029(DOMAIN min, DOMAIN MAX, Numeric<DOMAIN> $hash) {
        return new Interval<DOMAIN>(this.OPEN(), min, MAX, $hash);
    }
}

