/*
 * Decompiled with CFR 0.152.
 */
package ai.dstack.server.local.services;

import ai.dstack.server.model.User;
import ai.dstack.server.services.AppConfig;
import ai.dstack.server.services.FileService;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.input.BoundedInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\nH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\nH\u0016J\u0018\u0010\u0014\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0013H\u0016J\u0018\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lai/dstack/server/local/services/LocalFileService;", "Lai/dstack/server/services/FileService;", "config", "Lai/dstack/server/services/AppConfig;", "(Lai/dstack/server/services/AppConfig;)V", "getConfig", "()Lai/dstack/server/services/AppConfig;", "delete", "", "prefix", "", "download", "Ljava/net/URI;", "path", "user", "Lai/dstack/server/model/User;", "filename", "type", "get", "", "preview", "length", "", "save", "data", "upload", "server-base-local"})
public final class LocalFileService
implements FileService {
    @NotNull
    private final AppConfig config;

    @NotNull
    public URI upload(@NotNull String path, @NotNull User user) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        URI uRI = URI.create(this.config.getAddress() + "/api/files/" + path + "?user=" + user.getName() + "&code=" + user.getVerificationCode());
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"URI.create(\"${config.add\u2026{user.verificationCode}\")");
        return uRI;
    }

    public void save(@NotNull String path, @NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        File file = new File(this.config.getFileDirectory() + '/' + path);
        file.getParentFile().mkdirs();
        FilesKt.writeBytes((File)file, (byte[])data);
    }

    @NotNull
    public byte[] get(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return FilesKt.readBytes((File)new File(this.config.getFileDirectory() + '/' + path));
    }

    public void delete(@NotNull String prefix) {
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        FilesKt.deleteRecursively((File)new File(this.config.getFileDirectory() + '/' + prefix));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public byte[] preview(@NotNull String path, long length) {
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Object object = new File(this.config.getFileDirectory() + '/' + path);
        boolean bl = false;
        FileInputStream fileInputStream = new FileInputStream((File)object);
        long l = length;
        InputStream inputStream = fileInputStream;
        object = (Closeable)new BoundedInputStream(inputStream, l);
        bl = false;
        Throwable throwable = null;
        try {
            BoundedInputStream it = (BoundedInputStream)object;
            boolean bl2 = false;
            byArray = ByteStreamsKt.readBytes((InputStream)((InputStream)it));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return byArray;
    }

    @NotNull
    public URI download(@NotNull String path, @NotNull User user, @NotNull String filename, @NotNull String type) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        URI uRI = URI.create(this.config.getAddress() + "/api/files/" + path + "?user=" + user.getName() + "&code=" + user.getVerificationCode() + "&filename=" + filename + "&type=" + URLEncoder.encode(this.patchContentType(type), StandardCharsets.UTF_8.toString()));
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"URI.create(\n            \u2026            )}\"\n        )");
        return uRI;
    }

    @NotNull
    public final AppConfig getConfig() {
        return this.config;
    }

    public LocalFileService(@Autowired @NotNull AppConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.config = config;
        new File(this.config.getFileDirectory()).mkdirs();
    }

    @Nullable
    public String patchContentType(@Nullable String type) {
        return FileService.DefaultImpls.patchContentType((FileService)this, (String)type);
    }
}

