/*
 * Decompiled with CFR 0.152.
 */
package ai.dstack.server.local.sqlite.services;

import ai.dstack.server.local.sqlite.OptionalToNullableKt;
import ai.dstack.server.local.sqlite.model.DashboardId;
import ai.dstack.server.local.sqlite.model.DashboardItem;
import ai.dstack.server.local.sqlite.repositories.DashboardRepository;
import ai.dstack.server.model.Dashboard;
import ai.dstack.server.services.DashboardService;
import ai.dstack.server.services.EntityAlreadyExists;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0016J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\f\u0010\u0016\u001a\u00020\u0007*\u00020\u0017H\u0002J\f\u0010\u0018\u001a\u00020\u0017*\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lai/dstack/server/local/sqlite/services/SQLiteDashboardService;", "Lai/dstack/server/services/DashboardService;", "repository", "Lai/dstack/server/local/sqlite/repositories/DashboardRepository;", "(Lai/dstack/server/local/sqlite/repositories/DashboardRepository;)V", "mapId", "Lai/dstack/server/local/sqlite/model/DashboardId;", "Lai/dstack/server/model/Dashboard;", "getMapId", "(Lai/dstack/server/model/Dashboard;)Lai/dstack/server/local/sqlite/model/DashboardId;", "create", "", "dashboard", "delete", "findByUserName", "", "userName", "", "get", "id", "user", "update", "toDashboard", "Lai/dstack/server/local/sqlite/model/DashboardItem;", "toDashboardItem", "server-base-local"})
public final class SQLiteDashboardService
implements DashboardService {
    private final DashboardRepository repository;

    public void create(@NotNull Dashboard dashboard) {
        Intrinsics.checkParameterIsNotNull((Object)dashboard, (String)"dashboard");
        if (this.repository.existsById(this.getMapId(dashboard))) {
            throw (Throwable)new EntityAlreadyExists(null, 1, null);
        }
        this.repository.save(this.toDashboardItem(dashboard));
    }

    @Nullable
    public Dashboard get(@NotNull String userName, @NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)userName, (String)"userName");
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Optional optional = this.repository.findById(this.mapId(userName, id));
        Intrinsics.checkExpressionValueIsNotNull((Object)optional, (String)"repository.findById(mapId(userName, id))");
        DashboardItem dashboardItem = (DashboardItem)OptionalToNullableKt.toNullable(optional);
        return dashboardItem != null ? this.toDashboard(dashboardItem) : null;
    }

    public void update(@NotNull Dashboard dashboard) {
        Intrinsics.checkParameterIsNotNull((Object)dashboard, (String)"dashboard");
        this.repository.save(this.toDashboardItem(dashboard));
    }

    public void delete(@NotNull Dashboard dashboard) {
        Intrinsics.checkParameterIsNotNull((Object)dashboard, (String)"dashboard");
        this.repository.delete(this.toDashboardItem(dashboard));
    }

    @NotNull
    public List<Dashboard> findByUserName(@NotNull String userName) {
        Intrinsics.checkParameterIsNotNull((Object)userName, (String)"userName");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence(this.repository.findAllByUser(userName)), (Function1)((Function1)new Function1<DashboardItem, Dashboard>(this){
            final /* synthetic */ SQLiteDashboardService this$0;

            @NotNull
            public final Dashboard invoke(@NotNull DashboardItem it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return SQLiteDashboardService.access$toDashboard(this.this$0, it);
            }
            {
                this.this$0 = sQLiteDashboardService;
                super(1);
            }
        })));
    }

    private final DashboardId getMapId(@NotNull Dashboard $this$mapId) {
        return this.mapId($this$mapId.getUserName(), $this$mapId.getId());
    }

    private final DashboardId mapId(String user, String id) {
        return new DashboardId(user, id);
    }

    private final Dashboard toDashboard(@NotNull DashboardItem $this$toDashboard) {
        DashboardItem dashboardItem = $this$toDashboard;
        boolean bl = false;
        boolean bl2 = false;
        DashboardItem d = dashboardItem;
        boolean bl3 = false;
        return new Dashboard(d.getUser(), d.getId(), d.getTitle(), d.getDescription(), d.getTimestamp(), d.getPrivate());
    }

    private final DashboardItem toDashboardItem(@NotNull Dashboard $this$toDashboardItem) {
        Dashboard dashboard = $this$toDashboardItem;
        boolean bl = false;
        boolean bl2 = false;
        Dashboard d = dashboard;
        boolean bl3 = false;
        CharSequence charSequence = d.getTitle();
        long l = d.getTimestampMillis();
        boolean bl4 = d.getPrivate();
        String string = d.getId();
        String string2 = d.getUserName();
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = charSequence == null || StringsKt.isBlank((CharSequence)charSequence);
        charSequence = d.getDescription();
        String string3 = bl7 ? null : d.getTitle();
        bl5 = false;
        bl6 = false;
        boolean bl8 = charSequence == null || StringsKt.isBlank((CharSequence)charSequence);
        String string4 = bl8 ? null : d.getDescription();
        String string5 = string3;
        long l2 = l;
        boolean bl9 = bl4;
        String string6 = string;
        String string7 = string2;
        return new DashboardItem(string7, string6, bl9, l2, string5, string4);
    }

    public SQLiteDashboardService(@NotNull DashboardRepository repository) {
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        this.repository = repository;
    }

    public static final /* synthetic */ Dashboard access$toDashboard(SQLiteDashboardService $this, DashboardItem $this$access_u24toDashboard) {
        return $this.toDashboard($this$access_u24toDashboard);
    }
}

