/*
 * Decompiled with CFR 0.152.
 */
package ai.dstack.server.local.sqlite.services;

import ai.dstack.server.local.sqlite.OptionalToNullableKt;
import ai.dstack.server.local.sqlite.model.JobId;
import ai.dstack.server.local.sqlite.model.JobItem;
import ai.dstack.server.local.sqlite.repositories.JobRepository;
import ai.dstack.server.model.Job;
import ai.dstack.server.model.JobSchedule;
import ai.dstack.server.model.JobStatus;
import ai.dstack.server.services.EntityAlreadyExists;
import ai.dstack.server.services.JobService;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0011H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u00172\u0006\u0010\u0018\u001a\u00020\u0011H\u0016J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0011H\u0002J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\f\u0010\u001b\u001a\u00020\u0007*\u00020\u001cH\u0002J\f\u0010\u001d\u001a\u00020\u001c*\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001e"}, d2={"Lai/dstack/server/local/sqlite/services/SQLiteJobService;", "Lai/dstack/server/services/JobService;", "repository", "Lai/dstack/server/local/sqlite/repositories/JobRepository;", "(Lai/dstack/server/local/sqlite/repositories/JobRepository;)V", "mapId", "Lai/dstack/server/local/sqlite/model/JobId;", "Lai/dstack/server/model/Job;", "getMapId", "(Lai/dstack/server/model/Job;)Lai/dstack/server/local/sqlite/model/JobId;", "create", "", "job", "delete", "findByUser", "Lkotlin/sequences/Sequence;", "user", "", "consistent", "", "get", "id", "getJobsBySchedule", "", "schedule", "name", "update", "toJob", "Lai/dstack/server/local/sqlite/model/JobItem;", "toJobItem", "server-base-local"})
public final class SQLiteJobService
implements JobService {
    private final JobRepository repository;

    @Nullable
    public Job get(@NotNull String user, @NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Optional optional = this.repository.findById(this.mapId(user, id));
        Intrinsics.checkExpressionValueIsNotNull((Object)optional, (String)"repository.findById(mapId(user, id))");
        JobItem jobItem = (JobItem)OptionalToNullableKt.toNullable(optional);
        return jobItem != null ? this.toJob(jobItem) : null;
    }

    @NotNull
    public Sequence<Job> findByUser(@NotNull String user, boolean consistent) {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        return SequencesKt.map((Sequence)CollectionsKt.asSequence(this.repository.findAllByUser(user)), (Function1)((Function1)new Function1<JobItem, Job>(this){
            final /* synthetic */ SQLiteJobService this$0;

            @NotNull
            public final Job invoke(@NotNull JobItem it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return SQLiteJobService.access$toJob(this.this$0, it);
            }
            {
                this.this$0 = sQLiteJobService;
                super(1);
            }
        }));
    }

    public void create(@NotNull Job job) {
        Intrinsics.checkParameterIsNotNull((Object)job, (String)"job");
        if (this.repository.existsById(this.getMapId(job))) {
            throw (Throwable)new EntityAlreadyExists(null, 1, null);
        }
        this.repository.save(this.toJobItem(job));
    }

    public void delete(@NotNull Job job) {
        Intrinsics.checkParameterIsNotNull((Object)job, (String)"job");
        this.repository.deleteById(this.getMapId(job));
    }

    public void update(@NotNull Job job) {
        Intrinsics.checkParameterIsNotNull((Object)job, (String)"job");
        this.repository.save(this.toJobItem(job));
    }

    @NotNull
    public List<Job> getJobsBySchedule(@NotNull String schedule) {
        Intrinsics.checkParameterIsNotNull((Object)schedule, (String)"schedule");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence(this.repository.findAllBySchedule(schedule)), (Function1)((Function1)new Function1<JobItem, Job>(this){
            final /* synthetic */ SQLiteJobService this$0;

            @NotNull
            public final Job invoke(@NotNull JobItem it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return SQLiteJobService.access$toJob(this.this$0, it);
            }
            {
                this.this$0 = sQLiteJobService;
                super(1);
            }
        })));
    }

    private final JobId getMapId(@NotNull Job $this$mapId) {
        return this.mapId($this$mapId.getUserName(), $this$mapId.getId());
    }

    private final JobId mapId(String user, String name) {
        return new JobId(user, name);
    }

    private final Job toJob(@NotNull JobItem $this$toJob) {
        JobItem jobItem = $this$toJob;
        boolean bl = false;
        boolean bl2 = false;
        JobItem j = jobItem;
        boolean bl3 = false;
        String string = j.getTitle();
        String string2 = j.getId();
        String string3 = j.getUser();
        boolean bl4 = false;
        String string4 = string;
        if (string4 == null) {
            string4 = "";
        }
        String string5 = string4;
        string = j.getCode();
        String string6 = j.getRuntime();
        bl4 = false;
        String string7 = string;
        if (string7 == null) {
            string7 = "";
        }
        String string8 = string7;
        Long l = j.getEstimatedDuration();
        Long l2 = j.getFinished();
        Long l3 = j.getStarted();
        String string9 = j.getLogs();
        JobStatus jobStatus = JobStatus.Companion.fromCode(j.getStatus());
        JobSchedule jobSchedule = JobSchedule.Companion.fromCode(j.getSchedule());
        String string10 = string8;
        String string11 = string6;
        String string12 = string5;
        String string13 = string2;
        String string14 = string3;
        return new Job(string14, string13, string12, string11, string10, jobSchedule, jobStatus, string9, l3, l2, l);
    }

    private final JobItem toJobItem(@NotNull Job $this$toJobItem) {
        Job job = $this$toJobItem;
        boolean bl = false;
        boolean bl2 = false;
        Job s = job;
        boolean bl3 = false;
        CharSequence charSequence = s.getTitle();
        String string = s.getId();
        String string2 = s.getUserName();
        boolean bl4 = false;
        boolean bl5 = !StringsKt.isBlank((CharSequence)charSequence);
        charSequence = s.getCode();
        String string3 = s.getRuntime();
        String string4 = bl5 ? s.getTitle() : null;
        bl4 = false;
        boolean bl6 = !StringsKt.isBlank((CharSequence)charSequence);
        Long l = s.getEstimatedDurationMillis();
        Long l2 = s.getFinishedAtMillis();
        Long l3 = s.getStartedAtMillis();
        String string5 = s.getLogs();
        String string6 = s.getStatus().getCode();
        String string7 = s.getSchedule().getCode();
        String string8 = bl6 ? s.getCode() : null;
        String string9 = string3;
        String string10 = string4;
        String string11 = string;
        String string12 = string2;
        return new JobItem(string12, string11, string10, string9, string8, string7, string6, string5, l3, l2, l);
    }

    public SQLiteJobService(@NotNull JobRepository repository) {
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        this.repository = repository;
    }

    public static final /* synthetic */ Job access$toJob(SQLiteJobService $this, JobItem $this$access_u24toJob) {
        return $this.toJob($this$access_u24toJob);
    }
}

