/*
 * Decompiled with CFR 0.152.
 */
package ai.dstack.server.local.sqlite.services;

import ai.dstack.server.local.sqlite.OptionalToNullableKt;
import ai.dstack.server.local.sqlite.model.SessionItem;
import ai.dstack.server.local.sqlite.repositories.SessionRepository;
import ai.dstack.server.model.Session;
import ai.dstack.server.services.EntityAlreadyExists;
import ai.dstack.server.services.SessionService;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\f\u0010\r\u001a\u00020\b*\u00020\u000eH\u0002J\f\u0010\u000f\u001a\u00020\u000e*\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lai/dstack/server/local/sqlite/services/SQLiteSessionService;", "Lai/dstack/server/services/SessionService;", "repository", "Lai/dstack/server/local/sqlite/repositories/SessionRepository;", "(Lai/dstack/server/local/sqlite/repositories/SessionRepository;)V", "create", "", "session", "Lai/dstack/server/model/Session;", "get", "id", "", "update", "toSession", "Lai/dstack/server/local/sqlite/model/SessionItem;", "toSessionItem", "server-base-local"})
public final class SQLiteSessionService
implements SessionService {
    private final SessionRepository repository;

    @Nullable
    public Session get(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Optional optional = this.repository.findById(id);
        Intrinsics.checkExpressionValueIsNotNull((Object)optional, (String)"repository.findById(id)");
        SessionItem sessionItem = (SessionItem)OptionalToNullableKt.toNullable(optional);
        return sessionItem != null ? this.toSession(sessionItem) : null;
    }

    public void create(@NotNull Session session) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        if (this.repository.existsById(session.getId())) {
            throw (Throwable)new EntityAlreadyExists(null, 1, null);
        }
        this.repository.save(this.toSessionItem(session));
    }

    public void update(@NotNull Session session) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        this.repository.save(this.toSessionItem(session));
    }

    private final Session toSession(@NotNull SessionItem $this$toSession) {
        return new Session($this$toSession.getId(), $this$toSession.getUser(), $this$toSession.getExpiresAt());
    }

    private final SessionItem toSessionItem(@NotNull Session $this$toSessionItem) {
        return new SessionItem($this$toSessionItem.getId(), $this$toSessionItem.getUserName(), $this$toSessionItem.getExpiresAtEpochSecond());
    }

    public SQLiteSessionService(@NotNull SessionRepository repository) {
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        this.repository = repository;
    }

    public void renew(@NotNull Session session) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        SessionService.DefaultImpls.renew((SessionService)this, (Session)session);
    }
}

