/*
 * Decompiled with CFR 0.152.
 */
package ai.dstack.server.local.sqlite.services;

import ai.dstack.server.local.sqlite.OptionalToNullableKt;
import ai.dstack.server.local.sqlite.model.StackId;
import ai.dstack.server.local.sqlite.model.StackItem;
import ai.dstack.server.local.sqlite.model.StackItemHead;
import ai.dstack.server.local.sqlite.repositories.StackRepository;
import ai.dstack.server.model.Head;
import ai.dstack.server.model.Stack;
import ai.dstack.server.services.EntityAlreadyExists;
import ai.dstack.server.services.StackService;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0011H\u0016J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0011H\u0002J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\f\u0010\u0017\u001a\u00020\u0007*\u00020\u0018H\u0002J\f\u0010\u0019\u001a\u00020\u0018*\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001a"}, d2={"Lai/dstack/server/local/sqlite/services/SQLiteStackService;", "Lai/dstack/server/services/StackService;", "repository", "Lai/dstack/server/local/sqlite/repositories/StackRepository;", "(Lai/dstack/server/local/sqlite/repositories/StackRepository;)V", "mapId", "Lai/dstack/server/local/sqlite/model/StackId;", "Lai/dstack/server/model/Stack;", "getMapId", "(Lai/dstack/server/model/Stack;)Lai/dstack/server/local/sqlite/model/StackId;", "create", "", "stack", "delete", "findByUser", "Lkotlin/sequences/Sequence;", "user", "", "consistent", "", "get", "name", "update", "toStack", "Lai/dstack/server/local/sqlite/model/StackItem;", "toStackItem", "server-base-local"})
public final class SQLiteStackService
implements StackService {
    private final StackRepository repository;

    @Nullable
    public Stack get(@NotNull String user, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Optional optional = this.repository.findById(this.mapId(user, name));
        Intrinsics.checkExpressionValueIsNotNull((Object)optional, (String)"repository.findById(mapId(user, name))");
        StackItem stackItem = (StackItem)OptionalToNullableKt.toNullable(optional);
        return stackItem != null ? this.toStack(stackItem) : null;
    }

    @NotNull
    public Sequence<Stack> findByUser(@NotNull String user, boolean consistent) {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        return SequencesKt.map((Sequence)CollectionsKt.asSequence(this.repository.findAllByUser(user)), (Function1)((Function1)new Function1<StackItem, Stack>(this){
            final /* synthetic */ SQLiteStackService this$0;

            @NotNull
            public final Stack invoke(@NotNull StackItem it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return SQLiteStackService.access$toStack(this.this$0, it);
            }
            {
                this.this$0 = sQLiteStackService;
                super(1);
            }
        }));
    }

    public void create(@NotNull Stack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (this.repository.existsById(this.getMapId(stack))) {
            throw (Throwable)new EntityAlreadyExists(null, 1, null);
        }
        this.repository.save(this.toStackItem(stack));
    }

    public void delete(@NotNull Stack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        this.repository.deleteById(this.getMapId(stack));
    }

    public void update(@NotNull Stack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        this.repository.save(this.toStackItem(stack));
    }

    private final StackId getMapId(@NotNull Stack $this$mapId) {
        return this.mapId($this$mapId.getUserName(), $this$mapId.getName());
    }

    private final StackId mapId(String user, String name) {
        return new StackId(user, name);
    }

    private final Stack toStack(@NotNull StackItem $this$toStack) {
        Head head;
        StackItem stackItem = $this$toStack;
        boolean bl = false;
        boolean bl2 = false;
        StackItem s = stackItem;
        boolean bl3 = false;
        String string = s.getUser();
        String string2 = s.getName();
        boolean bl4 = s.getPrivate();
        StackItemHead stackItemHead = s.getHead();
        if (stackItemHead != null) {
            StackItemHead stackItemHead2 = stackItemHead;
            boolean bl5 = bl4;
            String string3 = string2;
            String string4 = string;
            boolean bl6 = false;
            boolean bl7 = false;
            StackItemHead h = stackItemHead2;
            boolean bl8 = false;
            Head head2 = new Head(h.getId(), h.getTimestampMillis());
            string = string4;
            string2 = string3;
            bl4 = bl5;
            head = head2;
        } else {
            head = null;
        }
        Head head3 = head;
        boolean bl9 = bl4;
        String string5 = string2;
        String string6 = string;
        return new Stack(string6, string5, bl9, head3);
    }

    private final StackItem toStackItem(@NotNull Stack $this$toStackItem) {
        StackItemHead stackItemHead;
        Stack stack = $this$toStackItem;
        boolean bl = false;
        boolean bl2 = false;
        Stack s = stack;
        boolean bl3 = false;
        String string = s.getUserName();
        String string2 = s.getName();
        boolean bl4 = s.getPrivate();
        Head head = s.getHead();
        if (head != null) {
            Head head2 = head;
            boolean bl5 = bl4;
            String string3 = string2;
            String string4 = string;
            boolean bl6 = false;
            boolean bl7 = false;
            Head h = head2;
            boolean bl8 = false;
            StackItemHead stackItemHead2 = new StackItemHead(h.getId(), h.getTimestampMillis());
            string = string4;
            string2 = string3;
            bl4 = bl5;
            stackItemHead = stackItemHead2;
        } else {
            stackItemHead = null;
        }
        StackItemHead stackItemHead3 = stackItemHead;
        boolean bl9 = bl4;
        String string5 = string2;
        String string6 = string;
        return new StackItem(string6, string5, bl9, stackItemHead3);
    }

    public SQLiteStackService(@NotNull StackRepository repository) {
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        this.repository = repository;
    }

    public static final /* synthetic */ Stack access$toStack(SQLiteStackService $this, StackItem $this$access_u24toStack) {
        return $this.toStack($this$access_u24toStack);
    }
}

