/*
 * Decompiled with CFR 0.152.
 */
package ai.dstack.server.local.sqlite.services;

import ai.dstack.server.local.sqlite.OptionalToNullableKt;
import ai.dstack.server.local.sqlite.model.UserItem;
import ai.dstack.server.local.sqlite.model.UserItemSettingNotifications;
import ai.dstack.server.local.sqlite.model.UserItemSettings;
import ai.dstack.server.local.sqlite.model.UserItemSettingsGeneral;
import ai.dstack.server.local.sqlite.repositories.UserRepository;
import ai.dstack.server.model.General;
import ai.dstack.server.model.Notifications;
import ai.dstack.server.model.Settings;
import ai.dstack.server.model.User;
import ai.dstack.server.model.UserPlan;
import ai.dstack.server.services.EntityAlreadyExists;
import ai.dstack.server.services.UserService;
import java.time.LocalDate;
import java.util.Iterator;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J&\u0010\u0013\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u0010H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0018\u001a\u00020\u0010H\u0016J\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\f\u0010\u001a\u001a\u00020\b*\u00020\u001bH\u0002J\f\u0010\u001c\u001a\u00020\u001b*\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lai/dstack/server/local/sqlite/services/SQLiteUserService;", "Lai/dstack/server/services/UserService;", "repository", "Lai/dstack/server/local/sqlite/repositories/UserRepository;", "(Lai/dstack/server/local/sqlite/repositories/UserRepository;)V", "create", "", "user", "Lai/dstack/server/model/User;", "delete", "findByCreatedDate", "Lkotlin/sequences/Sequence;", "createdDate", "Ljava/time/LocalDate;", "findByEmail", "email", "", "findByToken", "token", "findUnverified", "unverifiedName", "verificationCode", "password", "get", "name", "update", "toUser", "Lai/dstack/server/local/sqlite/model/UserItem;", "toUserItem", "server-base-local"})
public final class SQLiteUserService
implements UserService {
    private final UserRepository repository;

    @Nullable
    public User get(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Optional optional = this.repository.findById(name);
        Intrinsics.checkExpressionValueIsNotNull((Object)optional, (String)"repository.findById(name)");
        UserItem userItem = (UserItem)OptionalToNullableKt.toNullable(optional);
        return userItem != null ? this.toUser(userItem) : null;
    }

    @Nullable
    public User findByEmail(@NotNull String email) {
        UserItem userItem;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)email, (String)"email");
            Iterable<UserItem> $this$firstOrNull$iv = this.repository.findAllByEmail(email);
            boolean $i$f$firstOrNull = false;
            Iterator<UserItem> iterator = $this$firstOrNull$iv.iterator();
            while (iterator.hasNext()) {
                UserItem element$iv;
                UserItem it = element$iv = iterator.next();
                boolean bl = false;
                if (!it.getVerified()) continue;
                userItem = element$iv;
                break block1;
            }
            userItem = null;
        }
        UserItem userItem2 = userItem;
        return userItem2 != null ? this.toUser(userItem2) : null;
    }

    @Nullable
    public User findByToken(@NotNull String token) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        UserItem userItem = OptionalToNullableKt.toNullable(this.repository.findByToken(token));
        return userItem != null ? this.toUser(userItem) : null;
    }

    @NotNull
    public Sequence<User> findByCreatedDate(@NotNull LocalDate createdDate) {
        Intrinsics.checkParameterIsNotNull((Object)createdDate, (String)"createdDate");
        return SequencesKt.map((Sequence)CollectionsKt.asSequence(this.repository.findAllByCreatedDate(createdDate)), (Function1)((Function1)new Function1<UserItem, User>(this){
            final /* synthetic */ SQLiteUserService this$0;

            @NotNull
            public final User invoke(@NotNull UserItem it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return SQLiteUserService.access$toUser(this.this$0, it);
            }
            {
                this.this$0 = sQLiteUserService;
                super(1);
            }
        }));
    }

    public void create(@NotNull User user) {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        if (this.repository.existsById(user.getName())) {
            throw (Throwable)new EntityAlreadyExists(null, 1, null);
        }
        this.repository.save(this.toUserItem(user));
    }

    private final UserItem toUserItem(@NotNull User $this$toUserItem) {
        UserItemSettingNotifications userItemSettingNotifications;
        Settings settings = $this$toUserItem.getSettings();
        LocalDate localDate = $this$toUserItem.getCreatedDate();
        String string = $this$toUserItem.getPlan().getCode();
        boolean bl = $this$toUserItem.getVerified();
        String string2 = $this$toUserItem.getVerificationCode();
        String string3 = $this$toUserItem.getToken();
        String string4 = $this$toUserItem.getPassword();
        String string5 = $this$toUserItem.getEmail();
        String string6 = $this$toUserItem.getName();
        boolean bl2 = false;
        boolean bl3 = false;
        Settings it = settings;
        boolean bl4 = false;
        Notifications notifications = it.getNotifications();
        UserItemSettingsGeneral userItemSettingsGeneral = new UserItemSettingsGeneral(it.getGeneral().getDefaultAccessLevel());
        boolean bl5 = false;
        boolean bl6 = false;
        Notifications n = notifications;
        boolean bl7 = false;
        UserItemSettingNotifications userItemSettingNotifications2 = userItemSettingNotifications = new UserItemSettingNotifications(n.getComments(), n.getNewsletter());
        UserItemSettingsGeneral userItemSettingsGeneral2 = userItemSettingsGeneral;
        UserItemSettings userItemSettings = new UserItemSettings(userItemSettingsGeneral2, userItemSettingNotifications2);
        String string7 = $this$toUserItem.getUnverifiedName();
        UserItemSettings userItemSettings2 = userItemSettings;
        LocalDate localDate2 = localDate;
        String string8 = string;
        boolean bl8 = bl;
        String string9 = string2;
        String string10 = string3;
        String string11 = string4;
        String string12 = string5;
        String string13 = string6;
        return new UserItem(string13, string12, string11, string10, string9, bl8, string8, localDate2, userItemSettings2, string7);
    }

    public void update(@NotNull User user) {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        this.repository.save(this.toUserItem(user));
    }

    public void delete(@NotNull User user) {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        this.repository.deleteById(user.getName());
    }

    @Nullable
    public User findUnverified(@NotNull String unverifiedName, @Nullable String verificationCode, @Nullable String password) {
        Object v0;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)unverifiedName, (String)"unverifiedName");
            Sequence $this$firstOrNull$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence(this.repository.findAllByUnverifiedName(unverifiedName)), (Function1)((Function1)new Function1<UserItem, User>(this){
                final /* synthetic */ SQLiteUserService this$0;

                @NotNull
                public final User invoke(@NotNull UserItem it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return SQLiteUserService.access$toUser(this.this$0, it);
                }
                {
                    this.this$0 = sQLiteUserService;
                    super(1);
                }
            }));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                User it = (User)element$iv;
                boolean bl = false;
                if (!(verificationCode != null && Intrinsics.areEqual((Object)it.getVerificationCode(), (Object)verificationCode) || password != null && Intrinsics.areEqual((Object)it.getPassword(), (Object)password))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final User toUser(@NotNull UserItem $this$toUser) {
        Notifications notifications;
        UserItem userItem = $this$toUser;
        boolean bl = false;
        boolean bl2 = false;
        UserItem u = userItem;
        boolean bl3 = false;
        UserItemSettings userItemSettings = u.getSettings();
        LocalDate localDate = u.getCreatedDate();
        UserPlan userPlan = UserPlan.Companion.fromCode(u.getPlan());
        boolean bl4 = u.getVerified();
        String string = u.getVerificationCode();
        String string2 = u.getToken();
        String string3 = u.getPassword();
        String string4 = u.getEmail();
        String string5 = u.getName();
        boolean bl5 = false;
        boolean bl6 = false;
        UserItemSettings s = userItemSettings;
        boolean bl7 = false;
        UserItemSettingNotifications userItemSettingNotifications = s.getNotifications();
        General general = new General(s.getGeneral().getDefaultAccessLevel());
        boolean bl8 = false;
        boolean bl9 = false;
        UserItemSettingNotifications n = userItemSettingNotifications;
        boolean bl10 = false;
        Notifications notifications2 = notifications = new Notifications(n.getComments(), n.getNewsletter());
        General general2 = general;
        Settings settings = new Settings(general2, notifications2);
        String string6 = u.getUnverifiedName();
        Settings settings2 = settings;
        LocalDate localDate2 = localDate;
        UserPlan userPlan2 = userPlan;
        boolean bl11 = bl4;
        String string7 = string;
        String string8 = string2;
        String string9 = string3;
        String string10 = string4;
        String string11 = string5;
        return new User(string11, string10, string9, string8, string7, bl11, userPlan2, localDate2, settings2, string6);
    }

    public SQLiteUserService(@NotNull UserRepository repository) {
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        this.repository = repository;
    }

    public static final /* synthetic */ User access$toUser(SQLiteUserService $this, UserItem $this$access_u24toUser) {
        return $this.toUser($this$access_u24toUser);
    }
}

