/*
 * Decompiled with CFR 0.152.
 */
package ai.dstack.server.local.sqlite;

import ai.dstack.server.local.sqlite.repositories.AttachmentRepository;
import ai.dstack.server.local.sqlite.repositories.CardRepository;
import ai.dstack.server.local.sqlite.repositories.CommentRepository;
import ai.dstack.server.local.sqlite.repositories.DashboardRepository;
import ai.dstack.server.local.sqlite.repositories.FrameRepository;
import ai.dstack.server.local.sqlite.repositories.JobRepository;
import ai.dstack.server.local.sqlite.repositories.PermissionRepository;
import ai.dstack.server.local.sqlite.repositories.SessionRepository;
import ai.dstack.server.local.sqlite.repositories.StackRepository;
import ai.dstack.server.local.sqlite.repositories.UserRepository;
import ai.dstack.server.local.sqlite.services.SQLiteAttachmentService;
import ai.dstack.server.local.sqlite.services.SQLiteCardService;
import ai.dstack.server.local.sqlite.services.SQLiteCommentService;
import ai.dstack.server.local.sqlite.services.SQLiteDashboardService;
import ai.dstack.server.local.sqlite.services.SQLiteFrameService;
import ai.dstack.server.local.sqlite.services.SQLiteJobService;
import ai.dstack.server.local.sqlite.services.SQLitePermissionService;
import ai.dstack.server.local.sqlite.services.SQLiteSessionService;
import ai.dstack.server.local.sqlite.services.SQLiteStackService;
import ai.dstack.server.local.sqlite.services.SQLiteUserService;
import ai.dstack.server.services.AppConfig;
import ai.dstack.server.services.AttachmentService;
import ai.dstack.server.services.CardService;
import ai.dstack.server.services.CommentService;
import ai.dstack.server.services.DashboardService;
import ai.dstack.server.services.FrameService;
import ai.dstack.server.services.JobService;
import ai.dstack.server.services.PermissionService;
import ai.dstack.server.services.SessionService;
import ai.dstack.server.services.StackService;
import ai.dstack.server.services.UserService;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;

@Configuration
@Profile(value={"sqlite"})
@EnableJpaRepositories(basePackages={"ai.dstack.server.local.sqlite.repositories"})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0017J\u0012\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\u0005\u001a\u00020\tH\u0017J\u0012\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\u0005\u001a\u00020\fH\u0017J\u0012\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u0005\u001a\u00020\u000fH\u0017J\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J\u0012\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0005\u001a\u00020\u0016H\u0017J\u0012\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0005\u001a\u00020\u0019H\u0017J\u0012\u0010\u001a\u001a\u00020\u001b2\b\b\u0001\u0010\u0005\u001a\u00020\u001cH\u0017J\n\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0017J\u0012\u0010\u001f\u001a\u00020 2\b\b\u0001\u0010\u0005\u001a\u00020!H\u0017J\u0012\u0010\"\u001a\u00020#2\b\b\u0001\u0010\u0005\u001a\u00020$H\u0017J\u0012\u0010%\u001a\u00020&2\b\b\u0001\u0010\u0005\u001a\u00020'H\u0017\u00a8\u0006("}, d2={"Lai/dstack/server/local/sqlite/SQLiteConfig;", "", "()V", "attachmentService", "Lai/dstack/server/services/AttachmentService;", "repository", "Lai/dstack/server/local/sqlite/repositories/AttachmentRepository;", "carService", "Lai/dstack/server/services/CardService;", "Lai/dstack/server/local/sqlite/repositories/CardRepository;", "commentService", "Lai/dstack/server/services/CommentService;", "Lai/dstack/server/local/sqlite/repositories/CommentRepository;", "dashboardService", "Lai/dstack/server/services/DashboardService;", "Lai/dstack/server/local/sqlite/repositories/DashboardRepository;", "dataSource", "Ljavax/sql/DataSource;", "config", "Lai/dstack/server/services/AppConfig;", "frameService", "Lai/dstack/server/services/FrameService;", "Lai/dstack/server/local/sqlite/repositories/FrameRepository;", "jobService", "Lai/dstack/server/services/JobService;", "Lai/dstack/server/local/sqlite/repositories/JobRepository;", "permissionService", "Lai/dstack/server/services/PermissionService;", "Lai/dstack/server/local/sqlite/repositories/PermissionRepository;", "properties", "Lorg/springframework/context/support/PropertySourcesPlaceholderConfigurer;", "sessionService", "Lai/dstack/server/services/SessionService;", "Lai/dstack/server/local/sqlite/repositories/SessionRepository;", "stackService", "Lai/dstack/server/services/StackService;", "Lai/dstack/server/local/sqlite/repositories/StackRepository;", "userService", "Lai/dstack/server/services/UserService;", "Lai/dstack/server/local/sqlite/repositories/UserRepository;", "server-base-local"})
public class SQLiteConfig {
    @Bean
    @Nullable
    public DataSource dataSource(@Autowired @NotNull AppConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setDriverClassName("org.sqlite.JDBC");
        File directory = new File(config.getDataDirectory() + "/sqlite/");
        directory.mkdirs();
        hikariConfig.setJdbcUrl("jdbc:sqlite:" + directory.getAbsolutePath() + "/dstack.sqlite3");
        hikariConfig.setMaximumPoolSize(1);
        return (DataSource)new HikariDataSource(hikariConfig);
    }

    @Bean
    @Nullable
    public PropertySourcesPlaceholderConfigurer properties() {
        PropertySourcesPlaceholderConfigurer properties = new PropertySourcesPlaceholderConfigurer();
        properties.setLocations(new Resource[]{(Resource)new ClassPathResource("ai/dstack/server/local/sqlite/application.properties")});
        properties.setIgnoreUnresolvablePlaceholders(true);
        return properties;
    }

    @Bean
    @NotNull
    public AttachmentService attachmentService(@Autowired @NotNull AttachmentRepository repository) {
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        return new SQLiteAttachmentService(repository);
    }

    @Bean
    @NotNull
    public CardService carService(@Autowired @NotNull CardRepository repository) {
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        return new SQLiteCardService(repository);
    }

    @Bean
    @NotNull
    public CommentService commentService(@Autowired @NotNull CommentRepository repository) {
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        return new SQLiteCommentService(repository);
    }

    @Bean
    @NotNull
    public DashboardService dashboardService(@Autowired @NotNull DashboardRepository repository) {
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        return new SQLiteDashboardService(repository);
    }

    @Bean
    @NotNull
    public FrameService frameService(@Autowired @NotNull FrameRepository repository) {
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        return new SQLiteFrameService(repository);
    }

    @Bean
    @NotNull
    public JobService jobService(@Autowired @NotNull JobRepository repository) {
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        return new SQLiteJobService(repository);
    }

    @Bean
    @NotNull
    public PermissionService permissionService(@Autowired @NotNull PermissionRepository repository) {
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        return new SQLitePermissionService(repository);
    }

    @Bean
    @NotNull
    public SessionService sessionService(@Autowired @NotNull SessionRepository repository) {
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        return new SQLiteSessionService(repository);
    }

    @Bean
    @NotNull
    public StackService stackService(@Autowired @NotNull StackRepository repository) {
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        return new SQLiteStackService(repository);
    }

    @Bean
    @NotNull
    public UserService userService(@Autowired @NotNull UserRepository repository) {
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        return new SQLiteUserService(repository);
    }
}

