/*
 * Decompiled with CFR 0.152.
 */
package ai.dstack.server.local.sqlite.services;

import ai.dstack.server.local.sqlite.OptionalToNullableKt;
import ai.dstack.server.local.sqlite.model.AttachId;
import ai.dstack.server.local.sqlite.model.AttachmentItem;
import ai.dstack.server.local.sqlite.repositories.AttachmentRepository;
import ai.dstack.server.local.sqlite.services.SqliteMapperKt;
import ai.dstack.server.model.Attachment;
import ai.dstack.server.model.AttachmentTypeMigration;
import ai.dstack.server.services.AttachmentService;
import ai.dstack.server.services.EntityAlreadyExists;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0015H\u0002J\f\u0010\u0018\u001a\u00020\u0007*\u00020\u0019H\u0002J\f\u0010\u001a\u001a\u00020\u0019*\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lai/dstack/server/local/sqlite/services/SQLiteAttachmentService;", "Lai/dstack/server/services/AttachmentService;", "repository", "Lai/dstack/server/local/sqlite/repositories/AttachmentRepository;", "(Lai/dstack/server/local/sqlite/repositories/AttachmentRepository;)V", "mapId", "Lai/dstack/server/local/sqlite/model/AttachId;", "Lai/dstack/server/model/Attachment;", "getMapId", "(Lai/dstack/server/model/Attachment;)Lai/dstack/server/local/sqlite/model/AttachId;", "create", "", "attachment", "deleteByStackPath", "stackPath", "", "findByFrame", "", "frame", "get", "index", "", "framePath", "attachIndex", "toAttachment", "Lai/dstack/server/local/sqlite/model/AttachmentItem;", "toAttachmentItem", "server-base-local"})
public final class SQLiteAttachmentService
implements AttachmentService {
    private final AttachmentRepository repository;

    @Nullable
    public Attachment get(@NotNull String frame, int index) {
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        Optional optional = this.repository.findById(this.mapId(frame, index));
        Intrinsics.checkExpressionValueIsNotNull((Object)optional, (String)"repository.findById(mapId(frame, index))");
        AttachmentItem attachmentItem = (AttachmentItem)OptionalToNullableKt.toNullable(optional);
        return attachmentItem != null ? this.toAttachment(attachmentItem) : null;
    }

    public void deleteByStackPath(@NotNull String stackPath) {
        Intrinsics.checkParameterIsNotNull((Object)stackPath, (String)"stackPath");
        this.repository.deleteAllByStack(stackPath);
    }

    public void create(@NotNull Attachment attachment) {
        Intrinsics.checkParameterIsNotNull((Object)attachment, (String)"attachment");
        if (this.repository.existsById(this.getMapId(attachment))) {
            throw (Throwable)new EntityAlreadyExists(null, 1, null);
        }
        this.repository.save(this.toAttachmentItem(attachment));
    }

    @NotNull
    public List<Attachment> findByFrame(@NotNull String frame) {
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence(this.repository.findAllByFrame(frame)), (Function1)((Function1)new Function1<AttachmentItem, Attachment>(this){
            final /* synthetic */ SQLiteAttachmentService this$0;

            @NotNull
            public final Attachment invoke(@NotNull AttachmentItem it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return SQLiteAttachmentService.access$toAttachment(this.this$0, it);
            }
            {
                this.this$0 = sQLiteAttachmentService;
                super(1);
            }
        })));
    }

    private final AttachId getMapId(@NotNull Attachment $this$mapId) {
        return this.mapId($this$mapId.getFramePath(), $this$mapId.getIndex());
    }

    private final AttachId mapId(String framePath, int attachIndex) {
        return new AttachId(framePath, attachIndex);
    }

    private final Attachment toAttachment(@NotNull AttachmentItem $this$toAttachment) {
        AttachmentItem attachmentItem = $this$toAttachment;
        boolean bl = false;
        boolean bl2 = false;
        AttachmentItem a = attachmentItem;
        boolean bl3 = false;
        AttachmentTypeMigration values = AttachmentTypeMigration.Companion.migrate($this$toAttachment.getLegacyType(), $this$toAttachment.getApplication(), $this$toAttachment.getContentType());
        String string = a.getFrame();
        String string2 = a.getFile();
        String string3 = a.getDescription();
        String string4 = values.getLegacyType();
        if (string4 == null) {
            string4 = "unknown";
        }
        String string5 = values.getApplication();
        String string6 = values.getContentType();
        if (string6 == null) {
            string6 = "unknown";
        }
        long l = a.getLength();
        int n = a.getIndex();
        Object object = SqliteMapperKt.getSqliteMapper().readValue(a.getParamsJson(), (TypeReference)new TypeReference<Map<String, ? extends Object>>(){});
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"sqliteMapper.readValue(a\u2026e<Map<String, Any>>() {})");
        Map map = (Map)object;
        Object object2 = SqliteMapperKt.getSqliteMapper().readValue(a.getSettingsJson(), (TypeReference)new TypeReference<Map<String, ? extends Object>>(){});
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"sqliteMapper.readValue(a\u2026e<Map<String, Any>>() {})");
        return new Attachment(string, string2, string3, string4, string5, string6, l, n, map, (Map)object2, a.getCreatedDate());
    }

    private final AttachmentItem toAttachmentItem(@NotNull Attachment $this$toAttachmentItem) {
        Attachment attachment = $this$toAttachmentItem;
        boolean bl = false;
        boolean bl2 = false;
        Attachment a = attachment;
        boolean bl3 = false;
        AttachmentTypeMigration values = AttachmentTypeMigration.Companion.migrate($this$toAttachmentItem.getLegacyType(), $this$toAttachmentItem.getApplication(), $this$toAttachmentItem.getContentType());
        String string = a.getFramePath();
        int n = a.getIndex();
        String string2 = a.getFilePath();
        String string3 = values.getLegacyType();
        if (string3 == null) {
            string3 = "unknown";
        }
        String string4 = values.getApplication();
        String string5 = values.getContentType();
        if (string5 == null) {
            string5 = "unknown";
        }
        long l = a.getLength();
        String string6 = a.getDescription();
        String string7 = SqliteMapperKt.getSqliteMapper().writeValueAsString((Object)a.getParams());
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"sqliteMapper.writeValueA\u2026.params\n                )");
        String string8 = SqliteMapperKt.getSqliteMapper().writeValueAsString((Object)a.getSettings());
        Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"sqliteMapper.writeValueA\u2026ettings\n                )");
        return new AttachmentItem(string, n, string2, string3, string4, string5, l, string6, string7, string8, a.getCreatedDate());
    }

    public SQLiteAttachmentService(@NotNull AttachmentRepository repository) {
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        this.repository = repository;
    }

    public static final /* synthetic */ Attachment access$toAttachment(SQLiteAttachmentService $this, AttachmentItem $this$access_u24toAttachment) {
        return $this.toAttachment($this$access_u24toAttachment);
    }
}

