/*
 * Decompiled with CFR 0.152.
 */
package ai.dstack.server.local.sqlite.services;

import ai.dstack.server.local.sqlite.OptionalToNullableKt;
import ai.dstack.server.local.sqlite.model.CommentItem;
import ai.dstack.server.local.sqlite.repositories.CommentRepository;
import ai.dstack.server.model.Comment;
import ai.dstack.server.services.CommentService;
import ai.dstack.server.services.EntityAlreadyExists;
import java.util.List;
import java.util.Optional;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(message="Gonna be removed in October")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0011\u001a\u00020\fH\u0016J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\f\u0010\u0013\u001a\u00020\b*\u00020\u0014H\u0002J\f\u0010\u0015\u001a\u00020\u0014*\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lai/dstack/server/local/sqlite/services/SQLiteCommentService;", "Lai/dstack/server/services/CommentService;", "repository", "Lai/dstack/server/local/sqlite/repositories/CommentRepository;", "(Lai/dstack/server/local/sqlite/repositories/CommentRepository;)V", "create", "", "comment", "Lai/dstack/server/model/Comment;", "delete", "deleteByStackPath", "stackPath", "", "findByStackPath", "", "path", "get", "id", "update", "toComment", "Lai/dstack/server/local/sqlite/model/CommentItem;", "toCommentItem", "server-base-local"})
public final class SQLiteCommentService
implements CommentService {
    private final CommentRepository repository;

    @Nullable
    public Comment get(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Optional optional = this.repository.findById(id);
        Intrinsics.checkExpressionValueIsNotNull((Object)optional, (String)"repository.findById(id)");
        CommentItem commentItem = (CommentItem)OptionalToNullableKt.toNullable(optional);
        return commentItem != null ? this.toComment(commentItem) : null;
    }

    @NotNull
    public List<Comment> findByStackPath(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence(this.repository.findAllByStackPath(path)), (Function1)((Function1)new Function1<CommentItem, Comment>(this){
            final /* synthetic */ SQLiteCommentService this$0;

            @NotNull
            public final Comment invoke(@NotNull CommentItem it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return SQLiteCommentService.access$toComment(this.this$0, it);
            }
            {
                this.this$0 = sQLiteCommentService;
                super(1);
            }
        })));
    }

    public void create(@NotNull Comment comment) {
        Intrinsics.checkParameterIsNotNull((Object)comment, (String)"comment");
        if (this.repository.existsById(comment.getId())) {
            throw (Throwable)new EntityAlreadyExists(null, 1, null);
        }
        this.repository.save(this.toCommentItem(comment));
    }

    public void delete(@NotNull Comment comment) {
        Intrinsics.checkParameterIsNotNull((Object)comment, (String)"comment");
        this.repository.deleteById(comment.getId());
    }

    public void update(@NotNull Comment comment) {
        Intrinsics.checkParameterIsNotNull((Object)comment, (String)"comment");
        this.repository.save(this.toCommentItem(comment));
    }

    public void deleteByStackPath(@NotNull String stackPath) {
        Intrinsics.checkParameterIsNotNull((Object)stackPath, (String)"stackPath");
        this.repository.deleteAll(this.repository.findAllByStackPath(stackPath));
    }

    private final Comment toComment(@NotNull CommentItem $this$toComment) {
        CommentItem commentItem = $this$toComment;
        boolean bl = false;
        boolean bl2 = false;
        CommentItem c = commentItem;
        boolean bl3 = false;
        return new Comment(c.getId(), c.getStackPath(), c.getUser(), c.getTimestamp(), c.getText());
    }

    private final CommentItem toCommentItem(@NotNull Comment $this$toCommentItem) {
        Comment comment = $this$toCommentItem;
        boolean bl = false;
        boolean bl2 = false;
        Comment c = comment;
        boolean bl3 = false;
        return new CommentItem(c.getId(), c.getStackPath(), c.getTimestampMillis(), c.getUserName(), c.getText());
    }

    public SQLiteCommentService(@NotNull CommentRepository repository) {
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        this.repository = repository;
    }

    public static final /* synthetic */ Comment access$toComment(SQLiteCommentService $this, CommentItem $this$access_u24toComment) {
        return $this.toComment($this$access_u24toComment);
    }
}

