/*
 * Decompiled with CFR 0.152.
 */
package ai.dstack.server.local.sqlite.services;

import ai.dstack.server.local.sqlite.OptionalToNullableKt;
import ai.dstack.server.local.sqlite.model.FrameId;
import ai.dstack.server.local.sqlite.model.FrameItem;
import ai.dstack.server.local.sqlite.repositories.FrameRepository;
import ai.dstack.server.local.sqlite.services.SqliteMapperKt;
import ai.dstack.server.model.Frame;
import ai.dstack.server.services.EntityAlreadyExists;
import ai.dstack.server.services.FrameService;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000fH\u0016J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\f\u0010\u0015\u001a\u00020\u0007*\u00020\u0016H\u0002J\f\u0010\u0017\u001a\u00020\u0016*\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lai/dstack/server/local/sqlite/services/SQLiteFrameService;", "Lai/dstack/server/services/FrameService;", "repository", "Lai/dstack/server/local/sqlite/repositories/FrameRepository;", "(Lai/dstack/server/local/sqlite/repositories/FrameRepository;)V", "mapId", "Lai/dstack/server/local/sqlite/model/FrameId;", "Lai/dstack/server/model/Frame;", "getMapId", "(Lai/dstack/server/model/Frame;)Lai/dstack/server/local/sqlite/model/FrameId;", "create", "", "frame", "deleteByStackPath", "stackPath", "", "findByStackPath", "", "get", "frameId", "update", "toFrame", "Lai/dstack/server/local/sqlite/model/FrameItem;", "toFrameItem", "server-base-local"})
public final class SQLiteFrameService
implements FrameService {
    private final FrameRepository repository;

    @Nullable
    public Frame get(@NotNull String stackPath, @NotNull String frameId) {
        Intrinsics.checkParameterIsNotNull((Object)stackPath, (String)"stackPath");
        Intrinsics.checkParameterIsNotNull((Object)frameId, (String)"frameId");
        Optional optional = this.repository.findById(this.mapId(stackPath, frameId));
        Intrinsics.checkExpressionValueIsNotNull((Object)optional, (String)"repository.findById(mapId(stackPath, frameId))");
        FrameItem frameItem = (FrameItem)OptionalToNullableKt.toNullable(optional);
        return frameItem != null ? this.toFrame(frameItem) : null;
    }

    public void create(@NotNull Frame frame) {
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        if (this.repository.existsById(this.getMapId(frame))) {
            throw (Throwable)new EntityAlreadyExists(null, 1, null);
        }
        this.repository.save(this.toFrameItem(frame));
    }

    public void update(@NotNull Frame frame) {
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        this.repository.save(this.toFrameItem(frame));
    }

    @NotNull
    public List<Frame> findByStackPath(@NotNull String stackPath) {
        Intrinsics.checkParameterIsNotNull((Object)stackPath, (String)"stackPath");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence(this.repository.findAllByStack(stackPath)), (Function1)((Function1)new Function1<FrameItem, Frame>(this){
            final /* synthetic */ SQLiteFrameService this$0;

            @NotNull
            public final Frame invoke(@NotNull FrameItem it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return SQLiteFrameService.access$toFrame(this.this$0, it);
            }
            {
                this.this$0 = sQLiteFrameService;
                super(1);
            }
        })));
    }

    public void deleteByStackPath(@NotNull String stackPath) {
        Intrinsics.checkParameterIsNotNull((Object)stackPath, (String)"stackPath");
        this.repository.deleteAllByStack(stackPath);
    }

    private final FrameId getMapId(@NotNull Frame $this$mapId) {
        return this.mapId($this$mapId.getStackPath(), $this$mapId.getId());
    }

    private final FrameId mapId(String stackPath, String frameId) {
        return new FrameId(stackPath, frameId);
    }

    private final Frame toFrame(@NotNull FrameItem $this$toFrame) {
        Object object;
        Integer n;
        long l;
        String string;
        String string2;
        FrameItem f;
        block3: {
            block2: {
                FrameItem frameItem = $this$toFrame;
                boolean bl = false;
                boolean bl2 = false;
                f = frameItem;
                boolean bl3 = false;
                string2 = f.getStack();
                string = f.getId();
                l = f.getTimestamp();
                n = f.getSize();
                object = f.getParamsJson();
                if (object == null) break block2;
                String string3 = object;
                Integer n2 = n;
                long l2 = l;
                String string4 = string;
                String string5 = string2;
                boolean bl4 = false;
                boolean bl5 = false;
                String it = string3;
                boolean bl6 = false;
                Map map = (Map)SqliteMapperKt.getSqliteMapper().readValue(f.getParamsJson(), (TypeReference)new TypeReference<Map<String, ? extends Object>>(){});
                string2 = string5;
                string = string4;
                l = l2;
                n = n2;
                object = map;
                if (object != null) break block3;
            }
            object = MapsKt.emptyMap();
        }
        String string6 = f.getMessage();
        Object object2 = object;
        Integer n3 = n;
        long l3 = l;
        String string7 = string;
        String string8 = string2;
        return new Frame(string8, string7, l3, n3, (Map)object2, string6);
    }

    private final FrameItem toFrameItem(@NotNull Frame $this$toFrameItem) {
        Frame frame = $this$toFrameItem;
        boolean bl = false;
        boolean bl2 = false;
        Frame f = frame;
        boolean bl3 = false;
        return new FrameItem(f.getStackPath(), f.getId(), f.getTimestampMillis(), f.getSize(), SqliteMapperKt.getSqliteMapper().writeValueAsString((Object)f.getParams()), f.getMessage());
    }

    public SQLiteFrameService(@NotNull FrameRepository repository) {
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        this.repository = repository;
    }

    public static final /* synthetic */ Frame access$toFrame(SQLiteFrameService $this, FrameItem $this$access_u24toFrame) {
        return $this.toFrame($this$access_u24toFrame);
    }
}

