/*
 * Decompiled with CFR 0.152.
 */
package ai.dstack.server.local.cli;

import ai.dstack.server.local.cli.Startup;
import ai.dstack.server.model.AccessLevel;
import ai.dstack.server.model.General;
import ai.dstack.server.model.Notifications;
import ai.dstack.server.model.Settings;
import ai.dstack.server.model.User;
import ai.dstack.server.model.UserPlan;
import ai.dstack.server.services.AppConfig;
import ai.dstack.server.services.UserService;
import java.time.LocalDate;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.PostConstruct;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

@Configuration
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0007R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lai/dstack/server/local/cli/Startup;", "", "()V", "config", "Lai/dstack/server/services/AppConfig;", "getConfig", "()Lai/dstack/server/services/AppConfig;", "setConfig", "(Lai/dstack/server/services/AppConfig;)V", "userService", "Lai/dstack/server/services/UserService;", "getUserService", "()Lai/dstack/server/services/UserService;", "setUserService", "(Lai/dstack/server/services/UserService;)V", "initialize", "", "RandomString", "server-local-cli"})
public class Startup {
    @Autowired
    @NotNull
    public AppConfig config;
    @Autowired
    @NotNull
    public UserService userService;

    @NotNull
    public final AppConfig getConfig() {
        AppConfig appConfig = this.config;
        if (appConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        }
        return appConfig;
    }

    public final void setConfig(@NotNull AppConfig appConfig) {
        Intrinsics.checkParameterIsNotNull((Object)appConfig, (String)"<set-?>");
        this.config = appConfig;
    }

    @NotNull
    public final UserService getUserService() {
        UserService userService = this.userService;
        if (userService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"userService");
        }
        return userService;
    }

    public final void setUserService(@NotNull UserService userService) {
        Intrinsics.checkParameterIsNotNull((Object)userService, (String)"<set-?>");
        this.userService = userService;
    }

    @PostConstruct
    public final void initialize() {
        String string;
        User user;
        UserService userService = this.userService;
        if (userService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"userService");
        }
        if ((user = userService.get("dstack")) == null) {
            ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
            Intrinsics.checkExpressionValueIsNotNull((Object)threadLocalRandom, (String)"ThreadLocalRandom.current()");
            String string2 = new RandomString(8, (Random)threadLocalRandom).nextString();
            String string3 = UUID.randomUUID().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"UUID.randomUUID().toString()");
            String string4 = UUID.randomUUID().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"UUID.randomUUID().toString()");
            LocalDate localDate = LocalDate.now();
            Intrinsics.checkExpressionValueIsNotNull((Object)localDate, (String)"LocalDate.now()");
            string = new Settings(new General(AccessLevel.Public), new Notifications(false, false));
            String string5 = "dstack";
            user = new User("dstack", "dstack@localhost", string2, string3, string4, true, UserPlan.Free, localDate, (Settings)string, string5);
            UserService userService2 = this.userService;
            if (userService2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"userService");
            }
            userService2.create(user);
        }
        string = "To access the dstack server, open one of these URLs in the browser:";
        boolean bl = false;
        System.out.println((Object)string);
        StringBuilder stringBuilder = new StringBuilder().append("\t\thttp://localhost:");
        AppConfig appConfig = this.config;
        if (appConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        }
        string = stringBuilder.append(appConfig.getInternalPort()).append("/auth/verify?user=dstack&code=").append(user.getVerificationCode()).append("&next=/").toString();
        bl = false;
        System.out.println((Object)string);
        StringBuilder stringBuilder2 = new StringBuilder().append("\tor\thttp://127.0.0.1:");
        AppConfig appConfig2 = this.config;
        if (appConfig2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        }
        string = stringBuilder2.append(appConfig2.getInternalPort()).append("/auth/verify?user=dstack&code=").append(user.getVerificationCode()).append("&next=/").toString();
        bl = false;
        System.out.println((Object)string);
        boolean bl2 = false;
        System.out.println();
        String string6 = "If you're using Python, use the following command line command to configure your dstack profile:";
        bl = false;
        System.out.println((Object)string6);
        string6 = "\tpip install dstack";
        bl = false;
        System.out.println((Object)string6);
        StringBuilder stringBuilder3 = new StringBuilder().append("\tdstack config --token ").append(user.getToken()).append(" --user ").append(user.getName()).append(" --server http://localhost:");
        AppConfig appConfig3 = this.config;
        if (appConfig3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        }
        string6 = stringBuilder3.append(appConfig3.getInternalPort()).append("/api").toString();
        bl = false;
        System.out.println((Object)string6);
        boolean bl3 = false;
        System.out.println();
        String string7 = "If you're using R, use the following R command to configure your dstack profile:";
        bl = false;
        System.out.println((Object)string7);
        string7 = "\tinstall.packages(\"dstack\")";
        bl = false;
        System.out.println((Object)string7);
        StringBuilder stringBuilder4 = new StringBuilder().append("\tdstack::configure(user = \"").append(user.getName()).append("\", token = \"").append(user.getToken()).append("\", persist = \"global\", server = \"http://localhost:");
        AppConfig appConfig4 = this.config;
        if (appConfig4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        }
        string7 = stringBuilder4.append(appConfig4.getInternalPort()).append("/api\")").toString();
        bl = false;
        System.out.println((Object)string7);
    }
}

