/*
 * Decompiled with CFR 0.152.
 */
package ai.dstack.server.local.cli.sqlite;

import ai.dstack.server.services.AppConfig;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0017\u00a8\u0006\u0007"}, d2={"Lai/dstack/server/local/cli/sqlite/SQLiteConfig;", "", "()V", "dataSource", "Ljavax/sql/DataSource;", "config", "Lai/dstack/server/services/AppConfig;", "server-local-cli"})
public class SQLiteConfig {
    @Bean
    @Nullable
    public DataSource dataSource(@Autowired @NotNull AppConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        HikariConfig dsConfig = new HikariConfig();
        dsConfig.setDriverClassName("org.sqlite.JDBC");
        File directory = new File(config.getDataDirectory() + "/sqlite/");
        directory.mkdirs();
        dsConfig.setJdbcUrl("jdbc:sqlite:" + directory.getAbsolutePath() + "/dstack.sqlite3");
        dsConfig.setMaximumPoolSize(1);
        return (DataSource)new HikariDataSource(dsConfig);
    }
}

