/*
 * Decompiled with CFR 0.152.
 */
package ai.dstack.server.local.cli.sqlite.services;

import ai.dstack.server.local.cli.sqlite.OptionalToNullableKt;
import ai.dstack.server.local.cli.sqlite.model.AttachId;
import ai.dstack.server.local.cli.sqlite.model.AttachmentItem;
import ai.dstack.server.local.cli.sqlite.repositories.AttachmentRepository;
import ai.dstack.server.local.cli.sqlite.services.SQLiteAttachmentService;
import ai.dstack.server.local.cli.sqlite.services.SQLiteAttachmentServiceKt;
import ai.dstack.server.model.Attachment;
import ai.dstack.server.model.AttachmentTypeMigration;
import ai.dstack.server.services.AttachmentService;
import ai.dstack.server.services.EntityAlreadyExists;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0013H\u0002J\f\u0010\u0016\u001a\u00020\u0007*\u00020\u0017H\u0002J\f\u0010\u0018\u001a\u00020\u0017*\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lai/dstack/server/local/cli/sqlite/services/SQLiteAttachmentService;", "Lai/dstack/server/services/AttachmentService;", "repository", "Lai/dstack/server/local/cli/sqlite/repositories/AttachmentRepository;", "(Lai/dstack/server/local/cli/sqlite/repositories/AttachmentRepository;)V", "mapId", "Lai/dstack/server/local/cli/sqlite/model/AttachId;", "Lai/dstack/server/model/Attachment;", "getMapId", "(Lai/dstack/server/model/Attachment;)Lai/dstack/server/local/cli/sqlite/model/AttachId;", "create", "", "attachment", "findByFrame", "", "frame", "", "get", "index", "", "framePath", "attachIndex", "toAttachment", "Lai/dstack/server/local/cli/sqlite/model/AttachmentItem;", "toAttachmentItem", "server-local-cli"})
public final class SQLiteAttachmentService
implements AttachmentService {
    private final AttachmentRepository repository;

    @Nullable
    public Attachment get(@NotNull String frame, int index) {
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        Optional optional = this.repository.findById((Object)this.mapId(frame, index));
        Intrinsics.checkExpressionValueIsNotNull((Object)optional, (String)"repository.findById(mapId(frame, index))");
        AttachmentItem attachmentItem = (AttachmentItem)OptionalToNullableKt.toNullable((Optional)optional);
        return attachmentItem != null ? this.toAttachment(attachmentItem) : null;
    }

    public void create(@NotNull Attachment attachment) {
        Intrinsics.checkParameterIsNotNull((Object)attachment, (String)"attachment");
        if (this.repository.existsById((Object)this.getMapId(attachment))) {
            throw (Throwable)new EntityAlreadyExists(null, 1, null);
        }
        this.repository.save((Object)this.toAttachmentItem(attachment));
    }

    @NotNull
    public List<Attachment> findByFrame(@NotNull String frame) {
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.repository.findAllByFrame(frame)), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */)));
    }

    private final AttachId getMapId(@NotNull Attachment $this$mapId) {
        return this.mapId($this$mapId.getFramePath(), $this$mapId.getIndex());
    }

    private final AttachId mapId(String framePath, int attachIndex) {
        return new AttachId(framePath, attachIndex);
    }

    private final Attachment toAttachment(@NotNull AttachmentItem $this$toAttachment) {
        AttachmentItem attachmentItem = $this$toAttachment;
        boolean bl = false;
        boolean bl2 = false;
        AttachmentItem a = attachmentItem;
        boolean bl3 = false;
        AttachmentTypeMigration values = AttachmentTypeMigration.Companion.migrate($this$toAttachment.getLegacyType(), $this$toAttachment.getApplication(), $this$toAttachment.getContentType());
        String string = a.getFrame();
        String string2 = a.getFile();
        String string3 = a.getDescription();
        String string4 = values.getLegacyType();
        if (string4 == null) {
            string4 = "unknown";
        }
        String string5 = values.getApplication();
        String string6 = values.getContentType();
        if (string6 == null) {
            string6 = "unknown";
        }
        long l = a.getLength();
        int n = a.getIndex();
        Object object = SQLiteAttachmentServiceKt.getSQLITE_MAPPER().readValue(a.getParamsJson(), (TypeReference)new toAttachment.1.1());
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"SQLITE_MAPPER.readValue(\u2026e<Map<String, Any>>() {})");
        Map map = (Map)object;
        Object object2 = SQLiteAttachmentServiceKt.getSQLITE_MAPPER().readValue(a.getSettingsJson(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"SQLITE_MAPPER.readValue(\u2026e<Map<String, Any>>() {})");
        return new Attachment(string, string2, string3, string4, string5, string6, l, n, map, (Map)object2, a.getCreatedDate());
    }

    private final AttachmentItem toAttachmentItem(@NotNull Attachment $this$toAttachmentItem) {
        Attachment attachment = $this$toAttachmentItem;
        boolean bl = false;
        boolean bl2 = false;
        Attachment a = attachment;
        boolean bl3 = false;
        AttachmentTypeMigration values = AttachmentTypeMigration.Companion.migrate($this$toAttachmentItem.getLegacyType(), $this$toAttachmentItem.getApplication(), $this$toAttachmentItem.getContentType());
        String string = a.getFramePath();
        int n = a.getIndex();
        String string2 = a.getFilePath();
        String string3 = values.getLegacyType();
        if (string3 == null) {
            string3 = "unknown";
        }
        String string4 = values.getApplication();
        String string5 = values.getContentType();
        if (string5 == null) {
            string5 = "unknown";
        }
        long l = a.getLength();
        String string6 = a.getDescription();
        String string7 = SQLiteAttachmentServiceKt.getSQLITE_MAPPER().writeValueAsString((Object)a.getParams());
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"SQLITE_MAPPER.writeValue\u2026.params\n                )");
        String string8 = SQLiteAttachmentServiceKt.getSQLITE_MAPPER().writeValueAsString((Object)a.getSettings());
        Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"SQLITE_MAPPER.writeValue\u2026ettings\n                )");
        return new AttachmentItem(string, n, string2, string3, string4, string5, l, string6, string7, string8, a.getCreatedDate());
    }

    @Autowired
    public SQLiteAttachmentService(@NotNull AttachmentRepository repository) {
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        this.repository = repository;
    }

    public static final /* synthetic */ Attachment access$toAttachment(SQLiteAttachmentService $this, AttachmentItem $this$access_u24toAttachment) {
        return $this.toAttachment($this$access_u24toAttachment);
    }
}

