/*
 * Decompiled with CFR 0.152.
 */
package ai.dstack.server.local.cli.sqlite.services;

import ai.dstack.server.local.cli.sqlite.OptionalToNullableKt;
import ai.dstack.server.local.cli.sqlite.model.CardId;
import ai.dstack.server.local.cli.sqlite.model.CardItem;
import ai.dstack.server.local.cli.sqlite.repositories.CardRepository;
import ai.dstack.server.model.Card;
import ai.dstack.server.services.CardService;
import ai.dstack.server.services.EntityAlreadyExists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\u0016\u0010\u0016\u001a\u00020\u000b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015H\u0016J\f\u0010\u0018\u001a\u00020\u0007*\u00020\u0019H\u0002J\f\u0010\u001a\u001a\u00020\u0019*\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lai/dstack/server/local/cli/sqlite/services/SQLiteCardService;", "Lai/dstack/server/services/CardService;", "repository", "Lai/dstack/server/local/cli/sqlite/repositories/CardRepository;", "(Lai/dstack/server/local/cli/sqlite/repositories/CardRepository;)V", "mapId", "Lai/dstack/server/local/cli/sqlite/model/CardId;", "Lai/dstack/server/model/Card;", "getMapId", "(Lai/dstack/server/model/Card;)Lai/dstack/server/local/cli/sqlite/model/CardId;", "create", "", "card", "delete", "deleteByDashboardPath", "dashboardPath", "", "deleteByStackPath", "stackPath", "get", "getByDashboardPath", "", "update", "cards", "toCard", "Lai/dstack/server/local/cli/sqlite/model/CardItem;", "toCardItem", "server-local-cli"})
public final class SQLiteCardService
implements CardService {
    private final CardRepository repository;

    public void create(@NotNull Card card) {
        Intrinsics.checkParameterIsNotNull((Object)card, (String)"card");
        if (this.repository.existsById((Object)this.getMapId(card))) {
            throw (Throwable)new EntityAlreadyExists(null, 1, null);
        }
        this.repository.save((Object)this.toCardItem(card));
    }

    @NotNull
    public List<Card> getByDashboardPath(@NotNull String dashboardPath) {
        Intrinsics.checkParameterIsNotNull((Object)dashboardPath, (String)"dashboardPath");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.repository.findAllByDashboard(dashboardPath)), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */)));
    }

    @Nullable
    public Card get(@NotNull String dashboardPath, @NotNull String stackPath) {
        Intrinsics.checkParameterIsNotNull((Object)dashboardPath, (String)"dashboardPath");
        Intrinsics.checkParameterIsNotNull((Object)stackPath, (String)"stackPath");
        Optional optional = this.repository.findById((Object)this.mapId(dashboardPath, stackPath));
        Intrinsics.checkExpressionValueIsNotNull((Object)optional, (String)"repository.findById(mapI\u2026ashboardPath, stackPath))");
        CardItem cardItem = (CardItem)OptionalToNullableKt.toNullable((Optional)optional);
        return cardItem != null ? this.toCard(cardItem) : null;
    }

    public void update(@NotNull List<Card> cards) {
        Intrinsics.checkParameterIsNotNull(cards, (String)"cards");
        Iterable $this$forEach$iv = cards;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Card card = (Card)element$iv;
            boolean bl = false;
            this.repository.save((Object)this.toCardItem(card));
        }
    }

    public void delete(@NotNull Card card) {
        Intrinsics.checkParameterIsNotNull((Object)card, (String)"card");
        this.repository.delete((Object)this.toCardItem(card));
    }

    /*
     * WARNING - void declaration
     */
    public void deleteByDashboardPath(@NotNull String dashboardPath) {
        Collection<CardItem> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)dashboardPath, (String)"dashboardPath");
        Iterable iterable = this.getByDashboardPath(dashboardPath);
        CardRepository cardRepository = this.repository;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Card card = (Card)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            CardItem cardItem = this.toCardItem((Card)it);
            collection.add(cardItem);
        }
        collection = (List)destination$iv$iv;
        cardRepository.deleteAll((Iterable)CollectionsKt.toList((Iterable)collection));
    }

    public void deleteByStackPath(@NotNull String stackPath) {
        Intrinsics.checkParameterIsNotNull((Object)stackPath, (String)"stackPath");
        this.repository.deleteAll((Iterable)CollectionsKt.toList((Iterable)this.repository.findAllByStack(stackPath)));
    }

    private final CardId getMapId(@NotNull Card $this$mapId) {
        return this.mapId($this$mapId.getDashboardPath(), $this$mapId.getStackPath());
    }

    private final CardId mapId(String dashboardPath, String stackPath) {
        return new CardId(dashboardPath, stackPath);
    }

    private final Card toCard(@NotNull CardItem $this$toCard) {
        CardItem cardItem = $this$toCard;
        boolean bl = false;
        boolean bl2 = false;
        CardItem c = cardItem;
        boolean bl3 = false;
        return new Card(c.getDashboard(), c.getIndex(), c.getStack(), c.getTitle());
    }

    private final CardItem toCardItem(@NotNull Card $this$toCardItem) {
        Card card = $this$toCardItem;
        boolean bl = false;
        boolean bl2 = false;
        Card c = card;
        boolean bl3 = false;
        return new CardItem(c.getDashboardPath(), c.getStackPath(), c.getIndex(), c.getTitle());
    }

    @Autowired
    public SQLiteCardService(@NotNull CardRepository repository) {
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        this.repository = repository;
    }

    public static final /* synthetic */ Card access$toCard(SQLiteCardService $this, CardItem $this$access_u24toCard) {
        return $this.toCard($this$access_u24toCard);
    }
}

