/*
 * Decompiled with CFR 0.152.
 */
package ai.dstack.server.local.cli.sqlite.services;

import ai.dstack.server.local.cli.sqlite.OptionalToNullableKt;
import ai.dstack.server.local.cli.sqlite.model.FrameId;
import ai.dstack.server.local.cli.sqlite.model.FrameItem;
import ai.dstack.server.local.cli.sqlite.repositories.FrameRepository;
import ai.dstack.server.model.Frame;
import ai.dstack.server.services.EntityAlreadyExists;
import ai.dstack.server.services.FrameService;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\f\u0010\u0014\u001a\u00020\u0007*\u00020\u0015H\u0002J\f\u0010\u0016\u001a\u00020\u0015*\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lai/dstack/server/local/cli/sqlite/services/SQLiteFrameService;", "Lai/dstack/server/services/FrameService;", "repository", "Lai/dstack/server/local/cli/sqlite/repositories/FrameRepository;", "(Lai/dstack/server/local/cli/sqlite/repositories/FrameRepository;)V", "mapId", "Lai/dstack/server/local/cli/sqlite/model/FrameId;", "Lai/dstack/server/model/Frame;", "getMapId", "(Lai/dstack/server/model/Frame;)Lai/dstack/server/local/cli/sqlite/model/FrameId;", "create", "", "frame", "findByStackPath", "", "stackPath", "", "get", "frameId", "update", "toFrame", "Lai/dstack/server/local/cli/sqlite/model/FrameItem;", "toFrameItem", "server-local-cli"})
public final class SQLiteFrameService
implements FrameService {
    private final FrameRepository repository;

    @Nullable
    public Frame get(@NotNull String stackPath, @NotNull String frameId) {
        Intrinsics.checkParameterIsNotNull((Object)stackPath, (String)"stackPath");
        Intrinsics.checkParameterIsNotNull((Object)frameId, (String)"frameId");
        Optional optional = this.repository.findById((Object)this.mapId(stackPath, frameId));
        Intrinsics.checkExpressionValueIsNotNull((Object)optional, (String)"repository.findById(mapId(stackPath, frameId))");
        FrameItem frameItem = (FrameItem)OptionalToNullableKt.toNullable((Optional)optional);
        return frameItem != null ? this.toFrame(frameItem) : null;
    }

    public void create(@NotNull Frame frame) {
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        if (this.repository.existsById((Object)this.getMapId(frame))) {
            throw (Throwable)new EntityAlreadyExists(null, 1, null);
        }
        this.repository.save((Object)this.toFrameItem(frame));
    }

    public void update(@NotNull Frame frame) {
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        this.repository.save((Object)this.toFrameItem(frame));
    }

    @NotNull
    public List<Frame> findByStackPath(@NotNull String stackPath) {
        Intrinsics.checkParameterIsNotNull((Object)stackPath, (String)"stackPath");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.repository.findAllByStack(stackPath)), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */)));
    }

    private final FrameId getMapId(@NotNull Frame $this$mapId) {
        return this.mapId($this$mapId.getStackPath(), $this$mapId.getId());
    }

    private final FrameId mapId(String stackPath, String frameId) {
        return new FrameId(stackPath, frameId);
    }

    private final Frame toFrame(@NotNull FrameItem $this$toFrame) {
        FrameItem frameItem = $this$toFrame;
        boolean bl = false;
        boolean bl2 = false;
        FrameItem f = frameItem;
        boolean bl3 = false;
        return new Frame(f.getStack(), f.getId(), f.getTimestamp(), f.getSize(), f.getMessage());
    }

    private final FrameItem toFrameItem(@NotNull Frame $this$toFrameItem) {
        Frame frame = $this$toFrameItem;
        boolean bl = false;
        boolean bl2 = false;
        Frame f = frame;
        boolean bl3 = false;
        return new FrameItem(f.getStackPath(), f.getId(), f.getTimestampMillis(), f.getSize(), f.getMessage());
    }

    @Autowired
    public SQLiteFrameService(@NotNull FrameRepository repository) {
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        this.repository = repository;
    }

    public static final /* synthetic */ Frame access$toFrame(SQLiteFrameService $this, FrameItem $this$access_u24toFrame) {
        return $this.toFrame($this$access_u24toFrame);
    }
}

