/*
 * Decompiled with CFR 0.152.
 */
package ai.dstack.server.local.cli.sqlite.services;

import ai.dstack.server.local.cli.sqlite.OptionalToNullableKt;
import ai.dstack.server.local.cli.sqlite.model.PermissionId;
import ai.dstack.server.local.cli.sqlite.model.PermissionItem;
import ai.dstack.server.local.cli.sqlite.repositories.PermissionRepository;
import ai.dstack.server.model.Permission;
import ai.dstack.server.services.EntityAlreadyExists;
import ai.dstack.server.services.PermissionService;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0010H\u0016J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0010H\u0002J\f\u0010\u0019\u001a\u00020\u0007*\u00020\u001aH\u0002J\f\u0010\u001b\u001a\u00020\u001a*\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001c"}, d2={"Lai/dstack/server/local/cli/sqlite/services/SQLitePermissionService;", "Lai/dstack/server/services/PermissionService;", "repository", "Lai/dstack/server/local/cli/sqlite/repositories/PermissionRepository;", "(Lai/dstack/server/local/cli/sqlite/repositories/PermissionRepository;)V", "mapId", "Lai/dstack/server/local/cli/sqlite/model/PermissionId;", "Lai/dstack/server/model/Permission;", "getMapId", "(Lai/dstack/server/model/Permission;)Lai/dstack/server/local/cli/sqlite/model/PermissionId;", "add", "", "permission", "delete", "deleteByPath", "path", "", "findByIdentity", "Lkotlin/sequences/Sequence;", "identity", "findByPath", "get", "user", "stackPath", "userNameOrEmail", "toPermission", "Lai/dstack/server/local/cli/sqlite/model/PermissionItem;", "toPermissionItem", "server-local-cli"})
public final class SQLitePermissionService
implements PermissionService {
    private final PermissionRepository repository;

    @Nullable
    public Permission get(@NotNull String path, @NotNull String user) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Optional optional = this.repository.findById((Object)this.mapId(path, user));
        Intrinsics.checkExpressionValueIsNotNull((Object)optional, (String)"repository.findById(mapId(path, user))");
        PermissionItem permissionItem = (PermissionItem)OptionalToNullableKt.toNullable((Optional)optional);
        return permissionItem != null ? this.toPermission(permissionItem) : null;
    }

    public void add(@NotNull Permission permission) {
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        if (this.repository.existsById((Object)this.getMapId(permission))) {
            throw (Throwable)new EntityAlreadyExists(null, 1, null);
        }
        this.repository.save((Object)this.toPermissionItem(permission));
    }

    public void delete(@NotNull Permission permission) {
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        this.repository.deleteById((Object)this.getMapId(permission));
    }

    public void deleteByPath(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.repository.deleteAll(this.repository.findAllByPath(path));
    }

    @NotNull
    public Sequence<Permission> findByPath(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.repository.findAllByPath(path)), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */));
    }

    @NotNull
    public Sequence<Permission> findByIdentity(@NotNull String identity) {
        Intrinsics.checkParameterIsNotNull((Object)identity, (String)"identity");
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.repository.findAllByIdentity(identity)), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */));
    }

    private final PermissionId getMapId(@NotNull Permission $this$mapId) {
        return this.mapId($this$mapId.getPath(), $this$mapId.getIdentity());
    }

    private final PermissionId mapId(String stackPath, String userNameOrEmail) {
        return new PermissionId(stackPath, userNameOrEmail);
    }

    private final Permission toPermission(@NotNull PermissionItem $this$toPermission) {
        PermissionItem permissionItem = $this$toPermission;
        boolean bl = false;
        boolean bl2 = false;
        PermissionItem p = permissionItem;
        boolean bl3 = false;
        return new Permission(p.getPath(), p.getIdentity());
    }

    private final PermissionItem toPermissionItem(@NotNull Permission $this$toPermissionItem) {
        return new PermissionItem($this$toPermissionItem.getPath(), $this$toPermissionItem.getIdentity());
    }

    @Autowired
    public SQLitePermissionService(@NotNull PermissionRepository repository) {
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        this.repository = repository;
    }

    public static final /* synthetic */ Permission access$toPermission(SQLitePermissionService $this, PermissionItem $this$access_u24toPermission) {
        return $this.toPermission($this$access_u24toPermission);
    }
}

