/*
 * Decompiled with CFR 0.152.
 */
package ai.eloquent.data;

import ai.eloquent.data.Transport;
import ai.eloquent.data.UDPBroadcastProtos;
import ai.eloquent.io.IOUtils;
import ai.eloquent.monitoring.Prometheus;
import ai.eloquent.raft.RaftLifecycle;
import ai.eloquent.util.IdentityHashSet;
import ai.eloquent.util.Lazy;
import ai.eloquent.util.SafeTimerTask;
import ai.eloquent.util.StringUtils;
import ai.eloquent.util.SystemUtils;
import ai.eloquent.util.TimerUtils;
import ai.eloquent.util.ZipUtils;
import com.google.protobuf.ByteString;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDPTransport
implements Transport {
    private static final Logger log = LoggerFactory.getLogger(UDPTransport.class);
    private static final Pattern IP_REGEX = Pattern.compile("^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$");
    private static final int DEFAULT_UDP_LISTEN_PORT = 42888;
    private static final int DEFAULT_TCP_LISTEN_PORT = 42888;
    private static final int MAX_UDP_PACKET_SIZE = 65000;
    private static boolean networkSeemsDown = false;
    public final InetAddress serverName;
    private final String serverAddress;
    public final boolean thread;
    public final boolean zip;
    private InetAddress[] broadcastAddrs;
    private final boolean isRealBroadcast;
    private long lastMessageReceived = 0L;
    private long lastMessageSent = 0L;
    private final int udpListenPort;
    private final int tcpListenPort;
    private DatagramSocket socket;
    private DatagramSocket serverSocket;
    private final Map<UDPBroadcastProtos.MessageType, IdentityHashSet<Consumer<byte[]>>> listeners = new HashMap<UDPBroadcastProtos.MessageType, IdentityHashSet<Consumer<byte[]>>>();
    private final Map<byte[], Long> pingsReceived = new HashMap<byte[], Long>();
    public final int mtu;
    public final boolean allowJumboPackets;
    private final Queue<Runnable> sendQueue = new ArrayDeque<Runnable>();
    Object summaryTimer = Prometheus.summaryBuild("udp_transport", "Statistics on the UDP Transport calls", "operation");
    final Map<InetAddress, Socket> tcpSocketCache = new HashMap<InetAddress, Socket>();
    public static Lazy<Transport> DEFAULT = Lazy.of(() -> {
        try {
            return new UDPTransport();
        }
        catch (IOException iOException) {
            log.warn("UDPTransport already bound to address! Returning mock implementation");
            return new Transport(){

                @Override
                public void bind(UDPBroadcastProtos.MessageType messageType, Consumer<byte[]> consumer) {
                    log.warn("UDP address is in use: cannot bind to transport");
                }

                @Override
                public boolean sendTransport(String string, UDPBroadcastProtos.MessageType messageType, byte[] byArray) {
                    log.warn("UDP address is in use: cannot send on transport");
                    return false;
                }

                @Override
                public boolean broadcastTransport(UDPBroadcastProtos.MessageType messageType, byte[] byArray) {
                    log.warn("UDP address is in use: cannot broadcast on transport");
                    return false;
                }
            };
        }
    });

    private UDPTransport(int n, int n2, boolean bl, boolean bl2, boolean bl3) throws IOException {
        List<InterfaceAddress> list;
        Object object2;
        this.udpListenPort = n;
        this.tcpListenPort = n2;
        this.serverName = InetAddress.getLocalHost();
        this.serverAddress = this.serverName.getHostAddress();
        this.socket = new DatagramSocket();
        this.socket.setSendBufferSize(65000);
        this.socket.setReceiveBufferSize(65000);
        this.serverSocket = new DatagramSocket(n);
        this.thread = bl;
        this.zip = bl2;
        this.allowJumboPackets = bl3;
        InetAddress inetAddress = null;
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        int n3 = 65000;
        while (enumeration.hasMoreElements()) {
            int n4;
            object2 = enumeration.nextElement();
            if (!((NetworkInterface)object2).isUp() || ((NetworkInterface)object2).isLoopback()) continue;
            list = ((NetworkInterface)object2).getInterfaceAddresses();
            if (!list.isEmpty() && (n4 = ((NetworkInterface)object2).getMTU() - 20) < n3) {
                n3 = n4;
            }
            for (InterfaceAddress object3 : list) {
                if (object3.getBroadcast() == null) continue;
                inetAddress = object3.getBroadcast();
                log.info("Found broadcast address: {}", (Object)object3.getBroadcast());
            }
        }
        this.mtu = n3;
        log.info("Setting MTU to {}", (Object)this.mtu);
        if (inetAddress != null && !inetAddress.getHostAddress().equals("0.0.0.0")) {
            log.info("Using real broadcast address to broadcast");
            this.broadcastAddrs = new InetAddress[]{inetAddress};
            this.isRealBroadcast = true;
        } else {
            log.info("Using Kubernetes state to broadcast");
            this.isRealBroadcast = false;
            this.broadcastAddrs = UDPTransport.readKubernetesState();
            RaftLifecycle.global.timer.get().scheduleAtFixedRate(new SafeTimerTask(){

                @Override
                public void runUnsafe() throws Throwable {
                    Object[] objectArray = UDPTransport.this.broadcastAddrs;
                    UDPTransport.access$002(UDPTransport.this, (InetAddress[])Arrays.stream(UDPTransport.readKubernetesState()).filter(inetAddress -> {
                        try {
                            return inetAddress.isReachable(100);
                        }
                        catch (IOException iOException) {
                            return false;
                        }
                    }).toArray(InetAddress[]::new));
                    if (UDPTransport.this.broadcastAddrs.length == 0) {
                        log.warn("Could not read Kubernetes configuration (no nodes present)");
                        UDPTransport.access$002(UDPTransport.this, (InetAddress[])objectArray);
                    }
                    if (!Arrays.equals(objectArray, UDPTransport.this.broadcastAddrs)) {
                        log.info("detected change in online nodes: {}  (from {})", (Object)StringUtils.join(UDPTransport.this.broadcastAddrs, ","), (Object)StringUtils.join(objectArray, ","));
                    }
                    for (InetAddress inetAddress2 : UDPTransport.this.broadcastAddrs) {
                        UDPTransport.this.getTcpSocket(inetAddress2, true);
                    }
                    UDPTransport.this.broadcastTransport(UDPBroadcastProtos.MessageType.PING, UDPTransport.this.serverName.getAddress());
                }
            }, Duration.ofSeconds(10L), Duration.ofSeconds(10L));
        }
        log.info("Broadcast addresses are [{}] (is_inferred={})", (Object)StringUtils.join(this.broadcastAddrs, ", "), (Object)(inetAddress != null ? 1 : 0));
        if (this.isRealBroadcast) {
            this.socket.setBroadcast(true);
        }
        this.socket.setTrafficClass(16);
        log.info("Binding UDP to " + n);
        object2 = new Thread(() -> this.lambda$new$1(n, bl));
        ((Thread)object2).setDaemon(true);
        ((Thread)object2).setName("udp-listener");
        ((Thread)object2).setUncaughtExceptionHandler((thread, throwable) -> log.warn("Uncaught exception on thread {}: ", (Object)thread, (Object)throwable));
        ((Thread)object2).setPriority(9);
        ((Thread)object2).start();
        log.info("Binding TCP to " + n2);
        list = new Thread(() -> this.lambda$new$6(n2, bl));
        ((Thread)((Object)list)).setDaemon(true);
        ((Thread)((Object)list)).setName("tcp-listener");
        ((Thread)((Object)list)).setUncaughtExceptionHandler((thread, throwable) -> log.warn("Uncaught exception on thread {}: ", (Object)thread, (Object)throwable));
        ((Thread)((Object)list)).setPriority(9);
        ((Thread)((Object)list)).start();
        log.info("Starting sender thread" + n2);
        final AtomicLong atomicLong = new AtomicLong(-1L);
        final Thread thread2 = new Thread(() -> {
            block9: while (true) {
                try {
                    while (true) {
                        Object object = this.sendQueue;
                        synchronized (object) {
                            while (this.sendQueue.isEmpty()) {
                                try {
                                    this.sendQueue.wait(100L);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                        }
                        object = this.sendQueue.poll();
                        try {
                            if (object == null) continue block9;
                            atomicLong.set(System.currentTimeMillis());
                            object.run();
                            atomicLong.set(-1L);
                            continue block9;
                        }
                        catch (Exception exception) {
                            log.warn("Could not send message: {}: {}", (Object)exception.getClass().getSimpleName(), (Object)exception.getMessage());
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    log.warn("Caught exception sending message on transport: ", throwable);
                    continue;
                }
                break;
            }
        });
        thread2.setDaemon(true);
        thread2.setName("transport-sender");
        thread2.setUncaughtExceptionHandler((thread, throwable) -> log.warn("Uncaught exception on thread {}: ", (Object)thread, (Object)throwable));
        thread2.setPriority(9);
        thread2.start();
        RaftLifecycle.global.timer.get().scheduleAtFixedRate(new SafeTimerTask(){

            @Override
            public void runUnsafe() {
                if (System.currentTimeMillis() - atomicLong.get() > 100L) {
                    thread2.interrupt();
                }
            }
        }, Duration.ofMillis(100L));
    }

    public UDPTransport() throws IOException {
        this(42888, 42888, false, false, false);
    }

    public static InetAddress[] readKubernetesState() throws IOException {
        String string2 = System.getenv("ELOQUENT_RAFT_MEMBERS");
        if (string2 == null || "".equals(string2)) {
            throw new FileNotFoundException("Could not find Kubernetes file variable ELOQUENT_RAFT_MEMBERS");
        }
        String[] stringArray2 = IOUtils.slurpReader(IOUtils.readerFromString(string2)).split("\n");
        return (InetAddress[])Arrays.stream(stringArray2).filter(string -> string.trim().length() > 0).map(string -> string.split("\\t|\\s{2,}")).filter(stringArray -> ((String[])stringArray).length > 0 && IP_REGEX.matcher(stringArray[0]).matches()).map(stringArray -> {
            try {
                return InetAddress.getByName(stringArray[0]);
            }
            catch (UnknownHostException unknownHostException) {
                log.warn("Unknown host: " + stringArray[0]);
                return null;
            }
        }).filter(Objects::nonNull).toArray(InetAddress[]::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(UDPBroadcastProtos.MessageType messageType2, Consumer<byte[]> consumer) {
        Map<UDPBroadcastProtos.MessageType, IdentityHashSet<Consumer<byte[]>>> map = this.listeners;
        synchronized (map) {
            IdentityHashSet identityHashSet = this.listeners.computeIfAbsent(messageType2, messageType -> new IdentityHashSet());
            identityHashSet.add(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendTransport(String string, UDPBroadcastProtos.MessageType messageType, byte[] byArray) {
        try {
            byte[] byArray2;
            UDPBroadcastProtos.UDPPacket uDPPacket = UDPBroadcastProtos.UDPPacket.newBuilder().setIsBroadcast(false).setType(messageType).setSender(this.serverAddress).setContents(ByteString.copyFrom((byte[])byArray)).build();
            byte[] byArray3 = byArray2 = this.zip ? ZipUtils.gzip(uDPPacket.toByteArray()) : uDPPacket.toByteArray();
            if (this.allowJumboPackets && byArray2.length < 65000 || !this.allowJumboPackets && byArray2.length < this.mtu) {
                DatagramPacket datagramPacket = new DatagramPacket(byArray2, byArray2.length, InetAddress.getByName(string), this.udpListenPort);
                if (this.socket.isClosed()) {
                    UDPTransport uDPTransport = this;
                    synchronized (uDPTransport) {
                        if (this.socket.isClosed()) {
                            log.info("UDP socket was closed (in send call) -- reopening");
                            this.socket = new DatagramSocket();
                            this.socket.setSendBufferSize(65000);
                            if (this.isRealBroadcast) {
                                this.socket.setBroadcast(true);
                            }
                            this.socket.setTrafficClass(16);
                        }
                    }
                }
                long l = System.currentTimeMillis();
                try {
                    this.socket.send(datagramPacket);
                }
                finally {
                    long l2 = System.currentTimeMillis();
                    if (l2 > l + 10L) {
                        log.warn("Sending a direct message on the UDP socket took {}", (Object)TimerUtils.formatTimeDifference(l2 - l));
                    }
                }
                if (networkSeemsDown) {
                    log.info("Network is back up");
                }
                networkSeemsDown = false;
                boolean bl = true;
                return bl;
            }
            log.debug("Message is too long to send as a single packet ({}); sending over TCP", (Object)byArray2.length);
            Optional<Socket> optional = this.getTcpSocket(InetAddress.getByName(string), false);
            optional.ifPresent(socket -> this.safeWrite(uDPPacket, (Socket)socket, "sendTransport"));
        }
        catch (SocketException socketException) {
            log.warn("Could not create datagram socket: ", (Throwable)socketException);
        }
        catch (UnknownHostException unknownHostException) {
            log.warn("No such destination: ", (Throwable)unknownHostException);
        }
        catch (IOException iOException) {
            if (iOException.getMessage() != null && (iOException.getMessage().equals("Network is unreachable") || iOException.getMessage().equals("Network is down"))) {
                if (!networkSeemsDown) {
                    log.warn("Network seems to have disconnected! UDPTransport is not sending messages");
                }
                networkSeemsDown = true;
            } else {
                log.warn("Could not send message on datagram socket: ", (Throwable)iOException);
            }
        }
        finally {
            this.lastMessageSent = System.currentTimeMillis();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<Socket> getTcpSocket(InetAddress inetAddress, boolean bl) {
        Socket socket;
        Object object = this.tcpSocketCache;
        synchronized (object) {
            socket = this.tcpSocketCache.get(inetAddress);
            if (socket == null && !bl && this.tcpSocketCache.containsKey(inetAddress)) {
                return Optional.empty();
            }
        }
        if (socket == null || socket.isClosed()) {
            block26: {
                try {
                    if (inetAddress.isReachable(100)) break block26;
                    object = this.tcpSocketCache;
                    synchronized (object) {
                        this.tcpSocketCache.put(inetAddress, null);
                    }
                    log.warn("{} is reachable: ", (Object)inetAddress);
                    return Optional.empty();
                }
                catch (IOException iOException) {
                    log.warn("Could not check if {} is reachable: ", (Object)inetAddress, (Object)iOException);
                    Map<InetAddress, Socket> map = this.tcpSocketCache;
                    synchronized (map) {
                        this.tcpSocketCache.put(inetAddress, null);
                    }
                    return Optional.empty();
                }
            }
            object = new CompletableFuture();
            Thread thread2 = new Thread(() -> this.lambda$getTcpSocket$17(inetAddress, (CompletableFuture)object));
            thread2.setName("socket-creator-" + inetAddress.getHostAddress());
            thread2.setDaemon(true);
            thread2.setUncaughtExceptionHandler((thread, throwable) -> log.warn("Uncaught exception on {}: ", (Object)thread, (Object)throwable));
            thread2.start();
            try {
                socket = (Socket)((CompletableFuture)object).get(5L, TimeUnit.SECONDS);
                Map<InetAddress, Socket> map = this.tcpSocketCache;
                synchronized (map) {
                    Socket socket2 = this.tcpSocketCache.get(inetAddress);
                    if (socket2 != null && !socket2.isClosed()) {
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {}
                    } else {
                        this.tcpSocketCache.put(inetAddress, socket);
                    }
                }
                log.info("refreshed TCP socket for {}", (Object)inetAddress);
            }
            catch (InterruptedException | ExecutionException | TimeoutException exception) {
                log.warn("Could not create TCP socket to {} -- exception on future: ", (Object)inetAddress, (Object)exception);
                Optional<Socket> optional = Optional.empty();
                return optional;
            }
            finally {
                if (thread2.isAlive()) {
                    thread2.interrupt();
                }
            }
        }
        return Optional.of(socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean broadcastTransport(UDPBroadcastProtos.MessageType messageType, byte[] byArray) {
        long l = System.currentTimeMillis();
        try {
            byte[] byArray2;
            UDPBroadcastProtos.UDPPacket uDPPacket;
            block30: {
                uDPPacket = UDPBroadcastProtos.UDPPacket.newBuilder().setIsBroadcast(true).setType(messageType).setSender(this.serverAddress).setContents(ByteString.copyFrom((byte[])byArray)).build();
                byArray2 = this.zip ? ZipUtils.gzip(uDPPacket.toByteArray()) : uDPPacket.toByteArray();
                boolean bl = true;
                if ((!this.allowJumboPackets || byArray2.length >= 65000) && (this.allowJumboPackets || byArray2.length >= this.mtu)) break block30;
                for (InetAddress inetAddress : this.broadcastAddrs) {
                    long l2 = System.currentTimeMillis();
                    try {
                        if (inetAddress.equals(this.serverName)) continue;
                        DatagramPacket datagramPacket = new DatagramPacket(byArray2, byArray2.length, inetAddress, this.udpListenPort);
                        if (this.socket.isClosed()) {
                            UDPTransport uDPTransport = this;
                            synchronized (uDPTransport) {
                                if (this.socket.isClosed()) {
                                    log.info("UDP socket was closed (in broadcast call) -- reopening");
                                    this.socket = new DatagramSocket();
                                    this.socket.setSendBufferSize(65000);
                                    if (this.isRealBroadcast) {
                                        this.socket.setBroadcast(true);
                                    }
                                    this.socket.setTrafficClass(16);
                                }
                            }
                        }
                        long l3 = System.currentTimeMillis();
                        try {
                            this.socket.send(datagramPacket);
                        }
                        catch (Throwable throwable) {
                            long l4 = System.currentTimeMillis();
                            if (l4 > l3 + 10L) {
                                log.warn("Sending a broadcast to {} on the UDP socket took {} for packet of length {}", new Object[]{inetAddress, TimerUtils.formatTimeDifference(l4 - l3), datagramPacket.getLength()});
                            }
                            throw throwable;
                        }
                        long l5 = System.currentTimeMillis();
                        if (l5 > l3 + 10L) {
                            log.warn("Sending a broadcast to {} on the UDP socket took {} for packet of length {}", new Object[]{inetAddress, TimerUtils.formatTimeDifference(l5 - l3), datagramPacket.getLength()});
                        }
                        if (networkSeemsDown) {
                            log.info("Network is back up");
                        }
                        networkSeemsDown = false;
                    }
                    catch (Throwable throwable) {
                        bl = false;
                        if (throwable.getMessage() != null && (throwable.getMessage().equals("Network is unreachable") || throwable.getMessage().equals("Network is down"))) {
                            if (!networkSeemsDown) {
                                log.warn("Network seems to have disconnected! UDPTransport is not sending messages");
                            }
                            networkSeemsDown = true;
                            continue;
                        }
                        log.warn("Could not broadcast to " + inetAddress + " (attempt took " + TimerUtils.formatTimeSince(l2) + ") -- still trying other addressed", throwable);
                    }
                    finally {
                        long l6 = System.currentTimeMillis();
                        if (l6 > l2 + 10L) {
                            log.warn("Sending broadcast to {} on transport took {}", (Object)inetAddress, (Object)TimerUtils.formatTimeDifference(l6 - l2));
                        }
                    }
                }
                boolean bl2 = bl;
                return bl2;
            }
            if (!this.isRealBroadcast) {
                log.debug("Message is too long to send as a single packet ({}) -- broadcasting over TCP", (Object)byArray2.length);
                for (InetAddress inetAddress : this.broadcastAddrs) {
                    try {
                        Optional<Socket> optional = this.getTcpSocket(inetAddress, false);
                        optional.ifPresent(socket -> this.safeWrite(uDPPacket, (Socket)socket, "broadcastTransport"));
                    }
                    catch (Throwable throwable) {
                        log.warn("Unhandled exception sending message on TCP socket", throwable);
                    }
                }
            } else {
                log.debug("Message is too long to send as a single packet ({}), and we only have a broadcast address", (Object)byArray2.length);
            }
        }
        finally {
            this.lastMessageSent = System.currentTimeMillis();
            log.trace("Sending UDP broadcast took {}", (Object)TimerUtils.formatTimeSince(l));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safeWrite(UDPBroadcastProtos.UDPPacket uDPPacket, Socket socket, String string) {
        Queue<Runnable> queue = this.sendQueue;
        synchronized (queue) {
            if (this.sendQueue.size() < 10000) {
                this.sendQueue.offer(() -> {
                    Socket socket2 = socket;
                    synchronized (socket2) {
                        try {
                            uDPPacket.writeDelimitedTo(socket.getOutputStream());
                        }
                        catch (IOException iOException) {
                            log.info("IO or Socket exception writing to TCP socket ({}): {}", (Object)string, (Object)iOException.getMessage());
                            try {
                                socket.close();
                            }
                            catch (Throwable throwable) {}
                        }
                        catch (Throwable throwable) {
                            log.warn("Unknown exception writing to TCP socket (" + string + "): ", throwable);
                        }
                    }
                });
                this.sendQueue.notify();
            }
        }
    }

    private Set<String> liveServers(long l) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Map.Entry<byte[], Long> entry : this.pingsReceived.entrySet()) {
            if (Math.abs(entry.getValue() - System.currentTimeMillis()) >= l) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (byte by : entry.getKey()) {
                arrayList.add(Integer.toString((by + 256) % 256));
            }
            hashSet.add(StringUtils.join(arrayList, "."));
        }
        return hashSet;
    }

    public String toString() {
        return "UDP@" + SystemUtils.HOST + " (" + this.serverAddress + ")  <last message sent " + TimerUtils.formatTimeSince(this.lastMessageSent) + " ago; received " + TimerUtils.formatTimeSince(this.lastMessageReceived) + " ago>  <broadcasting to " + Arrays.asList(this.broadcastAddrs) + ">  <pings from " + StringUtils.join(this.liveServers(60000L), ", ") + ">";
    }

    public static void main(String[] stringArray) throws IOException {
        new UDPTransport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$getTcpSocket$17(InetAddress inetAddress, CompletableFuture completableFuture) {
        try {
            Socket socket = new Socket(inetAddress, this.tcpListenPort);
            CompletableFuture completableFuture2 = completableFuture;
            synchronized (completableFuture2) {
                completableFuture.complete(socket);
            }
        }
        catch (IOException iOException) {
            completableFuture.completeExceptionally(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$new$6(int var1_1, boolean var2_2) {
        try {
            try {
                var3_3 = new ServerSocket(var1_1);
                UDPTransport.log.info("Started TCP listener thread");
                while (true) lbl-1000:
                // 5 sources

                {
                    try {
                        var4_5 = var3_3.accept();
                        var5_8 = new Thread((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$null$4(java.net.Socket boolean ), ()V)((UDPTransport)this, (Socket)var4_5, (boolean)var2_2));
                        var5_8.setDaemon(true);
                        var5_8.setName("tcp-listener-" + var4_5.getInetAddress().getHostName());
                        var5_8.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Thread;Ljava/lang/Throwable;)V, lambda$null$5(java.lang.Thread java.lang.Throwable ), (Ljava/lang/Thread;Ljava/lang/Throwable;)V)());
                        var5_8.setPriority(Math.max(5, 9));
                        var5_8.start();
                    }
                    catch (IOException var4_6) {
                        UDPTransport.log.warn("IOException receiving new socket on TCP: " + var4_6.getClass().getSimpleName() + ": " + var4_6.getMessage());
                    }
                    catch (Throwable var4_7) {
                        UDPTransport.log.warn("Caught throwable in TCP receive method: ", var4_7);
                    }
                    finally {
                        this.lastMessageReceived = System.currentTimeMillis();
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable var3_4) {
                UDPTransport.log.error("Could not establish TCP socket -- this is an error!");
                UDPTransport.log.error("Why did we shut down the transport listener thread?");
            }
            ** GOTO lbl-1000
        }
        catch (Throwable var7_10) {
            UDPTransport.log.error("Why did we shut down the transport listener thread?");
            throw var7_10;
        }
    }

    private static /* synthetic */ void lambda$null$5(Thread thread, Throwable throwable) {
        log.warn("Uncaught exception on {}: ", (Object)thread, (Object)throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$null$4(Socket socket, boolean bl) {
        try {
            while (!socket.isClosed()) {
                IdentityHashSet identityHashSet;
                UDPBroadcastProtos.UDPPacket uDPPacket = UDPBroadcastProtos.UDPPacket.parseDelimitedFrom(socket.getInputStream());
                if (uDPPacket == null) {
                    break;
                }
                Object object = Prometheus.startTimer(this.summaryTimer, "parse_tcp_packet");
                Object object2 = this.listeners;
                synchronized (object2) {
                    identityHashSet = new IdentityHashSet(this.listeners.get((Object)uDPPacket.getType()));
                }
                object2 = uDPPacket.getContents().toByteArray();
                Prometheus.observeDuration(object);
                for (Consumer consumer : identityHashSet) {
                    this.doAction(bl, "inbound TCP message of type " + (Object)((Object)uDPPacket.getType()), () -> UDPTransport.lambda$null$3(consumer, (byte[])object2));
                }
            }
        }
        catch (IOException iOException) {
            log.warn("IOException receiving packet from TCP: " + iOException.getClass().getSimpleName() + ": " + iOException.getMessage());
        }
        catch (Throwable throwable) {
            log.warn("Caught throwable in TCP RPC receive method: ", throwable);
        }
        finally {
            this.lastMessageReceived = System.currentTimeMillis();
            try {
                socket.close();
            }
            catch (IOException iOException) {
                log.warn("Could not close TCP socket: ", (Throwable)iOException);
            }
        }
    }

    private static /* synthetic */ void lambda$null$3(Consumer consumer, byte[] byArray) {
        consumer.accept(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$new$1(int var1_1, boolean var2_2) {
        try {
            var3_3 = new byte[65000];
            var4_4 = new DatagramPacket(var3_3, var3_3.length);
            UDPTransport.log.info("Started UDP listener thread");
            while (true) lbl-1000:
            // 9 sources

            {
                try {
                    if (this.serverSocket.isClosed()) {
                        UDPTransport.log.info("UDP socket was closed -- reopening");
                        this.serverSocket = new DatagramSocket(var1_1);
                    }
                    this.serverSocket.receive(var4_4);
                    var5_5 = Prometheus.startTimer(this.summaryTimer, new String[]{"parse_upd_packet"});
                    var6_8 = new byte[var4_4.getLength()];
                    System.arraycopy(var4_4.getData(), var4_4.getOffset(), var6_8, 0, var6_8.length);
                    if (this.zip) {
                        try {
                            var7_9 = ZipUtils.gunzip(var6_8);
                        }
                        catch (Throwable var8_11) {
                            var7_9 = var6_8;
                        }
                    } else {
                        var7_9 = var6_8;
                    }
                    if ((var8_10 = UDPBroadcastProtos.UDPPacket.parseFrom(var7_9)) == null) ** GOTO lbl-1000
                    Prometheus.observeDuration(var5_5);
                    if (var8_10.getType() == UDPBroadcastProtos.MessageType.PING) {
                        this.pingsReceived.put(var8_10.getContents().toByteArray(), System.currentTimeMillis());
                    }
                    if (var8_10.getIsBroadcast() && var8_10.getSender().equals(this.serverAddress)) ** GOTO lbl-1000
                    var10_13 = this.listeners;
                    synchronized (var10_13) {
                        var9_12 = this.listeners.get((Object)var8_10.getType());
                    }
                    if (var9_12 == null) ** GOTO lbl-1000
                    var10_13 = var9_12.iterator();
                    while (true) {
                        if (!var10_13.hasNext()) ** GOTO lbl-1000
                        var11_14 = (Consumer)var10_13.next();
                        this.doAction(var2_2, "inbound message of type " + (Object)var8_10.getType(), (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$null$0(java.util.function.Consumer ai.eloquent.data.UDPBroadcastProtos$UDPPacket ), ()V)((Consumer)var11_14, (UDPBroadcastProtos.UDPPacket)var8_10));
                    }
                }
                catch (IOException var5_6) {
                    UDPTransport.log.warn("IOException receiving packet from UDP: " + var5_6.getClass().getSimpleName() + ": " + var5_6.getMessage());
                }
                catch (Throwable var5_7) {
                    UDPTransport.log.warn("Caught throwable in UDP RPC receive method with packet length " + var4_4.getLength() + " (at offset " + var4_4.getOffset() + " in the buffer of size " + var4_4.getData().length + ") and with source " + var4_4.getAddress() + ": ", var5_7);
                }
                finally {
                    this.lastMessageReceived = System.currentTimeMillis();
                    continue;
                }
                break;
            }
        }
        catch (Throwable var13_17) {
            UDPTransport.log.error("Why did we shut down the transport listener thread?");
            throw var13_17;
        }
        ** GOTO lbl-1000
    }

    private static /* synthetic */ void lambda$null$0(Consumer consumer, UDPBroadcastProtos.UDPPacket uDPPacket) {
        consumer.accept(uDPPacket.getContents().toByteArray());
    }

    static /* synthetic */ InetAddress[] access$002(UDPTransport uDPTransport, InetAddress[] inetAddressArray) {
        uDPTransport.broadcastAddrs = inetAddressArray;
        return inetAddressArray;
    }
}

