/*
 * Decompiled with CFR 0.152.
 */
package ai.eloquent.io;

import ai.eloquent.util.RuntimeIOException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class IOUtils {
    private static final int SLURP_BUFFER_SIZE = 16384;

    private IOUtils() {
    }

    public static BufferedReader readerFromString(String string) throws IOException {
        return new BufferedReader(new InputStreamReader(IOUtils.getInputStreamFromURLOrClasspathOrFileSystem(string), "UTF-8"));
    }

    public static BufferedReader readerFromString(String string, String string2) throws IOException {
        InputStream inputStream = IOUtils.getInputStreamFromURLOrClasspathOrFileSystem(string);
        if (string2 == null) {
            return new BufferedReader(new InputStreamReader(inputStream));
        }
        return new BufferedReader(new InputStreamReader(inputStream, string2));
    }

    public static String slurpReader(Reader reader) {
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            int n;
            char[] cArray = new char[16384];
            while ((n = bufferedReader.read(cArray, 0, 16384)) >= 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (Exception exception) {
            throw new RuntimeIOException("slurpReader IO problem", exception);
        }
        return stringBuilder.toString();
    }

    public static InputStream getInputStreamFromURLOrClasspathOrFileSystem(String string) throws IOException, NullPointerException {
        InputStream inputStream;
        if (string == null) {
            throw new NullPointerException("Attempt to open file with null name");
        }
        if (string.matches("https?://.*")) {
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            inputStream = uRLConnection.getInputStream();
        } else {
            try {
                inputStream = IOUtils.findStreamInClasspathOrFileSystem(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    inputStream = uRLConnection.getInputStream();
                }
                catch (IOException iOException) {
                    throw new IOException("Unable to open \"" + string + "\" as class path, filename or URL");
                }
            }
        }
        if (string.endsWith(".gz")) {
            try {
                inputStream = new GZIPInputStream(inputStream);
            }
            catch (Exception exception) {
                throw new RuntimeIOException("Resource or file looks like a gzip file, but is not: " + string, exception);
            }
        }
        inputStream = new BufferedInputStream(inputStream);
        return inputStream;
    }

    private static InputStream findStreamInClasspathOrFileSystem(String string) throws FileNotFoundException {
        InputStream inputStream = IOUtils.class.getClassLoader().getResourceAsStream(string);
        if (inputStream == null && (inputStream = IOUtils.class.getClassLoader().getResourceAsStream(string.replaceAll("\\\\", "/"))) == null) {
            inputStream = IOUtils.class.getClassLoader().getResourceAsStream(string.replaceAll("\\\\", "/").replaceAll("/+", "/"));
        }
        if (inputStream == null) {
            inputStream = new FileInputStream(string);
        }
        return inputStream;
    }

    public static void writeStringToFile(String string, String string2, String string3) throws IOException {
        OutputStream outputStream = IOUtils.getBufferedOutputStream(string2);
        outputStream.write(string.getBytes(string3));
        outputStream.close();
    }

    private static OutputStream getBufferedOutputStream(String string) throws IOException {
        FilterOutputStream filterOutputStream = new BufferedOutputStream(new FileOutputStream(string));
        if (string.endsWith(".gz")) {
            filterOutputStream = new GZIPOutputStream(filterOutputStream);
        }
        return filterOutputStream;
    }
}

