/*
 * Decompiled with CFR 0.152.
 */
package ai.eloquent.monitoring;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Prometheus {
    private static final Logger log = LoggerFactory.getLogger(Prometheus.class);
    private static boolean havePrometheus = false;
    private static final HashMap<String, Object> summaries = new HashMap();
    private static final HashMap<String, Object> gauges = new HashMap();
    private static final HashMap<String, Object> counters = new HashMap();
    @Nullable
    private static Method SUMMARY_METHOD_BUILD;
    @Nullable
    private static Method SUMMARY_METHOD_LABELS;
    @Nullable
    private static Method SUMMARY_METHOD_STARTTIMER;
    @Nullable
    private static Method SUMMARYBUILDER_METHOD_LABELNAMES;
    @Nullable
    private static Method SUMMARYBUILDER_METHOD_REGISTER;
    @Nullable
    private static Method TIMER_METHOD_OBSERVE_DURATION;
    @Nullable
    private static Method GAUGE_METHOD_BUILD;
    @Nullable
    private static Method GAUGE_METHOD_GET;
    @Nullable
    private static Method GAUGE_METHOD_SET;
    @Nullable
    private static Method GAUGE_METHOD_INC;
    @Nullable
    private static Method GAUGE_METHOD_DEC;
    @Nullable
    private static Method GAUGEBUILDER_METHOD_REGISTER;
    @Nullable
    private static Method COUNTER_METHOD_BUILD;
    @Nullable
    private static Method COUNTER_METHOD_INC;
    @Nullable
    private static Method COUNTERBUILDER_METHOD_REGISTER;

    private Prometheus() {
    }

    static void resetMetrics() {
        summaries.clear();
        gauges.clear();
        counters.clear();
    }

    public static Object summaryBuild(String string, String string2, String ... stringArray) {
        Object object;
        if (havePrometheus && string != null) {
            try {
                if (!summaries.containsKey(string)) {
                    Object object2 = SUMMARY_METHOD_BUILD.invoke(null, string, string2);
                    object2 = SUMMARYBUILDER_METHOD_LABELNAMES.invoke(object2, new Object[]{stringArray});
                    object = SUMMARYBUILDER_METHOD_REGISTER.invoke(object2, new Object[0]);
                    summaries.put(string, object);
                }
                object = summaries.get(string);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getCause() != null && invocationTargetException.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)invocationTargetException.getCause();
                }
                log.warn("Invocation target exception", (Throwable)invocationTargetException);
                return new SummaryMock(string, stringArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                log.warn("Prometheus methods could not be invoked (version mismatch?) -- not logging statistics", (Throwable)illegalAccessException);
                object = new SummaryMock(string, stringArray);
            }
        } else if (string == null) {
            log.warn("Trying to build a Summary with null name");
            object = new SummaryMock(string, stringArray);
        } else if (!summaries.containsKey(string) && string != null) {
            object = new SummaryMock(string, stringArray);
            summaries.put(string, object);
        } else {
            log.warn("Trying to build a Summary with duplicate names: ", (Object)string);
            object = summaries.get(string);
        }
        return object;
    }

    public static Object startTimer(@Nullable Object object, String ... stringArray) {
        TimerMock timerMock;
        if (havePrometheus && object != null) {
            try {
                Object object2 = null;
                Object object3 = SUMMARY_METHOD_LABELS.invoke(object, new Object[]{stringArray});
                if (object3 != null) {
                    object2 = SUMMARY_METHOD_STARTTIMER.invoke(object3, new Object[0]);
                }
                return object2;
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getCause() != null && invocationTargetException.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)invocationTargetException.getCause();
                }
                log.warn("Invocation target exception", (Throwable)invocationTargetException);
                timerMock = new TimerMock(null, stringArray);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                log.warn("Prometheus methods could not be invoked (version mismatch?) -- not logging statistics", (Throwable)exception);
                exception.printStackTrace();
                timerMock = new TimerMock(null, stringArray);
            }
        } else if (object != null && !(object instanceof SummaryMock)) {
            log.error("Starting a timer on something other than a SummaryMock: {}", object.getClass());
            timerMock = new TimerMock(null, stringArray);
        } else {
            timerMock = new TimerMock((SummaryMock)object, stringArray);
        }
        return timerMock;
    }

    public static double observeDuration(@Nullable Object object) {
        if (havePrometheus && object != null) {
            try {
                Double d = (Double)TIMER_METHOD_OBSERVE_DURATION.invoke(object, new Object[0]);
                if (d == null) {
                    return 0.0;
                }
                return d;
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getCause() != null && invocationTargetException.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)invocationTargetException.getCause();
                }
                log.warn("Invocation target exception", (Throwable)invocationTargetException);
                return 0.0;
            }
            catch (IllegalAccessException illegalAccessException) {
                log.warn("Prometheus methods could not be invoked (version mismatch?) -- not logging statistics", (Throwable)illegalAccessException);
                return 0.0;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.warn("Invalid parameter supplied: {}, should be of Prometheus.Summary.Timer or TimerMock class", object.getClass());
                return 0.0;
            }
        }
        if (object instanceof TimerMock) {
            return ((TimerMock)object).observeDuration();
        }
        log.warn("Something probably went wrong in Prometheus#observeDuration: Expected Timer or TimerMock but received {}", object == null ? "null" : object.getClass());
        return 0.0;
    }

    public static Object gaugeBuild(String string, String string2) {
        Object object;
        block7: {
            if (havePrometheus) {
                try {
                    if (gauges.containsKey(string)) {
                        object = gauges.get(string);
                        break block7;
                    }
                    Object object2 = GAUGE_METHOD_BUILD.invoke(null, string, string2);
                    object = GAUGEBUILDER_METHOD_REGISTER.invoke(object2, new Object[0]);
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (invocationTargetException.getCause() != null && invocationTargetException.getCause() instanceof RuntimeException) {
                        throw (RuntimeException)invocationTargetException.getCause();
                    }
                    log.warn("Invocation target exception", (Throwable)invocationTargetException);
                    object = new GaugeMock(string);
                }
                catch (IllegalAccessException | IllegalArgumentException exception) {
                    log.warn("Prometheus methods could not be invoked (version mismatch?) -- not logging statistics", (Throwable)exception);
                    object = new GaugeMock(string);
                }
            } else {
                object = gauges.containsKey(string) ? gauges.get(string) : new GaugeMock(string);
            }
        }
        gauges.put(string, object);
        return object;
    }

    public static double gaugeGet(Object object) {
        if (havePrometheus && object != null) {
            try {
                Double d = (Double)GAUGE_METHOD_GET.invoke(object, new Object[0]);
                if (d == null) {
                    return 0.0;
                }
                return d;
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getCause() != null && invocationTargetException.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)invocationTargetException.getCause();
                }
                log.warn("Invocation target exception", (Throwable)invocationTargetException);
                return 0.0;
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                log.warn("Prometheus methods could not be invoked (version mismatch?) -- not logging statistics", (Throwable)exception);
                return 0.0;
            }
        }
        if (object instanceof GaugeMock) {
            return ((GaugeMock)object).get();
        }
        log.warn("Something probably went wrong in Prometheus#gaugeGet: Expected Gauge or GaugeMock but received {}", object == null ? "null" : object.getClass());
        return 0.0;
    }

    public static void gaugeSet(Object object, double d) {
        if (havePrometheus && object != null) {
            try {
                GAUGE_METHOD_SET.invoke(object, d);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getCause() != null && invocationTargetException.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)invocationTargetException.getCause();
                }
                log.warn("Invocation target exception", (Throwable)invocationTargetException);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                log.warn("Prometheus methods could not be invoked (version mismatch?) -- not logging statistics", (Throwable)exception);
            }
        } else if (object instanceof GaugeMock) {
            ((GaugeMock)object).set(d);
        } else {
            log.warn("Something probably went wrong in Prometheus#gaugeSet: Expected Gauge or GaugeMock but received {}", object == null ? "null" : object.getClass());
        }
    }

    public static void gaugeInc(Object object) {
        if (havePrometheus && object != null) {
            try {
                GAUGE_METHOD_INC.invoke(object, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getCause() != null && invocationTargetException.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)invocationTargetException.getCause();
                }
                log.warn("Invocation target exception", (Throwable)invocationTargetException);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                log.warn("Prometheus methods could not be invoked (version mismatch?) -- not logging statistics", (Throwable)exception);
            }
        } else if (object instanceof GaugeMock) {
            ((GaugeMock)object).inc();
        } else {
            log.warn("Something probably went wrong in Prometheus#gaugeInc: Expected Gauge or GaugeMock but received {}", object == null ? "null" : object.getClass());
        }
    }

    public static void gaugeDec(Object object) {
        if (havePrometheus && object != null) {
            try {
                GAUGE_METHOD_DEC.invoke(object, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getCause() != null && invocationTargetException.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)invocationTargetException.getCause();
                }
                log.warn("Invocation target exception", (Throwable)invocationTargetException);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                log.warn("Prometheus methods could not be invoked (version mismatch?) -- not logging statistics", (Throwable)exception);
            }
        } else if (object instanceof GaugeMock) {
            ((GaugeMock)object).dec();
        } else {
            log.warn("Something probably went wrong in Prometheus#gaugeDec: Expected Gauge or GaugeMock but received {}", object == null ? "null" : object.getClass());
        }
    }

    public static Object counterBuild(String string, String string2) {
        Object object;
        if (havePrometheus) {
            try {
                Object object2 = COUNTER_METHOD_BUILD.invoke(null, string, string2);
                object = COUNTERBUILDER_METHOD_REGISTER.invoke(object2, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getCause() != null && invocationTargetException.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)invocationTargetException.getCause();
                }
                log.warn("Invocation target exception", (Throwable)invocationTargetException);
                object = new CounterMock(string);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                log.warn("Prometheus methods could not be invoked (version mismatch?) -- not logging statistics", (Throwable)exception);
                object = new CounterMock(string);
            }
        } else {
            object = new CounterMock(string);
        }
        counters.put(string, object);
        return object;
    }

    public static void counterInc(Object object) {
        if (havePrometheus && object != null) {
            try {
                COUNTER_METHOD_INC.invoke(object, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getCause() != null && invocationTargetException.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)invocationTargetException.getCause();
                }
                log.warn("Invocation target exception", (Throwable)invocationTargetException);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                log.warn("Prometheus methods could not be invoked (version mismatch?) -- not logging statistics", (Throwable)exception);
            }
        } else if (object instanceof CounterMock) {
            ((CounterMock)object).inc();
        } else {
            log.warn("Something probably went wrong in Prometheus#counterInc: Expected Gauge or GaugeMock but received {}", object == null ? "null" : object.getClass());
        }
    }

    public static boolean havePrometheus() {
        return havePrometheus;
    }

    static {
        try {
            Class<?> clazz = Class.forName("io.prometheus.client.Summary");
            Class<?> clazz2 = Class.forName("io.prometheus.client.Summary$Child");
            Class<?> clazz3 = Class.forName("io.prometheus.client.Summary$Builder");
            Class<?> clazz4 = Class.forName("io.prometheus.client.Summary$Timer");
            Class<?> clazz5 = Class.forName("io.prometheus.client.Gauge");
            Class<?> clazz6 = Class.forName("io.prometheus.client.Gauge$Builder");
            Class<?> clazz7 = Class.forName("io.prometheus.client.Gauge");
            Class<?> clazz8 = Class.forName("io.prometheus.client.Gauge$Builder");
            SUMMARY_METHOD_BUILD = clazz.getMethod("build", String.class, String.class);
            SUMMARY_METHOD_LABELS = clazz.getMethod("labels", String[].class);
            SUMMARY_METHOD_STARTTIMER = clazz2.getMethod("startTimer", new Class[0]);
            SUMMARYBUILDER_METHOD_LABELNAMES = clazz3.getMethod("labelNames", String[].class);
            SUMMARYBUILDER_METHOD_REGISTER = clazz3.getMethod("register", new Class[0]);
            TIMER_METHOD_OBSERVE_DURATION = clazz4.getMethod("observeDuration", new Class[0]);
            GAUGE_METHOD_BUILD = clazz5.getMethod("build", String.class, String.class);
            GAUGE_METHOD_GET = clazz5.getMethod("get", new Class[0]);
            GAUGE_METHOD_SET = clazz5.getMethod("set", Double.TYPE);
            GAUGE_METHOD_INC = clazz5.getMethod("inc", new Class[0]);
            GAUGE_METHOD_DEC = clazz5.getMethod("dec", new Class[0]);
            GAUGEBUILDER_METHOD_REGISTER = clazz6.getMethod("register", new Class[0]);
            COUNTER_METHOD_INC = clazz7.getMethod("inc", new Class[0]);
            COUNTER_METHOD_BUILD = clazz7.getMethod("build", String.class, String.class);
            COUNTERBUILDER_METHOD_REGISTER = clazz8.getMethod("register", new Class[0]);
            havePrometheus = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.info("Could not find Prometheus in your classpath -- not logging statistics", (Throwable)classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            log.warn("Prometheus methods are not as expected (version mismatch?) -- not logging statistics", (Throwable)noSuchMethodException);
            noSuchMethodException.printStackTrace();
            SUMMARY_METHOD_BUILD = null;
            SUMMARY_METHOD_STARTTIMER = null;
            SUMMARYBUILDER_METHOD_LABELNAMES = null;
            SUMMARYBUILDER_METHOD_REGISTER = null;
            TIMER_METHOD_OBSERVE_DURATION = null;
            SUMMARY_METHOD_LABELS = null;
            GAUGE_METHOD_BUILD = null;
            GAUGE_METHOD_GET = null;
            GAUGE_METHOD_SET = null;
            GAUGE_METHOD_INC = null;
            GAUGE_METHOD_DEC = null;
            GAUGEBUILDER_METHOD_REGISTER = null;
            COUNTER_METHOD_INC = null;
            COUNTER_METHOD_BUILD = null;
            COUNTERBUILDER_METHOD_REGISTER = null;
        }
    }

    private static class CounterMock {
        public final String name;
        private double value = 0.0;

        public CounterMock(String string) {
            this.name = string;
        }

        public void inc() {
            this.value += 1.0;
        }

        public void dec() {
            this.value -= 1.0;
        }

        public void set(double d) {
            this.value = d;
        }

        public double get() {
            return this.value;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            CounterMock counterMock = (CounterMock)object;
            return Objects.equals(this.name, counterMock.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }
    }

    private static class GaugeMock {
        private final String name;
        private double value = 0.0;

        public GaugeMock(String string) {
            this.name = string;
        }

        public double get() {
            return this.value;
        }

        public void set(double d) {
            this.value = d;
        }

        public void inc() {
            this.value += 1.0;
        }

        public void dec() {
            this.value -= 1.0;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            GaugeMock gaugeMock = (GaugeMock)object;
            return Objects.equals(this.name, gaugeMock.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }
    }

    private static class TimerMock {
        public final SummaryMock summary;
        public final String[] labels;
        public final long startTime;

        public TimerMock(SummaryMock summaryMock, String[] stringArray) {
            this.summary = summaryMock;
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            this.labels = stringArray;
            if (summaryMock != null && summaryMock.labels != null && stringArray.length != summaryMock.labels.length) {
                throw new IllegalArgumentException("Summary labels + timer label values should have the same length: " + summaryMock.labels.length + " vs " + stringArray.length);
            }
            this.startTime = System.nanoTime();
        }

        protected double observeDuration() {
            long l = System.nanoTime() - this.startTime;
            return (double)l / 1.0E9;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            TimerMock timerMock = (TimerMock)object;
            return Objects.equals(this.summary, timerMock.summary) && Arrays.equals(this.labels, timerMock.labels);
        }

        public int hashCode() {
            int n = Objects.hash(this.summary);
            n = 31 * n + Arrays.hashCode(this.labels);
            return n;
        }
    }

    private static class SummaryMock {
        public final String name;
        public final String[] labels;

        public SummaryMock(String string, String[] stringArray) {
            this.name = string;
            this.labels = stringArray;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            SummaryMock summaryMock = (SummaryMock)object;
            return Objects.equals(this.name, summaryMock.name) && Arrays.equals(this.labels, summaryMock.labels);
        }

        public int hashCode() {
            int n = Objects.hash(this.name);
            n = 31 * n + Arrays.hashCode(this.labels);
            return n;
        }
    }
}

