/*
 * Decompiled with CFR 0.152.
 */
package ai.eloquent.raft;

import ai.eloquent.monitoring.Prometheus;
import ai.eloquent.raft.EloquentRaftProto;
import ai.eloquent.raft.KeyValueStateMachine;
import ai.eloquent.raft.KeyValueStateMachineProto;
import ai.eloquent.raft.RaftAlgorithm;
import ai.eloquent.raft.RaftLifecycle;
import ai.eloquent.raft.RaftLog;
import ai.eloquent.raft.RaftLogEntryLocation;
import ai.eloquent.raft.RaftState;
import ai.eloquent.raft.RaftStateMachine;
import ai.eloquent.raft.RaftTransport;
import ai.eloquent.util.RuntimeInterruptedException;
import ai.eloquent.util.TimerUtils;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.sun.management.GarbageCollectorMXBean;
import com.sun.management.GcInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EloquentRaftAlgorithm
implements RaftAlgorithm {
    private static final Logger log = LoggerFactory.getLogger(EloquentRaftAlgorithm.class);
    public static final long MACHINE_DOWN_TIMEOUT = 30000L;
    private static int LEAKY_BUCKET_SIZE = 10;
    private final RaftState state;
    public final RaftTransport transport;
    private CompletableFuture<EloquentRaftProto.RaftMessage> clusterMembershipFuture;
    private volatile long lastClusterMembershipChange;
    private final long[] lastBroadcastTimes = new long[LEAKY_BUCKET_SIZE + 1];
    private volatile AtomicInteger lastBroadcastNextIndex = new AtomicInteger(0);
    private final Optional<RaftLifecycle> lifecycle;
    private long drivingThreadId = -1L;
    private Consumer<Runnable> drivingThreadQueue = Runnable::run;

    public EloquentRaftAlgorithm(String string, RaftStateMachine raftStateMachine, RaftTransport raftTransport, int n, ExecutorService executorService, Optional<RaftLifecycle> optional) {
        this(new RaftState(string, raftStateMachine, n, executorService), raftTransport, optional);
    }

    public EloquentRaftAlgorithm(String string, RaftStateMachine raftStateMachine, RaftTransport raftTransport, Collection<String> collection, ExecutorService executorService, Optional<RaftLifecycle> optional) {
        this(new RaftState(string, raftStateMachine, collection, executorService), raftTransport, optional);
    }

    public EloquentRaftAlgorithm(RaftState raftState, RaftTransport raftTransport, Optional<RaftLifecycle> optional) {
        this.state = raftState;
        this.transport = raftTransport;
        this.lifecycle = optional;
        this.clusterMembershipFuture = CompletableFuture.completedFuture(EloquentRaftProto.RaftMessage.newBuilder().setSender(raftState.serverName).build());
        this.lastClusterMembershipChange = raftTransport.now();
    }

    void setDrivingThread(Consumer<Runnable> consumer) {
        this.drivingThreadId = Thread.currentThread().getId();
        this.drivingThreadQueue = consumer;
    }

    @Override
    public RaftState state() {
        assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
        return this.state.copy();
    }

    @Override
    public RaftState mutableState() {
        return this.state;
    }

    @Override
    public RaftStateMachine mutableStateMachine() {
        return this.state.log.stateMachine;
    }

    @Override
    public long term() {
        return this.state.currentTerm;
    }

    @Override
    public String serverName() {
        return this.state.serverName;
    }

    @Override
    public void receiveAppendEntriesRPC(EloquentRaftProto.AppendEntriesRequest appendEntriesRequest, Consumer<EloquentRaftProto.RaftMessage> consumer, long l) {
        EloquentRaftProto.RaftMessage raftMessage;
        assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
        String string = "AppendEntriesRPC";
        if (appendEntriesRequest.getEntriesCount() > 0) {
            log.trace("{} - [{}] {}; num_entries={}  prevIndex={}  leader={}", new Object[]{this.state.serverName, this.transport.now(), string, appendEntriesRequest.getEntriesCount(), appendEntriesRequest.getPrevLogIndex(), appendEntriesRequest.getLeaderName()});
        }
        EloquentRaftProto.AppendEntriesReply.Builder builder = EloquentRaftProto.AppendEntriesReply.newBuilder().setFollowerName(this.state.serverName);
        if (!this.canPerformFollowerAction(string, appendEntriesRequest.getTerm(), false)) {
            raftMessage = RaftTransport.mkRaftMessage(this.state.serverName, builder.setTerm(this.state.currentTerm).setNextIndex(this.state.log.getLastEntryIndex() + 1L).setSuccess(false).setMissingFromQuorum(!this.state.log.latestQuorumMembers.contains(this.state.serverName)).build());
        } else {
            Optional<String> optional = this.state.leader;
            this.state.resetElectionTimeout(l, appendEntriesRequest.getLeaderName());
            if (!optional.equals(this.state.leader)) {
                log.info("{} - {}; registered new leader={}  old leader={}  time={}", new Object[]{this.state.serverName, string, this.state.leader.orElse("<none>"), optional.orElse("<none>"), l});
            }
            if (this.state.log.appendEntries(appendEntriesRequest.getPrevLogIndex(), appendEntriesRequest.getPrevLogTerm(), appendEntriesRequest.getEntriesList())) {
                assert (this.state.log.getLastEntryIndex() >= appendEntriesRequest.getPrevLogIndex() + (long)appendEntriesRequest.getEntriesCount()) : "appendEntries succeeded on " + this.state.serverName + ", but latest log index is not caught up(!?)  prevLogIndex=" + appendEntriesRequest.getPrevLogIndex() + "  entryCount=" + appendEntriesRequest.getEntriesCount() + "  new_lastIndex=" + this.state.log.getLastEntryIndex();
                if (!appendEntriesRequest.getEntriesList().isEmpty()) {
                    try {
                        KeyValueStateMachineProto.Transition transition = KeyValueStateMachineProto.Transition.parseFrom(appendEntriesRequest.getEntriesList().get(0).getTransition());
                        log.trace("{} - {} Appended entry @ time={} to index {} of type {}: {}", new Object[]{this.state.serverName, string, l, appendEntriesRequest.getEntriesList().get(0).getIndex(), transition.getType(), transition});
                    }
                    catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                        // empty catch block
                    }
                }
                if (this.state.commitIndex() < appendEntriesRequest.getLeaderCommit()) {
                    assert (this.state.commitIndex() <= appendEntriesRequest.getLeaderCommit()) : "Leader has committed past our current index on " + this.state.serverName + "!  commitIndex=" + this.state.commitIndex() + "  heartbeat.commitIndex=" + appendEntriesRequest.getLeaderCommit() + "  prevLogIndex=" + appendEntriesRequest.getPrevLogIndex() + "  entryCount=" + appendEntriesRequest.getEntriesCount() + "  new_lastIndex=" + this.state.log.getLastEntryIndex();
                    this.state.commitUpTo(appendEntriesRequest.getLeaderCommit(), l);
                }
                if (this.state.leadership == RaftState.LeadershipStatus.LEADER) {
                    log.warn("{} - {} Raft got an inbound heartbeat as a leader -- this is a possible split-brain. Stepping down from leadership so we can sort it out democratically.", (Object)this.state.serverName, (Object)string);
                    this.state.stepDownFromElection();
                }
                if (appendEntriesRequest.getEntriesCount() > 0) {
                    log.trace("{} - {} replying success;  term={}  nextIndex={}  commitIndex={}", new Object[]{this.state.serverName, string, this.state.currentTerm, this.state.log.getLastEntryIndex() + 1L, this.state.commitIndex()});
                }
                raftMessage = RaftTransport.mkRaftMessage(this.state.serverName, builder.setSuccess(true).setTerm(this.state.currentTerm).setNextIndex(this.state.log.getLastEntryIndex() + 1L).setMissingFromQuorum(!this.state.log.latestQuorumMembers.contains(this.state.serverName)).build());
            } else if (appendEntriesRequest.getEntriesCount() > 0) {
                if (appendEntriesRequest.getPrevLogIndex() >= this.state.log.snapshot.map(snapshot -> snapshot.lastIndex).orElse(0L)) {
                    log.warn("{} - {} replying error;  term={}  lastIndex={}  heartbeat.term={}  heartbeat.prevIndex={}", new Object[]{this.state.serverName, string, this.state.currentTerm, this.state.log.getLastEntryIndex(), appendEntriesRequest.getTerm(), appendEntriesRequest.getPrevLogIndex()});
                }
                long l2 = Math.max(this.state.log.snapshot.map(snapshot -> snapshot.lastIndex).orElse(0L), Math.min(appendEntriesRequest.getPrevLogIndex() - 1L, this.state.log.getLastEntryIndex()));
                raftMessage = RaftTransport.mkRaftMessage(this.state.serverName, builder.setSuccess(false).setTerm(this.state.currentTerm).setNextIndex(l2).setMissingFromQuorum(!this.state.log.latestQuorumMembers.contains(this.state.serverName)).build());
            } else {
                if (appendEntriesRequest.getEntriesCount() > 0) {
                    log.trace("{} - {} heartbeat has no payload;  term={}  nextIndex={}", new Object[]{this.state.serverName, string, this.state.currentTerm, appendEntriesRequest.getPrevLogIndex()});
                }
                raftMessage = RaftTransport.mkRaftMessage(this.state.serverName, builder.setSuccess(false).setTerm(this.state.currentTerm).setNextIndex(this.state.log.getLastEntryIndex() + 1L).setMissingFromQuorum(!this.state.log.latestQuorumMembers.contains(this.state.serverName)).build());
            }
        }
        consumer.accept(raftMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveAppendEntriesReply(EloquentRaftProto.AppendEntriesReply appendEntriesReply, long l) {
        assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
        String string = "AppendEntriesReply";
        long l2 = System.currentTimeMillis();
        try {
            log.trace("{} - [{}] {} from {}. success={}  term={}  nextIndex={}", new Object[]{this.state.serverName, this.transport.now(), string, appendEntriesReply.getFollowerName(), appendEntriesReply.getSuccess(), appendEntriesReply.getTerm(), appendEntriesReply.getNextIndex()});
            this.asLeader(appendEntriesReply.getFollowerName(), appendEntriesReply.getTerm(), l, () -> {
                assert (this.state.isLeader()) : "We should still be a leader if we process this reply";
                assert (appendEntriesReply.getTerm() == this.state.currentTerm) : "We should be on the correct term when getting a heartbeat reply";
                assert (this.state.nextIndex.isPresent()) : "We should have a nextIndex map";
                if (appendEntriesReply.getSuccess()) {
                    this.state.nextIndex.ifPresent(map -> map.put(appendEntriesReply.getFollowerName(), Math.max(map.getOrDefault(appendEntriesReply.getFollowerName(), 0L), appendEntriesReply.getNextIndex())));
                    this.state.matchIndex.ifPresent(map -> map.put(appendEntriesReply.getFollowerName(), Math.max(map.getOrDefault(appendEntriesReply.getFollowerName(), 0L), appendEntriesReply.getNextIndex() - 1L)));
                    if (appendEntriesReply.getMissingFromQuorum() && this.state.log.committedQuorumMembers.contains(appendEntriesReply.getFollowerName()) && this.state.log.latestQuorumMembers.contains(appendEntriesReply.getFollowerName()) && this.clusterMembershipFuture.isDone() && this.lastClusterMembershipChange + this.electionTimeoutMillisRange().end < this.transport.now()) {
                        log.warn("{} - {} detected quorum mismatch on node {}. Trying to recover, but this is an error state.", new Object[]{this.state.serverName, string, appendEntriesReply.getFollowerName()});
                        this.receiveAddServerRPC(EloquentRaftProto.AddServerRequest.newBuilder().setNewServer(appendEntriesReply.getFollowerName()).addAllQuorum(this.state.log.latestQuorumMembers).build(), l);
                    }
                } else {
                    long l2;
                    Optional<Object> optional;
                    log.trace("{} - {} from {} was rejected. resending with term={} and nextIndex={}", new Object[]{this.state.serverName, string, appendEntriesReply.getFollowerName(), appendEntriesReply.getTerm(), appendEntriesReply.getNextIndex()});
                    long l3 = Math.max(0L, appendEntriesReply.getNextIndex() - 1L);
                    if (!(l3 <= 0L || (optional = this.state.log.getEntryAtIndex(l3)).isPresent() || this.state.log.snapshot.isPresent() && l3 == this.state.log.snapshot.get().lastIndex || (l2 = this.state.matchIndex.map(map -> (Long)map.get(appendEntriesReply.getFollowerName())).orElse(0L).longValue()) >= l3)) {
                        this.state.matchIndex.ifPresent(map -> map.put(appendEntriesReply.getFollowerName(), 0L));
                        this.state.nextIndex.ifPresent(map -> map.put(appendEntriesReply.getFollowerName(), 0L));
                        log.warn("{} - {}  Follower asked for an index we do not have; setting index to 0 (to trigger snapshot)", (Object)this.state.serverName, (Object)string);
                        l3 = 0L;
                    }
                    if (!(optional = this.state.log.getEntriesSinceInclusive(l3 + 1L)).isPresent() || ((List)optional.get()).size() > 0) {
                        this.sendAppendEntries(appendEntriesReply.getFollowerName(), l3 + 1L);
                    }
                }
            });
        }
        finally {
            assert (this.checkDuration(string, l2, System.currentTimeMillis()));
        }
    }

    private <E> E generalizedAppendEntries(long l, BiFunction<EloquentRaftProto.AppendEntriesRequest, EloquentRaftProto.InstallSnapshotRequest, E> biFunction) {
        assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
        Optional<Object> optional = Optional.empty();
        Optional<Object> optional2 = Optional.empty();
        Optional<List<EloquentRaftProto.LogEntry>> optional3 = this.state.log.getEntriesSinceInclusive(l);
        Optional<Long> optional4 = this.state.log.getPreviousEntryTerm(l - 1L);
        if (optional3.isPresent() && optional4.isPresent()) {
            optional = Optional.of(EloquentRaftProto.AppendEntriesRequest.newBuilder().setTerm(this.state.currentTerm).setLeaderName(this.state.serverName).setPrevLogIndex(l - 1L).setPrevLogTerm(optional4.get()).addAllEntries((Iterable<? extends EloquentRaftProto.LogEntry>)optional3.get()).setLeaderCommit(this.state.log.getCommitIndex()).build());
            log.trace("{} - sending appendEntriesRequest; logIndex={}  logTerm={}  # entries={}", new Object[]{this.state.serverName, l - 1L, optional4.get(), optional3.get().size()});
        } else {
            optional2 = this.state.log.snapshot.map(snapshot -> EloquentRaftProto.InstallSnapshotRequest.newBuilder().setTerm(this.state.currentTerm).setLeaderName(this.state.serverName).setLastIndex(snapshot.lastIndex).setLastTerm(snapshot.lastTerm).addAllLastConfig(snapshot.lastClusterMembership).setData(ByteString.copyFrom((byte[])snapshot.serializedStateMachine)).build());
        }
        return biFunction.apply(optional.orElse(null), optional2.orElse(null));
    }

    private CompletableFuture<EloquentRaftProto.RaftMessage> rpcAppendEntries(String string, long l, long l2) {
        assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
        String string2 = "AppendEntriesRPC";
        return this.generalizedAppendEntries(l, (appendEntriesRequest, installSnapshotRequest) -> {
            assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
            if (appendEntriesRequest != null) {
                return this.transport.rpcTransportAsFuture(this.state.serverName, string, appendEntriesRequest, (raftMessage, throwable) -> {
                    assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
                    if (raftMessage != null) {
                        return raftMessage;
                    }
                    log.warn("{} - {} Failure: <{}>", new Object[]{this.state.serverName, string2, throwable == null ? "unknown error" : throwable.getClass().getName() + ": " + throwable.getMessage()});
                    return RaftTransport.mkRaftMessage(this.state.serverName, EloquentRaftProto.RaftMessage.newBuilder().setAppendEntriesReply(EloquentRaftProto.AppendEntriesReply.newBuilder().setFollowerName(string).setTerm(this.state.currentTerm).setSuccess(false)).build());
                }, this.drivingThreadQueue, l2);
            }
            if (installSnapshotRequest != null) {
                return this.transport.rpcTransportAsFuture(this.state.serverName, string, installSnapshotRequest, (raftMessage, throwable) -> {
                    assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
                    if (raftMessage != null) {
                        return raftMessage;
                    }
                    log.warn("{} - {} Failure: <{}>", new Object[]{this.state.serverName, string2, throwable == null ? "unknown error" : throwable.getClass().getName() + ": " + throwable.getMessage()});
                    return RaftTransport.mkRaftMessage(this.state.serverName, EloquentRaftProto.RaftMessage.newBuilder().setInstallSnapshotReply(EloquentRaftProto.InstallSnapshotReply.newBuilder().setTerm(this.state.currentTerm).build()));
                }, this.drivingThreadQueue, l2);
            }
            log.warn("{} - We have neither log entries or a snapshot to send to {}.", (Object)this.state.serverName, (Object)string);
            return CompletableFuture.completedFuture(EloquentRaftProto.RaftMessage.getDefaultInstance());
        }).thenApply(raftMessage -> {
            assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
            if (raftMessage.getAppendEntriesReply() != EloquentRaftProto.AppendEntriesReply.getDefaultInstance()) {
                EloquentRaftProto.AppendEntriesReply appendEntriesReply = raftMessage.getAppendEntriesReply();
                this.receiveAppendEntriesReply(appendEntriesReply, this.transport.now());
            } else if (raftMessage.getInstallSnapshotReply() != EloquentRaftProto.InstallSnapshotReply.getDefaultInstance()) {
                EloquentRaftProto.InstallSnapshotReply installSnapshotReply = raftMessage.getInstallSnapshotReply();
                this.receiveInstallSnapshotReply(installSnapshotReply, this.transport.now());
            }
            return raftMessage;
        });
    }

    @Override
    public void sendAppendEntries(String string, long l) {
        assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
        log.trace("{} - Sending appendEntries to {} with nextIndex {}", new Object[]{this.state.serverName, string, l});
        this.generalizedAppendEntries(l, (appendEntriesRequest, installSnapshotRequest) -> {
            if (appendEntriesRequest != null) {
                this.transport.sendTransport(this.state.serverName, string, appendEntriesRequest);
            } else if (installSnapshotRequest != null) {
                this.transport.sendTransport(this.state.serverName, string, installSnapshotRequest);
            } else {
                log.warn("{} - We have neither log entries or a snapshot to send to {}.", (Object)this.state.serverName, (Object)string);
            }
            return null;
        });
    }

    @Override
    public void broadcastAppendEntries(long l) {
        assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
        this.broadcastAppendEntries(l, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastAppendEntries(long l, boolean bl, boolean bl2) {
        long l22;
        assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
        String string = "broadcastAppendEntries";
        if (!bl2) {
            int n = 0;
            for (long l22 : this.lastBroadcastTimes) {
                if (l22 <= 0L || l <= l22 || l - l22 >= this.heartbeatMillis()) continue;
                ++n;
            }
            if (n > LEAKY_BUCKET_SIZE) {
                return;
            }
        }
        this.lastBroadcastTimes[this.lastBroadcastNextIndex.getAndIncrement() % this.lastBroadcastTimes.length] = l;
        if (!this.state.isLeader()) {
            log.trace("{} - {}; Not the leader", (Object)this.state.serverName, (Object)string);
            return;
        }
        assert (this.state.nextIndex.isPresent()) : "Running heartbeat as leader, but don't have a nextIndex defined";
        long l3 = System.currentTimeMillis();
        long l4 = Long.MAX_VALUE;
        l22 = Long.MAX_VALUE;
        List<Object> list = null;
        if (this.state.nextIndex.isPresent()) {
            Map<String, Long> map = this.state.nextIndex.get();
            for (String string2 : this.state.log.getQuorumMembers()) {
                long l5;
                if (string2.equals(this.state.serverName)) continue;
                if (!map.containsKey(string2)) {
                    l5 = this.state.log.getLastEntryIndex() + 1L;
                    map.put(string2, l5);
                }
                l5 = map.get(string2);
                long l6 = Math.max(0L, l5 - 1L);
                long l7 = this.state.log.getPreviousEntryTerm(l6).orElse(-1L);
                Optional<List<EloquentRaftProto.LogEntry>> optional = this.state.log.getEntriesSinceInclusive(l5);
                if (!optional.isPresent() || l7 >= l22 && (l7 != l22 || l6 >= l4)) continue;
                l22 = l7;
                l4 = l6;
                list = optional.get();
            }
        }
        this.checkDuration("finding update index", l3, System.currentTimeMillis());
        if (l22 == Long.MAX_VALUE || l4 == Long.MAX_VALUE || list == null) {
            l4 = this.state.log.getLastEntryIndex();
            l22 = this.state.log.getLastEntryTerm();
            list = Collections.emptyList();
            if (bl && l4 > 0L) {
                l22 = this.state.log.getPreviousEntryTerm(--l4).orElse(-1L);
                list = this.state.log.getEntriesSinceInclusive(l4 + 1L).orElse(Collections.emptyList());
            }
        }
        if (this.state.isLeader()) {
            this.updateLeaderInvariantsPostMessage(Optional.empty(), l);
        }
        long l8 = System.currentTimeMillis();
        EloquentRaftProto.AppendEntriesRequest appendEntriesRequest = EloquentRaftProto.AppendEntriesRequest.newBuilder().setTerm(this.state.currentTerm).setLeaderName(this.state.serverName).setPrevLogIndex(l4).setPrevLogTerm(l22).addAllEntries(list).setLeaderCommit(this.state.log.getCommitIndex()).build();
        this.checkDuration("creating heartbeat proto", l8, System.currentTimeMillis());
        log.trace("{} - Broadcasting appendEntriesRequest; logIndex={}  logTerm={}  # entries={}", new Object[]{this.state.serverName, l4, l22, list.size()});
        long l9 = System.currentTimeMillis();
        try {
            this.transport.broadcastTransport(this.state.serverName, appendEntriesRequest);
        }
        finally {
            this.checkDuration("broadcast transport call", l9, System.currentTimeMillis());
        }
    }

    @Override
    public void receiveInstallSnapshotRPC(EloquentRaftProto.InstallSnapshotRequest installSnapshotRequest, Consumer<EloquentRaftProto.RaftMessage> consumer, long l) {
        EloquentRaftProto.RaftMessage raftMessage;
        assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
        String string = "InstallSnapshotRPC";
        log.trace("{} - [{}] {}:  term={}  lastIndex={}", new Object[]{this.state.serverName, this.transport.now(), string, installSnapshotRequest.getTerm(), installSnapshotRequest.getLastIndex()});
        EloquentRaftProto.InstallSnapshotReply.Builder builder = EloquentRaftProto.InstallSnapshotReply.newBuilder().setFollowerName(this.state.serverName);
        Optional<String> optional = this.state.leader;
        this.state.resetElectionTimeout(l, installSnapshotRequest.getLeaderName());
        if (!optional.equals(this.state.leader)) {
            log.info("{} - {}; registered new leader={}  old leader={}  term={}  lastIndex={}  time={}", new Object[]{this.state.serverName, string, this.state.leader.orElse("<none>"), optional.orElse("<none>"), installSnapshotRequest.getTerm(), installSnapshotRequest.getLastIndex(), l});
        }
        if (!this.canPerformFollowerAction(string, installSnapshotRequest.getTerm(), false)) {
            raftMessage = RaftTransport.mkRaftMessage(this.state.serverName, builder.setTerm(this.state.currentTerm).setNextIndex(this.state.log.getLastEntryIndex() + 1L).build());
        } else {
            assert (installSnapshotRequest.getTerm() == this.state.currentTerm) : "Should not have been allowed to continue if the terms don't match!";
            RaftLog.Snapshot snapshot = new RaftLog.Snapshot(installSnapshotRequest.getData().toByteArray(), installSnapshotRequest.getLastIndex(), installSnapshotRequest.getLastTerm(), (Collection<String>)installSnapshotRequest.getLastConfigList());
            this.state.log.installSnapshot(snapshot, l);
            log.trace("{} - {} success: last index in log is {}", new Object[]{this.state.serverName, string, this.state.log.getLastEntryIndex()});
            raftMessage = RaftTransport.mkRaftMessage(this.state.serverName, builder.setTerm(this.state.currentTerm).setNextIndex(this.state.log.getLastEntryIndex() + 1L).build());
        }
        consumer.accept(raftMessage);
    }

    @Override
    public void receiveInstallSnapshotReply(EloquentRaftProto.InstallSnapshotReply installSnapshotReply, long l) {
        assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
        String string = "InstallSnapshotReply";
        log.trace("{} - [{}] {} from {}. term={}  nextIndex={}", new Object[]{this.state.serverName, this.transport.now(), string, installSnapshotReply.getFollowerName(), installSnapshotReply.getTerm(), installSnapshotReply.getNextIndex()});
        this.asLeader(installSnapshotReply.getFollowerName(), installSnapshotReply.getTerm(), l, () -> {
            this.state.nextIndex.ifPresent(map -> map.compute(installSnapshotReply.getFollowerName(), (string, l) -> installSnapshotReply.getNextIndex()));
            this.state.matchIndex.ifPresent(map -> map.compute(installSnapshotReply.getFollowerName(), (string, l) -> installSnapshotReply.getNextIndex() - 1L));
            Optional<List<EloquentRaftProto.LogEntry>> optional = this.state.log.getEntriesSinceInclusive(installSnapshotReply.getNextIndex());
            if (!optional.isPresent() || optional.get().size() > 0) {
                this.sendAppendEntries(installSnapshotReply.getFollowerName(), installSnapshotReply.getNextIndex());
            }
        });
    }

    @Override
    public void receiveRequestVoteRPC(EloquentRaftProto.RequestVoteRequest requestVoteRequest, Consumer<EloquentRaftProto.RaftMessage> consumer, long l) {
        EloquentRaftProto.RaftMessage raftMessage;
        assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
        String string = "RequestVoteRPC";
        log.trace("{} - [{}] {};  candidate={}  term={}", new Object[]{this.state.serverName, this.transport.now(), string, requestVoteRequest.getCandidateName(), requestVoteRequest.getTerm()});
        if (this.canPerformFollowerAction(string, requestVoteRequest.getTerm(), false)) {
            boolean bl;
            if (requestVoteRequest.getTerm() < this.state.currentTerm) {
                bl = false;
            } else {
                boolean bl2 = bl = (!this.state.votedFor.isPresent() || this.state.votedFor.get().equals(requestVoteRequest.getCandidateName())) && requestVoteRequest.getLastLogIndex() >= this.state.log.getLastEntryIndex();
                if (bl) {
                    Optional<String> optional = this.state.leader;
                    this.state.voteFor(requestVoteRequest.getCandidateName());
                    if (!optional.equals(this.state.leader)) {
                        log.info("{} - {}; registered new leader={}  old leader={}  time={}", new Object[]{this.state.serverName, string, this.state.leader.orElse("<none>"), optional.orElse("<none>"), l});
                    }
                }
            }
            log.trace("{} - {} replying;  candidate={}  vote_granted={}  term={}  voted_for={}", new Object[]{this.state.serverName, string, requestVoteRequest.getCandidateName(), bl, this.state.currentTerm, this.state.votedFor.orElse("<nobody>")});
            raftMessage = RaftTransport.mkRaftMessage(this.state.serverName, EloquentRaftProto.RequestVoteReply.newBuilder().setFollowerName(this.state.serverName).setTerm(requestVoteRequest.getTerm()).setFollowerTerm(this.state.currentTerm).setVoteGranted(bl).build());
        } else {
            log.trace("{} - {} we're not allowed to perform this action; responding with a rejected vote", (Object)this.state.serverName, (Object)string);
            raftMessage = RaftTransport.mkRaftMessage(this.state.serverName, EloquentRaftProto.RequestVoteReply.newBuilder().setFollowerName(this.state.serverName).setTerm(requestVoteRequest.getTerm()).setFollowerTerm(this.state.currentTerm).setVoteGranted(false).build());
        }
        consumer.accept(raftMessage);
    }

    @Override
    public void receiveRequestVotesReply(EloquentRaftProto.RequestVoteReply requestVoteReply, long l) {
        assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
        String string = "RequestVoteReply";
        log.trace("{} - [{}] {} from {};  term={}  follower_term={}  vote_granted={}", new Object[]{this.state.serverName, this.transport.now(), string, requestVoteReply.getFollowerName(), requestVoteReply.getTerm(), requestVoteReply.getFollowerTerm(), requestVoteReply.getVoteGranted()});
        if (this.canPerformFollowerAction(string, requestVoteReply.getTerm(), true) && requestVoteReply.getVoteGranted()) {
            this.state.receiveVoteFrom(requestVoteReply.getFollowerName());
            log.trace("{} - {} received vote; have {} votes total ({})", new Object[]{this.state.serverName, string, this.state.votesReceived.size(), this.state.votesReceived});
            if (this.state.votesReceived.size() > this.state.log.getQuorumMembers().size() / 2) {
                if (this.state.leadership != RaftState.LeadershipStatus.LEADER) {
                    this.state.elect(l);
                    log.info("{} - Raft won an election for term {} (time={}  members={})", new Object[]{this.state.serverName, this.state.currentTerm, l, this.state.log.getQuorumMembers()});
                    this.broadcastAppendEntries(l, false, true);
                } else {
                    log.trace("{} - {} already elected to term {}", new Object[]{this.state.serverName, string, this.state.currentTerm});
                }
            }
        }
    }

    @Override
    public void triggerElection(long l) {
        assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
        String string = "triggerElection";
        if (!this.state.isCandidate()) {
            this.state.becomeCandidate();
        }
        assert (this.state.isCandidate()) : "Should not be requesting votes if we're not a candidate";
        log.info("{} - Raft triggered an election with term {} (time={} chkpt={} cluster={} leader={})", new Object[]{this.state.serverName, this.state.currentTerm, l, this.state.electionTimeoutCheckpoint, this.state.log.getQuorumMembers(), this.state.leader.orElse("<unknown>")});
        this.state.setCurrentTerm(this.state.currentTerm + 1L);
        this.state.voteFor(this.state.serverName);
        Optional<String> optional = this.state.leader;
        this.state.resetElectionTimeout(l, this.state.serverName);
        if (!optional.equals(this.state.leader)) {
            log.info("{} - {}; registered new leader={}  old leader={}  time={}", new Object[]{this.state.serverName, string, this.state.leader.orElse("<none>"), optional.orElse("<none>"), l});
        }
        EloquentRaftProto.RequestVoteRequest requestVoteRequest = EloquentRaftProto.RequestVoteRequest.newBuilder().setTerm(this.state.currentTerm).setCandidateName(this.state.serverName).setLastLogIndex(this.state.log.getLastEntryIndex()).setLastLogTerm(this.state.log.getLastEntryTerm()).build();
        if (this.state.votesReceived.size() > this.state.log.getQuorumMembers().size() / 2) {
            if (this.state.leadership != RaftState.LeadershipStatus.LEADER) {
                this.state.elect(l);
                log.info("{} - Raft won an election (by default) for term {} (time={}; cluster={})", new Object[]{this.state.serverName, this.state.currentTerm, l, this.state.log.latestQuorumMembers});
            } else {
                log.trace("{} - already elected to term {}", (Object)this.state.serverName, (Object)this.state.currentTerm);
            }
        }
        log.trace("{} - Broadcasting requestVote", (Object)this.state.serverName);
        this.transport.broadcastTransport(this.state.serverName, requestVoteRequest);
    }

    @Override
    public CompletableFuture<EloquentRaftProto.RaftMessage> receiveAddServerRPC(EloquentRaftProto.AddServerRequest addServerRequest, long l) {
        assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
        String string2 = "AddServerRPC";
        log.info("{} - [{}] {};  is_leader={}  new_server={}", new Object[]{this.state.serverName, this.transport.now(), string2, this.state.isLeader(), addServerRequest.getNewServer()});
        if (this.state.isLeader()) {
            this.clusterMembershipFuture = this.clusterMembershipFuture.thenApply(raftMessage -> {
                assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
                return EloquentRaftProto.RaftMessage.newBuilder().setSender(this.state.serverName).build();
            });
            this.state.observeLifeFrom(addServerRequest.getNewServer(), l);
            long l2 = ((Map)this.state.matchIndex.orElse(new HashMap())).getOrDefault(addServerRequest.getNewServer(), 0L);
            if (l2 < this.state.log.getLastEntryIndex()) {
                for (int i = 0; i < 3; ++i) {
                    long l3 = i + 1;
                    long l4 = Math.max(5000L, Math.min(1000L, this.electionTimeoutMillisRange().begin * (long)(3 - i) / 2L));
                    long l5 = ((Map)this.state.matchIndex.orElse(new HashMap())).getOrDefault(addServerRequest.getNewServer(), 0L);
                    if (l5 != this.state.log.getLastEntryIndex()) {
                        this.clusterMembershipFuture = this.clusterMembershipFuture.thenCompose(raftMessage -> {
                            assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
                            log.trace("{} - {}.2;  round={}  is_leader={}", new Object[]{this.state.serverName, string2, l3, this.state.isLeader()});
                            if (raftMessage.getAddServerReply() != EloquentRaftProto.AddServerReply.getDefaultInstance()) {
                                return CompletableFuture.completedFuture(raftMessage);
                            }
                            if (!this.state.isLeader()) {
                                return CompletableFuture.completedFuture(EloquentRaftProto.RaftMessage.newBuilder().setSender(this.state.serverName).setAddServerReply(EloquentRaftProto.AddServerReply.newBuilder().setStatus(EloquentRaftProto.MembershipChangeStatus.NOT_LEADER)).build());
                            }
                            try {
                                log.trace("{} - {}.2 sending_append_entries  round={}  term={}  nextIndex={}", new Object[]{this.state.serverName, string2, l3, addServerRequest.getNewServer(), raftMessage.getAppendEntriesReply().getTerm(), raftMessage.getAppendEntriesReply().getNextIndex()});
                                return this.rpcAppendEntries(addServerRequest.getNewServer(), l5 + 1L, l4);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                log.warn("{} - {}.2 Could not execute Raft update for server {}; is the server up? Exception: <{}>", new Object[]{this.state.serverName, string2, addServerRequest.getNewServer(), exception.getClass() + ": " + exception.getMessage()});
                                return CompletableFuture.completedFuture(EloquentRaftProto.RaftMessage.newBuilder().setSender(this.state.serverName).setAddServerReply(EloquentRaftProto.AddServerReply.newBuilder().setStatus(EloquentRaftProto.MembershipChangeStatus.OTHER_ERROR)).build());
                            }
                        });
                        continue;
                    }
                    break;
                }
            } else {
                log.trace("{} - {}.2;  no update needed, so skipping updating the new server", (Object)this.state.serverName, (Object)string2);
            }
            this.clusterMembershipFuture = this.clusterMembershipFuture.thenCompose(raftMessage -> {
                assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
                log.trace("{} - {}.3;  is_leader={}", new Object[]{this.state.serverName, string2, this.state.isLeader()});
                if (raftMessage.getAddServerReply() != EloquentRaftProto.AddServerReply.getDefaultInstance()) {
                    return CompletableFuture.completedFuture(raftMessage);
                }
                if (!this.state.isLeader()) {
                    return CompletableFuture.completedFuture(EloquentRaftProto.RaftMessage.newBuilder().setSender(this.state.serverName).setAddServerReply(EloquentRaftProto.AddServerReply.newBuilder().setStatus(EloquentRaftProto.MembershipChangeStatus.NOT_LEADER)).build());
                }
                Optional<RaftLogEntryLocation> optional = this.state.log.lastConfigurationEntryLocation();
                if (optional.isPresent()) {
                    log.trace("{} - {}.3 waiting for commit", (Object)this.state.serverName, (Object)string2);
                    this.broadcastAppendEntries(this.transport.now(), false, true);
                    return this.state.log.createCommitFuture(optional.get().index, optional.get().term, true).thenApply(bl -> {
                        assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
                        log.trace("{} - {}.3 committed;  success={}", new Object[]{this.state.serverName, string2, bl});
                        if (bl.booleanValue()) {
                            this.broadcastAppendEntries(this.transport.now(), false, true);
                            return EloquentRaftProto.RaftMessage.newBuilder().setSender(this.state.serverName).setAddServerReply(EloquentRaftProto.AddServerReply.newBuilder().setStatus(EloquentRaftProto.MembershipChangeStatus.OK)).build();
                        }
                        return EloquentRaftProto.RaftMessage.newBuilder().setSender(this.state.serverName).setAddServerReply(EloquentRaftProto.AddServerReply.newBuilder().setStatus(EloquentRaftProto.MembershipChangeStatus.OTHER_ERROR)).build();
                    });
                }
                return CompletableFuture.completedFuture(raftMessage);
            });
            this.clusterMembershipFuture = this.clusterMembershipFuture.thenCompose(raftMessage -> {
                boolean bl2;
                assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
                log.trace("{} - {}.4;  is_leader={}", new Object[]{this.state.serverName, string2, this.state.isLeader()});
                if (raftMessage.getAddServerReply().getStatus() != EloquentRaftProto.MembershipChangeStatus.OK) {
                    return CompletableFuture.completedFuture(raftMessage);
                }
                if (!this.state.isLeader()) {
                    return CompletableFuture.completedFuture(EloquentRaftProto.RaftMessage.newBuilder().setSender(this.state.serverName).setAddServerReply(EloquentRaftProto.AddServerReply.newBuilder().setStatus(EloquentRaftProto.MembershipChangeStatus.NOT_LEADER)).build());
                }
                if (this.transport.now() - l > 30000L) {
                    return CompletableFuture.completedFuture(EloquentRaftProto.RaftMessage.newBuilder().setSender(this.state.serverName).setAddServerReply(EloquentRaftProto.AddServerReply.newBuilder().setStatus(EloquentRaftProto.MembershipChangeStatus.TIMEOUT)).build());
                }
                HashSet<String> hashSet = new HashSet<String>(this.state.log.getQuorumMembers());
                boolean bl3 = bl2 = !hashSet.add(addServerRequest.getNewServer());
                if (!(bl2 || addServerRequest.getQuorumList().isEmpty() || hashSet.equals(new HashSet(addServerRequest.getQuorumList())))) {
                    log.warn("{} - {} consistency error (forcing consistency);  adding={}  newMembership={}  presumedMembership={}", new Object[]{this.state.serverName, string2, addServerRequest.getNewServer(), hashSet, addServerRequest.getQuorumList()});
                    hashSet = new HashSet(addServerRequest.getQuorumList());
                    bl2 = true;
                }
                RaftLogEntryLocation raftLogEntryLocation = this.state.reconfigure(hashSet, bl2, l);
                log.info("{} - {} submitted new configuration to log: {}", new Object[]{this.state.serverName, string2, hashSet});
                log.trace("{} - {}.4 waiting for commit", (Object)this.state.serverName, (Object)string2);
                this.broadcastAppendEntries(this.transport.now(), false, true);
                CompletableFuture<Boolean> completableFuture = this.state.log.createCommitFuture(raftLogEntryLocation.index, raftLogEntryLocation.term, true);
                return completableFuture.thenApply(bl -> {
                    assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
                    log.trace("{} - {}.4 committed;  success={}", new Object[]{this.state.serverName, string2, bl});
                    if (bl.booleanValue()) {
                        log.info("{} - {} committed new configuration to log: {}", new Object[]{this.state.serverName, string2, this.state.log.committedQuorumMembers});
                        this.broadcastAppendEntries(this.transport.now(), false, true);
                        return EloquentRaftProto.RaftMessage.newBuilder().setSender(this.state.serverName).setAddServerReply(EloquentRaftProto.AddServerReply.newBuilder().setStatus(EloquentRaftProto.MembershipChangeStatus.OK)).build();
                    }
                    return EloquentRaftProto.RaftMessage.newBuilder().setSender(this.state.serverName).setAddServerReply(EloquentRaftProto.AddServerReply.newBuilder().setStatus(EloquentRaftProto.MembershipChangeStatus.OTHER_ERROR)).build();
                });
            });
            CompletableFuture<EloquentRaftProto.RaftMessage> completableFuture = new CompletableFuture<EloquentRaftProto.RaftMessage>();
            this.clusterMembershipFuture.handle((raftMessage, throwable) -> {
                log.trace("{} - {}.5 complete;  result={}  have_exception={}", new Object[]{this.state.serverName, string2, raftMessage == null ? "<exception>" : raftMessage.getAddServerReply().getStatus(), throwable != null});
                if (throwable != null) {
                    log.warn("Exception on addServer", throwable);
                }
                this.lastClusterMembershipChange = this.transport.now();
                if (raftMessage != null) {
                    completableFuture.complete((EloquentRaftProto.RaftMessage)raftMessage);
                } else {
                    completableFuture.complete(EloquentRaftProto.RaftMessage.newBuilder().setSender(this.state.serverName).setAddServerReply(EloquentRaftProto.AddServerReply.newBuilder().setStatus(EloquentRaftProto.MembershipChangeStatus.TIMEOUT)).build());
                }
                return raftMessage;
            });
            return completableFuture;
        }
        if (this.state.leader.map(string -> !string.equals(this.state.serverName)).orElse(false).booleanValue()) {
            if (addServerRequest.getForwardedByList().contains((Object)this.state.serverName)) {
                log.info("{} - {}; we've been forwarded our own message back to us in a loop. Failing the message", (Object)this.state.serverName, (Object)string2);
                return CompletableFuture.completedFuture(EloquentRaftProto.RaftMessage.newBuilder().setSender(this.state.serverName).setAddServerReply(EloquentRaftProto.AddServerReply.newBuilder().setStatus(EloquentRaftProto.MembershipChangeStatus.NOT_LEADER)).build());
            }
            log.trace("{} - got {}; forwarding request to {}", new Object[]{this.state.serverName, string2, this.state.leader.orElse("<unknown>")});
            return this.transport.rpcTransportAsFuture(this.state.serverName, this.state.leader.orElse("<unknown>"), addServerRequest.toBuilder().addForwardedBy(this.state.serverName).build(), (raftMessage, throwable) -> {
                assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
                if (raftMessage != null) {
                    return raftMessage;
                }
                log.warn("{} - {} Failure: <{}>", new Object[]{this.state.serverName, string2, throwable == null ? "unknown error" : throwable.getClass().getName() + ": " + throwable.getMessage()});
                return EloquentRaftProto.RaftMessage.newBuilder().setSender(this.state.serverName).setAddServerReply(EloquentRaftProto.AddServerReply.newBuilder().setStatus(EloquentRaftProto.MembershipChangeStatus.NOT_LEADER)).build();
            }, this.drivingThreadQueue, this.electionTimeoutMillisRange().end);
        }
        log.info("{} - got {}; we're not the leader and don't know who the leader is", (Object)this.state.serverName, (Object)string2);
        return CompletableFuture.completedFuture(EloquentRaftProto.RaftMessage.newBuilder().setSender(this.state.serverName).setAddServerReply(EloquentRaftProto.AddServerReply.newBuilder().setStatus(EloquentRaftProto.MembershipChangeStatus.NOT_LEADER)).build());
    }

    @Override
    public CompletableFuture<EloquentRaftProto.RaftMessage> receiveRemoveServerRPC(EloquentRaftProto.RemoveServerRequest removeServerRequest, long l) {
        assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
        String string2 = "RemoveServerRPC";
        log.info("{} - [{}] {};  is_leader={}  to_remove={}", new Object[]{this.state.serverName, this.transport.now(), string2, this.state.isLeader(), removeServerRequest.getOldServer()});
        if (this.state.isLeader()) {
            this.clusterMembershipFuture = this.clusterMembershipFuture.thenApply(raftMessage -> {
                assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
                return EloquentRaftProto.RaftMessage.newBuilder().setSender(this.state.serverName).build();
            });
            this.clusterMembershipFuture = this.clusterMembershipFuture.thenCompose(raftMessage -> {
                assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
                log.trace("{} - {}.2;  is_leader={}", new Object[]{this.state.serverName, string2, this.state.isLeader()});
                if (raftMessage.getAddServerReply().getStatus() != EloquentRaftProto.MembershipChangeStatus.OK) {
                    return CompletableFuture.completedFuture(raftMessage);
                }
                if (!this.state.isLeader()) {
                    return CompletableFuture.completedFuture(EloquentRaftProto.RaftMessage.newBuilder().setSender(this.state.serverName).setRemoveServerReply(EloquentRaftProto.RemoveServerReply.newBuilder().setStatus(EloquentRaftProto.MembershipChangeStatus.NOT_LEADER)).build());
                }
                Optional<RaftLogEntryLocation> optional = this.state.log.lastConfigurationEntryLocation();
                if (optional.isPresent()) {
                    log.trace("{} - {}.2 waiting for commit", (Object)this.state.serverName, (Object)string2);
                    this.broadcastAppendEntries(this.transport.now(), false, true);
                    return this.state.log.createCommitFuture(optional.get().index, optional.get().term, true).thenApply(bl -> {
                        assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
                        log.trace("{} - {}.2 committed;  success={}", new Object[]{this.state.serverName, string2, bl});
                        if (bl.booleanValue()) {
                            this.broadcastAppendEntries(this.transport.now(), false, true);
                            return EloquentRaftProto.RaftMessage.newBuilder().setSender(this.state.serverName).setRemoveServerReply(EloquentRaftProto.RemoveServerReply.newBuilder().setStatus(EloquentRaftProto.MembershipChangeStatus.OK)).build();
                        }
                        return EloquentRaftProto.RaftMessage.newBuilder().setSender(this.state.serverName).setRemoveServerReply(EloquentRaftProto.RemoveServerReply.newBuilder().setStatus(EloquentRaftProto.MembershipChangeStatus.OTHER_ERROR)).build();
                    });
                }
                return CompletableFuture.completedFuture(raftMessage);
            });
            this.clusterMembershipFuture = this.clusterMembershipFuture.thenCompose(raftMessage -> {
                boolean bl2;
                assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
                log.trace("{} - {}.3;  is_leader={}", new Object[]{this.state.serverName, string2, this.state.isLeader()});
                if (raftMessage.getAddServerReply().getStatus() != EloquentRaftProto.MembershipChangeStatus.OK) {
                    return CompletableFuture.completedFuture(raftMessage);
                }
                if (!this.state.isLeader()) {
                    return CompletableFuture.completedFuture(EloquentRaftProto.RaftMessage.newBuilder().setSender(this.state.serverName).setRemoveServerReply(EloquentRaftProto.RemoveServerReply.newBuilder().setStatus(EloquentRaftProto.MembershipChangeStatus.NOT_LEADER)).build());
                }
                if (this.transport.now() - l > 30000L) {
                    return CompletableFuture.completedFuture(EloquentRaftProto.RaftMessage.newBuilder().setSender(this.state.serverName).setRemoveServerReply(EloquentRaftProto.RemoveServerReply.newBuilder().setStatus(EloquentRaftProto.MembershipChangeStatus.TIMEOUT)).build());
                }
                HashSet<String> hashSet = new HashSet<String>(this.state.log.getQuorumMembers());
                boolean bl3 = bl2 = !hashSet.remove(removeServerRequest.getOldServer());
                if (!(bl2 || removeServerRequest.getQuorumList().isEmpty() || hashSet.equals(new HashSet(removeServerRequest.getQuorumList())))) {
                    log.warn("{} - {} consistency error (forcing consistency);  adding={}  newMembership={}  presumedMembership={}", new Object[]{this.state.serverName, string2, removeServerRequest.getOldServer(), hashSet, removeServerRequest.getQuorumList()});
                    hashSet = new HashSet(removeServerRequest.getQuorumList());
                    bl2 = true;
                }
                RaftLogEntryLocation raftLogEntryLocation = this.state.reconfigure(hashSet, bl2, l);
                log.info("{} - {} submitted new configuration to log: {}", new Object[]{this.state.serverName, string2, hashSet});
                log.trace("{} - {}.3 waiting for commit", (Object)this.state.serverName, (Object)string2);
                this.broadcastAppendEntries(this.transport.now(), false, true);
                CompletableFuture<Boolean> completableFuture = this.state.log.createCommitFuture(raftLogEntryLocation.index, raftLogEntryLocation.term, true);
                return completableFuture.thenApply(bl -> {
                    assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
                    log.trace("{} - {}.3 committed;  success={}", new Object[]{this.state.serverName, string2, bl});
                    if (bl.booleanValue()) {
                        log.info("{} - {} committed new configuration to log: {}", new Object[]{this.state.serverName, string2, this.state.log.committedQuorumMembers});
                        this.state.lastMessageTimestamp.ifPresent(map -> {
                            Long cfr_ignored_0 = (Long)map.remove(removeServerRequest.getOldServer());
                        });
                        this.broadcastAppendEntries(this.transport.now(), true, true);
                        return EloquentRaftProto.RaftMessage.newBuilder().setSender(this.state.serverName).setRemoveServerReply(EloquentRaftProto.RemoveServerReply.newBuilder().setStatus(EloquentRaftProto.MembershipChangeStatus.OK)).build();
                    }
                    return EloquentRaftProto.RaftMessage.newBuilder().setSender(this.state.serverName).setRemoveServerReply(EloquentRaftProto.RemoveServerReply.newBuilder().setStatus(EloquentRaftProto.MembershipChangeStatus.OTHER_ERROR)).build();
                });
            });
            CompletableFuture<EloquentRaftProto.RaftMessage> completableFuture = new CompletableFuture<EloquentRaftProto.RaftMessage>();
            this.clusterMembershipFuture.handle((raftMessage, throwable) -> {
                log.trace("{} - {}.5 complete;  result={}  have_exception={}", new Object[]{this.state.serverName, string2, raftMessage == null ? "<exception>" : raftMessage.getAddServerReply().getStatus(), throwable != null});
                if (throwable != null) {
                    log.warn("Exception on removeServer", throwable);
                }
                this.lastClusterMembershipChange = this.transport.now();
                if (raftMessage != null) {
                    if (removeServerRequest.getOldServer().equals(this.state.serverName) && raftMessage.getRemoveServerReply().getStatus() == EloquentRaftProto.MembershipChangeStatus.OK) {
                        this.state.stepDownFromElection();
                    }
                    completableFuture.complete((EloquentRaftProto.RaftMessage)raftMessage);
                } else {
                    completableFuture.complete(EloquentRaftProto.RaftMessage.newBuilder().setSender(this.state.serverName).setRemoveServerReply(EloquentRaftProto.RemoveServerReply.newBuilder().setStatus(EloquentRaftProto.MembershipChangeStatus.TIMEOUT)).build());
                }
                return raftMessage;
            });
            return completableFuture;
        }
        if (this.state.leader.map(string -> !string.equals(this.state.serverName)).orElse(false).booleanValue()) {
            if (removeServerRequest.getForwardedByList().contains((Object)this.state.serverName)) {
                log.info("{} - {}; we've been forwarded our own message back to us in a loop. Failing the message", (Object)this.state.serverName, (Object)string2);
                return CompletableFuture.completedFuture(EloquentRaftProto.RaftMessage.newBuilder().setSender(this.state.serverName).setRemoveServerReply(EloquentRaftProto.RemoveServerReply.newBuilder().setStatus(EloquentRaftProto.MembershipChangeStatus.NOT_LEADER)).build());
            }
            log.trace("{} - got {}; forwarding request to {}", new Object[]{this.state.serverName, string2, this.state.leader.orElse("<unknown>")});
            return this.transport.rpcTransportAsFuture(this.state.serverName, this.state.leader.orElse("<unknown>"), removeServerRequest.toBuilder().addForwardedBy(this.state.serverName).build(), (raftMessage, throwable) -> {
                assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
                if (raftMessage != null) {
                    return raftMessage;
                }
                log.warn("{} - {} Failure: <{}>", new Object[]{this.state.serverName, string2, throwable == null ? "unknown error" : throwable.getClass().getName() + ": " + throwable.getMessage()});
                return EloquentRaftProto.RaftMessage.newBuilder().setSender(this.state.serverName).setRemoveServerReply(EloquentRaftProto.RemoveServerReply.newBuilder().setStatus(EloquentRaftProto.MembershipChangeStatus.NOT_LEADER)).build();
            }, this.drivingThreadQueue, this.electionTimeoutMillisRange().end + 100L);
        }
        log.info("{} - got {}; we're not the leader and don't know who the leader is", (Object)this.state.serverName, (Object)string2);
        return CompletableFuture.completedFuture(EloquentRaftProto.RaftMessage.newBuilder().setSender(this.state.serverName).setRemoveServerReply(EloquentRaftProto.RemoveServerReply.newBuilder().setStatus(EloquentRaftProto.MembershipChangeStatus.NOT_LEADER)).build());
    }

    @Override
    public CompletableFuture<EloquentRaftProto.RaftMessage> receiveApplyTransitionRPC(EloquentRaftProto.ApplyTransitionRequest applyTransitionRequest, long l) {
        CompletionStage<EloquentRaftProto.RaftMessage> completionStage;
        assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
        String string2 = "ReceiveApplyTransition";
        log.trace("{} - [{}] {}; is_leader={}", new Object[]{this.state.serverName, this.transport.now(), string2, this.state.isLeader()});
        if (this.state.isLeader()) {
            RaftLogEntryLocation raftLogEntryLocation = this.state.transition(applyTransitionRequest.getTransition().isEmpty() ? Optional.empty() : Optional.of(applyTransitionRequest.getTransition().toByteArray()), "".equals(applyTransitionRequest.getNewHospiceMember()) ? Optional.empty() : Optional.of(applyTransitionRequest.getNewHospiceMember()));
            completionStage = this.state.log.createCommitFuture(raftLogEntryLocation.index, raftLogEntryLocation.term, true).handle((bl, throwable) -> {
                assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
                EloquentRaftProto.ApplyTransitionReply.Builder builder = EloquentRaftProto.ApplyTransitionReply.newBuilder().setTerm(this.state.currentTerm).setNewEntryIndex(-1L).setSuccess(bl != null ? bl : false);
                if (bl != null && bl.booleanValue()) {
                    builder.setNewEntryIndex(raftLogEntryLocation.index).setNewEntryTerm(raftLogEntryLocation.term);
                } else {
                    log.info("{} - {}; failed transition (on leader; could not commit) @ time={}", new Object[]{this.state.serverName, string2, l, throwable});
                }
                return EloquentRaftProto.RaftMessage.newBuilder().setSender(this.state.serverName).setApplyTransitionReply(builder).build();
            });
            this.broadcastAppendEntries(l, this.state.log.latestQuorumMembers.size() <= 1, false);
            this.updateLeaderInvariantsPostMessage(Optional.empty(), l);
        } else if (this.state.leader.map(string -> !string.equals(this.state.serverName)).orElse(false).booleanValue()) {
            if (applyTransitionRequest.getForwardedByList().contains((Object)this.state.serverName)) {
                log.info("{} - {}; we've been forwarded our own message back to us in a loop. Failing the message", (Object)this.state.serverName, (Object)string2);
                completionStage = CompletableFuture.completedFuture(EloquentRaftProto.RaftMessage.newBuilder().setSender(this.state.serverName).setApplyTransitionReply(EloquentRaftProto.ApplyTransitionReply.newBuilder().setTerm(this.state.currentTerm).setNewEntryIndex(-2L).setSuccess(false)).build());
            } else {
                assert (!this.state.leader.map(string -> string.equals(this.serverName())).orElse(false).booleanValue()) : "We are sending a message to the leader, but we think we're the leader!";
                log.trace("{} - [{}] {}; forwarding request to {}", new Object[]{this.state.serverName, this.transport.now(), string2, this.state.leader.orElse("<unknown>")});
                completionStage = this.transport.rpcTransportAsFuture(this.state.serverName, this.state.leader.orElse("<unknown>"), applyTransitionRequest.toBuilder().addForwardedBy(this.state.serverName).build(), (raftMessage, throwable) -> {
                    assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
                    if (raftMessage != null) {
                        log.trace("{} - {}; received reply to forwarded message", (Object)this.state.serverName, (Object)string2);
                        return raftMessage;
                    }
                    log.warn("{} - [{}] {} Failure: <{}>;  is_leader={}  leader={}", new Object[]{this.state.serverName, this.transport.now(), string2, throwable == null ? "unknown error" : throwable.getClass().getName() + ": " + throwable.getMessage(), this.state.isLeader(), this.state.leader.orElse("<unknown>")});
                    return EloquentRaftProto.RaftMessage.newBuilder().setSender(this.state.serverName).setApplyTransitionReply(EloquentRaftProto.ApplyTransitionReply.newBuilder().setTerm(this.state.currentTerm).setNewEntryIndex(-3L).setSuccess(false)).build();
                }, this.drivingThreadQueue, this.electionTimeoutMillisRange().end).thenCompose(raftMessage -> {
                    assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
                    if (raftMessage.getApplyTransitionReply().getSuccess()) {
                        log.trace("{} - {}; waiting for commit", (Object)this.state.serverName, (Object)string2);
                        long l = raftMessage.getApplyTransitionReply().getNewEntryIndex();
                        long l2 = raftMessage.getApplyTransitionReply().getNewEntryTerm();
                        return this.state.log.createCommitFuture(l, l2, true).thenApply(bl -> {
                            assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
                            log.trace("{} - {}; Entry @ {} (term={}) is committed in the local log", new Object[]{this.state.serverName, string2, l, l2});
                            EloquentRaftProto.ApplyTransitionReply.Builder builder = EloquentRaftProto.ApplyTransitionReply.newBuilder().setTerm(this.state.currentTerm).setNewEntryIndex(-4L).setSuccess((boolean)bl);
                            if (bl.booleanValue()) {
                                builder.setNewEntryIndex(l).setNewEntryTerm(l2);
                            } else {
                                log.info("{} - {}; failed transition (on follower) @ time={}", new Object[]{this.state.serverName, string2, this.transport.now()});
                            }
                            return EloquentRaftProto.RaftMessage.newBuilder().setSender(this.state.serverName).setApplyTransitionReply(builder).build();
                        });
                    }
                    log.info("{} - {}; failed to apply transition (reply proto had failure marked); returning failure", (Object)this.state.serverName, (Object)string2);
                    return CompletableFuture.completedFuture(raftMessage);
                });
            }
        } else {
            log.info("{} - {}; we're not the leader and don't know who the leader is", (Object)this.state.serverName, (Object)string2);
            completionStage = CompletableFuture.completedFuture(EloquentRaftProto.RaftMessage.newBuilder().setSender(this.state.serverName).setApplyTransitionReply(EloquentRaftProto.ApplyTransitionReply.newBuilder().setTerm(this.state.currentTerm).setNewEntryIndex(-5L).setSuccess(false)).build());
        }
        return completionStage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void heartbeat(long l) {
        assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
        long l2 = this.transport.now();
        Object object = Prometheus.startTimer(summaryTiming, "heartbeat");
        try {
            if (this.state.isLeader()) {
                Optional<String> optional;
                assert (this.checkDuration("leadership check", l2, this.transport.now()));
                long l3 = this.transport.now();
                log.trace("{} - heartbeat (leader) @ time={}  cluster={}", new Object[]{this.state.serverName, l, this.state.log.getQuorumMembers()});
                assert (this.checkDuration("get quorum members", l2, this.transport.now()));
                this.broadcastAppendEntries(l, false, true);
                if (Thread.interrupted()) {
                    throw new RuntimeInterruptedException();
                }
                assert (this.checkDuration("broadcast", l3, this.transport.now()));
                if (this.state.targetClusterSize >= 0) {
                    l3 = this.transport.now();
                    if (this.clusterMembershipFuture.getNow(null) != null) {
                        optional = this.state.serverToRemove(l, 30000L);
                        if (optional.isPresent()) {
                            log.info("{} - Detected Raft cluster is too large ({} > {}) or we have a delinquent server; scaling down by removing {} (latency {})  current_time={}", new Object[]{this.state.serverName, this.state.log.getQuorumMembers().size(), this.state.targetClusterSize, optional.get(), this.transport.now() - optional.flatMap(string -> this.state.lastMessageTimestamp.map(map -> (Long)map.get(string))).orElse(-1L), l});
                            this.receiveRPC(RaftTransport.mkRaftRPC(this.state.serverName, EloquentRaftProto.RemoveServerRequest.newBuilder().setOldServer(optional.get()).build()), l);
                            assert (this.checkDuration("remove server", l3, this.transport.now()));
                        } else {
                            optional = this.state.serverToAdd(l, this.electionTimeoutMillisRange().begin);
                            if (optional.isPresent()) {
                                log.info("{} - Detected Raft cluster is too small ({} < {}); scaling up by adding {} (latency {})  current_time={}", new Object[]{this.state.serverName, this.state.log.getQuorumMembers().size(), this.state.targetClusterSize, optional.get(), this.transport.now() - optional.flatMap(string -> this.state.lastMessageTimestamp.map(map -> (Long)map.get(string))).orElse(-1L), l});
                                this.receiveRPC(RaftTransport.mkRaftRPC(this.state.serverName, EloquentRaftProto.AddServerRequest.newBuilder().setNewServer(optional.get()).build()), l);
                                assert (this.checkDuration("add server", l3, this.transport.now()));
                            }
                        }
                    }
                    if (Thread.interrupted()) {
                        throw new RuntimeInterruptedException();
                    }
                    assert (this.checkDuration("size checks", l3, this.transport.now()));
                }
                l3 = this.transport.now();
                if (this.state.log.stateMachine instanceof KeyValueStateMachine) {
                    optional = this.state.killNodes(l, 30000L);
                    CompletionStage<Object> completionStage = CompletableFuture.completedFuture(null);
                    Iterator iterator = optional.iterator();
                    while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        completionStage = completionStage.thenCompose(raftMessage2 -> {
                            assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
                            log.info("{} - Clearing transient data for node {}", (Object)this.state.serverName, (Object)string2);
                            return this.receiveApplyTransitionRPC(EloquentRaftProto.ApplyTransitionRequest.newBuilder().setTransition(ByteString.copyFrom((byte[])KeyValueStateMachine.createClearTransition(string2))).build(), l).handle((raftMessage, throwable) -> {
                                if (throwable != null || raftMessage == null || !raftMessage.getApplyTransitionReply().getSuccess()) {
                                    this.state.revive(string2);
                                }
                                return null;
                            });
                        });
                    }
                }
                assert (this.checkDuration("offline check", l3, this.transport.now()));
            } else {
                log.trace("{} - heartbeat (follower) @ time={}  cluster={}", new Object[]{this.state.serverName, l, this.state.log.getQuorumMembers()});
                if (this.state.shouldTriggerElection(l, this.electionTimeoutMillisRange())) {
                    this.triggerElection(l);
                }
            }
        }
        finally {
            Prometheus.observeDuration(object);
            assert (this.checkDuration("total", l2, this.transport.now()));
        }
    }

    private boolean checkDuration(String string, long l, long l2) {
        assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
        long l3 = l2 - l;
        if (l3 > 50L) {
            long l4 = -1L;
            try {
                for (java.lang.management.GarbageCollectorMXBean platformManagedObject2 : ManagementFactory.getGarbageCollectorMXBeans()) {
                    GarbageCollectorMXBean garbageCollectorMXBean = (GarbageCollectorMXBean)platformManagedObject2;
                    GcInfo gcInfo = garbageCollectorMXBean.getLastGcInfo();
                    if (gcInfo == null) continue;
                    l4 = gcInfo.getStartTime();
                }
            }
            catch (Throwable throwable) {
                log.warn("Could not get GC info -- are you running on a non-Sun JVM?");
            }
            boolean bl = false;
            if (l4 > l && l4 < l2) {
                bl = true;
            }
            OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
            log.warn("{} - Raft took >50ms ({}) on step '{}';  leadership={}  system_load={}  interrupted_by_gc={}", new Object[]{this.state.serverName, TimerUtils.formatTimeDifference(l3), string, this.state.leadership, operatingSystemMXBean.getSystemLoadAverage(), bl});
        }
        return true;
    }

    @Override
    public boolean bootstrap(boolean bl) {
        assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
        if (bl || this.state.targetClusterSize >= 0 && this.state.log.getQuorumMembers().isEmpty()) {
            this.state.bootstrap(bl);
            return true;
        }
        return false;
    }

    @Override
    public void stop(boolean bl) {
    }

    @Override
    public boolean isRunning() {
        return true;
    }

    @Override
    public void receiveBadRequest(EloquentRaftProto.RaftMessage raftMessage) {
        assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
        if (raftMessage.getApplyTransitionReply() != EloquentRaftProto.ApplyTransitionReply.getDefaultInstance()) {
            log.warn("{} - Got an apply transition reply -- likely the dangling reply of a timeout somewhere", (Object)this.state.serverName);
        } else {
            log.warn("{} - Bad Raft message {}", (Object)this.state.serverName, (Object)raftMessage.toString());
        }
    }

    @Override
    public Optional<RaftLifecycle> lifecycle() {
        return this.lifecycle;
    }

    @Override
    public RaftTransport getTransport() {
        return this.transport;
    }

    public List<String> errors() {
        assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.clusterMembershipFuture.getNow(null) == null) {
            arrayList.add("Membership change in progress (future is not empty). My state: " + (Object)((Object)this.state.leadership) + "; leader=" + this.state.leader.orElse("<unknown>"));
        }
        if (this.state.lastMessageTimestamp.map(Map::size).orElse(0) > 1000) {
            arrayList.add("Keeping track of >1000 heartbeat (" + this.state.lastMessageTimestamp.map(Map::size).orElse(0) + ")");
        }
        if (this.state.electionTimeoutCheckpoint < 0L) {
            arrayList.add("No election timeout present (perhaps means heartbeats are not propagating?): " + Instant.ofEpochMilli(this.state.electionTimeoutCheckpoint));
        }
        long l = this.transport.now() - Arrays.stream(this.lastBroadcastTimes).max().orElse(0L);
        if (this.state.isLeader() && l > this.heartbeatMillis() * 10L) {
            arrayList.add("Last broadcast was " + TimerUtils.formatTimeDifference(l) + " ago");
        }
        return arrayList;
    }

    private boolean canPerformFollowerAction(String string, long l, boolean bl) {
        assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
        if (l < this.state.currentTerm && !bl) {
            log.trace("{} - {} cannot perform action: remoteTerm={} < currentTerm={}", new Object[]{this.state.serverName, string, l, this.state.currentTerm});
            return false;
        }
        if (l > this.state.currentTerm) {
            log.trace("{} - {} detected remoteTerm={} > currentTerm={} -- forced into follower state but otherwise continuing", new Object[]{this.state.serverName, string, l, this.state.currentTerm});
            this.state.stepDownFromElection();
            this.state.setCurrentTerm(l);
            assert (this.state.leadership == RaftState.LeadershipStatus.OTHER);
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asLeader(String string, long l, long l2, Runnable runnable) {
        assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
        if (this.canPerformLeaderAction(string, l)) {
            try {
                assert (this.state.isLeader()) : "We should be a leader if we get this far performing a leader action";
                runnable.run();
            }
            finally {
                this.updateLeaderInvariantsPostMessage(Optional.of(string), l2);
            }
        } else {
            log.trace("{} - Leader prereqs failed.", (Object)this.state.serverName);
        }
    }

    private boolean canPerformLeaderAction(String string, long l) {
        assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
        if (!this.state.isLeader()) {
            log.trace("{} - presumed leader is not a leader", (Object)this.state.serverName);
            return false;
        }
        if (string.isEmpty()) {
            log.warn("{} - Got a message with no follower name. This is an error!", (Object)this.state.serverName);
            return false;
        }
        if (l < this.state.currentTerm) {
            log.warn("{} - leader cannot perform action. remoteTerm={} < currentTerm={}", new Object[]{this.state.serverName, l, this.state.currentTerm});
            return false;
        }
        if (l > this.state.currentTerm) {
            log.trace("{} - detected remoteTerm={} > currentTerm={} -- forced into follower state", new Object[]{this.state.serverName, l, this.state.currentTerm});
            this.state.stepDownFromElection();
            this.state.setCurrentTerm(l);
            assert (this.state.leadership == RaftState.LeadershipStatus.OTHER);
            return false;
        }
        return true;
    }

    private void updateLeaderInvariantsPostMessage(Optional<String> optional, long l) {
        assert (this.drivingThreadId < 0L || this.drivingThreadId == Thread.currentThread().getId()) : "Eloquent Raft Algorithm should only be run from the driving thread (" + this.drivingThreadId + ") but is being driven by " + Thread.currentThread();
        if (this.state.isLeader()) {
            optional.ifPresent(string -> this.state.observeLifeFrom((String)string, l));
            this.state.matchIndex.ifPresent(map -> {
                Set<String> set = this.state.log.getQuorumMembers();
                if (!set.isEmpty()) {
                    long[] lArray = set.stream().mapToLong(string -> {
                        if (this.state.serverName.equals(string)) {
                            return this.state.log.getLastEntryIndex();
                        }
                        assert (map.containsKey(string)) : "no match index for member " + string;
                        return (Long)map.get(string);
                    }).toArray();
                    Arrays.sort(lArray);
                    long l2 = lArray.length % 2 == 0 ? lArray[lArray.length / 2 - 1] : lArray[lArray.length / 2];
                    if (l2 > this.state.commitIndex() && this.state.log.getLastEntryTerm() == this.state.currentTerm) {
                        log.trace("{} - Committing up to index {}; matchIndex={} -> {}", new Object[]{this.state.serverName, l2, map, lArray});
                        this.state.commitUpTo(l2, l);
                        if (optional.isPresent()) {
                            this.broadcastAppendEntries(l, false, false);
                        }
                    }
                }
            });
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        EloquentRaftAlgorithm eloquentRaftAlgorithm = (EloquentRaftAlgorithm)object;
        return Objects.equals(this.state, eloquentRaftAlgorithm.state);
    }

    public int hashCode() {
        return Objects.hash(this.state);
    }
}

