/*
 * Decompiled with CFR 0.152.
 */
package ai.eloquent.raft;

import ai.eloquent.error.RaftErrorListener;
import ai.eloquent.raft.EloquentRaftAlgorithm;
import ai.eloquent.raft.EloquentRaftProto;
import ai.eloquent.raft.RaftAlgorithm;
import ai.eloquent.raft.RaftFailsafe;
import ai.eloquent.raft.RaftLifecycle;
import ai.eloquent.raft.RaftTransport;
import ai.eloquent.raft.SingleThreadedRaftAlgorithm;
import ai.eloquent.util.Pointer;
import ai.eloquent.util.RuntimeIOException;
import ai.eloquent.util.SafeTimerTask;
import ai.eloquent.util.SystemUtils;
import ai.eloquent.util.TimerUtils;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EloquentRaftNode
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(EloquentRaftNode.class);
    private static ArrayList<RaftErrorListener> errorListeners = new ArrayList();
    public final RaftAlgorithm algorithm;
    public final RaftTransport transport;
    public final RaftLifecycle lifecycle;
    private boolean alive = true;
    private long lastHeartbeat;
    private List<Runnable> shutdownHooks = new ArrayList<Runnable>();
    private final List<RaftFailsafe> failsafes = new ArrayList<RaftFailsafe>();
    private Pointer<SafeTimerTask> heartbeatTimerTask = new Pointer();
    private Pointer<SafeTimerTask> failsafeTimerTask = new Pointer();

    protected void addErrorListener(RaftErrorListener raftErrorListener) {
        errorListeners.add(raftErrorListener);
    }

    protected void removeErrorListener(RaftErrorListener raftErrorListener) {
        errorListeners.remove(raftErrorListener);
    }

    protected void clearErrorListeners() {
        errorListeners.clear();
    }

    private void throwRaftError(String string, String string2) {
        errorListeners.forEach(raftErrorListener -> raftErrorListener.accept(string, string2, Thread.currentThread().getStackTrace()));
    }

    public EloquentRaftNode(RaftAlgorithm raftAlgorithm, RaftTransport raftTransport, RaftLifecycle raftLifecycle) {
        this.algorithm = raftAlgorithm;
        this.transport = raftTransport;
        this.lifecycle = raftLifecycle;
        this.lastHeartbeat = raftTransport.now();
        try {
            raftTransport.bind(raftAlgorithm);
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(iOException);
        }
        raftLifecycle.registerRaft(this);
    }

    public void registerShutdownHook(Runnable runnable) {
        this.shutdownHooks.add(runnable);
    }

    public void start() {
        SafeTimerTask safeTimerTask = new SafeTimerTask(){
            private final ExecutorService pool;
            {
                this.pool = EloquentRaftNode.this.lifecycle.managedThreadPool("raft-heartbeat-" + EloquentRaftNode.this.algorithm.serverName().replace('.', '_'), Math.max(9, 1));
            }

            @Override
            protected ExecutorService pool() {
                return this.pool;
            }

            @Override
            public void runUnsafe() {
                try {
                    if (EloquentRaftNode.this.alive) {
                        EloquentRaftNode.this.lastHeartbeat = EloquentRaftNode.this.transport.now();
                        EloquentRaftNode.this.algorithm.heartbeat(EloquentRaftNode.this.transport.now());
                    } else {
                        log.info("{} - Stopping heartbeat timer by user request", (Object)EloquentRaftNode.this.algorithm.serverName());
                        this.cancel();
                    }
                }
                catch (Throwable throwable) {
                    log.warn("Got exception on Raft heartbeat timer task: ", throwable);
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    throwable.printStackTrace(printWriter);
                    EloquentRaftNode.this.throwRaftError("heartbeat_error@" + SystemUtils.HOST, "Exception on Raft heartbeat");
                }
            }
        };
        this.transport.scheduleAtFixedRate(safeTimerTask, this.algorithm.heartbeatMillis());
        this.heartbeatTimerTask.set(safeTimerTask);
        SafeTimerTask safeTimerTask2 = new SafeTimerTask(){
            private final ExecutorService pool;
            {
                this.pool = EloquentRaftNode.this.lifecycle.managedThreadPool("raft-failsafe-" + EloquentRaftNode.this.algorithm.serverName().replace('.', '_'), Math.max(9, 1));
            }

            @Override
            protected ExecutorService pool() {
                return this.pool;
            }

            @Override
            public void runUnsafe() {
                try {
                    if (EloquentRaftNode.this.alive) {
                        for (RaftFailsafe raftFailsafe : EloquentRaftNode.this.failsafes) {
                            raftFailsafe.heartbeat(EloquentRaftNode.this.algorithm, System.currentTimeMillis());
                        }
                        EloquentRaftNode.this.lastHeartbeat = EloquentRaftNode.this.transport.now();
                    } else {
                        log.info("{} - Stopping failsafe timer by user request", (Object)EloquentRaftNode.this.algorithm.serverName());
                        this.cancel();
                    }
                }
                catch (Throwable throwable) {
                    log.warn("Got exception on Raft failsafe timer task: ", throwable);
                }
            }
        };
        this.transport.scheduleAtFixedRate(safeTimerTask2, Duration.ofSeconds(1L).toMillis());
        this.failsafeTimerTask.set(safeTimerTask2);
    }

    public boolean bootstrap(boolean bl) {
        return this.algorithm.bootstrap(bl);
    }

    public CompletableFuture<Boolean> submitTransition(byte[] byArray) {
        return this.algorithm.receiveRPC(RaftTransport.mkRaftRPC(this.algorithm.serverName(), EloquentRaftProto.ApplyTransitionRequest.newBuilder().setTransition(ByteString.copyFrom((byte[])byArray)).setTerm(this.algorithm.term()).build()), this.transport.now()).thenApply(raftMessage -> raftMessage.getApplyTransitionReply().getSuccess());
    }

    public List<String> errors() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.algorithm instanceof EloquentRaftAlgorithm) {
            arrayList.addAll(((EloquentRaftAlgorithm)this.algorithm).errors());
        } else if (this.algorithm instanceof SingleThreadedRaftAlgorithm) {
            arrayList.addAll(((SingleThreadedRaftAlgorithm)this.algorithm).errors());
        }
        if (!this.alive) {
            arrayList.add("Node is not alive");
        }
        if (this.alive && Math.abs(this.transport.now() - this.lastHeartbeat) > this.algorithm.heartbeatMillis() * 2L) {
            arrayList.add("Last heartbeat was " + TimerUtils.formatTimeSince(this.lastHeartbeat) + " ago");
        }
        return arrayList;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void close(boolean bl) {
        if (this.alive) {
            log.info(this.algorithm.serverName() + " - Stopping Raft node {}", (Object)this.algorithm.serverName());
            for (Runnable runnable : this.shutdownHooks) {
                runnable.run();
            }
            RaftAlgorithm.shutdown(this.algorithm, this.transport, bl);
            this.alive = false;
            log.info(this.algorithm.serverName() + " - Stopped Raft node {}", (Object)this.algorithm.serverName());
        } else {
            log.warn("Detected double shutdown of {} -- ignoring", (Object)this.algorithm.serverName());
        }
    }

    @Override
    public void close() {
        this.close(false);
    }

    public void registerFailsafe(RaftFailsafe raftFailsafe) {
        this.failsafes.add(raftFailsafe);
    }
}

