/*
 * Decompiled with CFR 0.152.
 */
package ai.eloquent.raft;

import ai.eloquent.raft.EloquentRaftProto;
import ai.eloquent.raft.RaftAlgorithm;
import ai.eloquent.raft.RaftTransport;
import ai.eloquent.raft.Theseus;
import ai.eloquent.util.SafeTimerTask;
import ai.eloquent.util.Span;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstantTransport
implements RaftTransport {
    private static final Logger log = LoggerFactory.getLogger(InstantTransport.class);
    Map<String, RaftAlgorithm> bound = new HashMap<String, RaftAlgorithm>();

    @Override
    public void bind(RaftAlgorithm raftAlgorithm) {
        this.bound.put(raftAlgorithm.serverName(), raftAlgorithm);
    }

    @Override
    public Collection<RaftAlgorithm> boundAlgorithms() {
        return this.bound.values();
    }

    @Override
    public void rpcTransport(String string, String string2, EloquentRaftProto.RaftMessage raftMessage, Consumer<EloquentRaftProto.RaftMessage> consumer, Runnable runnable, long l) {
        try {
            EloquentRaftProto.RaftMessage raftMessage2 = this.bound.get(string2).receiveRPC(raftMessage, System.currentTimeMillis()).get();
            consumer.accept(raftMessage2);
        }
        catch (InterruptedException | ExecutionException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void sendTransport(String string, String string2, EloquentRaftProto.RaftMessage raftMessage2) {
        this.bound.get(string2).receiveMessage(raftMessage2, raftMessage -> this.sendTransport(string2, string, (EloquentRaftProto.RaftMessage)raftMessage), System.currentTimeMillis());
    }

    @Override
    public void broadcastTransport(String string, EloquentRaftProto.RaftMessage raftMessage) {
        for (RaftAlgorithm raftAlgorithm : this.bound.values()) {
            if (raftAlgorithm.serverName().equals(string)) continue;
            try {
                EloquentRaftProto.RaftMessage raftMessage2 = raftAlgorithm.receiveRPC(raftMessage, System.currentTimeMillis()).get();
                this.sendTransport(raftAlgorithm.serverName(), string, raftMessage2);
            }
            catch (InterruptedException | ExecutionException exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public Span expectedNetworkDelay() {
        return new Span(0L, 1L);
    }

    @Override
    public void scheduleAtFixedRate(SafeTimerTask safeTimerTask, long l) {
    }

    @Override
    public void schedule(SafeTimerTask safeTimerTask, long l) {
    }

    private static double burnInRun(Theseus theseus, long l) {
        long l2 = System.nanoTime();
        int n = 0;
        while ((long)n < l) {
            try {
                theseus.withElementAsync("key_" + n % 50, new AddOne(), () -> ByteBuffer.allocate(4).putInt(0).array(), true).get(5L, TimeUnit.SECONDS);
                theseus.node.algorithm.heartbeat(n);
            }
            catch (InterruptedException | ExecutionException | TimeoutException exception) {
                log.warn("Caught exception running JIT burn in:", (Throwable)exception);
            }
            ++n;
        }
        return (double)(System.nanoTime() - l2) / (double)l;
    }

    public static void burnInJIT() {
        log.info("Ignoring the burn in run on Raft, since the InstantTransport deadlocks...");
    }

    private static class AddOne
    implements Function<byte[], byte[]> {
        private AddOne() {
        }

        @Override
        public byte[] apply(byte[] byArray) {
            int n = ByteBuffer.wrap(byArray).getInt() + 1;
            return ByteBuffer.allocate(4).putInt(n).array();
        }
    }
}

