/*
 * Decompiled with CFR 0.152.
 */
package ai.eloquent.raft;

import ai.eloquent.error.RaftErrorListener;
import ai.eloquent.monitoring.Prometheus;
import ai.eloquent.raft.KeyValueStateMachineProto;
import ai.eloquent.raft.RaftStateMachine;
import ai.eloquent.util.IdentityHashSet;
import ai.eloquent.util.StackTrace;
import ai.eloquent.util.SystemUtils;
import ai.eloquent.util.TimerUtils;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValueStateMachine
extends RaftStateMachine {
    private static final Logger log = LoggerFactory.getLogger(KeyValueStateMachine.class);
    private static final Object gaugeNumListeners = Prometheus.gaugeBuild("kv_state_machine_listeners", "The number of listeners on Raft's Key/Value state machine");
    private static ArrayList<RaftErrorListener> errorListeners = new ArrayList();
    final Map<String, ValueWithOptionalOwner> values = new ConcurrentHashMap<String, ValueWithOptionalOwner>();
    final Map<String, QueueLock> locks = new ConcurrentHashMap<String, QueueLock>();
    final List<LockAcquiredFuture> lockAcquiredFutures = new ArrayList<LockAcquiredFuture>();
    final Set<ChangeListener> changeListeners = new IdentityHashSet<ChangeListener>();
    Map<ChangeListener, StackTrace> changeListenerToTrace = new IdentityHashMap<ChangeListener, StackTrace>();
    public final Optional<String> serverName;

    protected void addErrorListener(RaftErrorListener raftErrorListener) {
        errorListeners.add(raftErrorListener);
    }

    protected void removeErrorListener(RaftErrorListener raftErrorListener) {
        errorListeners.remove(raftErrorListener);
    }

    protected void clearErrorListeners() {
        errorListeners.clear();
    }

    protected void throwRaftError(String string, String string2) {
        errorListeners.forEach(raftErrorListener -> raftErrorListener.accept(string, string2, Thread.currentThread().getStackTrace()));
    }

    public KeyValueStateMachine(String string) {
        this.serverName = Optional.ofNullable(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ByteString serializeImpl() {
        ByteString byteString;
        long l = System.currentTimeMillis();
        try {
            KeyValueStateMachineProto.KVStateMachine.Builder builder = KeyValueStateMachineProto.KVStateMachine.newBuilder();
            this.values.forEach((string, valueWithOptionalOwner) -> {
                builder.addValuesKeys((String)string);
                builder.addValuesValues(valueWithOptionalOwner.serialize());
            });
            this.locks.forEach((string, queueLock) -> {
                builder.addLocksKeys((String)string);
                builder.addLocksValues(queueLock.serialize());
            });
            byteString = builder.build().toByteString();
        }
        catch (Throwable throwable) {
            if (!this.values.isEmpty() && System.currentTimeMillis() - l > 10L) {
                log.warn("Serialization of state machine took {}; {} entries and {} locks", new Object[]{TimerUtils.formatTimeSince(l), this.values.size(), this.locks.size()});
            }
            throw throwable;
        }
        if (!this.values.isEmpty() && System.currentTimeMillis() - l > 10L) {
            log.warn("Serialization of state machine took {}; {} entries and {} locks", new Object[]{TimerUtils.formatTimeSince(l), this.values.size(), this.locks.size()});
        }
        return byteString;
    }

    @Override
    public synchronized void overwriteWithSerializedImpl(byte[] byArray, long l, ExecutorService executorService) {
        try {
            int n;
            KeyValueStateMachineProto.KVStateMachine kVStateMachine = KeyValueStateMachineProto.KVStateMachine.parseFrom(byArray);
            this.values.clear();
            for (n = 0; n < kVStateMachine.getValuesKeysCount(); ++n) {
                ValueWithOptionalOwner valueWithOptionalOwner = ValueWithOptionalOwner.deserialize(kVStateMachine.getValuesValues(n));
                this.values.put(kVStateMachine.getValuesKeys(n), valueWithOptionalOwner);
            }
            this.locks.clear();
            for (n = 0; n < kVStateMachine.getLocksKeysCount(); ++n) {
                this.locks.put(kVStateMachine.getLocksKeys(n), QueueLock.deserialize(kVStateMachine.getLocksValues(n)));
            }
            this.checkLocksAcquired(executorService);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            log.error("Attempting to deserialize an invalid snapshot! This is very bad. Leaving current state unchanged.", (Throwable)invalidProtocolBufferException);
        }
    }

    @Override
    public void applyTransition(byte[] byArray, long l, ExecutorService executorService) {
        try {
            KeyValueStateMachineProto.Transition transition = KeyValueStateMachineProto.Transition.parseFrom(byArray);
            this.applyTransition(transition, l, executorService);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            log.warn("Attempting to deserialize an invalid transition! This is very bad. Leaving current state unchanged.", (Throwable)invalidProtocolBufferException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyTransition(KeyValueStateMachineProto.Transition transition, long l, ExecutorService executorService) {
        HashSet<ChangeListener> hashSet;
        boolean bl = false;
        switch (transition.getType()) {
            case TRANSITION_GROUP: {
                for (KeyValueStateMachineProto.Transition object2 : transition.getTransitionsList()) {
                    this.applyTransition(object2, l, executorService);
                }
                break;
            }
            case REQUEST_LOCK: {
                hashSet = transition.getRequestLock();
                LockRequest lockRequest = new LockRequest(((KeyValueStateMachineProto.RequestLock)((Object)hashSet)).getRequester(), ((KeyValueStateMachineProto.RequestLock)((Object)hashSet)).getUniqueHash());
                Iterator iterator = this;
                synchronized (iterator) {
                    if (!this.locks.containsKey(((KeyValueStateMachineProto.RequestLock)((Object)hashSet)).getLock())) {
                        QueueLock queueLock = new QueueLock(Optional.of(lockRequest), new ArrayList<LockRequest>());
                        this.locks.put(((KeyValueStateMachineProto.RequestLock)((Object)hashSet)).getLock(), queueLock);
                    } else {
                        QueueLock queueLock = this.locks.get(((KeyValueStateMachineProto.RequestLock)((Object)hashSet)).getLock());
                        if (!(queueLock.waiting.contains(lockRequest) || queueLock.holder.isPresent() && queueLock.holder.get().equals(lockRequest))) {
                            queueLock.waiting.add(lockRequest);
                        }
                    }
                    this.checkLocksAcquired(executorService, ((KeyValueStateMachineProto.RequestLock)((Object)hashSet)).getLock());
                    break;
                }
            }
            case RELEASE_LOCK: {
                Optional<LockRequest> optional;
                Object object2;
                Iterator iterator = transition.getReleaseLock();
                KeyValueStateMachine keyValueStateMachine = this;
                synchronized (keyValueStateMachine) {
                    if (this.locks.containsKey(((KeyValueStateMachineProto.ReleaseLock)((Object)iterator)).getLock())) {
                        object2 = this.locks.get(((KeyValueStateMachineProto.ReleaseLock)((Object)iterator)).getLock());
                        if (((QueueLock)object2).holder.isPresent() && ((QueueLock)object2).holder.get().server.equals(((KeyValueStateMachineProto.ReleaseLock)((Object)iterator)).getRequester()) && ((QueueLock)object2).holder.get().uniqueHash.equals(((KeyValueStateMachineProto.ReleaseLock)((Object)iterator)).getUniqueHash())) {
                            this.releaseLock(((KeyValueStateMachineProto.ReleaseLock)((Object)iterator)).getLock(), executorService);
                        } else {
                            optional = Optional.empty();
                            for (LockRequest lockRequest : ((QueueLock)object2).waiting) {
                                if (!lockRequest.server.equals(((KeyValueStateMachineProto.ReleaseLock)((Object)iterator)).getRequester()) || !lockRequest.uniqueHash.equals(((KeyValueStateMachineProto.ReleaseLock)((Object)iterator)).getUniqueHash())) continue;
                                optional = Optional.of(lockRequest);
                            }
                            optional.ifPresent(arg_0 -> KeyValueStateMachine.lambda$applyTransition$3((QueueLock)object2, arg_0));
                            if (!optional.isPresent()) {
                                log.warn("Received a release lock command that will not result in any action - this is fine, but should be rare");
                            }
                        }
                    } else {
                        log.warn("Received a release lock command that will not result in any action - this is fine, but should be rare");
                    }
                    break;
                }
            }
            case TRY_LOCK: {
                Object object;
                KeyValueStateMachineProto.TryLock tryLock = transition.getTryLock();
                Object object2 = new LockRequest(tryLock.getRequester(), tryLock.getUniqueHash());
                Optional<LockRequest> optional = this;
                synchronized (optional) {
                    if (!this.locks.containsKey(tryLock.getLock())) {
                        object = new QueueLock(Optional.of(object2), new ArrayList<LockRequest>());
                        this.locks.put(tryLock.getLock(), (QueueLock)object);
                    }
                    this.checkLocksAcquired(executorService, tryLock.getLock());
                    break;
                }
            }
            case SET_VALUE: {
                Optional<LockRequest> optional = transition.getSetValue();
                Object object = ((KeyValueStateMachineProto.SetValue)((Object)optional)).getOwner().equals("") ? new ValueWithOptionalOwner(((KeyValueStateMachineProto.SetValue)((Object)optional)).getValue().toByteArray(), l) : new ValueWithOptionalOwner(((KeyValueStateMachineProto.SetValue)((Object)optional)).getValue().toByteArray(), ((KeyValueStateMachineProto.SetValue)((Object)optional)).getOwner(), l);
                if (!this.values.containsKey(((KeyValueStateMachineProto.SetValue)((Object)optional)).getKey()) || !this.values.get(((KeyValueStateMachineProto.SetValue)((Object)optional)).getKey()).equals(object)) {
                    bl = true;
                }
                this.values.put(((KeyValueStateMachineProto.SetValue)((Object)optional)).getKey(), (ValueWithOptionalOwner)object);
                break;
            }
            case REMOVE_VALUE: {
                KeyValueStateMachineProto.RemoveValue removeValue = transition.getRemoveValue();
                if (this.values.containsKey(removeValue.getKey())) {
                    bl = true;
                }
                this.values.remove(removeValue.getKey());
                break;
            }
            case CLEAR_TRANSIENTS: {
                KeyValueStateMachine keyValueStateMachine = this;
                synchronized (keyValueStateMachine) {
                    this.clearTransientsFor(transition.getClearTransients().getOwner(), executorService);
                    break;
                }
            }
            case UNRECOGNIZED: 
            case INVALID: {
                log.warn("Unrecognized transition type " + (Object)((Object)transition.getType()) + "! This is very bad. Leaving current state unchanged.");
            }
        }
        if (bl) {
            Set<ChangeListener> set = this.changeListeners;
            synchronized (set) {
                hashSet = new HashSet<ChangeListener>(this.changeListeners);
            }
            if (hashSet.size() > 0) {
                ValueWithOptionalOwnerMapView valueWithOptionalOwnerMapView = new ValueWithOptionalOwnerMapView(this.values);
                for (ChangeListener changeListener : hashSet) {
                    if (transition.getType() == KeyValueStateMachineProto.TransitionType.SET_VALUE) {
                        executorService.execute(() -> changeListener.onChange(transition.getSetValue().getKey(), Optional.of(transition.getSetValue().getValue().toByteArray()), valueWithOptionalOwnerMapView));
                        continue;
                    }
                    if (transition.getType() == KeyValueStateMachineProto.TransitionType.REMOVE_VALUE) {
                        executorService.execute(() -> changeListener.onChange(transition.getRemoveValue().getKey(), Optional.empty(), valueWithOptionalOwnerMapView));
                        continue;
                    }
                    log.warn("We should be calling a change listener, but the transition doesn't seem to warrant an update");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener changeListener) {
        int n;
        Set<ChangeListener> set = this.changeListeners;
        synchronized (set) {
            this.changeListeners.add(changeListener);
            n = this.changeListeners.size();
            assert (this.changeListeners.contains(changeListener));
            this.changeListenerToTrace.put(changeListener, new StackTrace());
            assert (this.changeListenerToTrace.containsKey(changeListener));
            Prometheus.gaugeSet(gaugeNumListeners, n);
        }
        if (n > 256) {
            this.throwRaftError("too-many-raft-listeners-" + SystemUtils.HOST, "Too many Raft listeners: Listener count at : " + n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.changeListeners;
        synchronized (set) {
            int n;
            Set<ChangeListener> set2 = this.changeListeners;
            synchronized (set2) {
                if (!this.changeListeners.remove(changeListener)) {
                    log.warn("Removing a change listener that isn't registered");
                }
                if (this.changeListenerToTrace.remove(changeListener) == null) {
                    log.warn("Could not find change listener in stack trace mapping");
                }
                n = this.changeListeners.size();
            }
            Prometheus.gaugeSet(gaugeNumListeners, n);
        }
    }

    public Optional<byte[]> get(String string, long l) {
        return Optional.ofNullable(this.values.getOrDefault(string, null)).map(valueWithOptionalOwner -> valueWithOptionalOwner.registerGet(l));
    }

    public Collection<String> keys() {
        return this.values.keySet();
    }

    public Map<String, byte[]> map() {
        return new ValueWithOptionalOwnerMapView(new HashMap<String, ValueWithOptionalOwner>(this.values));
    }

    public Set<String> keysIdleSince(Duration duration, long l) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Map.Entry<String, ValueWithOptionalOwner> entry : this.values.entrySet()) {
            if (entry.getValue().lastAccessed + duration.toMillis() >= l) continue;
            hashSet.add(entry.getKey());
        }
        return hashSet;
    }

    public Set<String> keysPresentSince(Duration duration, long l) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Map.Entry<String, ValueWithOptionalOwner> entry : this.values.entrySet()) {
            if (entry.getValue().createdAt + duration.toMillis() >= l) continue;
            hashSet.add(entry.getKey());
        }
        return hashSet;
    }

    public Collection<Map.Entry<String, ValueWithOptionalOwner>> entries() {
        return this.values.entrySet();
    }

    private void releaseLock(String string, ExecutorService executorService) {
        if (this.locks.containsKey(string)) {
            QueueLock queueLock = this.locks.get(string);
            if (queueLock.waiting.size() > 0) {
                LockRequest lockRequest = queueLock.waiting.get(0);
                queueLock.waiting.remove(0);
                queueLock.holder = Optional.of(lockRequest);
            } else {
                this.locks.remove(string);
            }
        }
        this.checkLocksAcquired(executorService, string);
    }

    private synchronized void clearTransientsFor(String string, ExecutorService executorService) {
        if (this.serverName.map(string2 -> Objects.equals(string2, string)).orElse(false).booleanValue()) {
            log.warn("Got a Raft transition telling us we're offline. We are, of course, not offline. All transient state owned by us is being cleared.");
        }
        HashSet hashSet = new HashSet();
        this.values.forEach((string3, valueWithOptionalOwner) -> {
            if (valueWithOptionalOwner.owner.map(string2 -> Objects.equals(string2, string)).orElse(false).booleanValue()) {
                hashSet.add(string3);
            }
        });
        for (String string4 : hashSet) {
            this.values.remove(string4);
        }
        HashMap<String, QueueLock> hashMap = new HashMap<String, QueueLock>(this.locks);
        hashMap.values().forEach(queueLock -> queueLock.waiting.removeIf(lockRequest -> Objects.equals(lockRequest.server, string)));
        hashMap.entrySet().stream().filter(entry -> ((QueueLock)entry.getValue()).holder.map(lockRequest -> Objects.equals(lockRequest.server, string)).orElse(false)).forEach(entry -> this.releaseLock((String)entry.getKey(), executorService));
    }

    @Override
    public Set<String> owners() {
        HashSet<String> hashSet = new HashSet<String>();
        this.locks.forEach((string, queueLock) -> {
            if (queueLock.holder.isPresent()) {
                String string2 = queueLock.holder.get().server;
                hashSet.add(string2);
            }
        });
        this.values.forEach((string, valueWithOptionalOwner) -> {
            if (valueWithOptionalOwner.owner.isPresent()) {
                String string2 = valueWithOptionalOwner.owner.get();
                hashSet.add(string2);
            }
        });
        return hashSet;
    }

    @Override
    public String debugTransition(byte[] byArray) {
        try {
            KeyValueStateMachineProto.Transition transition = KeyValueStateMachineProto.Transition.parseFrom(byArray);
            if (transition.getType() == KeyValueStateMachineProto.TransitionType.REQUEST_LOCK) {
                return transition.getRequestLock().getRequester() + " requests lock '" + transition.getRequestLock().getLock() + "' with hash " + transition.getRequestLock().getUniqueHash();
            }
            if (transition.getType() == KeyValueStateMachineProto.TransitionType.RELEASE_LOCK) {
                return transition.getReleaseLock().getRequester() + " releases lock '" + transition.getReleaseLock().getLock() + "' with hash " + transition.getReleaseLock().getUniqueHash();
            }
            if (transition.getType() == KeyValueStateMachineProto.TransitionType.SET_VALUE) {
                return "set " + transition.getSetValue().getKey() + " = '" + transition.getSetValue().getValue().toStringUtf8() + "'";
            }
            if (transition.getType() == KeyValueStateMachineProto.TransitionType.REMOVE_VALUE) {
                return "remove " + transition.getRemoveValue().getKey();
            }
            return "Unrecognized - type " + (Object)((Object)transition.getType());
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            return "Unrecognized - invalid proto";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeLockFuture(@Nullable ExecutorService executorService, QueueLock queueLock, LockAcquiredFuture lockAcquiredFuture) {
        if (queueLock.holder.isPresent() && queueLock.holder.get().server.equals(lockAcquiredFuture.requester) && queueLock.holder.get().uniqueHash.equals(lockAcquiredFuture.uniqueHash)) {
            List<LockAcquiredFuture> list = this.lockAcquiredFutures;
            synchronized (list) {
                this.lockAcquiredFutures.remove(lockAcquiredFuture);
            }
            if (executorService == null) {
                lockAcquiredFuture.future.complete(true);
            } else {
                executorService.execute(() -> lockAcquiredFuture.future.complete(true));
            }
        } else if (!queueLock.holder.isPresent()) {
            List<LockAcquiredFuture> list = this.lockAcquiredFutures;
            synchronized (list) {
                this.lockAcquiredFutures.remove(lockAcquiredFuture);
            }
            if (executorService == null) {
                lockAcquiredFuture.future.complete(false);
            } else {
                executorService.execute(() -> lockAcquiredFuture.future.complete(false));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLocksAcquired(ExecutorService executorService, String string) {
        ArrayList<LockAcquiredFuture> arrayList;
        List<LockAcquiredFuture> list = this.lockAcquiredFutures;
        synchronized (list) {
            arrayList = new ArrayList<LockAcquiredFuture>(this.lockAcquiredFutures);
        }
        for (LockAcquiredFuture lockAcquiredFuture : new ArrayList<LockAcquiredFuture>(arrayList)) {
            if (!string.equals(lockAcquiredFuture.lock)) continue;
            QueueLock queueLock = this.locks.get(string);
            if (queueLock != null) {
                this.completeLockFuture(executorService, queueLock, lockAcquiredFuture);
                continue;
            }
            executorService.execute(() -> lockAcquiredFuture.future.complete(false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLocksAcquired(ExecutorService executorService) {
        ArrayList<LockAcquiredFuture> arrayList;
        List<LockAcquiredFuture> list = this.lockAcquiredFutures;
        synchronized (list) {
            arrayList = new ArrayList<LockAcquiredFuture>(this.lockAcquiredFutures);
        }
        list = new ArrayList<LockAcquiredFuture>();
        for (LockAcquiredFuture lockAcquiredFuture : new ArrayList<LockAcquiredFuture>(arrayList)) {
            QueueLock queueLock = this.locks.get(lockAcquiredFuture.lock);
            if (queueLock != null) {
                this.completeLockFuture(executorService, queueLock, lockAcquiredFuture);
                continue;
            }
            list.add(lockAcquiredFuture);
            executorService.execute(() -> lockAcquiredFuture.future.complete(false));
        }
        List<LockAcquiredFuture> list2 = this.lockAcquiredFutures;
        synchronized (list2) {
            this.lockAcquiredFutures.removeAll(list);
        }
    }

    public synchronized boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        KeyValueStateMachine keyValueStateMachine = (KeyValueStateMachine)object;
        return Objects.equals(this.values, keyValueStateMachine.values) && Objects.equals(this.locks, keyValueStateMachine.locks);
    }

    public synchronized int hashCode() {
        return Objects.hash(this.values, this.locks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableFuture<Boolean> createLockAcquiredFuture(String string, String string2, String string3) {
        CompletableFuture<Boolean> completableFuture = new CompletableFuture<Boolean>();
        LockAcquiredFuture lockAcquiredFuture = new LockAcquiredFuture(string, string2, string3, completableFuture);
        Object object = this.lockAcquiredFutures;
        synchronized (object) {
            this.lockAcquiredFutures.add(lockAcquiredFuture);
        }
        object = this.locks.get(string);
        if (object != null) {
            this.completeLockFuture(null, (QueueLock)object, lockAcquiredFuture);
        }
        return completableFuture;
    }

    public static byte[] createRequestLockTransition(String string, String string2, String string3) {
        KeyValueStateMachineProto.Transition.Builder builder = KeyValueStateMachineProto.Transition.newBuilder();
        builder.setType(KeyValueStateMachineProto.TransitionType.REQUEST_LOCK);
        KeyValueStateMachineProto.RequestLock.Builder builder2 = KeyValueStateMachineProto.RequestLock.newBuilder();
        builder2.setLock(string);
        builder2.setRequester(string2);
        builder2.setUniqueHash(string3);
        builder.setRequestLock(builder2);
        return builder.build().toByteArray();
    }

    public static byte[] createTryLockTransition(String string, String string2, String string3) {
        KeyValueStateMachineProto.Transition.Builder builder = KeyValueStateMachineProto.Transition.newBuilder();
        builder.setType(KeyValueStateMachineProto.TransitionType.TRY_LOCK);
        KeyValueStateMachineProto.TryLock.Builder builder2 = KeyValueStateMachineProto.TryLock.newBuilder();
        builder2.setLock(string);
        builder2.setRequester(string2);
        builder2.setUniqueHash(string3);
        builder.setTryLock(builder2);
        return builder.build().toByteArray();
    }

    public static byte[] createReleaseLockTransition(String string, String string2, String string3) {
        KeyValueStateMachineProto.Transition.Builder builder = KeyValueStateMachineProto.Transition.newBuilder();
        builder.setType(KeyValueStateMachineProto.TransitionType.RELEASE_LOCK);
        KeyValueStateMachineProto.ReleaseLock.Builder builder2 = KeyValueStateMachineProto.ReleaseLock.newBuilder();
        builder2.setLock(string);
        builder2.setRequester(string2);
        builder2.setUniqueHash(string3);
        builder.setReleaseLock(builder2);
        return builder.build().toByteArray();
    }

    public static byte[] createGroupedTransition(byte[] ... byArray) {
        KeyValueStateMachineProto.Transition.Builder builder = KeyValueStateMachineProto.Transition.newBuilder();
        builder.setType(KeyValueStateMachineProto.TransitionType.TRANSITION_GROUP);
        for (byte[] byArray2 : byArray) {
            try {
                builder.addTransitions(KeyValueStateMachineProto.Transition.parseFrom(byArray2));
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                log.warn("Unable to parse");
            }
        }
        return builder.build().toByteArray();
    }

    public static byte[] createSetValueTransitionWithOwner(String string, byte[] byArray, String string2) {
        KeyValueStateMachineProto.Transition.Builder builder = KeyValueStateMachineProto.Transition.newBuilder();
        builder.setType(KeyValueStateMachineProto.TransitionType.SET_VALUE);
        KeyValueStateMachineProto.SetValue.Builder builder2 = KeyValueStateMachineProto.SetValue.newBuilder();
        builder2.setKey(string);
        builder2.setValue(ByteString.copyFrom((byte[])byArray));
        builder2.setOwner(string2);
        builder.setSetValue(builder2);
        return builder.build().toByteArray();
    }

    public static byte[] createSetValueTransition(String string, byte[] byArray) {
        KeyValueStateMachineProto.Transition.Builder builder = KeyValueStateMachineProto.Transition.newBuilder();
        builder.setType(KeyValueStateMachineProto.TransitionType.SET_VALUE);
        KeyValueStateMachineProto.SetValue.Builder builder2 = KeyValueStateMachineProto.SetValue.newBuilder();
        builder2.setKey(string);
        builder2.setValue(ByteString.copyFrom((byte[])byArray));
        builder.setSetValue(builder2);
        return builder.build().toByteArray();
    }

    public static byte[] createRemoveValueTransition(String string) {
        KeyValueStateMachineProto.Transition.Builder builder = KeyValueStateMachineProto.Transition.newBuilder();
        builder.setType(KeyValueStateMachineProto.TransitionType.REMOVE_VALUE);
        KeyValueStateMachineProto.RemoveValue.Builder builder2 = KeyValueStateMachineProto.RemoveValue.newBuilder();
        builder2.setKey(string);
        builder.setRemoveValue(builder2);
        return builder.build().toByteArray();
    }

    public static byte[] createClearTransition(String string) {
        return KeyValueStateMachineProto.Transition.newBuilder().setType(KeyValueStateMachineProto.TransitionType.CLEAR_TRANSIENTS).setClearTransients(KeyValueStateMachineProto.ClearTransients.newBuilder().setOwner(string)).build().toByteArray();
    }

    private static /* synthetic */ void lambda$applyTransition$3(QueueLock queueLock, LockRequest lockRequest) {
        queueLock.waiting.remove(lockRequest);
    }

    static {
        new KeyValueStateMachine("name").serialize();
    }

    private static class ValueWithOptionalOwnerMapView
    implements Map<String, byte[]> {
        final Map<String, ValueWithOptionalOwner> backingMap;

        public ValueWithOptionalOwnerMapView(Map<String, ValueWithOptionalOwner> map) {
            this.backingMap = map;
        }

        @Override
        public int size() {
            return this.backingMap.size();
        }

        @Override
        public boolean isEmpty() {
            return this.backingMap.isEmpty();
        }

        @Override
        public boolean containsKey(Object object) {
            return this.backingMap.containsKey(object);
        }

        @Override
        public boolean containsValue(Object object) {
            return this.backingMap.containsValue(object);
        }

        @Override
        public byte[] get(Object object) {
            return this.backingMap.get((Object)object).value;
        }

        @Override
        @Nullable
        public byte[] put(String string, byte[] byArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(@Nonnull Map<? extends String, ? extends byte[]> map) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nonnull
        public Set<String> keySet() {
            return this.backingMap.keySet();
        }

        @Override
        @Nonnull
        public Collection<byte[]> values() {
            return this.backingMap.values().stream().map(valueWithOptionalOwner -> valueWithOptionalOwner.value).collect(Collectors.toList());
        }

        @Override
        @Nonnull
        public Set<Map.Entry<String, byte[]>> entrySet() {
            return this.backingMap.entrySet().stream().map(entry -> new Map.Entry<String, byte[]>(){

                @Override
                public String getKey() {
                    return (String)entry.getKey();
                }

                @Override
                public byte[] getValue() {
                    return ((ValueWithOptionalOwner)entry.getValue()).value;
                }

                @Override
                public byte[] setValue(byte[] byArray) {
                    throw new UnsupportedOperationException();
                }
            }).collect(Collectors.toSet());
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ValueWithOptionalOwnerMapView valueWithOptionalOwnerMapView = (ValueWithOptionalOwnerMapView)object;
            return Objects.equals(this.backingMap, valueWithOptionalOwnerMapView.backingMap);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.backingMap);
        }
    }

    private static class LockAcquiredFuture {
        String lock;
        String requester;
        String uniqueHash;
        CompletableFuture<Boolean> future;

        public LockAcquiredFuture(String string, String string2, String string3, CompletableFuture<Boolean> completableFuture) {
            this.lock = string;
            this.requester = string2;
            this.uniqueHash = string3;
            this.future = completableFuture;
        }
    }

    static class LockRequest {
        String server;
        String uniqueHash;

        public LockRequest(String string, String string2) {
            this.server = string;
            this.uniqueHash = string2;
        }

        public KeyValueStateMachineProto.LockRequest serialize() {
            KeyValueStateMachineProto.LockRequest.Builder builder = KeyValueStateMachineProto.LockRequest.newBuilder();
            builder.setServer(this.server);
            builder.setUniqueHash(this.uniqueHash);
            return builder.build();
        }

        public static LockRequest deserialize(KeyValueStateMachineProto.LockRequest lockRequest) {
            return new LockRequest(lockRequest.getServer(), lockRequest.getUniqueHash());
        }

        public String toString() {
            return "LockRequest from " + this.server + " with " + this.uniqueHash;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            LockRequest lockRequest = (LockRequest)object;
            return this.server.equals(lockRequest.server) && this.uniqueHash.equals(lockRequest.uniqueHash);
        }

        public int hashCode() {
            int n = this.server.hashCode();
            n = 31 * n + this.uniqueHash.hashCode();
            return n;
        }
    }

    static class QueueLock {
        Optional<LockRequest> holder;
        List<LockRequest> waiting;

        public QueueLock(Optional<LockRequest> optional, List<LockRequest> list) {
            this.holder = optional;
            this.waiting = list;
        }

        public KeyValueStateMachineProto.QueueLock serialize() {
            KeyValueStateMachineProto.QueueLock.Builder builder = KeyValueStateMachineProto.QueueLock.newBuilder();
            this.holder.ifPresent(lockRequest -> builder.setHolder(lockRequest.serialize()));
            builder.addAllWaiting(this.waiting.stream().map(LockRequest::serialize).collect(Collectors.toList()));
            return builder.build();
        }

        public static QueueLock deserialize(KeyValueStateMachineProto.QueueLock queueLock) {
            Optional<LockRequest> optional = queueLock.hasHolder() ? Optional.of(LockRequest.deserialize(queueLock.getHolder())) : Optional.empty();
            List<LockRequest> list = queueLock.getWaitingList().stream().map(LockRequest::deserialize).collect(Collectors.toList());
            return new QueueLock(optional, list);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            QueueLock queueLock = (QueueLock)object;
            return Objects.equals(this.holder, queueLock.holder) && Objects.equals(this.waiting, queueLock.waiting);
        }

        public int hashCode() {
            return Objects.hash(this.holder, this.waiting);
        }
    }

    static class ValueWithOptionalOwner {
        final byte[] value;
        final Optional<String> owner;
        long lastAccessed;
        final long createdAt;

        public ValueWithOptionalOwner(byte[] byArray, long l) {
            this(byArray, null, l);
        }

        public ValueWithOptionalOwner(byte[] byArray, String string, long l) {
            this(byArray, string, l, l);
        }

        private ValueWithOptionalOwner(byte[] byArray, String string, long l, long l2) {
            this.value = byArray;
            this.owner = Optional.ofNullable(string);
            this.lastAccessed = l;
            this.createdAt = l2;
        }

        public byte[] registerGet(long l) {
            this.lastAccessed = l;
            return this.value;
        }

        public KeyValueStateMachineProto.ValueWithOptionalOwner serialize() {
            KeyValueStateMachineProto.ValueWithOptionalOwner.Builder builder = KeyValueStateMachineProto.ValueWithOptionalOwner.newBuilder();
            this.owner.ifPresent(builder::setOwner);
            return builder.setValue(ByteString.copyFrom((byte[])this.value)).setLastAccessed(this.lastAccessed).setCreatedAt(this.createdAt).build();
        }

        public static ValueWithOptionalOwner deserialize(KeyValueStateMachineProto.ValueWithOptionalOwner valueWithOptionalOwner) {
            return new ValueWithOptionalOwner(valueWithOptionalOwner.getValue().toByteArray(), "".equals(valueWithOptionalOwner.getOwner()) ? null : valueWithOptionalOwner.getOwner(), valueWithOptionalOwner.getLastAccessed(), valueWithOptionalOwner.getCreatedAt());
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ValueWithOptionalOwner valueWithOptionalOwner = (ValueWithOptionalOwner)object;
            return Arrays.equals(this.value, valueWithOptionalOwner.value) && this.owner.equals(valueWithOptionalOwner.owner);
        }

        public int hashCode() {
            int n = Arrays.hashCode(this.value);
            n = 31 * n + this.owner.hashCode();
            return n;
        }
    }

    @FunctionalInterface
    public static interface ChangeListener {
        public void onChange(String var1, Optional<byte[]> var2, Map<String, byte[]> var3);
    }
}

