/*
 * Decompiled with CFR 0.152.
 */
package ai.eloquent.raft;

import ai.eloquent.raft.EloquentRaftProto;
import ai.eloquent.raft.RaftAlgorithm;
import ai.eloquent.raft.RaftLifecycle;
import ai.eloquent.raft.RaftLog;
import ai.eloquent.raft.RaftState;
import ai.eloquent.raft.RaftTransport;
import ai.eloquent.raft.SingleThreadedRaftAlgorithm;
import ai.eloquent.util.ConcurrencyUtils;
import ai.eloquent.util.IdentityHashSet;
import ai.eloquent.util.RuntimeInterruptedException;
import ai.eloquent.util.SafeTimerMock;
import ai.eloquent.util.SafeTimerTask;
import ai.eloquent.util.Span;
import ai.eloquent.util.Uninterruptably;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalTransport
implements RaftTransport {
    private static final Logger log = LoggerFactory.getLogger(LocalTransport.class);
    private static volatile StackTraceElement[] singleton = null;
    public final long delayMin;
    public final long delayMax;
    public final double dropProb;
    public final double ioExceptionProb;
    public final boolean trueTime;
    public long numRPCsSent = 0L;
    private final Set<WaitingCallback> waitingCallbacks = new IdentityHashSet<WaitingCallback>();
    private final AtomicLong nextMessageId = new AtomicLong(0L);
    private List<RaftAlgorithm> nodes = new ArrayList<RaftAlgorithm>();
    private final ReadWriteLock nodesLock = new ReentrantReadWriteLock();
    private boolean isAlive = true;
    private final Random rand;
    private final Thread timekeeper;
    private final CompletableFuture<Void> timekeeperFinished;
    public final List<Throwable> exceptions = new ArrayList<Throwable>();
    private final Set<Partition> partitions = new HashSet<Partition>();
    private final SafeTimerMock transportMockTimer = new SafeTimerMock();

    public LocalTransport(long l, long l2, double d, double d2, boolean bl, long l3) {
        if (l < 1L || l2 < 0L || l2 < l || d < 0.0 || d > 1.0 || d2 < 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("Invalid params for mock Raft transport");
        }
        if (singleton != null) {
            log.warn("Created two local transports at once. Old one created from:");
            for (StackTraceElement stackTraceElement : singleton) {
                if (!stackTraceElement.toString().startsWith("ai.eloquent")) continue;
                log.warn("  " + stackTraceElement.toString());
            }
            log.warn("New one is:");
            for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
                if (!stackTraceElement.toString().startsWith("ai.eloquent")) continue;
                log.warn("  " + stackTraceElement.toString());
            }
            throw new RuntimeException("Two LocalTransports are running at the same time");
        }
        singleton = Thread.currentThread().getStackTrace();
        this.delayMin = l;
        this.delayMax = l2;
        this.dropProb = d;
        this.ioExceptionProb = d2;
        this.trueTime = bl;
        this.rand = new Random(l3);
        this.timekeeperFinished = new CompletableFuture();
        this.timekeeper = new Thread(() -> {
            while (true) {
                if (Thread.interrupted()) {
                    throw new RuntimeInterruptedException();
                }
                if (!this.isAlive) break;
                boolean bl = false;
                Iterator<RaftAlgorithm> iterator = this;
                synchronized (iterator) {
                    if (this.transportMockTimer.numTasksScheduled() > 0) {
                        bl = true;
                    }
                }
                if (bl) {
                    for (RaftAlgorithm raftAlgorithm : this.boundAlgorithms()) {
                        if (!(raftAlgorithm instanceof SingleThreadedRaftAlgorithm)) continue;
                        ((SingleThreadedRaftAlgorithm)raftAlgorithm).flush(() -> {});
                    }
                    Thread.yield();
                    while (SingleThreadedRaftAlgorithm.boundaryPoolThreadsWaiting.get() > 0) {
                        for (RaftAlgorithm raftAlgorithm : this.boundAlgorithms()) {
                            if (!(raftAlgorithm instanceof SingleThreadedRaftAlgorithm)) continue;
                            ((SingleThreadedRaftAlgorithm)raftAlgorithm).flush(() -> {});
                        }
                        Thread.yield();
                    }
                    SafeTimerMock.advanceTime(1L);
                }
                if (this.trueTime) {
                    Uninterruptably.sleep(1L);
                    continue;
                }
                Thread.yield();
            }
            this.transportMockTimer.cancel();
            this.timekeeperFinished.complete(null);
        });
        this.timekeeper.setName("mock-raft-transport-time");
        this.timekeeper.setDaemon(true);
        this.timekeeper.setPriority(1);
        this.timekeeper.setUncaughtExceptionHandler((thread, throwable) -> {
            log.warn("Caught exception on timekeeper: ", throwable);
            this.isAlive = false;
        });
    }

    public LocalTransport(boolean bl) {
        this(5L, 100L, bl ? 0.0 : 0.3, bl ? 0.0 : 0.3, false, 42L);
    }

    public LocalTransport(boolean bl, boolean bl2) {
        this(5L, 100L, bl ? 0.0 : 0.3, bl ? 0.0 : 0.3, bl2, 42L);
    }

    public LocalTransport() {
        this(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void silenceOn(Iterator<?> iterator, Runnable runnable) {
        if (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj != null) {
                Object obj2 = obj;
                synchronized (obj2) {
                    this.silenceOn(iterator, runnable);
                }
            }
        } else {
            runnable.run();
        }
    }

    public void synchronizedRun(Runnable runnable) {
        runnable.run();
    }

    public void waitForSilence() {
        log.info("[{}] Waiting for transport to flush. queue_size={}", (Object)this.now(), (Object)this.transportMockTimer.numTasksScheduled());
        try {
            this.transportMockTimer.waitForSilence();
            log.info("[{}] Transport has flushed.", (Object)this.now());
        }
        catch (Throwable throwable) {
            this.isAlive = false;
            try {
                this.timekeeperFinished.get(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException exception) {
                log.warn("Failed to shut down the timekeeper thread for 10 seconds. This is a bug.");
            }
            log.warn("Transport failed to wait for silence: ", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Thread thread = this.timekeeper;
        synchronized (thread) {
            if (!this.timekeeper.isAlive() && this.isAlive) {
                this.timekeeper.start();
            }
        }
    }

    @Override
    public void stop() {
        try {
            this.transportMockTimer.cancel();
            if (!this.isAlive || !this.timekeeper.isAlive()) {
                return;
            }
            this.waitForSilence();
            this.isAlive = false;
            try {
                this.timekeeperFinished.get(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException exception) {
                log.error("Failed to shut down the timekeeper thread for 10 seconds. This is a bug.");
            }
        }
        finally {
            singleton = null;
        }
    }

    @Override
    public boolean threadsCanBlock() {
        return true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.stop();
    }

    @Override
    public void bind(RaftAlgorithm raftAlgorithm) {
        Lock lock = this.nodesLock.writeLock();
        try {
            lock.lock();
            if (!this.nodes.contains(raftAlgorithm)) {
                this.nodes.add(raftAlgorithm);
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Collection<RaftAlgorithm> boundAlgorithms() {
        Lock lock = this.nodesLock.readLock();
        try {
            lock.lock();
            ArrayList<RaftAlgorithm> arrayList = new ArrayList<RaftAlgorithm>(this.nodes);
            return arrayList;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Span expectedNetworkDelay() {
        return new Span(this.delayMin, this.delayMax);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransportMessage sendMessage(String string, String string2, EloquentRaftProto.RaftMessage raftMessage, Optional<Long> optional) {
        assert (ConcurrencyUtils.ensureNoLocksHeld());
        final TransportMessage transportMessage = optional.isPresent() ? new TransportMessage(this.nextMessageId.incrementAndGet(), optional.get(), string, string2, raftMessage.toByteArray()) : new TransportMessage(this.nextMessageId.incrementAndGet(), string, string2, raftMessage.toByteArray());
        long l = this.sampleDelay();
        this.transportMockTimer.withTimerLock(() -> {
            if (this.shouldDrop(string, string2, l)) {
                log.trace("[{}] Dropped RPC {} -> {}; with delay {}", new Object[]{this.now(), string, string2, l});
            } else {
                log.trace("[{}] Sending {} -> {}; with delay {}", new Object[]{this.now(), string, string2, l});
                ++this.numRPCsSent;
                SafeTimerTask safeTimerTask = new SafeTimerTask(){

                    @Override
                    public void runUnsafe() {
                        LocalTransport.this.receiveMessage(transportMessage, LocalTransport.this.now());
                    }
                };
                this.transportMockTimer.schedule(safeTimerTask, l);
            }
        });
        Thread thread = this.timekeeper;
        synchronized (thread) {
            if (!this.timekeeper.isAlive() && this.isAlive) {
                this.timekeeper.start();
            }
        }
        return transportMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rpcTransport(final String string, final String string2, EloquentRaftProto.RaftMessage raftMessage, Consumer<EloquentRaftProto.RaftMessage> consumer, final Runnable runnable, long l) {
        assert (ConcurrencyUtils.ensureNoLocksHeld());
        final TransportMessage transportMessage = this.sendMessage(string, string2, raftMessage, Optional.empty());
        final WaitingCallback waitingCallback = new WaitingCallback(transportMessage.id, consumer, runnable, this.now() + l);
        Set<WaitingCallback> set = this.waitingCallbacks;
        synchronized (set) {
            this.waitingCallbacks.add(waitingCallback);
        }
        this.transportMockTimer.schedule(new SafeTimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runUnsafe() {
                boolean bl = false;
                WaitingCallback waitingCallback2 = waitingCallback;
                synchronized (waitingCallback2) {
                    if (LocalTransport.this.waitingCallbacks.contains(waitingCallback)) {
                        LocalTransport.this.waitingCallbacks.remove(waitingCallback);
                        bl = true;
                    }
                }
                if (bl) {
                    log.info("Timing out RPC for message {} from {} -> {}", new Object[]{transportMessage.id, string, string2});
                    runnable.run();
                }
            }
        }, l);
    }

    @Override
    public void sendTransport(String string, String string2, EloquentRaftProto.RaftMessage raftMessage) {
        assert (ConcurrencyUtils.ensureNoLocksHeld());
        this.sendMessage(string, string2, raftMessage, Optional.empty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void broadcastTransport(String string, EloquentRaftProto.RaftMessage raftMessage) {
        assert (ConcurrencyUtils.ensureNoLocksHeld());
        assert (this.boundAlgorithms().stream().allMatch(raftAlgorithm -> raftAlgorithm.getClass().getName().contains("RecordingRaft")) || this.boundAlgorithms().stream().filter(raftAlgorithm -> raftAlgorithm.serverName().equals(string)).findFirst().map(raftAlgorithm -> raftAlgorithm.state().leadership != RaftState.LeadershipStatus.OTHER).orElse(false).booleanValue()) : "A follower / shadow should not be broadcasting on the transport!";
        Lock lock = this.nodesLock.readLock();
        try {
            lock.lock();
            for (RaftAlgorithm raftAlgorithm2 : this.nodes) {
                String string2 = raftAlgorithm2.serverName();
                if (Objects.equals(raftAlgorithm2.serverName(), string)) continue;
                this.sendMessage(string, string2, raftMessage, Optional.empty());
            }
        }
        finally {
            lock.unlock();
        }
    }

    public LocalTransport assertNoErrors() {
        assert (this.exceptions.isEmpty()) : "Got " + this.exceptions.size() + " exceptions on transport. First one: <" + this.exceptions.get(0).getClass() + ": " + this.exceptions.get(0).getMessage() + ">";
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertInvariantsHold() {
        Lock lock = this.nodesLock.readLock();
        try {
            Optional<Object> optional;
            long l;
            RaftLog raftLog;
            int n;
            int n2;
            lock.lock();
            HashSet<Long> hashSet = new HashSet<Long>();
            for (RaftAlgorithm object2 : this.nodes) {
                if (!object2.state().isLeader()) continue;
                assert (!hashSet.contains(object2.mutableState().currentTerm)) : "At most one leader can be elected in a given term. More than one leader for term " + object2.state().currentTerm;
                hashSet.add(object2.mutableState().currentTerm);
            }
            for (n2 = 0; n2 < this.nodes.size() - 1; ++n2) {
                RaftLog raftLog2 = this.nodes.get((int)n2).mutableState().log;
                block5: for (n = n2 + 1; n < this.nodes.size(); ++n) {
                    raftLog = this.nodes.get((int)n).mutableState().log;
                    l = Math.min(raftLog2.getLastEntryIndex(), raftLog.getLastEntryIndex());
                    boolean bl = false;
                    for (long i = l; i >= 0L; --i) {
                        optional = raftLog2.getPreviousEntryTerm(i);
                        Optional<Long> optional2 = raftLog.getPreviousEntryTerm(i);
                        if (!optional.isPresent() || !optional2.isPresent()) continue block5;
                        if (optional.get().equals(optional2.get())) {
                            bl = true;
                            continue;
                        }
                        assert (!bl) : "If two logs contain an entry with the same index and term, then the logs are identical in all entries up through the given index. Violation at index " + i;
                    }
                }
            }
            for (n2 = 0; n2 < this.nodes.size() - 1; ++n2) {
                RaftLog raftLog3 = this.nodes.get((int)n2).mutableState().log;
                block8: for (n = n2 + 1; n < this.nodes.size(); ++n) {
                    raftLog = this.nodes.get((int)n).mutableState().log;
                    for (long i = l = Math.min(raftLog3.getLastEntryIndex(), raftLog.getLastEntryIndex()); i >= 0L; --i) {
                        Optional<EloquentRaftProto.LogEntry> optional3 = raftLog3.getEntryAtIndex(i);
                        optional = raftLog.getEntryAtIndex(i);
                        if (!optional3.isPresent() || !optional.isPresent()) continue block8;
                        if (optional3.get().getTerm() == ((EloquentRaftProto.LogEntry)optional.get()).getTerm()) assert (optional3.get().toByteString().equals((Object)((EloquentRaftProto.LogEntry)optional.get()).toByteString())) : "Two log entries at the same index with the same term should be identical";
                    }
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(long l, int n, final Consumer<Long> consumer) {
        SafeTimerTask safeTimerTask = new SafeTimerTask(){

            @Override
            public void runUnsafe() throws Throwable {
                consumer.accept(LocalTransport.this.now());
            }
        };
        this.transportMockTimer.withTimerLock(() -> {
            for (int i = 0; i < n; ++i) {
                long l2 = l * (long)(i + 1);
                this.transportMockTimer.schedule(safeTimerTask, l2);
            }
        });
        Thread thread = this.timekeeper;
        synchronized (thread) {
            if (!this.timekeeper.isAlive() && this.isAlive) {
                this.timekeeper.start();
            }
        }
    }

    public void partitionOff(long l, long l2, String ... stringArray) {
        this.partitions.add(new Partition(l, l2, stringArray));
    }

    public void liftPartitions() {
        this.partitions.clear();
    }

    @Override
    public long now() {
        if (this.trueTime) {
            return System.currentTimeMillis();
        }
        return this.transportMockTimer.now();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sleep(long l2) {
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        this.schedule(l2, 1, l -> {
            AtomicBoolean atomicBoolean2 = atomicBoolean;
            synchronized (atomicBoolean2) {
                atomicBoolean.set(true);
                atomicBoolean.notifyAll();
            }
        });
        AtomicBoolean atomicBoolean2 = atomicBoolean;
        synchronized (atomicBoolean2) {
            while (!atomicBoolean.get() && this.isAlive) {
                try {
                    atomicBoolean.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    @Override
    public void scheduleAtFixedRate(SafeTimerTask safeTimerTask, long l) {
        safeTimerTask.run(Optional.empty());
        this.transportMockTimer.schedule(safeTimerTask, 0L, l);
    }

    @Override
    public void schedule(SafeTimerTask safeTimerTask, long l2) {
        this.schedule(l2, 1, l -> safeTimerTask.run(Optional.empty()));
    }

    @Override
    public <E> E getFuture(CompletableFuture<E> completableFuture, Duration duration) throws InterruptedException, ExecutionException, TimeoutException {
        long l = 0L;
        while (!(completableFuture.isDone() || completableFuture.isCancelled() || completableFuture.isCompletedExceptionally())) {
            this.sleep(1L);
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (++l <= duration.toMillis()) continue;
            throw new TimeoutException("Took too long to return future");
        }
        if (completableFuture.isCompletedExceptionally()) {
            Throwable throwable2 = (Throwable)((CompletableFuture)completableFuture.exceptionally(throwable -> throwable)).get();
            throw new ExecutionException(throwable2);
        }
        E e = completableFuture.getNow(null);
        if (e == null) {
            throw new IllegalStateException("Logic error in future resolution");
        }
        return e;
    }

    private boolean shouldDrop(String string, String string2, long l) {
        Iterator<Partition> iterator = this.partitions.iterator();
        long l2 = this.now() + l;
        while (iterator.hasNext()) {
            Partition partition = iterator.next();
            if (partition.endTime < this.now()) {
                iterator.remove();
                continue;
            }
            if (partition.startTime > l2 || partition.endTime <= l2 || (!partition.members.contains(string) || partition.members.contains(string2)) && (partition.members.contains(string) || !partition.members.contains(string2))) continue;
            return true;
        }
        return this.rand.nextDouble() < this.dropProb;
    }

    private long sampleDelay() {
        if (this.delayMin == this.delayMax) {
            return this.delayMin;
        }
        if (this.rand.nextDouble() < 0.1) {
            return this.delayMin + (long)this.rand.nextInt((int)(this.delayMax - this.delayMin));
        }
        return this.delayMin + (long)this.rand.nextInt((int)(Math.min(this.delayMax, this.delayMin + 10L) - this.delayMin));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveMessage(TransportMessage transportMessage, long l) {
        ArrayList<WaitingCallback> arrayList = new ArrayList<WaitingCallback>();
        Collection<WaitingCallback> collection = this.waitingCallbacks;
        synchronized (collection) {
            IdentityHashSet<WaitingCallback> object2 = new IdentityHashSet<WaitingCallback>();
            try {
                for (WaitingCallback waitingCallback : this.waitingCallbacks) {
                    if (waitingCallback.messageId != transportMessage.correlationId) continue;
                    log.trace("[{}] {} received RPC reply from {} at time {}; id={} correlation_id={}", new Object[]{l, transportMessage.target, transportMessage.sender, l, transportMessage.id, transportMessage.correlationId});
                    arrayList.add(waitingCallback);
                    object2.add(waitingCallback);
                }
            }
            finally {
                this.waitingCallbacks.removeAll(object2);
            }
        }
        if (!arrayList.isEmpty()) {
            for (WaitingCallback waitingCallback : arrayList) {
                try {
                    waitingCallback.onSuccess.accept(EloquentRaftProto.RaftMessage.parseFrom(transportMessage.contents));
                }
                catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                    log.warn("Transport got a bad protocol buffer; logging in exceptions", (Throwable)invalidProtocolBufferException);
                    this.exceptions.add(invalidProtocolBufferException);
                }
            }
            return;
        }
        log.trace("[{}] {} received message from {}; id={} correlation_id={}", new Object[]{this.now(), transportMessage.target, transportMessage.sender, transportMessage.id, transportMessage.correlationId});
        if (transportMessage.correlationId >= 0L) {
            collection = this.waitingCallbacks;
            synchronized (collection) {
                log.trace("[{}] Above message (id={}) has an unmatched correlation_id (corr_id={}). waitingCallbacks={}", new Object[]{this.now(), transportMessage.id, transportMessage.correlationId, this.waitingCallbacks});
            }
        }
        try {
            EloquentRaftProto.RaftMessage raftMessage;
            collection = new ArrayList();
            Lock lock = this.nodesLock.readLock();
            try {
                lock.lock();
                collection.addAll(this.nodes);
            }
            finally {
                lock.unlock();
            }
            try {
                raftMessage = EloquentRaftProto.RaftMessage.parseFrom(transportMessage.contents);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                log.warn("Could not decode message {}; adding to exception list", (Object)transportMessage);
                this.exceptions.add(invalidProtocolBufferException);
                return;
            }
            if (collection.stream().noneMatch(raftAlgorithm -> Objects.equals(transportMessage.target, raftAlgorithm.serverName()))) {
                log.warn("Server {} was not found in server list {}", (Object)transportMessage.target, this.nodes.stream().map(RaftAlgorithm::serverName).collect(Collectors.toSet()));
            }
            collection.stream().filter(raftAlgorithm -> Objects.equals(transportMessage.target, raftAlgorithm.serverName())).findAny().ifPresent(raftAlgorithm -> {
                Optional<RaftLifecycle> optional = raftAlgorithm.lifecycle();
                if (optional.isPresent() && optional.get().CORE_THREAD_POOLS_CLOSED.get()) {
                    log.trace("Not delivering messages to " + raftAlgorithm.serverName() + " because core thread pools are already closed");
                    return;
                }
                if (raftMessage.getIsRPC()) {
                    CompletableFuture<EloquentRaftProto.RaftMessage> completableFuture = raftAlgorithm.receiveRPC(raftMessage, l);
                    if (completableFuture == null) {
                        NullPointerException nullPointerException = new NullPointerException();
                        log.warn("Got null response from RPC: ", (Throwable)nullPointerException);
                        this.exceptions.add(nullPointerException);
                        return;
                    }
                    assert (this.now() == l) : "Time should not be slipping";
                    completableFuture.whenComplete((raftMessage, throwable) -> {
                        if (throwable != null) {
                            log.warn("Got exception from RPC: ", throwable);
                        }
                        this.sendMessage(transportMessage.target, transportMessage.sender, (EloquentRaftProto.RaftMessage)raftMessage, Optional.of(transportMessage.id));
                    });
                } else {
                    raftAlgorithm.receiveMessage(raftMessage, raftMessage -> this.sendTransport(transportMessage.target, transportMessage.sender, (EloquentRaftProto.RaftMessage)raftMessage), l);
                }
            });
        }
        catch (Throwable throwable) {
            log.warn("Caught exception on receiving message: ", throwable);
            this.exceptions.add(throwable);
        }
    }

    private static class Partition {
        private final long startTime;
        private final long endTime;
        private final Set<String> members;

        private Partition(long l, long l2, String[] stringArray) {
            this.startTime = l;
            this.endTime = l2;
            this.members = new HashSet<String>(Arrays.asList(stringArray));
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Partition partition = (Partition)object;
            return this.startTime == partition.startTime && this.endTime == partition.endTime && Objects.equals(this.members, partition.members);
        }

        public int hashCode() {
            return Objects.hash(this.startTime, this.endTime, this.members);
        }
    }

    private static class WaitingCallback {
        private final long messageId;
        private final Consumer<EloquentRaftProto.RaftMessage> onSuccess;
        private final Runnable onTimeout;
        private final long timeoutTime;

        private WaitingCallback(long l, Consumer<EloquentRaftProto.RaftMessage> consumer, Runnable runnable, long l2) {
            this.messageId = l;
            this.onSuccess = consumer;
            this.onTimeout = runnable;
            this.timeoutTime = l2;
        }

        public String toString() {
            return "callback(" + this.messageId + ")@" + this.timeoutTime;
        }
    }

    private class TransportTask
    implements TransportEvent {
        private final Consumer<Long> task;
        private final long queuedAt;
        private String stack;
        private boolean testTask;

        private TransportTask(Consumer<Long> consumer) {
            this.task = consumer;
            this.queuedAt = LocalTransport.this.now();
            if (RaftLog.level() > 0) {
                this.stack = "";
                this.testTask = false;
            } else {
                try {
                    throw new RuntimeException();
                }
                catch (Throwable throwable) {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    throwable.printStackTrace(printWriter);
                    this.stack = stringWriter.toString();
                    this.testTask = this.stack.contains("AbstractRaftAlgorithmTest");
                }
            }
        }

        public String toString() {
            return "TransportTask from @" + this.queuedAt + ": " + (this.testTask ? "AbstractRaftAlgorithmTest" : this.stack);
        }
    }

    private class TransportMessage
    implements TransportEvent {
        private final long id;
        private final long correlationId;
        private final String sender;
        private final String target;
        private final byte[] contents;
        private final long sentAt;

        private TransportMessage(long l, String string, String string2, byte[] byArray) {
            this(l, -1L, string, string2, byArray);
        }

        private TransportMessage(long l, long l2, String string, String string2, byte[] byArray) {
            this.id = l;
            this.correlationId = l2;
            this.sender = string;
            this.target = string2;
            this.contents = byArray;
            this.sentAt = LocalTransport.this.now();
        }

        public String toString() {
            try {
                EloquentRaftProto.RaftMessage raftMessage = EloquentRaftProto.RaftMessage.parseFrom(this.contents);
                String string = raftMessage.getContentsCase().toString() + " ";
                switch (raftMessage.getContentsCase()) {
                    case APPENDENTRIES: {
                        string = string + raftMessage.getAppendEntries().toString();
                        break;
                    }
                    case APPENDENTRIESREPLY: {
                        string = string + raftMessage.getAppendEntriesReply().toString();
                        break;
                    }
                    case APPLYTRANSITION: {
                        string = string + raftMessage.getApplyTransition().toString();
                        break;
                    }
                    case APPLYTRANSITIONREPLY: {
                        string = string + raftMessage.getApplyTransitionReply().toString();
                    }
                }
                return "@" + this.sentAt + " :" + this.sender + "->" + this.target + ": " + string.replaceAll("\n", ", ");
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                return "@" + this.sentAt + " :" + this.sender + "->" + this.target + ": Unrecognized message";
            }
        }
    }

    private static interface TransportEvent {
    }
}

