/*
 * Decompiled with CFR 0.152.
 */
package ai.eloquent.raft;

import ai.eloquent.monitoring.Prometheus;
import ai.eloquent.raft.EloquentRaftAlgorithm;
import ai.eloquent.raft.EloquentRaftProto;
import ai.eloquent.raft.RaftLifecycle;
import ai.eloquent.raft.RaftState;
import ai.eloquent.raft.RaftStateMachine;
import ai.eloquent.raft.RaftTransport;
import ai.eloquent.util.Span;
import ai.eloquent.util.StringUtils;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface RaftAlgorithm {
    public static final Logger log = LoggerFactory.getLogger(RaftAlgorithm.class);
    public static final Object summaryTiming = Prometheus.summaryBuild("raft", "Statistics on the Raft RPC calls", "rpc");
    public static final Span DEFAULT_ELECTION_RANGE = new Span(1000L, 2000L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void receiveMessage(EloquentRaftProto.RaftMessage raftMessage2, Consumer<EloquentRaftProto.RaftMessage> consumer, long l) {
        if (!raftMessage2.getAppendEntries().equals(EloquentRaftProto.AppendEntriesRequest.getDefaultInstance())) {
            Object object = Prometheus.startTimer(summaryTiming, "append_entries");
            this.receiveAppendEntriesRPC(raftMessage2.getAppendEntries(), raftMessage -> {
                Prometheus.observeDuration(object);
                consumer.accept((EloquentRaftProto.RaftMessage)raftMessage);
            }, l);
        } else if (!raftMessage2.getRequestVotes().equals(EloquentRaftProto.RequestVoteRequest.getDefaultInstance())) {
            Object object = Prometheus.startTimer(summaryTiming, "request_votes");
            this.receiveRequestVoteRPC(raftMessage2.getRequestVotes(), raftMessage -> {
                Prometheus.observeDuration(object);
                consumer.accept((EloquentRaftProto.RaftMessage)raftMessage);
            }, l);
        } else if (!raftMessage2.getInstallSnapshot().equals(EloquentRaftProto.InstallSnapshotRequest.getDefaultInstance())) {
            Object object = Prometheus.startTimer(summaryTiming, "install_snapshot");
            this.receiveInstallSnapshotRPC(raftMessage2.getInstallSnapshot(), raftMessage -> {
                Prometheus.observeDuration(object);
                consumer.accept((EloquentRaftProto.RaftMessage)raftMessage);
            }, l);
        } else if (!raftMessage2.getAppendEntriesReply().equals(EloquentRaftProto.AppendEntriesReply.getDefaultInstance())) {
            Object object = Prometheus.startTimer(summaryTiming, "append_entries_reply");
            try {
                this.receiveAppendEntriesReply(raftMessage2.getAppendEntriesReply(), l);
            }
            finally {
                Prometheus.observeDuration(object);
            }
        } else if (!raftMessage2.getRequestVotesReply().equals(EloquentRaftProto.RequestVoteReply.getDefaultInstance())) {
            Object object = Prometheus.startTimer(summaryTiming, "request_votes_reply");
            try {
                this.receiveRequestVotesReply(raftMessage2.getRequestVotesReply(), l);
            }
            finally {
                Prometheus.observeDuration(object);
            }
        } else if (!raftMessage2.getInstallSnapshotReply().equals(EloquentRaftProto.InstallSnapshotReply.getDefaultInstance())) {
            Object object = Prometheus.startTimer(summaryTiming, "installl_snapshot_reply");
            try {
                this.receiveInstallSnapshotReply(raftMessage2.getInstallSnapshotReply(), l);
            }
            finally {
                Prometheus.observeDuration(object);
            }
        } else if (!raftMessage2.getAddServer().equals(EloquentRaftProto.AddServerRequest.getDefaultInstance())) {
            Object object = Prometheus.startTimer(summaryTiming, "add_server");
            CompletableFuture<EloquentRaftProto.RaftMessage> completableFuture = this.receiveAddServerRPC(raftMessage2.getAddServer(), l);
            completableFuture.whenComplete((raftMessage, throwable) -> {
                Prometheus.observeDuration(object);
                if (throwable != null && raftMessage != null) {
                    consumer.accept((EloquentRaftProto.RaftMessage)raftMessage);
                } else {
                    consumer.accept(null);
                }
            });
        } else if (!raftMessage2.getRemoveServer().equals(EloquentRaftProto.RemoveServerRequest.getDefaultInstance())) {
            Object object = Prometheus.startTimer(summaryTiming, "remove_server");
            CompletableFuture<EloquentRaftProto.RaftMessage> completableFuture = this.receiveRemoveServerRPC(raftMessage2.getRemoveServer(), l);
            completableFuture.whenComplete((raftMessage, throwable) -> {
                Prometheus.observeDuration(object);
                if (throwable != null && raftMessage != null) {
                    consumer.accept((EloquentRaftProto.RaftMessage)raftMessage);
                } else {
                    consumer.accept(null);
                }
            });
        } else if (!raftMessage2.getApplyTransition().equals(EloquentRaftProto.ApplyTransitionRequest.getDefaultInstance())) {
            Object object = Prometheus.startTimer(summaryTiming, "apply_transition");
            CompletableFuture<EloquentRaftProto.RaftMessage> completableFuture = this.receiveApplyTransitionRPC(raftMessage2.getApplyTransition(), l);
            completableFuture.whenComplete((raftMessage, throwable) -> {
                Prometheus.observeDuration(object);
                if (throwable != null && raftMessage != null) {
                    consumer.accept((EloquentRaftProto.RaftMessage)raftMessage);
                } else {
                    consumer.accept(null);
                }
            });
        } else {
            this.receiveBadRequest(raftMessage2);
        }
    }

    default public CompletableFuture<EloquentRaftProto.RaftMessage> receiveRPC(EloquentRaftProto.RaftMessage raftMessage2, long l) {
        Object object = null;
        CompletableFuture<Object> completableFuture = new CompletableFuture();
        try {
            if (raftMessage2.getAppendEntries() != EloquentRaftProto.AppendEntriesRequest.getDefaultInstance()) {
                object = Prometheus.startTimer(summaryTiming, "append_entries_rpc");
                this.receiveAppendEntriesRPC(raftMessage2.getAppendEntries(), completableFuture::complete, l);
            } else if (raftMessage2.getRequestVotes() != EloquentRaftProto.RequestVoteRequest.getDefaultInstance()) {
                object = Prometheus.startTimer(summaryTiming, "request_votes_rpc");
                this.receiveRequestVoteRPC(raftMessage2.getRequestVotes(), completableFuture::complete, l);
            } else if (raftMessage2.getInstallSnapshot() != EloquentRaftProto.InstallSnapshotRequest.getDefaultInstance()) {
                object = Prometheus.startTimer(summaryTiming, "install_snapshop_rpc");
                this.receiveInstallSnapshotRPC(raftMessage2.getInstallSnapshot(), completableFuture::complete, l);
            } else if (raftMessage2.getAddServer() != EloquentRaftProto.AddServerRequest.getDefaultInstance()) {
                object = Prometheus.startTimer(summaryTiming, "add_server_rpc");
                completableFuture = this.receiveAddServerRPC(raftMessage2.getAddServer(), l);
            } else if (raftMessage2.getRemoveServer() != EloquentRaftProto.RemoveServerRequest.getDefaultInstance()) {
                object = Prometheus.startTimer(summaryTiming, "remove_server_rpc");
                completableFuture = this.receiveRemoveServerRPC(raftMessage2.getRemoveServer(), l);
            } else if (raftMessage2.getApplyTransition() != EloquentRaftProto.ApplyTransitionRequest.getDefaultInstance()) {
                object = Prometheus.startTimer(summaryTiming, "transition_rpc");
                completableFuture = this.receiveApplyTransitionRPC(raftMessage2.getApplyTransition(), l);
            } else {
                object = Prometheus.startTimer(summaryTiming, "unknown_rpc");
                completableFuture.completeExceptionally(new IllegalStateException("Message type not implemented: " + raftMessage2));
            }
        }
        catch (Throwable throwable) {
            completableFuture.completeExceptionally(throwable);
        }
        Object object2 = object;
        return completableFuture.thenApply(raftMessage -> {
            if (object2 != null) {
                Prometheus.observeDuration(object2);
            }
            return raftMessage;
        });
    }

    public RaftState state();

    public RaftState mutableState();

    public RaftStateMachine mutableStateMachine();

    public long term();

    public String serverName();

    public void broadcastAppendEntries(long var1);

    public void sendAppendEntries(String var1, long var2);

    public void receiveAppendEntriesRPC(EloquentRaftProto.AppendEntriesRequest var1, Consumer<EloquentRaftProto.RaftMessage> var2, long var3);

    public void receiveAppendEntriesReply(EloquentRaftProto.AppendEntriesReply var1, long var2);

    public void receiveInstallSnapshotRPC(EloquentRaftProto.InstallSnapshotRequest var1, Consumer<EloquentRaftProto.RaftMessage> var2, long var3);

    public void receiveInstallSnapshotReply(EloquentRaftProto.InstallSnapshotReply var1, long var2);

    public void triggerElection(long var1);

    public void receiveRequestVoteRPC(EloquentRaftProto.RequestVoteRequest var1, Consumer<EloquentRaftProto.RaftMessage> var2, long var3);

    public void receiveRequestVotesReply(EloquentRaftProto.RequestVoteReply var1, long var2);

    public CompletableFuture<EloquentRaftProto.RaftMessage> receiveAddServerRPC(EloquentRaftProto.AddServerRequest var1, long var2);

    public CompletableFuture<EloquentRaftProto.RaftMessage> receiveRemoveServerRPC(EloquentRaftProto.RemoveServerRequest var1, long var2);

    public CompletableFuture<EloquentRaftProto.RaftMessage> receiveApplyTransitionRPC(EloquentRaftProto.ApplyTransitionRequest var1, long var2);

    public boolean bootstrap(boolean var1);

    default public void stop(boolean bl) {
    }

    public boolean isRunning();

    default public long heartbeatMillis() {
        return 50L;
    }

    default public Span electionTimeoutMillisRange() {
        return DEFAULT_ELECTION_RANGE;
    }

    public void heartbeat(long var1);

    public void receiveBadRequest(EloquentRaftProto.RaftMessage var1);

    public Optional<RaftLifecycle> lifecycle();

    public RaftTransport getTransport();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown(RaftAlgorithm raftAlgorithm, RaftTransport raftTransport, boolean bl) {
        log.info("{} - Shutting down Raft", (Object)raftAlgorithm.mutableState().serverName);
        log.info("{} - [{}] Entering the hospice", (Object)raftAlgorithm.mutableState().serverName, (Object)raftTransport.now());
        boolean bl2 = false;
        int n = 0;
        while (!bl2 && ++n < 50) {
            try {
                EloquentRaftProto.RaftMessage raftMessage = raftAlgorithm.receiveApplyTransitionRPC(EloquentRaftProto.ApplyTransitionRequest.newBuilder().setNewHospiceMember(raftAlgorithm.serverName()).build(), raftTransport.now()).get(raftAlgorithm.electionTimeoutMillisRange().end + 100L, TimeUnit.MILLISECONDS);
                bl2 = raftMessage.getApplyTransitionReply().getSuccess();
            }
            catch (InterruptedException | ExecutionException | TimeoutException exception) {
                log.info("{} - [{}] Could not apply hospice transition: ", new Object[]{raftAlgorithm.mutableState().serverName, raftTransport.now(), exception});
            }
            finally {
                if (bl2) continue;
                raftTransport.sleep(raftAlgorithm.electionTimeoutMillisRange().end + 100L);
            }
        }
        if (n >= 50) {
            log.warn("{} - [{}] Could not add ourselves to the hospice; continuing anyways and wishing for the best", (Object)raftAlgorithm.mutableState().serverName, (Object)raftTransport.now());
        } else {
            log.info("{} - [{}] Entered the hospice", (Object)raftAlgorithm.mutableState().serverName, (Object)raftTransport.now());
        }
        while (!bl && raftAlgorithm.mutableState().log.committedQuorumMembers.size() < 2) {
            log.warn("{} - [{}] We're the last member of the quorum -- sleeping to wait for someone else to arrive. Errors={}. Heartbeats from={}. Hospice={}.", new Object[]{raftAlgorithm.mutableState().serverName, raftTransport.now(), raftAlgorithm instanceof EloquentRaftAlgorithm ? StringUtils.join(((EloquentRaftAlgorithm)raftAlgorithm).errors(), ", ") : "<n/a>", raftAlgorithm.mutableState().lastMessageTimestamp.orElse(Collections.emptyMap()).keySet(), raftAlgorithm.mutableStateMachine().getHospice()});
            raftTransport.sleep(1000L);
        }
        log.info("{} - [{}] Removing ourselves from the cluster", (Object)raftAlgorithm.mutableState().serverName, (Object)raftTransport.now());
        boolean bl3 = true;
        n = 0;
        while (bl3 && ++n < 50) {
            try {
                EloquentRaftProto.RaftMessage raftMessage = raftAlgorithm.receiveRemoveServerRPC(EloquentRaftProto.RemoveServerRequest.newBuilder().setOldServer(raftAlgorithm.serverName()).build(), raftTransport.now()).get(raftAlgorithm.electionTimeoutMillisRange().end + 100L, TimeUnit.MILLISECONDS);
                if (raftMessage.getRemoveServerReply().getStatus() != EloquentRaftProto.MembershipChangeStatus.OK) continue;
                bl3 = false;
            }
            catch (InterruptedException | ExecutionException | TimeoutException exception) {
                log.info("{} - [{}] Could not apply remove server transition: ", new Object[]{raftAlgorithm.mutableState().serverName, raftTransport.now(), exception});
            }
            finally {
                ++n;
                if (!bl3) continue;
                raftTransport.sleep(raftAlgorithm.electionTimeoutMillisRange().end + 100L);
                raftTransport.sleep(raftAlgorithm.electionTimeoutMillisRange().end + 100L);
            }
        }
        if (n >= 50) {
            log.warn("{} - [{}] Could not remove ourselves to the cluster; continuing anyways and wishing for the best", (Object)raftAlgorithm.mutableState().serverName, (Object)raftTransport.now());
        } else {
            log.info("{} - [{}] Removed ourselves from the cluster", (Object)raftAlgorithm.mutableState().serverName, (Object)raftTransport.now());
        }
        log.info("{} - [{}] Stopping the algorithm", (Object)raftAlgorithm.mutableState().serverName, (Object)raftTransport.now());
        raftAlgorithm.stop(false);
        log.info("{} - [{}] Stopped the algorithm", (Object)raftAlgorithm.mutableState().serverName, (Object)raftTransport.now());
    }
}

