/*
 * Decompiled with CFR 0.152.
 */
package ai.eloquent.raft;

import ai.eloquent.raft.KeyValueStateMachine;
import ai.eloquent.raft.Theseus;
import ai.eloquent.util.Pointer;
import ai.eloquent.util.SafeTimerTask;
import ai.eloquent.util.TimerUtils;
import com.google.protobuf.InvalidProtocolBufferException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.ref.WeakReference;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RaftBackedCache<V>
implements Iterable<Map.Entry<String, V>>,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(RaftBackedCache.class);
    private static final int DEFAULT_MAX_SIZE_BYTES = 0x100000;
    public final Theseus raft;
    private SafeTimerTask evictionTask;
    Map<ChangeListener, KeyValueStateMachine.ChangeListener> changeListeners = new IdentityHashMap<ChangeListener, KeyValueStateMachine.ChangeListener>();
    private final Map<ChangeListener, WeakReference<Object>> changeListenerOwner = new ConcurrentHashMap<ChangeListener, WeakReference<Object>>();
    final Set<CompletableFuture<Boolean>> evictionTasksRunning = ConcurrentHashMap.newKeySet();

    protected void onSet(V v) {
    }

    protected RaftBackedCache(final Theseus theseus, final Duration duration, final Duration duration2, final int n) {
        this.raft = theseus;
        this.evictionTask = new SafeTimerTask(){

            @Override
            public void runUnsafe() {
                RaftBackedCache.this.evictionTasksRunning.removeAll(RaftBackedCache.this.evictionTasksRunning.stream().filter(completableFuture -> !completableFuture.isDone()).collect(Collectors.toList()));
                Set<String> set = theseus.stateMachine.keysIdleSince(duration, theseus.node.transport.now());
                set.addAll(theseus.stateMachine.keysPresentSince(duration2, theseus.node.transport.now()));
                for (String string : set) {
                    if (!string.startsWith(RaftBackedCache.this.prefix()) || RaftBackedCache.this.valuePersistedSinceLastWrite(string)) continue;
                    RaftBackedCache.this.evictionTasksRunning.add(theseus.withDistributedLockAsync(string, () -> {
                        Optional<byte[]> optional = theseus.getElement(string);
                        if (optional.isPresent()) {
                            if (Entry.readIsPersisted(optional.get())) {
                                return CompletableFuture.completedFuture(true);
                            }
                            try {
                                String string2 = string.replace(RaftBackedCache.this.prefix(), "");
                                Entry<Object> entry = Entry.deserialize(string2, optional.get(), RaftBackedCache.this::deserialize);
                                try {
                                    log.info("Persisting RaftBackedCache element with key {}", (Object)string2);
                                    RaftBackedCache.this.persist(string2, entry.value, false);
                                    entry.isPersisted = true;
                                    return theseus.setElementAsync(string, entry.serialize(RaftBackedCache.this::serialize), true, Duration.ofSeconds(30L));
                                }
                                catch (Throwable throwable) {
                                    log.warn("Could not evict element from RaftBackedCache; not removing from Raft", throwable);
                                }
                            }
                            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                                log.warn("Could not deserialize Raft value for key {}", (Object)string);
                            }
                        }
                        return CompletableFuture.completedFuture(false);
                    }));
                }
                Collection<Map.Entry<String, KeyValueStateMachine.ValueWithOptionalOwner>> collection = theseus.stateMachine.entries();
                long l = collection.stream().mapToInt(entry -> ((KeyValueStateMachine.ValueWithOptionalOwner)entry.getValue()).value.length).sum();
                if (l > (long)n) {
                    ArrayList<Map.Entry> arrayList = new ArrayList<Map.Entry>(collection);
                    HashMap hashMap = new HashMap();
                    arrayList.sort(Comparator.comparingLong(entry -> hashMap.computeIfAbsent(entry.getKey(), string -> ((KeyValueStateMachine.ValueWithOptionalOwner)entry.getValue()).lastAccessed)));
                    long l2 = (long)n - l;
                    for (Map.Entry entry2 : arrayList) {
                        if (l2 <= 0L) break;
                        l2 -= (long)((KeyValueStateMachine.ValueWithOptionalOwner)entry2.getValue()).value.length;
                        String string = (String)entry2.getKey();
                        if (!string.startsWith(RaftBackedCache.this.prefix())) continue;
                        String string2 = string.replace(RaftBackedCache.this.prefix(), "");
                        RaftBackedCache.this.evictionTasksRunning.add(theseus.withDistributedLockAsync(string, () -> {
                            Optional<byte[]> optional = theseus.getElement(string);
                            if (optional.isPresent()) {
                                if (!Entry.readIsPersisted(optional.get())) {
                                    try {
                                        Entry entry = Entry.deserialize(string2, optional.get(), RaftBackedCache.this::deserialize);
                                        log.info("Persisting RaftBackedCache element with key {} in preparation for eviction", (Object)string2);
                                        RaftBackedCache.this.persist(string2, entry.value, false);
                                    }
                                    catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                                        log.warn("Could not deserialize Raft value for key {}", (Object)string);
                                    }
                                }
                                log.info("Evicting RaftBackedCache element with key {}", (Object)string2);
                                return theseus.removeElementAsync(string, Duration.ofSeconds(30L));
                            }
                            return CompletableFuture.completedFuture(false);
                        }));
                    }
                }
            }
        };
        this.raft.node.transport.scheduleAtFixedRate(this.evictionTask, 1000L);
    }

    protected RaftBackedCache(Theseus theseus, Duration duration, Duration duration2) {
        this(theseus, duration, duration2, 0x100000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> allOutstandingEvictionsFuture() {
        Set<CompletableFuture<Boolean>> set = this.evictionTasksRunning;
        synchronized (set) {
            return CompletableFuture.allOf(this.evictionTasksRunning.toArray(new CompletableFuture[0]));
        }
    }

    @Override
    public void close() {
        this.evictionTask.cancel();
    }

    protected abstract String prefix();

    public abstract byte[] serialize(V var1);

    public abstract Optional<V> deserialize(byte[] var1);

    public abstract Optional<V> restore(String var1);

    public abstract void persist(String var1, V var2, boolean var3);

    public CompletableFuture<Boolean> clearCache() {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this.raft.stateMachine.values.keySet()) {
            if (!string.startsWith(this.prefix())) continue;
            hashSet.add(string);
        }
        return this.raft.removeElementsAsync(hashSet, Duration.ofSeconds(30L));
    }

    public void addChangeListener(ChangeListener<V> changeListener, @Nullable Object object) {
        KeyValueStateMachine.ChangeListener changeListener2 = (string, optional, map) -> {
            if (string.startsWith(this.prefix())) {
                string = string.replace(this.prefix(), "");
                Optional<Object> optional2 = Optional.empty();
                if (optional.isPresent()) {
                    try {
                        optional2 = Optional.of(Entry.deserialize((String)string, (byte[])((byte[])optional.get()), (Function<byte[], Optional<V>>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, deserialize(byte[] ), ([B)Ljava/util/Optional;)((RaftBackedCache)this)).value);
                    }
                    catch (Throwable throwable) {
                        log.warn("Could not parse entry in change listener", throwable);
                    }
                }
                changeListener.onChange(string, optional2);
            }
        };
        this.changeListeners.put(changeListener, changeListener2);
        this.raft.addChangeListener(changeListener2);
        if (object != null) {
            this.changeListenerOwner.put(changeListener, new WeakReference<Object>(object));
            HashSet hashSet = new HashSet();
            for (Map.Entry<ChangeListener, WeakReference<Object>> entry : this.changeListenerOwner.entrySet()) {
                if (entry.getValue().get() != null) continue;
                hashSet.add(entry.getKey());
            }
            for (Map.Entry<ChangeListener, WeakReference<Object>> entry : hashSet) {
                log.warn("Leaked Raft change listener {} on cache {}", (Object)entry, (Object)this.toString());
                this.removeChangeListener((ChangeListener)((Object)entry));
            }
        }
    }

    public void addChangeListener(ChangeListener<V> changeListener) {
        this.addChangeListener(changeListener, null);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        KeyValueStateMachine.ChangeListener changeListener2 = this.changeListeners.get(changeListener);
        if (changeListener2 != null) {
            this.raft.removeChangeListener(changeListener2);
        } else {
            log.warn("No corresponding listener to remove from the KeyValueStateMachine. This is troubling.");
        }
        this.changeListenerOwner.remove(changeListener);
    }

    public CompletableFuture<Boolean> withElementAsync(String string, BiFunction<V, Consumer<V>, V> biFunction, @Nullable Supplier<V> supplier, boolean bl) {
        log.trace("WithElement {}", (Object)string);
        Pointer<Boolean> pointer = new Pointer<Boolean>(false);
        Function<byte[], byte[]> function = byArray -> {
            Entry entry;
            try {
                entry = Entry.deserialize(string, byArray, this::deserialize);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                log.warn("Could not deserialize value for key=" + this.prefix() + string);
                return byArray;
            }
            Object r = biFunction.apply(entry.value, object -> {
                try {
                    Entry<Object> entry2 = new Entry<Object>(string, false, entry.value);
                    this.raft.setElementAsync(this.prefix() + string, entry2.serialize(this::serialize), true, Duration.ofSeconds(5L)).get(6L, TimeUnit.SECONDS);
                }
                catch (InterruptedException | ExecutionException | TimeoutException exception) {
                    log.warn("Could not save intermediate state during withElementAsyc call in RaftBackedCache: ", (Throwable)exception);
                }
            });
            if (r != entry.value) {
                this.onSet(r);
                boolean bl = false;
                if (pointer.dereference().orElse(false).booleanValue()) {
                    bl = true;
                    this.persist(string, r, false);
                }
                return new Entry(string, bl, r).serialize(this::serialize);
            }
            return byArray;
        };
        Supplier<byte[]> supplier2 = () -> {
            Optional<V> optional = this.restore(string);
            if (optional.isPresent()) {
                return new Entry<Object>(string, true, optional.get()).serialize(this::serialize);
            }
            if (supplier != null) {
                Object t = supplier.get();
                pointer.set(true);
                return new Entry(string, false, t).serialize(this::serialize);
            }
            return null;
        };
        if (bl) {
            return this.raft.withElementUnlockedAsync(this.prefix() + string, function, supplier2, true);
        }
        return this.raft.withElementAsync(this.prefix() + string, function, supplier2, true);
    }

    public CompletableFuture<Boolean> withElementAsync(String string, Function<V, V> function, @Nullable Supplier<V> supplier, boolean bl) {
        return this.withElementAsync(string, (V object, Consumer<V> consumer) -> function.apply(object), supplier, bl);
    }

    public CompletableFuture<Boolean> withElementAsync(String string, Function<V, V> function, Supplier<V> supplier) {
        return this.withElementAsync(string, function, supplier, false);
    }

    public CompletableFuture<Boolean> withElementAsync(String string, Function<V, V> function) {
        return this.withElementAsync(string, function, null, false);
    }

    public CompletableFuture<Boolean> withElementAsync(String string, BiFunction<V, Consumer<V>, V> biFunction) {
        return this.withElementAsync(string, biFunction, null, false);
    }

    public Optional<V> get(String string) {
        Optional<byte[]> optional = this.raft.stateMachine.get(this.prefix() + string, TimerUtils.mockableNow().toEpochMilli());
        if (optional.isPresent()) {
            try {
                return Optional.of(Entry.deserialize((String)string, (byte[])optional.get(), (Function<byte[], Optional<V>>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, deserialize(byte[] ), ([B)Ljava/util/Optional;)((RaftBackedCache)this)).value);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                log.warn("Could not read Proto for Raft item");
                return Optional.empty();
            }
        }
        Optional<V> optional2 = this.restore(string);
        optional2.ifPresent(object -> this.raft.setElementAsync(this.prefix() + string, new Entry<Object>(string, false, object).serialize(this::serialize), true, Duration.ofSeconds(5L)));
        return optional2;
    }

    public Optional<V> getIfPresent(String string) {
        return this.raft.stateMachine.get(this.prefix() + string, TimerUtils.mockableNow().toEpochMilli()).flatMap(byArray -> {
            try {
                return Optional.of(Entry.deserialize((String)string, (byte[])byArray, (Function<byte[], Optional<V>>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, deserialize(byte[] ), ([B)Ljava/util/Optional;)((RaftBackedCache)this)).value);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                return Optional.empty();
            }
        });
    }

    public CompletableFuture<Boolean> put(String string, V v, boolean bl) {
        this.onSet(v);
        Entry<Object> entry = new Entry<Object>(string, false, v);
        if (bl) {
            this.persist(string, v, false);
        }
        return this.raft.setElementAsync(this.prefix() + string, entry.serialize(this::serialize), true, Duration.ofSeconds(5L));
    }

    public CompletableFuture<Boolean> evictWithoutSaving(String string) {
        return this.raft.removeElementAsync(this.prefix() + string, Duration.ofSeconds(5L));
    }

    @Override
    @Nonnull
    public Iterator<Map.Entry<String, V>> iterator() {
        String string = this.prefix();
        return this.raft.getMap().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(string)).map(entry -> {
            try {
                return Entry.deserialize((String)entry.getKey(), (byte[])entry.getValue(), this::deserialize);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                return null;
            }
        }).filter(Objects::nonNull).iterator();
    }

    private boolean valuePersistedSinceLastWrite(String string) {
        return this.raft.getElement(string).filter(Entry::readIsPersisted).isPresent();
    }

    @FunctionalInterface
    public static interface ChangeListener<V> {
        public void onChange(String var1, Optional<V> var2);
    }

    static class Entry<V>
    implements Map.Entry<String, V> {
        public boolean isPersisted;
        public final String key;
        public final V value;

        Entry(String string, boolean bl, V v) {
            this.key = string;
            this.isPersisted = bl;
            this.value = v;
        }

        public static <V> Entry<V> deserialize(String string, byte[] byArray, Function<byte[], Optional<V>> function) throws InvalidProtocolBufferException {
            byte by = byArray[0];
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            Optional<V> optional = function.apply(byArray2);
            if (!optional.isPresent()) {
                Optional<V> optional2 = function.apply(byArray);
                if (optional2.isPresent()) {
                    return new Entry<V>(string, false, optional2.get());
                }
                throw new InvalidProtocolBufferException("Deserialization returned Optional.empty()");
            }
            return new Entry<V>(string, by == 1, optional.get());
        }

        public static boolean readIsPersisted(byte[] byArray) {
            return byArray[0] == 1;
        }

        public byte[] serialize(Function<V, byte[]> function) {
            byte[] byArray = function.apply(this.value);
            byte[] byArray2 = new byte[byArray.length + 1];
            System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
            byArray2[0] = (byte)(this.isPersisted ? 1 : 0);
            return byArray2;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            throw new UnsupportedOperationException();
        }
    }
}

