/*
 * Decompiled with CFR 0.152.
 */
package ai.eloquent.raft;

import ai.eloquent.raft.EloquentRaftNode;
import ai.eloquent.util.IdentityHashSet;
import ai.eloquent.util.Lazy;
import ai.eloquent.util.Pair;
import ai.eloquent.util.SafeTimer;
import ai.eloquent.util.SafeTimerMock;
import ai.eloquent.util.SafeTimerReal;
import ai.eloquent.util.SystemUtils;
import ai.eloquent.util.TimerUtils;
import ai.eloquent.util.Uninterruptably;
import ai.eloquent.web.TrackedExecutorService;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaftLifecycle {
    private static final Logger log = LoggerFactory.getLogger(RaftLifecycle.class);
    public static RaftLifecycle global = RaftLifecycle.newBuilder().build();
    public Lazy<SafeTimer> timer;
    protected final Map<String, ExecutorService> managedThreadPools = new HashMap<String, ExecutorService>();
    protected final Map<String, ExecutorService> coreThreadPools = new HashMap<String, ExecutorService>();
    protected Optional<EloquentRaftNode> registeredRaft = Optional.empty();
    protected final IdentityHashSet<Runnable> shutdownHooks = new IdentityHashSet();
    public final AtomicBoolean IS_READY = new AtomicBoolean(false);
    public final AtomicBoolean IS_SHUTTING_DOWN = new AtomicBoolean(false);
    public final AtomicBoolean SHUTDOWN_BEGIN = new AtomicBoolean(false);
    public final AtomicBoolean CORE_THREAD_POOLS_CLOSED = new AtomicBoolean(false);
    public static final int STATUS_PERIOD_SEC = 2;
    public static final int STATUS_FAILURE_THRESHOLD = 3;
    public static final int STATUS_TIMEOUT_SEC = 5;
    protected final Set<ReentrantLock> criticalSections = new IdentityHashSet<ReentrantLock>();
    protected boolean allowCriticalSections = true;

    public RaftLifecycle(Lazy<SafeTimer> lazy) {
        this.timer = lazy;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public void registerRaft(EloquentRaftNode eloquentRaftNode) {
        this.registeredRaft = Optional.of(eloquentRaftNode);
    }

    private String logServerNamePrefix() {
        return this.registeredRaft.map(eloquentRaftNode -> eloquentRaftNode.algorithm.serverName() + " - ").orElse("");
    }

    public ExecutorService managedThreadPool(int n, String string, boolean bl, int n2) {
        if (bl && !this.coreThreadPools.containsKey(string) || !bl && !this.managedThreadPools.containsKey(string)) {
            ExecutorService executorService = n == 1 ? Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat(string + "-%d").setDaemon(true).setUncaughtExceptionHandler((thread, throwable) -> log.warn("Uncaught exception on thread " + thread.getName(), throwable)).setPriority(n2).build()) : Executors.newFixedThreadPool(n, new ThreadFactoryBuilder().setNameFormat(string + "-%d").setDaemon(true).build());
            if (this == global) {
                executorService = new TrackedExecutorService(string, executorService);
            }
            if (bl) {
                this.coreThreadPools.put(string, executorService);
            } else {
                this.managedThreadPools.put(string, executorService);
            }
        } else {
            log.warn(this.logServerNamePrefix() + "Getting a thread pool that already exists for \"" + string + "\", but asking for a pool with a fixed size = " + n + ". This will likely lead to trouble as multiple people each think they have exclusive access to " + n + " threads, when in fact they do not", (Throwable)new IllegalStateException());
        }
        if (bl) {
            return this.coreThreadPools.get(string);
        }
        return this.managedThreadPools.get(string);
    }

    public ExecutorService managedThreadPool(int n, String string, boolean bl) {
        return this.managedThreadPool(n, string, bl, 5);
    }

    public ExecutorService managedThreadPool(int n, String string, int n2) {
        return this.managedThreadPool(n, string, false, n2);
    }

    public ExecutorService managedThreadPool(int n, String string) {
        return this.managedThreadPool(n, string, false);
    }

    public ExecutorService managedThreadPool(String string, boolean bl, int n) {
        if (bl && !this.coreThreadPools.containsKey(string) || !bl && !this.managedThreadPools.containsKey(string)) {
            ExecutorService executorService = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat(string + "-%d").setDaemon(true).setUncaughtExceptionHandler((thread, throwable) -> log.warn("Uncaught exception on thread " + thread.getName(), throwable)).setPriority(n).build());
            if (this == global) {
                executorService = new TrackedExecutorService(string, executorService);
            }
            if (bl) {
                this.coreThreadPools.put(string, executorService);
            } else {
                this.managedThreadPools.put(string, executorService);
            }
        }
        if (bl) {
            return this.coreThreadPools.get(string);
        }
        return this.managedThreadPools.get(string);
    }

    public ExecutorService managedThreadPool(String string, boolean bl) {
        return this.managedThreadPool(string, bl, 5);
    }

    public ExecutorService managedThreadPool(String string) {
        return this.managedThreadPool(string, false, 5);
    }

    public ExecutorService managedThreadPool(String string, int n) {
        return this.managedThreadPool(string, false, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean bl) {
        if (this.SHUTDOWN_BEGIN.getAndSet(true)) {
            log.warn(this.logServerNamePrefix() + "Detected an attempt to double-shutdown. Ignoring.");
            return;
        }
        Thread thread = new Thread(() -> {
            log.info(global.logServerNamePrefix() + "Memory (pre-gc):  free=" + Runtime.getRuntime().freeMemory() / 0x100000L + "MB  total=" + Runtime.getRuntime().totalMemory() / 0x100000L + "MB  max=" + Runtime.getRuntime().maxMemory() / 0x100000L + "MB");
            Runtime.getRuntime().gc();
            log.info(global.logServerNamePrefix() + "Memory (post-gc): free=" + Runtime.getRuntime().freeMemory() / 0x100000L + "MB  total=" + Runtime.getRuntime().totalMemory() / 0x100000L + "MB  max=" + Runtime.getRuntime().maxMemory() / 0x100000L + "MB");
        });
        thread.setDaemon(true);
        thread.setName("shutdown-gc");
        thread.start();
        if (this.IS_READY.getAndSet(false)) {
            long l = 23000L;
            log.info(this.logServerNamePrefix() + "Waiting " + TimerUtils.formatTimeDifference(l) + " before shutting down to let Kubernetes detect we're not READY...");
            Uninterruptably.sleep(l);
        }
        this.IS_SHUTTING_DOWN.set(true);
        Set<ReentrantLock> set = this.criticalSections;
        synchronized (set) {
            this.allowCriticalSections = false;
        }
        log.info(this.logServerNamePrefix() + "Running shutdown hooks (1 minute timeout on each)");
        IdentityHashSet<Object> identityHashSet = this.shutdownHooks;
        synchronized (identityHashSet) {
            set = new HashSet<Runnable>(this.shutdownHooks);
        }
        set.stream().map(runnable -> {
            log.info(this.logServerNamePrefix() + "Starting shutdown task {}", runnable.getClass());
            Thread thread = new Thread((Runnable)runnable);
            thread.setName("shutdown-hook");
            thread.start();
            return Pair.makePair(thread, runnable.getClass());
        }).collect(Collectors.toList()).forEach(pair -> {
            try {
                ((Thread)pair.first).join(Duration.ofMinutes(1L).toMillis());
                log.info(this.logServerNamePrefix() + "Joined shutdown task {}", pair.second);
            }
            catch (InterruptedException interruptedException) {
                log.warn(this.logServerNamePrefix() + "Shutdown hook got interrupted before it could finish!");
            }
        });
        log.info(this.logServerNamePrefix() + "Waiting on critical sections to finish (max 1 minute)...");
        Set<ReentrantLock> set2 = this.criticalSections;
        synchronized (set2) {
            this.allowCriticalSections = false;
            identityHashSet = new IdentityHashSet<ReentrantLock>(this.criticalSections);
        }
        identityHashSet.forEach(reentrantLock -> {
            try {
                reentrantLock.tryLock(Duration.ofMinutes(1L).toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        log.info(this.logServerNamePrefix() + "Finalizing as much as we can (connections are still alive)");
        try {
            thread.join(30000L);
        }
        catch (InterruptedException interruptedException) {
            log.warn("shutdown GC thread interrupted before completion");
        }
        System.runFinalization();
        this.registeredRaft.ifPresent(eloquentRaftNode -> {
            log.info(this.logServerNamePrefix() + "Shutting down raft (blocking={})...", (Object)(!bl ? 1 : 0));
            eloquentRaftNode.close(bl);
            log.info(this.logServerNamePrefix() + "Raft shut down");
        });
        log.info(this.logServerNamePrefix() + "Cancelling timers");
        Optional.ofNullable(this.timer.getIfDefined()).ifPresent(SafeTimer::cancel);
        log.info(this.logServerNamePrefix() + "Timers cancelled");
        log.info(this.logServerNamePrefix() + "Stopping non-essential thread pools");
        this.stopPool(this.managedThreadPools.values());
        log.info(this.logServerNamePrefix() + "All non-essential threads should be stopped");
        log.info(this.logServerNamePrefix() + "Stopping core thread pools");
        this.stopPool(this.coreThreadPools.values());
        log.info(this.logServerNamePrefix() + "All core thread pools should be stopped");
        this.CORE_THREAD_POOLS_CLOSED.set(true);
        log.info(this.logServerNamePrefix() + "Finalizing as much as we can (connections are dead)");
        System.runFinalization();
    }

    protected void stopPool(Collection<ExecutorService> collection) {
        collection.stream().map(executorService -> {
            executorService.shutdown();
            Thread thread = new Thread(() -> {
                try {
                    long l = System.currentTimeMillis();
                    executorService.awaitTermination(1L, TimeUnit.MINUTES);
                    if (System.currentTimeMillis() - l > 55000L) {
                        log.warn(this.logServerNamePrefix() + "Service took >55s to shut down: {}", executorService);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
            thread.setDaemon(true);
            thread.setName("waiting for " + executorService + " to terminate");
            thread.start();
            return thread;
        }).forEach(thread -> {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        });
        log.info(this.logServerNamePrefix() + "pools stopped");
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (System.getenv("CI") != null) {
                return;
            }
            log.info(global.logServerNamePrefix() + "-----------------BEGIN SHUTDOWN " + SystemUtils.HOST + "--------------------");
            global.shutdown(false);
            log.info(global.logServerNamePrefix() + "-----------------END SHUTDOWN " + SystemUtils.HOST + "--------------------");
            Uninterruptably.sleep(1000L);
            log.info(global.logServerNamePrefix() + "Done with shutdown");
            log.info(global.logServerNamePrefix() + "-----------------TERMINATION " + SystemUtils.HOST + "--------------------");
        }));
    }

    public static class Builder {
        private boolean mockTimer = false;

        public Builder mockTime() {
            this.mockTimer = true;
            return this;
        }

        public RaftLifecycle build() {
            Lazy<SafeTimer> lazy = this.mockTimer ? Lazy.of(SafeTimerMock::new) : Lazy.of(SafeTimerReal::new);
            return new RaftLifecycle(lazy);
        }
    }
}

