/*
 * Decompiled with CFR 0.152.
 */
package ai.eloquent.raft;

import ai.eloquent.monitoring.Prometheus;
import ai.eloquent.raft.EloquentRaftProto;
import ai.eloquent.raft.KeyValueStateMachine;
import ai.eloquent.raft.RaftLogEntryLocation;
import ai.eloquent.raft.RaftStateMachine;
import ai.eloquent.util.FunctionalUtils;
import ai.eloquent.util.TimerUtils;
import com.sun.management.GarbageCollectorMXBean;
import com.sun.management.GcInfo;
import java.lang.management.ManagementFactory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaftLog {
    private static final Logger log = LoggerFactory.getLogger(RaftLog.class);
    private static int minLogLevel = 2;
    public static final int COMPACTION_LIMIT = 1024;
    private final ExecutorService pool;
    long commitIndex;
    final Deque<EloquentRaftProto.LogEntry> logEntries = new ArrayDeque<EloquentRaftProto.LogEntry>(1024);
    public final RaftStateMachine stateMachine;
    final List<CommitFuture> commitFutures = new ArrayList<CommitFuture>();
    public Optional<Snapshot> snapshot = Optional.empty();
    final Set<String> latestQuorumMembers = new HashSet<String>();
    public final Set<String> committedQuorumMembers = new HashSet<String>();
    private Set<String> initialQuorumMembers;
    private static Object summaryTiming = Prometheus.summaryBuild("raft_log", "Timing on the Raft log methods", new String[0]);

    public static void setLevel(int n) {
        minLogLevel = n;
    }

    public static void setLevel(String string) {
        switch (string.toLowerCase()) {
            case "trace": 
            case "0": {
                minLogLevel = 0;
                break;
            }
            case "debug": 
            case "1": {
                minLogLevel = 1;
                break;
            }
            case "info": 
            case "2": {
                minLogLevel = 2;
                break;
            }
            case "warn": 
            case "3": {
                minLogLevel = 3;
                break;
            }
            case "error": 
            case "4": {
                minLogLevel = 4;
                break;
            }
            case "off": 
            case "5": {
                minLogLevel = 99;
                break;
            }
            default: {
                minLogLevel = 2;
            }
        }
    }

    public static int level() {
        return minLogLevel;
    }

    public RaftLog(RaftStateMachine raftStateMachine, Collection<String> collection, ExecutorService executorService) {
        this.stateMachine = raftStateMachine;
        this.commitIndex = 0L;
        this.initialQuorumMembers = FunctionalUtils.immutable(new HashSet<String>(collection));
        this.latestQuorumMembers.addAll(collection);
        this.committedQuorumMembers.addAll(collection);
        this.pool = executorService;
    }

    private boolean fast(String string, Object object) {
        long l = (long)(Prometheus.observeDuration(object) * 1000.0);
        if (l > 5L) {
            long l2 = -1L;
            try {
                for (java.lang.management.GarbageCollectorMXBean garbageCollectorMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
                    GarbageCollectorMXBean garbageCollectorMXBean2 = (GarbageCollectorMXBean)garbageCollectorMXBean;
                    GcInfo gcInfo = garbageCollectorMXBean2.getLastGcInfo();
                    if (gcInfo == null) continue;
                    l2 = gcInfo.getStartTime();
                }
            }
            catch (Throwable throwable) {
                log.warn("Could not get GC info -- are you running on a non-Sun JVM?");
            }
            boolean bl = false;
            if (l2 > System.currentTimeMillis() - l && l2 < System.currentTimeMillis()) {
                bl = true;
            }
            log.warn("{} took {};  interrupted_by_gc={}", new Object[]{string, TimerUtils.formatTimeDifference(l), bl});
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RaftLog copy() {
        Object object = Prometheus.startTimer(summaryTiming, new String[0]);
        try {
            this.assertConsistency();
            RaftLog raftLog = new RaftLog(this.stateMachine, Collections.emptyList(), this.pool);
            raftLog.latestQuorumMembers.addAll(this.latestQuorumMembers);
            raftLog.committedQuorumMembers.addAll(this.committedQuorumMembers);
            raftLog.logEntries.addAll(this.logEntries);
            raftLog.commitFutures.addAll(this.commitFutures);
            raftLog.commitIndex = this.commitIndex;
            raftLog.snapshot = this.snapshot;
            assert (raftLog.equals(this)) : "Copy did not copy the log state entirely";
            RaftLog raftLog2 = raftLog;
            return raftLog2;
        }
        finally {
            assert (this.fast("copy", object));
        }
    }

    void unsafeBootstrapQuorum(Collection<String> collection) {
        Object object = Prometheus.startTimer(summaryTiming, new String[0]);
        this.assertConsistency();
        try {
            assert (this.getQuorumMembers().isEmpty()) : "Cannot bootstrap from an existing quorum";
            this.initialQuorumMembers = FunctionalUtils.immutable(new HashSet<String>(collection));
            this.latestQuorumMembers.clear();
            this.latestQuorumMembers.addAll(collection);
            this.snapshot = Optional.empty();
            this.logEntries.clear();
            this.commitIndex = 0L;
        }
        finally {
            assert (this.fast("unsafeBootstrapQuorum", object));
            this.assertConsistency();
        }
    }

    public long getCommitIndex() {
        this.assertConsistency();
        return this.commitIndex;
    }

    public long getLastEntryIndex() {
        if (this.logEntries.size() > 0) {
            return this.logEntries.getLast().getIndex();
        }
        if (this.snapshot.isPresent()) {
            return this.snapshot.get().lastIndex;
        }
        return 0L;
    }

    public long getLastEntryTerm() {
        this.assertConsistency();
        try {
            if (this.logEntries.size() > 0) {
                long l = this.logEntries.getLast().getTerm();
                return l;
            }
            if (this.snapshot.isPresent()) {
                long l = this.snapshot.get().lastTerm;
                return l;
            }
            long l = 0L;
            return l;
        }
        finally {
            this.assertConsistency();
        }
    }

    public Set<String> getQuorumMembers() {
        this.assertConsistency();
        return this.latestQuorumMembers;
    }

    public List<EloquentRaftProto.LogEntry> getAllUncompressedEntries() {
        this.assertConsistency();
        return new ArrayList<EloquentRaftProto.LogEntry>(this.logEntries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<List<EloquentRaftProto.LogEntry>> getEntriesSinceInclusive(long l) {
        Object object = Prometheus.startTimer(summaryTiming, new String[0]);
        this.assertConsistency();
        try {
            if (l > this.getLastEntryIndex()) {
                Optional<List<EloquentRaftProto.LogEntry>> optional = Optional.of(new ArrayList());
                return optional;
            }
            if (!this.getEntryAtIndex(l).isPresent()) {
                Optional<List<EloquentRaftProto.LogEntry>> optional = Optional.empty();
                return optional;
            }
            ArrayList<EloquentRaftProto.LogEntry> arrayList = new ArrayList<EloquentRaftProto.LogEntry>();
            for (long i = l; i <= this.getLastEntryIndex(); ++i) {
                Optional<EloquentRaftProto.LogEntry> optional = this.getEntryAtIndex(i);
                assert (optional.isPresent());
                arrayList.add(optional.get());
            }
            Optional<List<EloquentRaftProto.LogEntry>> optional = Optional.of(arrayList);
            return optional;
        }
        finally {
            this.assertConsistency();
            assert (this.fast("getEntriesSinceInclusive", object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Long> getPreviousEntryTerm(long l) {
        Object object = Prometheus.startTimer(summaryTiming, new String[0]);
        this.assertConsistency();
        try {
            if (l > this.getLastEntryIndex()) {
                Optional<Long> optional = Optional.empty();
                return optional;
            }
            if (this.snapshot.isPresent() && this.snapshot.get().lastIndex == l) {
                Optional<Long> optional = Optional.of(this.snapshot.get().lastTerm);
                return optional;
            }
            Optional<EloquentRaftProto.LogEntry> optional = this.getEntryAtIndex(l);
            if (optional.isPresent()) {
                Optional<Long> optional2 = Optional.of(optional.get().getTerm());
                return optional2;
            }
            if (l == 0L) {
                Optional<Long> optional3 = Optional.of(0L);
                return optional3;
            }
            Optional<Long> optional4 = Optional.empty();
            return optional4;
        }
        finally {
            this.assertConsistency();
            assert (this.fast("getPreviousEntryTerm", object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getSafeToChangeMembership() {
        Object object = Prometheus.startTimer(summaryTiming, new String[0]);
        this.assertConsistency();
        try {
            for (long i = this.commitIndex + 1L; i <= this.getLastEntryIndex(); ++i) {
                Optional<EloquentRaftProto.LogEntry> optional = this.getEntryAtIndex(i);
                assert (optional.isPresent());
                if (optional.get().getType() != EloquentRaftProto.LogEntryType.CONFIGURATION) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.assertConsistency();
            assert (this.fast("getSafeToChangeMembership", object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<RaftLogEntryLocation> lastConfigurationEntryLocation() {
        Object object = Prometheus.startTimer(summaryTiming, new String[0]);
        this.assertConsistency();
        try {
            Object object2;
            Iterator<EloquentRaftProto.LogEntry> iterator = this.logEntries.descendingIterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                if (((EloquentRaftProto.LogEntry)object2).getConfigurationList().isEmpty()) continue;
                Optional<RaftLogEntryLocation> optional = Optional.of(new RaftLogEntryLocation(((EloquentRaftProto.LogEntry)object2).getIndex(), ((EloquentRaftProto.LogEntry)object2).getTerm()));
                return optional;
            }
            object2 = Optional.empty();
            return object2;
        }
        finally {
            this.assertConsistency();
            assert (this.fast("lastConfigurationEntryLocation", object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableFuture<Boolean> createCommitFuture(long l, long l2, boolean bl2) {
        Object object = Prometheus.startTimer(summaryTiming, new String[0]);
        this.assertConsistency();
        try {
            CompletableFuture<Boolean> completableFuture = new CompletableFuture<Boolean>();
            if (l <= this.getCommitIndex()) {
                boolean bl3 = this.snapshot.map(snapshot -> l < snapshot.lastIndex && l2 <= snapshot.lastTerm).orElse(false);
                if (!bl3) {
                    Optional<Long> optional = this.getPreviousEntryTerm(l);
                    boolean bl4 = bl3 = optional.isPresent() && optional.get() == l2;
                    if (!bl3) {
                        log.trace("Failing commit future (bad term; actual={} != expected={})", optional.isPresent() ? optional.get() : "<unk>", (Object)l2);
                    }
                }
                completableFuture.complete(bl3);
            } else if (bl2) {
                this.commitFutures.add(new CommitFuture(l, l2, completableFuture::complete));
            } else {
                this.commitFutures.add(new CommitFuture(l, l2, bl -> this.pool.submit(() -> completableFuture.complete((Boolean)bl))));
            }
            CompletableFuture<Boolean> completableFuture2 = completableFuture;
            return completableFuture2;
        }
        finally {
            this.assertConsistency();
            assert (this.fast("createCommitFuture", object));
        }
    }

    public CompletableFuture<Boolean> createCommitFuture(long l, long l2) {
        return this.createCommitFuture(l, l2, false);
    }

    public CompletableFuture<Boolean> createCommitFuture(RaftLogEntryLocation raftLogEntryLocation) {
        return this.createCommitFuture(raftLogEntryLocation.index, raftLogEntryLocation.term);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCommitIndex(long l2, long l22) {
        Object object = Prometheus.startTimer(summaryTiming, new String[0]);
        this.assertConsistency();
        try {
            if (l2 > this.commitIndex) {
                long l3 = this.snapshot.map(snapshot -> snapshot.lastIndex).orElse(0L);
                if (this.logEntries.size() > 0) {
                    l3 = Math.max(this.logEntries.peekLast().getIndex(), l3);
                }
                long l4 = Math.min(l2, l3);
                assert (l4 > this.commitIndex);
                for (EloquentRaftProto.LogEntry object2 : this.logEntries) {
                    if (object2.getIndex() <= this.commitIndex || object2.getIndex() > l4) continue;
                    if (object2.getType() == EloquentRaftProto.LogEntryType.TRANSITION) {
                        this.stateMachine.applyTransition(object2.getTransition().isEmpty() ? Optional.empty() : Optional.of(object2.getTransition().toByteArray()), "".equals(object2.getNewHospiceMember()) ? Optional.empty() : Optional.of(object2.getNewHospiceMember()), l22, this.pool);
                        continue;
                    }
                    if (object2.getType() == EloquentRaftProto.LogEntryType.CONFIGURATION) {
                        this.committedQuorumMembers.clear();
                        this.committedQuorumMembers.addAll((Collection<String>)object2.getConfigurationList());
                        continue;
                    }
                    throw new IllegalStateException("Unrecognized entry type. This likely means we're very very out of date, and should now crash.");
                }
                this.commitIndex = l4;
                this.assertConsistency();
                for (CommitFuture commitFuture : new ArrayList<CommitFuture>(this.commitFutures)) {
                    if (this.commitIndex < commitFuture.index) continue;
                    Optional<Long> optional = this.getPreviousEntryTerm(commitFuture.index);
                    boolean bl = optional.map(l -> l == commitFuture.term).orElse(false);
                    if (!bl) {
                        if (optional.isPresent()) {
                            log.trace("Failing commit future (bad term; actual={} != expected={})", (Object)optional.get(), (Object)commitFuture.term);
                        } else {
                            log.trace("Failing commit future (bad term; already compacted entry in snapshot)");
                        }
                    }
                    commitFuture.complete.accept(bl);
                    this.commitFutures.remove(commitFuture);
                }
            }
        }
        finally {
            this.assertConsistency();
            assert (this.fast("setCommitIndex", object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean appendEntries(long l, long l2, List<EloquentRaftProto.LogEntry> list) {
        Object object = Prometheus.startTimer(summaryTiming, new String[0]);
        this.assertConsistency();
        try {
            Optional<EloquentRaftProto.LogEntry> optional = this.getEntryAtIndex(l);
            boolean bl = false;
            if (l == 0L) {
                bl = true;
            } else if (optional.isPresent() && optional.get().getTerm() == l2) {
                bl = true;
            } else if (this.snapshot.isPresent() && this.snapshot.get().lastTerm == l2 && this.snapshot.get().lastIndex == l) {
                bl = true;
            }
            assert (list.stream().noneMatch(logEntry -> this.getEntryAtIndex(logEntry.getIndex()).map(logEntry2 -> logEntry2.getTerm() > logEntry.getTerm()).orElse(false))) : "We should never overwrite an entry with a lower term";
            if (!bl) {
                log.trace("Rejecting log transition: prevLogIndex={}  prevEntry.getTerm()={}  prevLogTerm={}  commitIndex={}", new Object[]{l, optional.map(EloquentRaftProto.LogEntry::getTerm).orElse(-1L), l2, this.commitIndex});
                boolean bl2 = false;
                return bl2;
            }
            if (list.isEmpty()) {
                if (this.logEntries.isEmpty()) {
                    boolean bl3 = true;
                    return bl3;
                }
                if (optional.isPresent() && optional.get().getIndex() == l && optional.get().getTerm() == l2 && optional.get().getIndex() == this.getLastEntryIndex()) {
                    boolean bl4 = true;
                    return bl4;
                }
            }
            if (!list.isEmpty()) {
                for (EloquentRaftProto.LogEntry logEntry2 : list) {
                    Optional<EloquentRaftProto.LogEntry> optional2 = this.getEntryAtIndex(logEntry2.getIndex());
                    if (!optional2.isPresent()) continue;
                    if (optional2.get().getTerm() != logEntry2.getTerm()) {
                        this.truncateLogAfterIndexInclusive(logEntry2.getIndex());
                        break;
                    }
                    assert (logEntry2.toByteString().equals((Object)optional2.get().toByteString()));
                }
            }
            if (!list.isEmpty()) {
                long l3 = list.get(0).getIndex();
                long l4 = this.getLastEntryIndex();
                int n = (int)(l4 - l3) + 1;
                assert (n >= 0);
                for (int i = n; i < list.size(); ++i) {
                    this.logEntries.add(list.get(i));
                    if (list.get(i).getType() != EloquentRaftProto.LogEntryType.CONFIGURATION) continue;
                    Optional<String> optional3 = Optional.empty();
                    if (this.stateMachine instanceof KeyValueStateMachine) {
                        optional3 = ((KeyValueStateMachine)this.stateMachine).serverName;
                    }
                    log.info("{} - Reconfiguring cluster to {}", (Object)optional3.orElse("?"), (Object)list.get(i).getConfigurationList());
                    this.latestQuorumMembers.clear();
                    this.latestQuorumMembers.addAll((Collection<String>)list.get(i).getConfigurationList());
                }
                if (this.logEntries.size() >= 1024) {
                    this.forceSnapshot();
                }
            }
            boolean bl5 = true;
            return bl5;
        }
        finally {
            this.assertConsistency();
            assert (this.fast("appendEntries", object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean installSnapshot(Snapshot snapshot, long l) {
        Object object = Prometheus.startTimer(summaryTiming, new String[0]);
        this.assertConsistency();
        try {
            if (this.snapshot.isPresent() && snapshot.lastIndex <= this.snapshot.get().lastIndex) {
                boolean bl = false;
                return bl;
            }
            this.snapshot = Optional.of(snapshot);
            Optional<EloquentRaftProto.LogEntry> optional = this.getEntryAtIndex(snapshot.lastIndex);
            if (optional.isPresent() && optional.get().getTerm() == snapshot.lastTerm) {
                if (this.commitIndex < snapshot.lastIndex) {
                    this.setCommitIndex(snapshot.lastIndex, l);
                }
                this.truncateLogBeforeIndexInclusive(snapshot.lastIndex);
                boolean bl = true;
                return bl;
            }
            this.logEntries.clear();
            this.stateMachine.overwriteWithSerialized(snapshot.serializedStateMachine, l, this.pool);
            this.committedQuorumMembers.clear();
            this.committedQuorumMembers.addAll(snapshot.lastClusterMembership);
            this.latestQuorumMembers.clear();
            this.latestQuorumMembers.addAll(snapshot.lastClusterMembership);
            this.setCommitIndex(snapshot.lastIndex, l);
            this.assertConsistency();
            boolean bl = true;
            return bl;
        }
        finally {
            this.assertConsistency();
            assert (this.fast("installSnapshot", object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snapshot forceSnapshot() {
        Object object = Prometheus.startTimer(summaryTiming, new String[0]);
        this.assertConsistency();
        try {
            Optional<EloquentRaftProto.LogEntry> optional = this.getEntryAtIndex(this.commitIndex);
            if (!optional.isPresent()) {
                log.info("Snapshotting without any entries to snapshot. This means that our commitIndex has gotten more than 1024 behind our latest entry: commitIndex={}, number non-compacted entries={}, latestEntry={}", new Object[]{this.commitIndex, this.logEntries.size(), this.logEntries.size() > 0 ? this.logEntries.getLast().getIndex() : -1L});
                if (this.snapshot.isPresent()) {
                    Snapshot snapshot = this.snapshot.get();
                    return snapshot;
                }
                assert (this.commitIndex <= 1L);
                Snapshot snapshot = new Snapshot(this.stateMachine.serialize(), 0L, 0L, this.committedQuorumMembers);
                return snapshot;
            }
            EloquentRaftProto.LogEntry logEntry = optional.get();
            Snapshot snapshot = new Snapshot(this.stateMachine.serialize(), logEntry.getIndex(), logEntry.getTerm(), this.committedQuorumMembers);
            this.snapshot = Optional.of(snapshot);
            this.truncateLogBeforeIndexInclusive(logEntry.getIndex());
            assert (this.logEntries.size() <= 0 || snapshot.lastIndex < this.logEntries.getLast().getIndex());
            Snapshot snapshot2 = snapshot;
            return snapshot2;
        }
        finally {
            this.assertConsistency();
            assert (this.fast("forceSnapshot", object));
        }
    }

    public void unsafeSetLog(List<EloquentRaftProto.LogEntry> list) {
        Object object = Prometheus.startTimer(summaryTiming, new String[0]);
        if ("true".equals(System.getenv("ELOQUENT_PRODUCTION"))) {
            System.err.println("Called unsafeSetLog in production! Ignoring the call");
            return;
        }
        this.assertConsistency();
        try {
            this.logEntries.clear();
            this.logEntries.addAll(list);
            this.commitIndex = 0L;
        }
        finally {
            this.assertConsistency();
            assert (this.fast("unsafeSetLog", object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Optional<EloquentRaftProto.LogEntry> getEntryAtIndex(long l) {
        Object object = Prometheus.startTimer(summaryTiming, new String[0]);
        this.assertConsistency();
        try {
            Object object2;
            Iterator<EloquentRaftProto.LogEntry> iterator;
            if (this.logEntries.isEmpty()) {
                Optional<EloquentRaftProto.LogEntry> optional = Optional.empty();
                return optional;
            }
            EloquentRaftProto.LogEntry logEntry = this.logEntries.getFirst();
            EloquentRaftProto.LogEntry logEntry2 = this.logEntries.getLast();
            if (l == logEntry.getIndex()) {
                Optional<EloquentRaftProto.LogEntry> optional = Optional.of(logEntry);
                return optional;
            }
            if (l < logEntry.getIndex()) {
                Optional<EloquentRaftProto.LogEntry> optional = Optional.empty();
                return optional;
            }
            if (l == logEntry2.getIndex()) {
                Optional<EloquentRaftProto.LogEntry> optional = Optional.of(logEntry2);
                return optional;
            }
            if (l > logEntry2.getIndex()) {
                Optional<EloquentRaftProto.LogEntry> optional = Optional.empty();
                return optional;
            }
            Iterator<EloquentRaftProto.LogEntry> iterator2 = iterator = l > logEntry.getIndex() + (long)(this.logEntries.size() / 2) ? this.logEntries.descendingIterator() : this.logEntries.iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                if (((EloquentRaftProto.LogEntry)object2).getIndex() != l) continue;
                Optional<Object> optional = Optional.of(object2);
                return optional;
            }
            object2 = Optional.empty();
            return object2;
        }
        finally {
            this.assertConsistency();
            assert (this.fast("getEntryAtIndex", object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void truncateLogAfterIndexInclusive(long l) {
        Object object = Prometheus.startTimer(summaryTiming, new String[0]);
        this.assertConsistency();
        assert (l > this.commitIndex);
        try {
            if (l < 0L) {
                assert (false) : "Cannot truncate to a negative log index";
                l = 0L;
            }
            if (this.logEntries.size() == 0) {
                return;
            }
            long l2 = this.logEntries.getFirst().getIndex();
            if (l < l2) {
                assert (false) : "Cannot truncate beyond already compacted log entries";
                l = l2;
            }
            int n = (int)(l - l2);
            while (this.logEntries.size() > n) {
                this.logEntries.removeLast();
                long l3 = Math.min(this.getLastEntryIndex(), this.commitIndex);
                assert (l3 >= this.commitIndex);
                this.commitIndex = l3;
            }
            Object object2 = null;
            Iterator<EloquentRaftProto.LogEntry> iterator = this.logEntries.descendingIterator();
            while (iterator.hasNext()) {
                EloquentRaftProto.LogEntry logEntry = iterator.next();
                if (logEntry.getConfigurationCount() <= 0) continue;
                object2 = logEntry.getConfigurationList();
                break;
            }
            if (object2 == null && this.snapshot.isPresent()) {
                object2 = this.snapshot.get().lastClusterMembership;
            }
            if (object2 == null) {
                object2 = this.initialQuorumMembers;
            }
            this.latestQuorumMembers.clear();
            this.latestQuorumMembers.addAll((Collection<String>)object2);
        }
        finally {
            this.assertConsistency();
            assert (this.fast("truncateLogAfterIndexInclusive", object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void truncateLogBeforeIndexInclusive(long l) {
        Object object = Prometheus.startTimer(summaryTiming, new String[0]);
        this.assertConsistency();
        try {
            if (l < 0L) {
                throw new IndexOutOfBoundsException("Cannot truncate before a negative log index");
            }
            if (this.logEntries.size() == 0) {
                return;
            }
            long l2 = this.logEntries.getFirst().getIndex();
            if (l < l2) {
                return;
            }
            int n = (int)(l - l2);
            for (int i = 0; i <= n; ++i) {
                assert (this.logEntries.size() > 0);
                this.logEntries.removeFirst();
            }
            assert (this.logEntries.size() <= 0 || this.logEntries.getFirst().getIndex() == l + 1L);
        }
        finally {
            this.assertConsistency();
            assert (this.fast("truncateLogBeforeIndexInclusive", object));
        }
    }

    void assertConsistency() {
        assert (this.commitIndex <= this.getLastEntryIndex()) : "We've marked ourselves committed past our last entry: commitIndex=" + this.commitIndex + "  lastEntry=" + this.getLastEntryIndex();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RaftLog raftLog = (RaftLog)object;
        return this.commitIndex == raftLog.commitIndex && Objects.equals(new ArrayList<EloquentRaftProto.LogEntry>(this.logEntries), new ArrayList<EloquentRaftProto.LogEntry>(raftLog.logEntries)) && Objects.equals(this.stateMachine, raftLog.stateMachine) && Objects.equals(this.commitFutures, raftLog.commitFutures) && Objects.equals(this.snapshot, raftLog.snapshot) && Objects.equals(this.latestQuorumMembers, raftLog.latestQuorumMembers) && Objects.equals(this.committedQuorumMembers, raftLog.committedQuorumMembers);
    }

    public int hashCode() {
        return (int)this.commitIndex;
    }

    public static class Snapshot {
        byte[] serializedStateMachine;
        long lastIndex;
        long lastTerm;
        Set<String> lastClusterMembership;

        public Snapshot(byte[] byArray, long l, long l2, Collection<String> collection) {
            this.serializedStateMachine = byArray;
            this.lastIndex = l;
            this.lastTerm = l2;
            this.lastClusterMembership = FunctionalUtils.immutable(new HashSet<String>(collection));
        }
    }

    private static class CommitFuture {
        public final long index;
        public final long term;
        public final Consumer<Boolean> complete;

        public CommitFuture(long l, long l2, Consumer<Boolean> consumer) {
            this.index = l;
            this.term = l2;
            this.complete = consumer;
        }
    }
}

